/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.cmd;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSCommandStyle;
import oracle.jdeveloper.vcs.vop.VersionOperationSelectTablePanel;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITAbstractOperation;
import oracle.jdevimpl.vcs.git.nav.GITBranchNode;
import oracle.jdevimpl.vcs.git.nav.GITTagNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

abstract class GITExtendedAbstractOperation
extends GITAbstractOperation {
    private VersionOperationSelectTablePanel _gitSelectionTablePanel;
    private static String GIT_EXPORT_DIR = "git.export.dir";

    protected GITExtendedAbstractOperation(String commandId) {
        super(commandId);
    }

    protected GITExtendedAbstractOperation(String commandId, VCSCommandStyle style) {
        super(commandId, style);
    }

    protected GITExtendedAbstractOperation(String commandId, int type, VCSCommandStyle style) {
        super(commandId, type, style);
    }

    protected GITExtendedAbstractOperation(String commandId, int type, String name, VCSCommandStyle style) {
        super(commandId, type, name, style);
    }

    protected final VersionOperationSelectTablePanel getGITVersionOperationPanel() {
        return this._gitSelectionTablePanel;
    }

    protected final void setGITVersionOperationPanel(VersionOperationSelectTablePanel panel) {
        this._gitSelectionTablePanel = panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getBranchRevisionOptions(URL root, String branch, boolean useTracking) throws GitException, GITProcessException {
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(root);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("branches");
            Map branches = client.getBranches(false, (ProgressMonitor)monitor);
            if (monitor.getError() != null) {
                throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_CHECKOUT_ERROR"), monitor.getError());
            }
            GitBranch activeBranch = GITUtil.getActiveBranch(branches);
            HashMap<String, Object> defaultOpts = new HashMap<String, Object>();
            defaultOpts.put("Git-use-revision-enable", Boolean.FALSE);
            if (useTracking && activeBranch.getTrackedBranch() != null) {
                defaultOpts.put("Git-default-branch", activeBranch.getTrackedBranch().getName());
                defaultOpts.put("Git-active-branch", activeBranch.getName());
            } else if (branch == null) {
                defaultOpts.put("Git-default-branch", activeBranch.getName());
            } else {
                defaultOpts.put("Git-default-branch", branch);
            }
            defaultOpts.put("Git-local-root", root);
            HashMap<String, Object> hashMap = defaultOpts;
            return hashMap;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    protected URL getURLfromLocatable(Locatable[] locs) {
        if (locs.length == 1) {
            return locs[0].getURL();
        }
        return URLFileSystem.getParent((URL)locs[0].getURL());
    }

    protected Locatable[] getLocatableFromNavOrProfile(VCSProfile profile) throws Exception {
        Node node = this.getContext().getNode();
        if (node != null && GITNavURLFileSystemHelper.isNavigatorURL(node.getURL())) {
            URL url = GITNavURLFileSystemHelper.fromNavigatorURL(node.getURL());
            GITNode lNode = new GITNode(url){

                public Icon getIcon() {
                    return OracleIcons.getIcon((String)"folder.png");
                }
            };
            if (node instanceof GITBranchNode) {
                lNode._branch = node.getShortLabel();
            }
            if (node instanceof GITTagNode) {
                lNode._tag = node.getShortLabel();
            }
            return new Locatable[]{lNode};
        }
        return this.getRootOperand(profile);
    }

    protected void saveExportLocation(URL export) {
        URL parent = URLFileSystem.getParent((URL)export);
        Ide.getDTCache().putString(GIT_EXPORT_DIR, parent.getPath());
    }

    protected URL getExportFileSuggestion(String suggestionToken) {
        String rootLocation = Ide.getDTCache().getString(GIT_EXPORT_DIR);
        if (rootLocation == null || rootLocation.equals("")) {
            rootLocation = Ide.getWorkDirectory();
        }
        URL base = URLFactory.newDirURL((String)rootLocation);
        URL suggestion = URLFactory.newURL((URL)base, (String)(suggestionToken + ".diff"));
        int i = 0;
        while (URLFileSystem.exists((URL)suggestion)) {
            suggestion = URLFactory.newURL((URL)base, (String)(suggestionToken + i++ + ".diff"));
        }
        return suggestion;
    }

    protected OutputStream getOutputStream(URL url) throws IOException {
        if (URLFileSystem.mkdirs((URL)URLFileSystem.getParent((URL)url))) {
            OutputStream os = URLFileSystem.openOutputStream((URL)url);
            return new BufferedOutputStream(os);
        }
        return null;
    }

    protected void openEditor(final URL url) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorManager.getEditorManager().openDefaultEditorInFrame(url);
            }
        });
    }

    protected Collection<String> getRevisions(GitClient client, String revision, GITCommandProgressMonitor monitor) throws GitException.MissingObjectException, GitException {
        GitRevisionInfo[] infos;
        ArrayList<String> revisions = new ArrayList<String>();
        SearchCriteria sc = new SearchCriteria();
        sc.setRevisionFrom(revision);
        sc.setFollowRenames(true);
        sc.setIncludeMerges(false);
        for (GitRevisionInfo info : infos = client.log(sc, (ProgressMonitor)monitor)) {
            if (info.getRevision().equals(revision)) continue;
            revisions.add(info.getRevision());
        }
        return revisions;
    }

    protected static class GITNode
    extends Node {
        String _branch;
        String _tag;

        private GITNode(URL url) {
            super(url);
        }
    }
}

