/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.branchcompare;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.cmd.GITOperationMerge;
import oracle.jdevimpl.vcs.git.ui.GITMergeCustomizer;

public class GITBranchMergeCommand
extends GITOperationMerge {
    private static final Logger LOG = Logger.getLogger(GITBranchMergeCommand.class.getName());
    public static String COMMAND_ID = "oracle.jdeveloper.vcs.git.branchmerge";

    public GITBranchMergeCommand() {
        super(COMMAND_ID);
    }

    @Override
    protected Locatable[] getOperands(VCSProfile profile) throws Exception {
        return this.getLocatables();
    }

    @Override
    protected VCSOptionsCustomizer createOptionsCustomizer() {
        Locatable[] loc = this.getLocatables();
        String activeBranch = (String)this.getContext().getProperty("ActiveBranch");
        String compareBranch = (String)this.getContext().getProperty("CompareBranch");
        HashMap<String, Object> defaultOpts = new HashMap<String, Object>();
        defaultOpts.put("Git-use-revision-enable", Boolean.FALSE);
        defaultOpts.put("Git-default-branch", compareBranch);
        defaultOpts.put("Git-local-root", GITUtil.getRootContaining(loc[0].getURL()));
        GITMergeCustomizer customizer = new GITMergeCustomizer(this.getErrorTitle());
        customizer.setOptions(defaultOpts);
        return customizer;
    }

    private Locatable[] getLocatables() {
        Element[] elms = this.getContext().getSelection();
        ArrayList<Locatable> loc = new ArrayList<Locatable>();
        for (Element elm : elms) {
            if (!(elm instanceof Locatable)) continue;
            loc.add((Locatable)elm);
        }
        return loc.toArray(new Locatable[0]);
    }
}

