/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.branchcompare;

import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.model.Element;
import oracle.jdeveloper.vcs.generic.VCSProfileRegistry;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.branchcompare.BranchListItem;
import oracle.jdevimpl.vcs.git.branchcompare.GITBranchCompare;
import oracle.jdevimpl.vcs.git.branchcompare.GITBranchCompareWindow;
import oracle.jdevimpl.vcs.git.branchcompare.GITBranchMergeCommand;

public class GITBranchMenuController
implements Controller {
    boolean invokeCompare(Context context) {
        this.prepareContext(context);
        return this.invokeCommand((Command)new GITBranchCompare(), context);
    }

    private void prepareContext(Context context) {
        GITBranchCompareWindow window = (GITBranchCompareWindow)context.getView();
        context.setProperty("ActiveBranch", (Object)window.getActiveBranch());
        context.setProperty("CompareBranch", (Object)(window.getBranchCompare() != null ? window.getBranchCompare() : window.getTrackBranch()));
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (context.getView() instanceof GITBranchCompareWindow) {
            if (cmdId == 51) {
                action.setEnabled(!((GITBranchCompareWindow)context.getView()).isBusy());
                return true;
            }
            if (cmdId == Ide.findCmdID((String)GITBranchCompare.COMMAND_ID)) {
                Element[] elm = context.getSelection();
                if (elm.length > 0 && elm[0] instanceof BranchListItem) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
            if (cmdId == Ide.findCmdID((String)GITBranchMergeCommand.COMMAND_ID)) {
                if (context.getView() instanceof GITBranchCompareWindow) {
                    action.setEnabled(true);
                } else {
                    action.setEnabled(false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (context.getView() instanceof GITBranchCompareWindow) {
            if (cmdId == 51) {
                ((GITBranchCompareWindow)context.getView()).refresh();
                return true;
            }
            if (cmdId == Ide.findCmdID((String)GITBranchCompare.COMMAND_ID)) {
                this.invokeCompare(context);
                return true;
            }
            if (cmdId == Ide.findCmdID((String)GITBranchMergeCommand.COMMAND_ID)) {
                this.prepareContext(context);
                GITBranchMergeCommand command = new GITBranchMergeCommand();
                command.setProfile(VCSProfileRegistry.getInstance().getProfile("oracle.jdeveloper.git"));
                this.invokeCommand((Command)command, context);
                return true;
            }
        }
        return false;
    }

    private boolean invokeCommand(Command command, Context context) {
        try {
            command.setContext(context);
            CommandProcessor.getInstance().invoke(command);
            return true;
        }
        catch (Exception e) {
            GITProfile.getQualifiedLogger(GITBranchMenuController.class.getName()).log(Level.SEVERE, e.getMessage());
            return false;
        }
    }
}

