/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.util.ArrayList;
import java.util.Collection;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.MetaClassVisitor;
import javax.ide.util.MetaClass;
import oracle.jdevimpl.vcs.git.GITHistoryLink;

public class GITCommitHistoryHook
extends ExtensionHook {
    public static final String HISTORY_PROVIDER_HOOK = "git-history-hook";
    private static final String NS = "http://xmlns.oracle.com/ide/extension";
    private static final ElementName HYPERLINK_CLASS = new ElementName("http://xmlns.oracle.com/ide/extension", "hyperlink-class");
    private static final ElementName PATTERN = new ElementName("http://xmlns.oracle.com/ide/extension", "pattern");
    private static final String KEY_PROVIDER = "git-history";
    private final ElementVisitor _hyperlinkClassHandler = new HyperlinkClassHandler();
    private final ElementVisitor _patternHandler = new PatternHandler();
    private Collection<GITHistoryLink> _providers = new ArrayList<GITHistoryLink>();

    public Collection<GITHistoryLink> getProviders() {
        return this._providers;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(HYPERLINK_CLASS, this._hyperlinkClassHandler);
        context.registerChildVisitor(PATTERN, this._patternHandler);
        context.getScopeData().put(KEY_PROVIDER, new GITHistoryLink());
    }

    public void end(ElementEndContext context) {
        GITHistoryLink link = (GITHistoryLink)context.getScopeData().get(KEY_PROVIDER);
        this._providers.add(link);
    }

    private class PatternHandler
    extends ElementVisitor {
        private PatternHandler() {
        }

        public void end(ElementEndContext context) {
            GITHistoryLink link = (GITHistoryLink)context.getScopeData().get(GITCommitHistoryHook.KEY_PROVIDER);
            link.setPattern(context.getText());
        }
    }

    private class HyperlinkClassHandler
    extends MetaClassVisitor {
        private HyperlinkClassHandler() {
        }

        protected void metaClass(ElementContext context, MetaClass mc) {
            GITHistoryLink link = (GITHistoryLink)context.getScopeData().get(GITCommitHistoryHook.KEY_PROVIDER);
            link.setMetaClass(mc);
        }
    }
}

