/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.sql.SQLException;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.TypeInfo;
import sqlj.runtime.profile.ref.CachedDynamicProfile;
import sqlj.runtime.profile.ref.CachedDynamicProfileWrapper;
import sqlj.runtime.profile.ref.CachedStatement;
import sqlj.runtime.profile.ref.CachedStatementWrapper;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.ExecuteEventListener;
import sqlj.runtime.profile.ref.RTCallableStatement;

public class ParamRegProfile
extends CachedDynamicProfileWrapper {
    public ParamRegProfile(DynamicProfile dynamicProfile) {
        super(dynamicProfile);
    }

    public ParamRegProfile(CachedDynamicProfile cachedDynamicProfile) {
        super(cachedDynamicProfile);
    }

    public CachedStatement getCachedStatement(int n) throws SQLException {
        CachedStatement cachedStatement = super.getCachedStatement(n);
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(n);
        if (entryInfo.getStatementType() == 4) {
            cachedStatement = new ParamRegCachedStatement(entryInfo, cachedStatement);
        }
        return cachedStatement;
    }

    public CachedStatement getCachedStatement(int n, BatchContext batchContext) throws SQLException {
        CachedStatement cachedStatement = super.getCachedStatement(n, batchContext);
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(n);
        if (entryInfo.getStatementType() == 4) {
            cachedStatement = new ParamRegCachedStatement(entryInfo, cachedStatement);
        }
        return cachedStatement;
    }

    private class ParamRegCachedStatement
    extends CachedStatementWrapper {
        EntryInfo m_entry;

        ParamRegCachedStatement(EntryInfo entryInfo, CachedStatement cachedStatement) {
            super(cachedStatement);
            this.m_entry = entryInfo;
        }

        public RTStatement getStatement(ExecuteEventListener executeEventListener) throws SQLException {
            RTStatement rTStatement = super.getStatement(executeEventListener);
            if (this.m_entry != null) {
                try {
                    this.registerParameters(this.m_entry, (RTCallableStatement)rTStatement);
                }
                catch (SQLException sQLException) {
                    try {
                        this.releaseStatement();
                    }
                    catch (SQLException sQLException2) {
                        sQLException.setNextException(sQLException2);
                    }
                    throw sQLException;
                }
                this.m_entry = null;
            }
            return rTStatement;
        }

        public RTStatement getStatement(ExecuteEventListener executeEventListener, BatchContext batchContext) throws SQLException {
            RTStatement rTStatement = super.getStatement(executeEventListener, batchContext);
            if (this.m_entry != null) {
                try {
                    this.registerParameters(this.m_entry, (RTCallableStatement)rTStatement);
                }
                catch (SQLException sQLException) {
                    try {
                        this.releaseStatement();
                    }
                    catch (SQLException sQLException2) {
                        sQLException.setNextException(sQLException2);
                    }
                    throw sQLException;
                }
                this.m_entry = null;
            }
            return rTStatement;
        }

        private void registerParameters(EntryInfo entryInfo, RTCallableStatement rTCallableStatement) throws SQLException {
            int n = entryInfo.getParamCount();
            for (int i = 1; i <= n; ++i) {
                TypeInfo typeInfo = entryInfo.getParamInfo(i);
                if (typeInfo.getMode() == 1) continue;
                rTCallableStatement.registerOutParameter(i, typeInfo.getSQLType());
            }
        }
    }
}

