/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.error;

import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sqlj.runtime.error.Errors;

public class RuntimeRefErrors
extends Errors {
    private static final String RESOURCE_NAME = "sqlj.runtime.error.RuntimeRefErrorsText";
    private static ResourceBundle m_bundle = null;
    public static final String PROFILE_NOT_FOUND = "RTR-0001";
    public static final String NO_ROW_SELECT_INTO = "RTR-0002";
    public static final String MULTI_ROW_SELECT_INTO = "RTR-0003";
    public static final String WRONG_NUM_COLS = "RTR-0004";
    public static final String NULL_CONN_CTX = "RTR-0008";
    public static final String NULL_EXEC_CTX = "RTR-0009";
    public static final String NULL_CONNECTION = "RTR-0010";
    public static final String NULL_DATASOURCE = "RTR-0011";
    public static final String INVALID_TYPEMAP = "RTR-0012";
    public static final String INVALID_BATCH_LIMIT = "RTR-0013";
    public static final String CLOSED_CONNECTION = "RTR-0014";
    public static final String INCOMPATIBLE_BATCH = "RTR-0015";
    public static final String CODEGEN_ORACLE_REQUIRES_9 = "RTR-0016";

    public static void raise_PROFILE_NOT_FOUND(String profileName, Exception profileExcn) throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, PROFILE_NOT_FOUND, profileName, profileExcn.toString());
    }

    public static void raise_NO_ROW_SELECT_INTO() throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, NO_ROW_SELECT_INTO);
    }

    public static void raise_MULTI_ROW_SELECT_INTO() throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, MULTI_ROW_SELECT_INTO);
    }

    public static void raise_WRONG_NUM_COLS(int expectedCols, int foundCols) throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, WRONG_NUM_COLS, new Integer(expectedCols), new Integer(foundCols));
    }

    public static void raise_NULL_CONN_CTX() throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, NULL_CONN_CTX);
    }

    public static void raise_NULL_EXEC_CTX() throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, NULL_EXEC_CTX);
    }

    public static void raise_NULL_CONNECTION() throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, NULL_CONNECTION);
    }

    public static void raise_NULL_DATASOURCE(String dataSource, String mesg) throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, NULL_DATASOURCE, dataSource, mesg);
    }

    public static void raise_INVALID_TYPEMAP(String typeMap) throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, INVALID_TYPEMAP, typeMap, "");
    }

    public static void raise_INVALID_TYPEMAP(String typeMap, String mesg) throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, INVALID_TYPEMAP, typeMap, ": " + mesg);
    }

    public static void raise_INVALID_BATCH_LIMIT(int size) throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, INVALID_BATCH_LIMIT, Integer.toString(size));
    }

    public static void raise_CLOSED_CONNECTION() throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, CLOSED_CONNECTION);
    }

    public static void raise_INCOMPATIBLE_BATCH() throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, INCOMPATIBLE_BATCH);
    }

    public static void raise_CODEGEN_ORACLE_REQUIRES_9() throws SQLException {
        RuntimeRefErrors.raiseError(null, m_bundle, CODEGEN_ORACLE_REQUIRES_9);
    }

    static {
        try {
            m_bundle = ResourceBundle.getBundle(RESOURCE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

