/*
 * Decompiled with CFR 0.152.
 */
package oracle.sqlj.runtime;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.OracleDriver;
import oracle.sqlj.runtime.OraRTStatement;
import oracle.sqlj.runtime.error.OraCustomizationErrors;
import sqlj.runtime.ConnectionContext;
import sqlj.runtime.ref.ConnectionContextImpl;
import sqlj.runtime.ref.DefaultContext;

public class Oracle {
    public static final String SQLJ_PROPERTIES = "sqlj.properties";
    public static final String USER_KEY = "sqlj.user";
    public static final String PASSWORD_KEY = "sqlj.password";
    public static final String URL_KEY = "sqlj.url";
    public static final String DEFAULT_DRIVER_NAME = "SQLJ";
    private static boolean m_registered = false;

    public static DefaultContext connect(Connection connection) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(connection));
    }

    public static DefaultContext connect(String string, String string2, String string3, boolean bl) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(string, string2, string3, bl));
    }

    public static DefaultContext connect(String string, String string2, String string3) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(string, string2, string3));
    }

    public static DefaultContext connect(String string, Properties properties, boolean bl) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(string, properties, bl));
    }

    public static DefaultContext connect(String string, Properties properties) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(string, properties));
    }

    public static DefaultContext connect(String string, boolean bl) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(string, bl));
    }

    public static DefaultContext connect(String string) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(string));
    }

    public static DefaultContext connect(ConnectionContext connectionContext) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(connectionContext));
    }

    public static DefaultContext connect(Class clazz, String string, boolean bl) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(clazz, string, bl));
    }

    public static DefaultContext connect(Class clazz, String string) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(clazz, string));
    }

    public static DefaultContext connect(Class clazz, String string, String string2, String string3, boolean bl) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(clazz, string, string2, string3, bl));
    }

    public static DefaultContext connect(Class clazz, String string, String string2, String string3) throws SQLException {
        if (DefaultContext.getDefaultContext() != null) {
            return null;
        }
        return Oracle.installDefault(Oracle.getConnection(clazz, string, string2, string3));
    }

    public static void close() throws SQLException {
        DefaultContext defaultContext = DefaultContext.getDefaultContext();
        if (defaultContext != null) {
            if (OraRTStatement.inJServer()) {
                defaultContext.close(false);
            } else {
                defaultContext.close();
            }
            DefaultContext.setDefaultContext(null);
        }
    }

    public static void close(boolean bl) throws SQLException {
        DefaultContext defaultContext = DefaultContext.getDefaultContext();
        if (defaultContext != null) {
            if (OraRTStatement.inJServer()) {
                defaultContext.close(false);
            } else {
                defaultContext.close(bl);
            }
            DefaultContext.setDefaultContext(null);
        }
    }

    public static DefaultContext getConnection(Connection connection) throws SQLException {
        return new DefaultContext(connection);
    }

    public static DefaultContext getConnection(String string, String string2, String string3, boolean bl) throws SQLException {
        Oracle.registerDriver();
        Properties properties = new Properties();
        properties.put("user", string2);
        properties.put("password", string3);
        properties.put("oracle.jdbc.driverNameAttribute", DEFAULT_DRIVER_NAME);
        return new DefaultContext(string, properties, bl);
    }

    public static DefaultContext getConnection(String string, String string2, String string3) throws SQLException {
        return Oracle.getConnection(string, string2, string3, false);
    }

    public static DefaultContext getConnection(String string, Properties properties, boolean bl) throws SQLException {
        Oracle.registerDriver();
        String string2 = properties.getProperty("sqlj.driver_name");
        if (string2 == null) {
            properties.put("oracle.jdbc.driverNameAttribute", DEFAULT_DRIVER_NAME);
        } else {
            properties.put("oracle.jdbc.driverNameAttribute", string2);
        }
        return new DefaultContext(string, properties, bl);
    }

    public static DefaultContext getConnection(String string, Properties properties) throws SQLException {
        return Oracle.getConnection(string, properties, false);
    }

    public static DefaultContext getConnection(String string, boolean bl) throws SQLException {
        Oracle.registerDriver();
        Properties properties = new Properties();
        properties.put("oracle.jdbc.driverNameAttribute", DEFAULT_DRIVER_NAME);
        return new DefaultContext(string, properties, bl);
    }

    public static DefaultContext getConnection(String string) throws SQLException {
        return Oracle.getConnection(string, false);
    }

    public static DefaultContext getConnection(ConnectionContext connectionContext) throws SQLException {
        return new DefaultContext(connectionContext);
    }

    public static DefaultContext getConnection(Class clazz, String string, boolean bl) throws SQLException {
        Properties properties;
        Oracle.registerDriver();
        if (string == null) {
            string = SQLJ_PROPERTIES;
        }
        if ((properties = ConnectionContextImpl.loadProps(clazz, string)) == null) {
            OraCustomizationErrors.raise_CANNOT_LOAD_CONNECT_PROPS(string);
        }
        return Oracle.getConnection(properties, bl);
    }

    public static DefaultContext getConnection(Class clazz, String string) throws SQLException {
        return Oracle.getConnection(clazz, string, false);
    }

    public static DefaultContext getConnection(Class clazz, String string, String string2, String string3, boolean bl) throws SQLException {
        Properties properties;
        Oracle.registerDriver();
        if (string == null) {
            string = SQLJ_PROPERTIES;
        }
        if ((properties = ConnectionContextImpl.loadProps(clazz, string)) == null) {
            OraCustomizationErrors.raise_CANNOT_LOAD_CONNECT_PROPS(string);
        }
        return Oracle.getConnection(properties, string2, string3, bl);
    }

    public static DefaultContext getConnection(Class clazz, String string, String string2, String string3) throws SQLException {
        return Oracle.getConnection(clazz, string, string2, string3, false);
    }

    private static void registerDriver() throws SQLException {
        if (!m_registered) {
            m_registered = true;
            try {
                DriverManager.registerDriver((Driver)new OracleDriver());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    private static DefaultContext getConnection(Properties properties, boolean bl) throws SQLException {
        String string;
        String string2;
        String string3 = properties.getProperty(URL_KEY);
        if (string3 == null) {
            OraCustomizationErrors.raise_MISSING_CONNECT_KEY(URL_KEY);
        }
        if ((string2 = properties.getProperty(USER_KEY)) == null) {
            OraCustomizationErrors.raise_MISSING_CONNECT_KEY(USER_KEY);
        }
        if ((string = properties.getProperty(PASSWORD_KEY)) == null) {
            OraCustomizationErrors.raise_MISSING_CONNECT_KEY(PASSWORD_KEY);
        }
        properties.put("user", string2);
        properties.put("password", string);
        return Oracle.getConnection(string3, properties, bl);
    }

    private static DefaultContext getConnection(Properties properties, String string, String string2, boolean bl) throws SQLException {
        String string3 = properties.getProperty(URL_KEY);
        if (string3 == null) {
            OraCustomizationErrors.raise_MISSING_CONNECT_KEY(URL_KEY);
        }
        properties.put("user", string);
        properties.put("password", string2);
        return Oracle.getConnection(string3, properties, bl);
    }

    private static DefaultContext installDefault(DefaultContext defaultContext) {
        DefaultContext.setDefaultContext(defaultContext);
        return defaultContext;
    }
}

