/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import oracle.jpub.reflect.Client;
import oracle.jpub.reflect.RClass;
import oracle.jpub.reflect.RObject;

public class RMethod {
    static final int DECLARED_METHOD_OF = 1;
    static final int METHOD_OF = 2;
    private RClass m_declaringClass;
    private int m_modifiers;
    private RClass m_returnType;
    private String m_name;
    private RClass[] m_parameterTypes;
    private Method m_method;
    private boolean m_isDeclared;

    private RMethod() {
    }

    static RMethod[] map(RClass jc, int[] modifiers, String[] returnTypes, String[] names, String[][] arguments) throws ClassNotFoundException {
        RMethod[] ma = new RMethod[modifiers.length];
        for (int i = 0; i < ma.length; ++i) {
            ma[i] = RMethod.newRMethod(jc, modifiers[i], returnTypes[i], names[i], arguments[i]);
        }
        return ma;
    }

    static RMethod[] map(RClass jc, Method[] methods) {
        RMethod[] ma = new RMethod[methods.length];
        for (int i = 0; i < ma.length; ++i) {
            ma[i] = RMethod.newRMethod(jc, methods[i]);
        }
        return ma;
    }

    static RMethod newRMethod(RClass jc, String name, RClass[] parameterTypes, boolean isDeclared) throws ClassNotFoundException {
        RMethod c = new RMethod();
        c.m_declaringClass = jc;
        c.m_name = name;
        c.m_parameterTypes = parameterTypes;
        c.m_isDeclared = isDeclared;
        return c;
    }

    static RMethod newRMethod(RClass jc, Method m) {
        RMethod jm = new RMethod();
        jm.m_declaringClass = jc;
        jm.m_method = m;
        return jm;
    }

    private static RMethod newRMethod(RClass jc, int modif, String ret, String name, String[] args) throws ClassNotFoundException {
        RMethod jm = new RMethod();
        jm.m_declaringClass = jc;
        jm.m_modifiers = modif;
        jm.m_returnType = RClass.newRClass(jc, ret);
        jm.m_name = name;
        jm.m_parameterTypes = RClass.map(jc, args);
        return jm;
    }

    public String toString() {
        if (this.m_method == null) {
            StringBuffer sb = new StringBuffer();
            sb.append(Modifier.toString(this.m_modifiers));
            sb.append(" ");
            sb.append(this.m_returnType.toString());
            sb.append(" ");
            sb.append(this.m_name);
            sb.append("(");
            for (int i = 0; i < this.m_parameterTypes.length; ++i) {
                sb.append(this.m_parameterTypes[i]);
                if (i >= this.m_parameterTypes.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            return sb.toString();
        }
        return this.m_method.toString();
    }

    public RClass getDeclaringClass() {
        if (this.m_declaringClass == null) {
            this.m_declaringClass = RClass.newRClass(this.m_method.getDeclaringClass());
        }
        return this.m_returnType;
    }

    public String getName() {
        return this.m_method == null ? this.m_name : this.m_method.getName();
    }

    public int getModifiers() {
        return this.m_method == null ? this.m_modifiers : this.m_method.getModifiers();
    }

    public RClass getReturnType() {
        if (this.m_returnType == null) {
            this.m_returnType = RClass.newRClass(this.m_method.getReturnType());
        }
        return this.m_returnType;
    }

    public RClass[] getParameterTypes() {
        if (this.m_parameterTypes == null) {
            Class<?>[] pt = this.m_method.getParameterTypes();
            this.m_parameterTypes = new RClass[pt.length];
            for (int i = 0; i < pt.length; ++i) {
                this.m_parameterTypes[i] = RClass.newRClass(pt[i]);
            }
        }
        return this.m_parameterTypes;
    }

    public RClass[] getExceptionTypes() {
        throw new IllegalArgumentException("getExceptionTypes(): not implemented");
    }

    public RObject invoke(Object o, Object[] args) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        if (this.m_method == null || o != null && o instanceof RObject || this.isRemote(args)) {
            return new RObject(this.m_declaringClass.getDefaultContext(), this.m_declaringClass.getName(), this.m_name, Client.getSignature(this.getParameterTypes()), args, o, this.m_isDeclared);
        }
        return new RObject(this.m_method.invoke(o, args), true, true);
    }

    private boolean isRemote(Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null || !(args[i] instanceof RObject)) continue;
            return true;
        }
        return false;
    }
}

