/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.reflect;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

class Descriptor
implements Serializable {
    private int m_modifiers;
    private boolean m_isArray;
    private boolean m_isPrimitive;
    private boolean m_isInterface;
    private String m_name;
    private String m_componentType;
    private String m_superclass;
    private String m_declaringClass;
    private String[] m_interfaces;
    private String[] m_declaredClasses;
    private int[] m_declaredFieldModifiers;
    private String[] m_declaredFieldTypes;
    private String[] m_declaredFieldNames;
    private int[] m_declaredMethodModifiers;
    private String[] m_declaredMethodReturnTypes;
    private String[] m_declaredMethodNames;
    private String[][] m_declaredMethodParameterTypes;
    private int[] m_declaredConstructorModifiers;
    private String[] m_declaredConstructorNames;
    private String[][] m_declaredConstructorParameterTypes;

    public String toString() {
        int j;
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(this.m_modifiers));
        if (this.m_isInterface) {
            sb.append(" interface ");
        } else {
            sb.append(" class ");
        }
        sb.append(this.m_name);
        sb.append(" extends ");
        sb.append(this.m_superclass);
        if (this.m_interfaces.length > 0) {
            sb.append("\n   implements ");
            for (i = 0; i < this.m_interfaces.length; ++i) {
                sb.append(this.m_interfaces[i]);
                if (i >= this.m_interfaces.length - 1) continue;
                sb.append(", ");
            }
        }
        sb.append("\n{\n");
        if (this.m_declaredFieldNames.length > 0) {
            sb.append("   /* Fields */\n");
            for (i = 0; i < this.m_declaredFieldNames.length; ++i) {
                sb.append("   ");
                sb.append(Modifier.toString(this.m_declaredFieldModifiers[i]));
                sb.append(" ");
                sb.append(this.m_declaredFieldTypes[i]);
                sb.append(" ");
                sb.append(this.m_declaredFieldNames[i]);
                sb.append(";\n");
            }
        }
        if (this.m_declaredConstructorNames.length > 0) {
            sb.append("   /* Constructors */\n");
            for (i = 0; i < this.m_declaredConstructorNames.length; ++i) {
                sb.append("   ");
                sb.append(Modifier.toString(this.m_declaredConstructorModifiers[i]));
                sb.append(" ");
                sb.append(this.m_name);
                sb.append("(");
                for (j = 0; j < this.m_declaredConstructorParameterTypes[i].length; ++j) {
                    sb.append(this.m_declaredConstructorParameterTypes[i][j]);
                    if (j >= this.m_declaredConstructorParameterTypes[i].length - 1) continue;
                    sb.append(",");
                }
                sb.append(");\n");
            }
        }
        if (this.m_declaredMethodNames.length > 0) {
            sb.append("   /* Methods */\n");
            for (i = 0; i < this.m_declaredMethodNames.length; ++i) {
                sb.append("   ");
                sb.append(Modifier.toString(this.m_declaredMethodModifiers[i]));
                sb.append(" ");
                sb.append(this.m_declaredMethodReturnTypes[i]);
                sb.append(" ");
                sb.append(this.m_declaredMethodNames[i]);
                sb.append("(");
                for (j = 0; j < this.m_declaredMethodParameterTypes[i].length; ++j) {
                    sb.append(this.m_declaredMethodParameterTypes[i][j]);
                    if (j >= this.m_declaredMethodParameterTypes[i].length - 1) continue;
                    sb.append(",");
                }
                sb.append(");\n");
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    private Descriptor(String name) throws ClassNotFoundException {
        Class<?> c = Class.forName(name);
        this.m_name = c.getName();
        this.m_superclass = c.getSuperclass().getName();
        this.m_declaringClass = c.getDeclaringClass() == null ? null : c.getDeclaringClass().getName();
        this.m_isArray = c.isArray();
        if (this.m_isArray) {
            this.m_componentType = c.getComponentType().getName();
        }
        this.m_isPrimitive = c.isPrimitive();
        this.m_modifiers = c.getModifiers();
        Class<?>[] itf = c.getInterfaces();
        this.m_interfaces = new String[itf.length];
        for (int i = 0; i < itf.length; ++i) {
            this.m_interfaces[i] = itf[i].getName();
        }
        Class<?>[] dc = c.getDeclaredClasses();
        this.m_declaredClasses = new String[dc.length];
        for (int i = 0; i < dc.length; ++i) {
            this.m_declaredClasses[i] = dc[i].getName();
        }
        Field[] fields = c.getDeclaredFields();
        this.m_declaredFieldNames = new String[fields.length];
        this.m_declaredFieldTypes = new String[fields.length];
        this.m_declaredFieldModifiers = new int[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.m_declaredFieldNames[i] = fields[i].getName();
            this.m_declaredFieldTypes[i] = fields[i].getType().getName();
            this.m_declaredFieldModifiers[i] = fields[i].getModifiers();
        }
        Method[] methods = c.getDeclaredMethods();
        this.m_declaredMethodNames = new String[methods.length];
        this.m_declaredMethodReturnTypes = new String[methods.length];
        this.m_declaredMethodParameterTypes = new String[methods.length][];
        this.m_declaredMethodModifiers = new int[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            this.m_declaredMethodNames[i] = methods[i].getName();
            this.m_declaredMethodModifiers[i] = methods[i].getModifiers();
            this.m_declaredMethodReturnTypes[i] = methods[i].getReturnType().getName();
            Class<?>[] params = methods[i].getParameterTypes();
            this.m_declaredMethodParameterTypes[i] = new String[params.length];
            for (int j = 0; j < params.length; ++j) {
                this.m_declaredMethodParameterTypes[i][j] = params[j].getName();
            }
        }
        Constructor<?>[] constructors = c.getDeclaredConstructors();
        this.m_declaredConstructorNames = new String[constructors.length];
        this.m_declaredConstructorParameterTypes = new String[constructors.length][];
        this.m_declaredConstructorModifiers = new int[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            this.m_declaredConstructorNames[i] = constructors[i].getName();
            this.m_declaredConstructorModifiers[i] = constructors[i].getModifiers();
            Class<?>[] params = constructors[i].getParameterTypes();
            this.m_declaredConstructorParameterTypes[i] = new String[params.length];
            for (int j = 0; j < params.length; ++j) {
                this.m_declaredConstructorParameterTypes[i][j] = params[j].getName();
            }
        }
    }

    static Descriptor reflect(String name) throws ClassNotFoundException {
        return new Descriptor(name);
    }

    boolean isAssignableFrom(Descriptor rc) {
        throw new IllegalArgumentException("Descriptor.isAssignableFrom(): not implemented");
    }

    boolean isArray() {
        return this.m_isArray;
    }

    boolean isPrimitive() {
        return this.m_isPrimitive;
    }

    boolean isInterface() {
        return this.m_isInterface;
    }

    int getModifiers() {
        return this.m_modifiers;
    }

    String getName() {
        return this.m_name;
    }

    String getComponentType() {
        return this.m_componentType;
    }

    String getSuperclass() {
        return this.m_superclass;
    }

    String getDeclaringClass() {
        return this.m_declaringClass;
    }

    String[] getInterfaces() {
        return this.m_interfaces;
    }

    String[] getDeclaredClasses() {
        return this.m_declaredClasses;
    }

    String[] getDeclaredFieldTypes() {
        return this.m_declaredFieldTypes;
    }

    int[] getDeclaredFieldModifiers() {
        return this.m_declaredFieldModifiers;
    }

    String[] getDeclaredFieldNames() {
        return this.m_declaredFieldNames;
    }

    int[] getDeclaredConstructorModifiers() {
        return this.m_declaredConstructorModifiers;
    }

    String[][] getDeclaredConstructorParameterTypes() {
        return this.m_declaredConstructorParameterTypes;
    }

    int[] getDeclaredMethodModifiers() {
        return this.m_declaredMethodModifiers;
    }

    String[] getDeclaredMethodReturnTypes() {
        return this.m_declaredMethodReturnTypes;
    }

    String[] getDeclaredMethodNames() {
        return this.m_declaredMethodNames;
    }

    String[][] getDeclaredMethodParameterTypes() {
        return this.m_declaredMethodParameterTypes;
    }

    static void main(String[] args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("*** " + args[i] + " ***");
            System.out.println(Descriptor.reflect(args[i]).toString());
        }
    }
}

