/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.topo;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.topo.CompGeom;
import oracle.spatial.topo.Edge;
import oracle.spatial.topo.Face;
import oracle.spatial.topo.IntArrayList;
import oracle.spatial.topo.InvalidTopoOperationException;
import oracle.spatial.topo.Node;
import oracle.spatial.topo.Point2DD;
import oracle.spatial.topo.TopoDataException;
import oracle.spatial.topo.TopoEntityNotFoundException;
import oracle.spatial.topo.TopoFaceSplitInfo;
import oracle.spatial.topo.TopoValidationException;
import oracle.spatial.util.RTree;

public class TopoPrimitivesMap {
    public static final int NOID = 0;
    public static final int UNIVERSE_FACE = -1;
    private static final int MAX_EDGES_AT_NODE = 200;
    private int srid = -1;
    Int reuseInt = new Int();
    Point2DD reusePoint = new Point2DD();
    double pGrid;
    double sGrid;
    boolean snapGrid = false;
    int shiftRight = 16;
    private HashMap edgeHashMap;
    private HashMap nodeHashMap;
    private HashMap faceHashMap;
    private HashSet edgeChangedList;
    private HashSet edgeAddedList;
    private HashSet edgeDeletedList;
    private HashSet nodeChangedList;
    private HashSet nodeAddedList;
    private HashSet nodeDeletedList;
    private HashSet faceChangedList;
    private HashSet faceAddedList;
    private HashSet faceDeletedList;
    private boolean isValid0 = false;
    private boolean isValid1 = false;
    private boolean areEdgesIndexed = false;
    private boolean areFacesIndexed = false;
    private RTree edgeRTree;
    private RTree faceRTree;
    private int nextNodeID = 1;
    private int nextEdgeID = 1;
    private int nextFaceID = 1;
    private ArrayList<TopoFaceSplitInfo> faceSplitInfo = new ArrayList();

    public TopoPrimitivesMap(int numberOfEdges, int numberOfNodes, int numberOfFaces, int decimalDigitsPrecision) throws Exception {
        this.edgeHashMap = new HashMap(4 * numberOfEdges / 3);
        this.nodeHashMap = new HashMap(4 * numberOfNodes / 3);
        this.faceHashMap = new HashMap(4 * numberOfFaces / 3);
        this.edgeChangedList = new HashSet(50000);
        this.edgeAddedList = new HashSet(50000);
        this.edgeDeletedList = new HashSet(100);
        this.nodeChangedList = new HashSet(100);
        this.nodeAddedList = new HashSet(25000);
        this.nodeDeletedList = new HashSet(100);
        this.faceChangedList = new HashSet(100);
        this.faceAddedList = new HashSet(25000);
        this.faceDeletedList = new HashSet(100);
        this.createEdgeIndex();
        this.createFaceIndex();
        Face f = new Face(-1);
        this.faceHashMap.put(new Int(-1), f);
        if (decimalDigitsPrecision > 0) {
            this.shiftRight = decimalDigitsPrecision;
        }
        if (this.shiftRight < 12) {
            this.snapGrid = true;
            this.sGrid = 1.0;
            this.pGrid = 1.0;
            for (int i = 0; i < this.shiftRight; ++i) {
                this.pGrid *= 10.0;
                this.sGrid /= 10.0;
            }
        }
    }

    public ArrayList<TopoFaceSplitInfo> getFaceSplitInfo() {
        return this.faceSplitInfo;
    }

    public void reset() throws Exception {
        this.edgeRTree = null;
        this.faceRTree = null;
        this.areEdgesIndexed = false;
        this.areFacesIndexed = false;
        this.nextNodeID = 1;
        this.nextEdgeID = 1;
        this.nextFaceID = 1;
        this.edgeHashMap.clear();
        this.nodeHashMap.clear();
        this.faceHashMap.clear();
        this.createEdgeIndex();
        this.createFaceIndex();
        Face f = new Face(-1);
        this.faceHashMap.put(new Int(-1), f);
        this.faceSplitInfo.clear();
    }

    public void build(Vector<JGeometry> geometries) throws Exception {
        this.reset();
        if (geometries == null || geometries.size() == 0) {
            return;
        }
        for (int i = 0; i < geometries.size(); ++i) {
            int[] ids;
            JGeometry geom = geometries.get(i);
            int gtype = geom.getType();
            if (gtype == 1 || gtype == 5) {
                System.out.println("Point or multi point geometry [" + i + "] is ignored.");
                continue;
            }
            if (gtype == 2 || gtype == 6) {
                if (this.srid == -1) {
                    this.srid = geom.getSRID();
                }
                ids = this.addLinearGeometry(geom);
                continue;
            }
            if (gtype == 3 || gtype == 7) {
                if (this.srid == -1) {
                    this.srid = geom.getSRID();
                }
                ids = this.addPolygonGeometry(geom);
                continue;
            }
            System.out.println("Geometry type [" + gtype + "] is not supported.");
        }
    }

    public void snapToGrid(Point2DD p) {
        long grid = (long)(p.x * this.pGrid + 0.5);
        p.x = (double)grid * this.sGrid;
        grid = (long)(p.y * this.pGrid + 0.5);
        p.y = (double)grid * this.sGrid;
    }

    public double snapToGrid(double d) {
        long grid = (long)(d * this.pGrid + 0.5);
        return (double)grid * this.sGrid;
    }

    public void snapToGrid(Point2DD[] p) {
        int dupCount = 0;
        for (int i = 0; i < p.length; ++i) {
            long grid = (long)(p[i].x * this.pGrid + 0.5);
            p[i].x = (double)grid * this.sGrid;
            grid = (long)(p[i].y * this.pGrid + 0.5);
            p[i].y = (double)grid * this.sGrid;
            if (i <= 0 || !p[i].equals(p[i - 1])) continue;
            ++dupCount;
        }
        if (dupCount > 0) {
            Point2DD[] pp = new Point2DD[p.length - dupCount];
            int j = 0;
            for (int i = 0; i < p.length; ++i) {
                if (i > 0 && p[i].equals(p[i - 1])) continue;
                pp[j++] = new Point2DD(p[i]);
            }
            p = pp;
        }
    }

    public int getCacheEdgeCount() {
        return this.edgeHashMap.size();
    }

    public int getCacheNodeCount() {
        return this.nodeHashMap.size();
    }

    public int getCacheFaceCount() {
        return this.faceHashMap.size();
    }

    public void createEdgeIndex() throws Exception {
        this.edgeRTree = new RTree(2, 8, 1);
        int numEntries = this.edgeHashMap.size();
        if (numEntries == 0) {
            this.areEdgesIndexed = true;
            return;
        }
        Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
        double[][][] mbhList = new double[numEntries][2][2];
        Object[] edgeList = new Object[numEntries];
        Iterator it = this.getEdgeIterator();
        int i = 0;
        while (it.hasNext()) {
            Edge e = (Edge)it.next();
            e.computeMBR(mbr);
            mbhList[i][0][0] = mbr[0].x;
            mbhList[i][0][1] = mbr[1].x;
            mbhList[i][1][0] = mbr[0].y;
            mbhList[i][1][1] = mbr[1].y;
            edgeList[i] = e;
            ++i;
        }
        this.edgeRTree.packTree(mbhList, edgeList);
        this.areEdgesIndexed = true;
    }

    public void createFaceIndex() throws Exception {
        this.faceRTree = new RTree(2, 8, 1);
        int numEntries = this.faceHashMap.size();
        if (this.faceHashMap.containsKey(new Int(-1))) {
            --numEntries;
        }
        if (numEntries == 0) {
            this.areFacesIndexed = true;
            return;
        }
        double[][][] mbhList = new double[numEntries][2][2];
        Object[] faceList = new Object[numEntries];
        Iterator it = this.getFaceIterator();
        int i = 0;
        while (it.hasNext()) {
            Face f = (Face)it.next();
            if (f.id == -1) continue;
            mbhList[i][0][0] = f.mbr[0].x;
            mbhList[i][0][1] = f.mbr[1].x;
            mbhList[i][1][0] = f.mbr[0].y;
            mbhList[i][1][1] = f.mbr[1].y;
            faceList[i] = f;
            ++i;
        }
        this.faceRTree.packTree(mbhList, faceList);
        this.areFacesIndexed = true;
    }

    public void clearCache() {
        this.edgeHashMap.clear();
        this.nodeHashMap.clear();
        this.faceHashMap.clear();
        this.edgeChangedList.clear();
        this.edgeAddedList.clear();
        this.edgeDeletedList.clear();
        this.nodeChangedList.clear();
        this.nodeAddedList.clear();
        this.nodeDeletedList.clear();
        this.faceChangedList.clear();
        this.faceAddedList.clear();
        this.faceDeletedList.clear();
        this.edgeRTree = null;
        this.faceRTree = null;
        this.areEdgesIndexed = false;
        this.areFacesIndexed = false;
    }

    public Point2DD[] getCacheBounds() throws InvalidTopoOperationException {
        if (!this.areEdgesIndexed) {
            throw new InvalidTopoOperationException("Cannot determine cache bounds without an edge RTree index");
        }
        double[][] b = this.edgeRTree.getMBH();
        Point2DD[] p = new Point2DD[]{new Point2DD(b[0][0], b[1][0]), new Point2DD(b[0][1], b[1][1])};
        return p;
    }

    public Point2DD[] getTopologyBounds() throws InvalidTopoOperationException {
        Point2DD[] mbr = new Point2DD[2];
        Point2DD[] mbrC = new Point2DD[2];
        if (mbr[0] == null) {
            throw new InvalidTopoOperationException("Node and edge tables contain no data to determine bounds");
        }
        return mbr;
    }

    public boolean searchEdgeRTree(double[][] h, ArrayList a) {
        if (this.areEdgesIndexed) {
            return this.edgeRTree.search(h, a);
        }
        return false;
    }

    public boolean searchFaceRTree(double[][] h, ArrayList a) {
        if (this.areFacesIndexed) {
            return this.faceRTree.search(h, a);
        }
        return false;
    }

    public Edge getEdge(int id) throws TopoEntityNotFoundException {
        if (id == 0) {
            return null;
        }
        this.reuseInt.i = id = Math.abs(id);
        Edge e = (Edge)this.edgeHashMap.get(this.reuseInt);
        if (e == null) {
            throw new TopoEntityNotFoundException("Edge ID " + id + " not found in cache");
        }
        return e;
    }

    public Node getNode(int id) throws TopoEntityNotFoundException {
        if (id == 0) {
            return null;
        }
        this.reuseInt.i = id;
        Node n = (Node)this.nodeHashMap.get(this.reuseInt);
        if (n == null) {
            throw new TopoEntityNotFoundException("Node ID " + id + " not found in cache");
        }
        return n;
    }

    public Face getFace(int id) throws TopoEntityNotFoundException {
        if (id == 0) {
            return null;
        }
        this.reuseInt.i = id;
        Face f = (Face)this.faceHashMap.get(this.reuseInt);
        if (f == null) {
            throw new TopoEntityNotFoundException("Face ID " + id + " not found in cache");
        }
        return f;
    }

    public int[] getFaceBoundary(int faceID, int option) throws TopoEntityNotFoundException, TopoDataException {
        if (option < 0 || option > 2) {
            throw new TopoDataException("Invalid option " + option + ". Only 0, 1, or 2 allowed");
        }
        if (faceID == -1 && option == 0) {
            throw new TopoDataException("Universe has no external boundary as requested");
        }
        Face f = this.getFace(faceID);
        ArrayList<Edge> edgeList = new ArrayList<Edge>(20);
        for (int i = -1; i < f.islandEdges.length; ++i) {
            Edge eT;
            if (faceID == -1 && i == -1) continue;
            if (i > -1 && option == 0) break;
            int edge = i == -1 ? f.boundaryEdge : f.islandEdges[i];
            int edgeT = edge;
            do {
                eT = this.getEdge(edgeT);
                if (option != 2 && eT.boundedFaceL == eT.boundedFaceR || edgeList.contains(eT)) continue;
                edgeList.add(eT);
            } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edge);
        }
        int[] boundaryArray = new int[edgeList.size()];
        for (int i = 0; i < edgeList.size(); ++i) {
            boundaryArray[i] = ((Edge)edgeList.get((int)i)).id;
        }
        return boundaryArray;
    }

    public int getNearestEdgeInCache(Point2DD point) {
        Edge e = null;
        Edge eBest = null;
        double dist = 1.0E100;
        Iterator it = this.getEdgeIterator();
        while (it.hasNext()) {
            e = (Edge)it.next();
            for (int i = 0; i < e.coords.length - 1; ++i) {
                double distComp = CompGeom.distToLine((Point2DD)point, (Point2DD)e.coords[i], (Point2DD)e.coords[i + 1]);
                if (distComp == 0.0) {
                    return e.id;
                }
                if (!(distComp < dist)) continue;
                dist = distComp;
                eBest = e;
            }
        }
        if (eBest == null) {
            return 0;
        }
        return eBest.id;
    }

    public int getNearestNodeInCache(Point2DD p) {
        Node n = null;
        Node nBest = null;
        double dist = 1.0E100;
        Iterator it = this.getNodeIterator();
        while (it.hasNext()) {
            n = (Node)it.next();
            double distComp = (p.x - n.coord.x) * (p.x - n.coord.x) + (p.y - n.coord.y) * (p.y - n.coord.y);
            if (distComp == 0.0) {
                return n.id;
            }
            if (!(distComp < dist)) continue;
            dist = distComp;
            nBest = n;
        }
        if (nBest == null) {
            return 0;
        }
        return nBest.id;
    }

    public Iterator getEdgeIterator() {
        return this.edgeHashMap.values().iterator();
    }

    public Iterator getNodeIterator() {
        return this.nodeHashMap.values().iterator();
    }

    public Iterator getFaceIterator() {
        return this.faceHashMap.values().iterator();
    }

    private ArrayList getEdgeModList(HashSet h) {
        ArrayList<Integer> l = new ArrayList<Integer>(h.size());
        Iterator it = h.iterator();
        while (it.hasNext()) {
            l.add(new Integer(((Edge)it.next()).id));
        }
        return l;
    }

    private ArrayList getNodeModList(HashSet h) {
        ArrayList<Integer> l = new ArrayList<Integer>(h.size());
        Iterator it = h.iterator();
        while (it.hasNext()) {
            l.add(new Integer(((Node)it.next()).id));
        }
        return l;
    }

    private ArrayList getFaceModList(HashSet h) {
        ArrayList<Integer> l = new ArrayList<Integer>(h.size());
        Iterator it = h.iterator();
        while (it.hasNext()) {
            l.add(new Integer(((Face)it.next()).id));
        }
        return l;
    }

    public ArrayList getEdgeChanges() {
        return this.getEdgeModList(this.edgeChangedList);
    }

    public ArrayList getNodeChanges() {
        return this.getNodeModList(this.nodeChangedList);
    }

    public ArrayList getFaceChanges() {
        return this.getFaceModList(this.faceChangedList);
    }

    public ArrayList getEdgeAdditions() {
        return this.getEdgeModList(this.edgeAddedList);
    }

    public ArrayList getNodeAdditions() {
        return this.getNodeModList(this.nodeAddedList);
    }

    public ArrayList getFaceAdditions() {
        return this.getFaceModList(this.faceAddedList);
    }

    public ArrayList getEdgeDeletions() {
        return this.getEdgeModList(this.edgeDeletedList);
    }

    public ArrayList getNodeDeletions() {
        return this.getNodeModList(this.nodeDeletedList);
    }

    public ArrayList getFaceDeletions() {
        return this.getFaceModList(this.faceDeletedList);
    }

    public void moveIsolatedNode(int nodeID, Point2DD point) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        Node n;
        try {
            n = this.getNode(nodeID);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("Node ID passed to moveIsolatedNode does not exist in cache");
        }
        if (n.coord.equals(point)) {
            throw new InvalidTopoOperationException("Moved Iso Node without a coordinate move");
        }
        if (n.containFace == 0) {
            throw new InvalidTopoOperationException("Attempt to move an isolated node which is not isolated");
        }
        Face f = this.getFace(n.containFace);
        if (!this.pointInFace(point, this.getFace(n.containFace), false)) {
            throw new InvalidTopoOperationException("Attempt to move iso node outside its face or onto an existing node or edge");
        }
        for (int j = 0; j < f.islandNodes.length; ++j) {
            Node nj;
            try {
                nj = this.getNode(f.islandNodes[j]);
            }
            catch (TopoEntityNotFoundException it) {
                continue;
            }
            if (nj.id == nodeID || !point.equals(nj.coord)) continue;
            throw new InvalidTopoOperationException("Attempt to move an isolated node on top of another isolated node");
        }
        Object backupNode = null;
        n.coord.x = point.x;
        n.coord.y = point.y;
        int affectedList = 0;
        if (!this.nodeAddedList.contains(n) && this.listAdd(this.nodeChangedList, n)) {
            affectedList = 2;
        }
    }

    public void moveNode(int nodeID, Point2DD[][] edgesCoords) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        this.moveNode(nodeID, edgesCoords, new ArrayList(), new ArrayList(), true);
    }

    public void moveNode(int nodeID, Point2DD[][] edgesCoords, ArrayList movedIsoNodes, ArrayList movedIsoEdges, boolean allowIsoMoves) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        int j;
        int i;
        int edgeT;
        int edge;
        Node n;
        int j2;
        boolean dupe;
        Node n0;
        int[] nodeStar = this.getNodeStar(nodeID);
        if (nodeStar.length == 0) {
            throw new InvalidTopoOperationException("Cannot move an isolated node with this method; use moveIsolatedNode()");
        }
        if (edgesCoords.length != nodeStar.length) {
            throw new InvalidTopoOperationException("Coordinate array and node star have a different length");
        }
        Edge e = null;
        Face f = null;
        try {
            n0 = this.getNode(nodeID);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("moveNode called with a node ID that does not exist");
        }
        Point2DD p0 = new Point2DD(nodeStar[0] > 0 ? edgesCoords[0][0] : edgesCoords[0][edgesCoords[0].length - 1]);
        if (p0.equals(n0.coord)) {
            throw new InvalidTopoOperationException("Moved node has not moved");
        }
        int[] faceStar = this.getNodeFaceStar(nodeID);
        boolean found = false;
        boolean isoOnEdge = false;
        for (int i2 = 0; i2 < faceStar.length; ++i2) {
            dupe = false;
            for (j2 = 0; j2 < i2; ++j2) {
                if (faceStar[j2] != faceStar[i2]) continue;
                dupe = true;
                break;
            }
            if (dupe) continue;
            if (!found && this.pointInFace(p0, f = this.getFace(faceStar[i2]), false)) {
                found = true;
            }
            for (int k = 0; k < f.islandNodes.length; ++k) {
                try {
                    n = this.getNode(f.islandNodes[k]);
                }
                catch (TopoEntityNotFoundException it) {
                    continue;
                }
                for (int l = 0; l < nodeStar.length; ++l) {
                    for (int m = 0; m < edgesCoords[l].length - 1; ++m) {
                        if (!n.coord.equals(edgesCoords[l][m]) && !CompGeom.onLine((Point2DD)n.coord, (Point2DD)edgesCoords[l][m], (Point2DD)edgesCoords[l][m + 1])) continue;
                        isoOnEdge = true;
                        break;
                    }
                    if (!isoOnEdge && !n.coord.equals(edgesCoords[l][edgesCoords[l].length - 1])) continue;
                    throw new InvalidTopoOperationException("Moved node or adjoining edges would overlap iso node ID " + n.id);
                }
            }
        }
        if (!found) {
            throw new InvalidTopoOperationException("Node is not moved to a position inside one of the original adjoining faces");
        }
        for (j2 = 0; j2 < nodeStar.length; ++j2) {
            Point2DD p;
            e = this.getEdge(nodeStar[j2]);
            if (edgesCoords[j2].length < (e.originNode == e.endNode ? 4 : 2)) {
                throw new InvalidTopoOperationException("At least one of the changed edges in the argument array has insufficient coordinates");
            }
            Point2DD point2DD = p = nodeStar[j2] > 0 ? edgesCoords[j2][0] : edgesCoords[j2][edgesCoords[j2].length - 1];
            if (!p.equals(p0)) {
                throw new InvalidTopoOperationException("Coordinate mismatch at moved end of edges");
            }
            if (e.originNode != e.endNode) {
                if ((nodeStar[j2] <= 0 || e.coords[e.coords.length - 1].equals(edgesCoords[j2][edgesCoords[j2].length - 1])) && (nodeStar[j2] >= 0 || e.coords[0].equals(edgesCoords[j2][0]))) continue;
                throw new InvalidTopoOperationException("An edge does not maintain the position of the opposite end node");
            }
            if (edgesCoords[j2][edgesCoords[j2].length - 1].equals(edgesCoords[j2][0])) continue;
            throw new InvalidTopoOperationException("Attempted move node with attached loop while opening loop");
        }
        Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
        double[][] mbrD = new double[2][2];
        ArrayList aL = new ArrayList(6);
        for (int j3 = 0; j3 < nodeStar.length; ++j3) {
            int k;
            e = this.getEdge(nodeStar[j3]);
            if (CompGeom.lineStringSelfIntersects((Point2DD[])edgesCoords[j3], (e.originNode == e.endNode ? 1 : 0) != 0)) {
                throw new InvalidTopoOperationException("Coordinate string self-intersects");
            }
            for (k = j3 + 1; k < nodeStar.length; ++k) {
                if (nodeStar[j3] == -nodeStar[k] || !CompGeom.lineStringsIntersect((Point2DD[])edgesCoords[j3], (Point2DD[])edgesCoords[k], (boolean)true)) continue;
                throw new InvalidTopoOperationException("Coordinate strings intersect each other");
            }
            if (!this.areEdgesIndexed) continue;
            CompGeom.computeMBR((Point2DD[])edgesCoords[j3], (Point2DD[])mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.search(mbrD, aL);
            for (k = 0; k < nodeStar.length; ++k) {
                Edge eK = this.getEdge(nodeStar[k]);
                int m = aL.indexOf(eK);
                if (m < 0) continue;
                aL.remove(m);
            }
            for (int i3 = 0; i3 < aL.size(); ++i3) {
                Edge eR = (Edge)aL.get(i3);
                if (!eR.intersects(edgesCoords[j3], true)) continue;
                throw new InvalidTopoOperationException("An edge coordinate string has an intersection with another edge");
            }
        }
        Point2DD[] sPts = new Point2DD[3];
        for (int i4 = 0; i4 < 3; ++i4) {
            sPts[i4] = new Point2DD();
        }
        if (nodeStar.length > 2) {
            sPts[1].x = p0.x;
            sPts[1].y = p0.y;
            for (int i5 = 0; i5 < nodeStar.length; ++i5) {
                int ip1 = i5 - 1;
                if (ip1 < 0) {
                    ip1 = nodeStar.length - 1;
                }
                int ip2 = (i5 + 1) % nodeStar.length;
                if (nodeStar[ip1] > 0) {
                    sPts[0].x = edgesCoords[ip1][1].x;
                    sPts[0].y = edgesCoords[ip1][1].y;
                } else {
                    sPts[0].x = edgesCoords[ip1][edgesCoords[ip1].length - 2].x;
                    sPts[0].y = edgesCoords[ip1][edgesCoords[ip1].length - 2].y;
                }
                if (nodeStar[ip2] > 0) {
                    sPts[2].x = edgesCoords[ip2][1].x;
                    sPts[2].y = edgesCoords[ip2][1].y;
                } else {
                    sPts[2].x = edgesCoords[ip2][edgesCoords[ip2].length - 2].x;
                    sPts[2].y = edgesCoords[ip2][edgesCoords[ip2].length - 2].y;
                }
                if (CompGeom.inSector((Point2DD)(nodeStar[i5] > 0 ? edgesCoords[i5][1] : edgesCoords[i5][edgesCoords[i5].length - 2]), (Point2DD[])sPts)) continue;
                throw new InvalidTopoOperationException("Logical ordering of node star at moved node " + nodeID + " does not" + " match input geometric ordering");
            }
        }
        for (int k = 0; k < nodeStar.length; ++k) {
            e = this.getEdge(nodeStar[k]);
            n = this.getNode(nodeStar[k] > 0 ? e.endNode : e.originNode);
            if ((nodeStar[k] <= 0 || e.nextEdgeL == -e.prevEdgeR) && (nodeStar[k] >= 0 || e.nextEdgeR == -e.prevEdgeL)) continue;
            sPts[1].x = n.coord.x;
            sPts[1].y = n.coord.y;
            int edge1 = nodeStar[k] > 0 ? -e.prevEdgeR : -e.prevEdgeL;
            int edge2 = nodeStar[k] > 0 ? e.nextEdgeL : e.nextEdgeR;
            Edge e1 = this.getEdge(edge1);
            Edge e2 = this.getEdge(edge2);
            if (edge1 > 0) {
                sPts[0].x = e1.coords[1].x;
                sPts[0].y = e1.coords[1].y;
            } else {
                sPts[0].x = e1.coords[e1.coords.length - 2].x;
                sPts[0].y = e1.coords[e1.coords.length - 2].y;
            }
            if (edge2 > 0) {
                sPts[2].x = e2.coords[1].x;
                sPts[2].y = e2.coords[1].y;
            } else {
                sPts[2].x = e2.coords[e2.coords.length - 2].x;
                sPts[2].y = e2.coords[e2.coords.length - 2].y;
            }
            if (CompGeom.inSector((Point2DD)(nodeStar[k] < 0 ? edgesCoords[k][1] : edgesCoords[k][edgesCoords[k].length - 2]), (Point2DD[])sPts)) continue;
            throw new InvalidTopoOperationException("Move node attempts to reorder node star at node " + n.id);
        }
        if (nodeStar.length == 2 && faceStar[0] != faceStar[1]) {
            double area1 = 0.0;
            double area2 = 0.0;
            edge = nodeStar[0];
            try {
                do {
                    e = this.getEdge(edge);
                    double incArea1 = e.subtendedArea();
                    double incArea2 = Math.abs(edge) == Math.abs(nodeStar[0]) ? CompGeom.subtendedArea((Point2DD[])edgesCoords[0]) : (Math.abs(edge) == Math.abs(nodeStar[1]) ? CompGeom.subtendedArea((Point2DD[])edgesCoords[1]) : incArea1);
                    if (edge < 0) {
                        incArea1 = -incArea1;
                        incArea2 = -incArea2;
                    }
                    area1 += incArea1;
                    area2 += incArea2;
                } while ((edge = edge > 0 ? e.nextEdgeL : e.nextEdgeR) != nodeStar[0]);
                if (area1 * area2 < 0.0) {
                    throw new InvalidTopoOperationException("Move node produces a disallowed mirror image");
                }
            }
            catch (TopoEntityNotFoundException tenf) {
                // empty catch block
            }
        }
        boolean didIsoMove = false;
        boolean universeTouchesNode = false;
        int count = 0;
        for (int k = 0; k < faceStar.length; ++k) {
            if (faceStar[k] == -1) {
                universeTouchesNode = true;
            }
            dupe = false;
            for (int j4 = 0; j4 < k; ++j4) {
                if (faceStar[j4] != faceStar[k]) continue;
                dupe = true;
                break;
            }
            if (dupe) continue;
            ++count;
        }
        if (count > 1) {
            for (int k = 0; k < faceStar.length; ++k) {
                int odd1;
                int countOld;
                dupe = false;
                for (int j5 = 0; j5 < k; ++j5) {
                    if (faceStar[j5] != faceStar[k]) continue;
                    dupe = true;
                    break;
                }
                if (dupe) continue;
                f = this.getFace(faceStar[k]);
                for (int i6 = 0; i6 < f.islandNodes.length; ++i6) {
                    try {
                        n = this.getNode(f.islandNodes[i6]);
                    }
                    catch (TopoEntityNotFoundException it) {
                        continue;
                    }
                    int countNew = 0;
                    countOld = 0;
                    for (int j6 = 0; j6 < nodeStar.length; ++j6) {
                        dupe = false;
                        for (int m = 0; m < j6; ++m) {
                            if (Math.abs(nodeStar[m]) != Math.abs(nodeStar[j6])) continue;
                            dupe = true;
                            break;
                        }
                        if (dupe) continue;
                        e = this.getEdge(nodeStar[j6]);
                        if (e.boundedFaceL == e.boundedFaceR || e.boundedFaceL != faceStar[k] && e.boundedFaceR != faceStar[k]) continue;
                        if (CompGeom.incPointInPolygon((Point2DD)n.coord, (Point2DD[])e.coords, (boolean)false)) {
                            ++countOld;
                        }
                        if (!CompGeom.incPointInPolygon((Point2DD)n.coord, (Point2DD[])edgesCoords[j6], (boolean)false)) continue;
                        ++countNew;
                    }
                    odd1 = Math.abs(countOld - countNew);
                    int odd2 = odd1 / 2;
                    if (odd1 == (odd2 = 2 * odd2)) continue;
                    try {
                        didIsoMove = true;
                        movedIsoNodes.add(new Integer(f.islandNodes[i6]));
                        continue;
                    }
                    catch (NullPointerException npe) {
                        throw new InvalidTopoOperationException("iso node will move and movedIsoNodes passed null");
                    }
                }
                int countNew = 0;
                countOld = 0;
                for (int i7 = 0; i7 < f.islandEdges.length; ++i7) {
                    int j7;
                    Edge eT;
                    Edge eI;
                    try {
                        eI = this.getEdge(f.islandEdges[i7]);
                    }
                    catch (TopoEntityNotFoundException tn) {
                        continue;
                    }
                    edgeT = f.islandEdges[i7];
                    boolean skip = false;
                    block38: do {
                        eT = this.getEdge(edgeT);
                        for (j7 = 0; j7 < nodeStar.length; ++j7) {
                            if (Math.abs(edgeT) != Math.abs(nodeStar[j7])) continue;
                            skip = true;
                            break block38;
                        }
                    } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != f.islandEdges[i7]);
                    if (skip) continue;
                    for (j7 = 0; j7 < nodeStar.length; ++j7) {
                        dupe = false;
                        for (int m = 0; m < j7; ++m) {
                            if (Math.abs(nodeStar[m]) != Math.abs(nodeStar[j7])) continue;
                            dupe = true;
                            break;
                        }
                        if (dupe) continue;
                        e = this.getEdge(nodeStar[j7]);
                        if (e.boundedFaceL == e.boundedFaceR || e.boundedFaceL != faceStar[k] && e.boundedFaceR != faceStar[k]) continue;
                        if (CompGeom.incPointInPolygon((Point2DD)eI.coords[0], (Point2DD[])e.coords, (boolean)false)) {
                            ++countOld;
                        }
                        if (!CompGeom.incPointInPolygon((Point2DD)eI.coords[0], (Point2DD[])edgesCoords[j7], (boolean)false)) continue;
                        ++countNew;
                    }
                    odd1 = Math.abs(countOld - countNew);
                    int odd2 = odd1 / 2;
                    if (odd1 == (odd2 = 2 * odd2)) continue;
                    try {
                        didIsoMove = true;
                        movedIsoEdges.add(new Integer(f.islandEdges[i7]));
                        continue;
                    }
                    catch (NullPointerException npe) {
                        throw new InvalidTopoOperationException("iso edge will move and movedIsoEdges passed null");
                    }
                }
            }
        }
        if (didIsoMove && !allowIsoMoves) {
            return;
        }
        if (didIsoMove && universeTouchesNode) {
            this.listAdd(this.faceChangedList, this.getFace(-1));
        }
        Object backupNode = null;
        n0.coord = p0;
        int affectedList = 0;
        if (!this.nodeAddedList.contains(n0) && this.listAdd(this.nodeChangedList, n0)) {
            affectedList = 2;
        }
        for (i = 0; i < nodeStar.length; ++i) {
            dupe = false;
            for (int j8 = 0; j8 < i; ++j8) {
                if (Math.abs(nodeStar[i]) != Math.abs(nodeStar[j8])) continue;
                dupe = true;
                break;
            }
            if (dupe) continue;
            e = this.getEdge(nodeStar[i]);
            Object backupEdge = null;
            if (this.areEdgesIndexed) {
                e.computeMBR(mbr);
                mbrD[0][0] = mbr[0].x;
                mbrD[0][1] = mbr[1].x;
                mbrD[1][0] = mbr[0].y;
                mbrD[1][1] = mbr[1].y;
                this.edgeRTree.removeEntry(mbrD, (Object)e);
            }
            e.coords = new Point2DD[edgesCoords[i].length];
            for (j = 0; j < edgesCoords[i].length; ++j) {
                e.coords[j] = new Point2DD(edgesCoords[i][j]);
            }
            if (this.areEdgesIndexed) {
                e.computeMBR(mbr);
                mbrD[0][0] = mbr[0].x;
                mbrD[0][1] = mbr[1].x;
                mbrD[1][0] = mbr[0].y;
                mbrD[1][1] = mbr[1].y;
                this.edgeRTree.addEntry(mbrD, (Object)e);
            }
            affectedList = 0;
            if (this.edgeAddedList.contains(e) || !this.listAdd(this.edgeChangedList, e)) continue;
            affectedList = 2;
        }
        for (i = 0; i < faceStar.length; ++i) {
            Object backupFace = null;
            dupe = false;
            for (j = 0; j < i; ++j) {
                if (faceStar[j] != faceStar[i]) continue;
                dupe = true;
                break;
            }
            if (!dupe) {
                if (faceStar[i] == -1) continue;
                f = this.getFace(faceStar[i]);
                if (this.areFacesIndexed) {
                    mbrD[0][0] = f.mbr[0].x;
                    mbrD[0][1] = f.mbr[1].x;
                    mbrD[1][0] = f.mbr[0].y;
                    mbrD[1][1] = f.mbr[1].y;
                    this.faceRTree.removeEntry(mbrD, (Object)f);
                }
                edge = f.boundaryEdge;
                e = this.getEdge(edge);
                f.mbr = new Point2DD[]{new Point2DD(e.coords[0]), new Point2DD(e.coords[0])};
                do {
                    e = this.getEdge(edge);
                    e.computeMBR(mbr);
                    CompGeom.augmentMBR((Point2DD[])mbr, (Point2DD[])f.mbr);
                } while ((edge = edge > 0 ? e.nextEdgeL : e.nextEdgeR) != f.boundaryEdge);
                if (this.areFacesIndexed) {
                    mbrD[0][0] = f.mbr[0].x;
                    mbrD[0][1] = f.mbr[1].x;
                    mbrD[1][0] = f.mbr[0].y;
                    mbrD[1][1] = f.mbr[1].y;
                    this.faceRTree.addEntry(mbrD, (Object)f);
                }
            }
            affectedList = 0;
            if (this.faceAddedList.contains(f) || !this.listAdd(this.faceChangedList, f)) continue;
            affectedList = 2;
        }
        if (!didIsoMove) {
            return;
        }
        for (i = 0; i < movedIsoNodes.size(); ++i) {
            Object backupFace = null;
            Object currNode = null;
            int node = (Integer)movedIsoNodes.get(i);
            n = this.getNode(node);
            f = this.getFace(n.containFace);
            f.trimIslandNodes(node);
            found = false;
            for (int j9 = 0; j9 < faceStar.length; ++j9) {
                dupe = false;
                for (int k = 0; k < j9; ++k) {
                    if (faceStar[k] != faceStar[j9]) continue;
                    dupe = true;
                    break;
                }
                if (dupe || faceStar[j9] == -1 || !this.pointInFace(n.coord, f = this.getFace(faceStar[j9]), true)) continue;
                found = true;
                break;
            }
            if (found) {
                n.containFace = f.id;
                f.extendIslandNodes(node);
            } else {
                n.containFace = -1;
                f = this.getFace(-1);
                f.extendIslandNodes(node);
            }
            affectedList = 0;
            if (this.nodeAddedList.contains(n) || !this.listAdd(this.nodeChangedList, n)) continue;
            affectedList = 2;
        }
        for (i = 0; i < movedIsoEdges.size(); ++i) {
            Object backupFace = null;
            Object backupEdge = null;
            edge = (Integer)movedIsoEdges.get(i);
            e = this.getEdge(edge);
            f = this.getFace(edge > 0 ? e.boundedFaceL : e.boundedFaceR);
            f.trimIslandEdges(edge);
            found = false;
            for (int j10 = 0; j10 < faceStar.length; ++j10) {
                dupe = false;
                for (int k = 0; k < j10; ++k) {
                    if (faceStar[k] != faceStar[j10]) continue;
                    dupe = true;
                    break;
                }
                if (dupe || faceStar[j10] == -1 || !this.pointInFace(e.coords[0], f = this.getFace(faceStar[j10]), true)) continue;
                found = true;
                break;
            }
            if (found) {
                f.extendIslandEdges(edge);
            } else {
                f = this.getFace(-1);
                f.extendIslandEdges(edge);
            }
            edgeT = edge;
            do {
                e = this.getEdge(edgeT);
                if (edgeT > 0) {
                    e.boundedFaceL = f.id;
                } else {
                    e.boundedFaceR = f.id;
                }
                affectedList = 0;
                if (this.edgeAddedList.contains(e) || !this.listAdd(this.edgeChangedList, e)) continue;
                affectedList = 2;
            } while ((edgeT = edgeT > 0 ? e.nextEdgeL : e.nextEdgeR) != edge);
        }
    }

    public void moveEdge(int edgeID, int sNodeID, int tNodeID, Point2DD[] edgeCoords) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        this.moveEdge(edgeID, sNodeID, tNodeID, edgeCoords, new ArrayList(), new ArrayList(), true);
    }

    public void moveEdge(int edgeID, int sNodeID, int tNodeID, Point2DD[] edgeCoords, ArrayList movedIsoNodes, ArrayList movedIsoEdges, boolean allowIsoMoves) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        Object backupEdgeET;
        Face fT;
        Face fF;
        int id;
        Object backupFaceFT;
        Object backupFaceFF;
        int i;
        Node n;
        Face f;
        int node;
        Node nS;
        Node nT;
        Edge e;
        edgeID = Math.abs(edgeID);
        try {
            e = this.getEdge(edgeID);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("moveEdge called with an edge ID that does not exist in cache");
        }
        try {
            nT = this.getNode(tNodeID);
            nS = this.getNode(sNodeID);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("moveEdge called with a node ID that does not exist");
        }
        if (e.boundedFaceL == e.boundedFaceR) {
            throw new InvalidTopoOperationException("Attempted move edge with same face on both sides");
        }
        if (e.originNode == e.endNode) {
            throw new InvalidTopoOperationException("Cannot move loop edge");
        }
        if (e.originNode == tNodeID || e.endNode == tNodeID) {
            throw new InvalidTopoOperationException("Move edge cannot create loop edge");
        }
        int unmovedNode = e.originNode == sNodeID ? e.endNode : e.originNode;
        Node nU = this.getNode(unmovedNode);
        if (!nU.coord.equals(e.originNode == sNodeID ? edgeCoords[edgeCoords.length - 1] : edgeCoords[0])) {
            throw new InvalidTopoOperationException("Move edge coordinates do not match node coordinate at unmoved end");
        }
        if (!nT.coord.equals(e.originNode == sNodeID ? edgeCoords[0] : edgeCoords[edgeCoords.length - 1])) {
            throw new InvalidTopoOperationException("Move edge coordinates do not match destination node coordinate at moved end");
        }
        if (CompGeom.lineStringSelfIntersects((Point2DD[])edgeCoords, (boolean)false)) {
            throw new InvalidTopoOperationException("Coordinate string for moved edge self-intersects");
        }
        Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
        double[][] mbrD = new double[2][2];
        ArrayList aL = new ArrayList(6);
        if (this.areEdgesIndexed) {
            CompGeom.computeMBR((Point2DD[])edgeCoords, (Point2DD[])mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.search(mbrD, aL);
            int m = aL.indexOf(e);
            if (m >= 0) {
                aL.remove(m);
            }
            for (int i2 = 0; i2 < aL.size(); ++i2) {
                Edge eR = (Edge)aL.get(i2);
                if (!eR.intersects(edgeCoords, true)) continue;
                throw new InvalidTopoOperationException("Moved edge coordinate string has an intersection with another edge");
            }
        }
        boolean left = false;
        boolean right = false;
        Edge eT = null;
        int edgeT = e.nextEdgeL;
        do {
            try {
                eT = this.getEdge(edgeT);
            }
            catch (TopoEntityNotFoundException tn) {
                // empty catch block
            }
            int n2 = node = edgeT > 0 ? eT.endNode : eT.originNode;
            if (node != tNodeID) continue;
            left = true;
            break;
        } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edgeID);
        edgeT = e.nextEdgeR;
        do {
            try {
                eT = this.getEdge(edgeT);
            }
            catch (TopoEntityNotFoundException tn) {
                // empty catch block
            }
            int n3 = node = edgeT > 0 ? eT.endNode : eT.originNode;
            if (node != tNodeID) continue;
            right = true;
            break;
        } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != -edgeID);
        if (!right && !left) {
            throw new InvalidTopoOperationException("Destination node for move edge cannot be found in adjoining boundary components");
        }
        int[] nodeStar = this.getNodeStar(unmovedNode);
        if (nodeStar.length > 2) {
            Point2DD t;
            Point2DD[] sector = new Point2DD[3];
            sector[1] = nU.coord;
            edgeT = unmovedNode == e.originNode ? e.prevEdgeL : e.prevEdgeR;
            eT = this.getEdge(edgeT);
            sector[0] = edgeT > 0 ? eT.coords[eT.coords.length - 2] : eT.coords[1];
            edgeT = unmovedNode == e.originNode ? e.nextEdgeR : e.nextEdgeL;
            eT = this.getEdge(edgeT);
            sector[2] = edgeT > 0 ? eT.coords[1] : eT.coords[eT.coords.length - 2];
            Point2DD point2DD = t = unmovedNode == e.originNode ? edgeCoords[1] : edgeCoords[edgeCoords.length - 2];
            if (!CompGeom.inSector((Point2DD)t, (Point2DD[])sector)) {
                throw new InvalidTopoOperationException("Move edge attempts to reorder node star at unmoved end");
            }
        }
        ArrayList<Edge> connectEdgeList = new ArrayList<Edge>();
        boolean foundBegin = false;
        int nodeBegin = 0;
        int nodeEnd = 0;
        nodeBegin = left && !right ? (e.originNode == sNodeID ? tNodeID : sNodeID) : (right && !left ? (e.originNode == sNodeID ? sNodeID : tNodeID) : sNodeID);
        int n4 = nodeEnd = nodeBegin == sNodeID ? tNodeID : sNodeID;
        edgeT = left && right ? (e.originNode == sNodeID ? -edgeID : edgeID) : (left ? edgeID : -edgeID);
        int edgeS = edgeT;
        do {
            try {
                eT = this.getEdge(edgeT);
            }
            catch (TopoEntityNotFoundException tn) {
                // empty catch block
            }
            if (foundBegin) {
                connectEdgeList.add(eT);
            }
            int n5 = node = edgeT > 0 ? eT.endNode : eT.originNode;
            if (foundBegin) {
                if (node == nodeEnd) break;
                if (node != nodeBegin) continue;
                connectEdgeList.clear();
                continue;
            }
            if (node != nodeBegin) continue;
            foundBegin = true;
        } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edgeS);
        boolean didIsoMove = false;
        boolean didUniverseChange = false;
        int face = e.boundedFaceL;
        int oFace = e.boundedFaceR;
        for (int i3 = 0; i3 < 2; ++i3) {
            boolean mod;
            int j;
            f = this.getFace(face);
            for (j = 0; j < f.islandNodes.length; ++j) {
                int k;
                try {
                    n = this.getNode(f.islandNodes[j]);
                }
                catch (TopoEntityNotFoundException it) {
                    continue;
                }
                boolean isoOnEdge = false;
                for (k = 0; k < edgeCoords.length - 1; ++k) {
                    if (!n.coord.equals(edgeCoords[k]) && !CompGeom.onLine((Point2DD)n.coord, (Point2DD)edgeCoords[k], (Point2DD)edgeCoords[k + 1])) continue;
                    isoOnEdge = true;
                    break;
                }
                if (isoOnEdge || n.coord.equals(edgeCoords[edgeCoords.length - 1])) {
                    throw new InvalidTopoOperationException("Moved edge would pass through isolated node ID " + n.id);
                }
                mod = CompGeom.incPointInPolygon((Point2DD)n.coord, (Point2DD[])e.coords, (boolean)false);
                mod = CompGeom.incPointInPolygon((Point2DD)n.coord, (Point2DD[])edgeCoords, (boolean)mod);
                for (k = 0; k < connectEdgeList.size(); ++k) {
                    mod = CompGeom.incPointInPolygon((Point2DD)n.coord, (Point2DD[])((Edge)connectEdgeList.get((int)k)).coords, (boolean)mod);
                }
                if (!mod) continue;
                didIsoMove = true;
                try {
                    if (face == -1 || oFace == -1) {
                        didUniverseChange = true;
                    }
                    movedIsoNodes.add(new Integer(n.id));
                    continue;
                }
                catch (NullPointerException npe) {
                    throw new InvalidTopoOperationException("An iso node will move and movedIsoNodes passed null");
                }
            }
            for (j = 0; j < f.islandEdges.length; ++j) {
                try {
                    eT = this.getEdge(f.islandEdges[j]);
                }
                catch (TopoEntityNotFoundException tn) {
                    continue;
                }
                mod = CompGeom.incPointInPolygon((Point2DD)eT.coords[0], (Point2DD[])e.coords, (boolean)false);
                mod = CompGeom.incPointInPolygon((Point2DD)eT.coords[0], (Point2DD[])edgeCoords, (boolean)mod);
                for (int k = 0; k < connectEdgeList.size(); ++k) {
                    mod = CompGeom.incPointInPolygon((Point2DD)eT.coords[0], (Point2DD[])((Edge)connectEdgeList.get((int)k)).coords, (boolean)mod);
                }
                if (!mod) continue;
                try {
                    didIsoMove = true;
                    if (face == -1 || oFace == -1) {
                        didUniverseChange = true;
                    }
                    movedIsoEdges.add(new Integer(f.islandEdges[j]));
                    continue;
                }
                catch (NullPointerException npe) {
                    throw new InvalidTopoOperationException("An iso edge will move and movedIsoEdges passed null");
                }
            }
            face = e.boundedFaceR;
            oFace = e.boundedFaceL;
        }
        if (!allowIsoMoves && didIsoMove) {
            return;
        }
        Object backupEdge = null;
        if (this.areEdgesIndexed) {
            e.computeMBR(mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.removeEntry(mbrD, (Object)e);
        }
        e.fillCoords(edgeCoords);
        if (this.areEdgesIndexed) {
            e.computeMBR(mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.addEntry(mbrD, (Object)e);
        }
        int affectedList = 0;
        if (!this.edgeAddedList.contains(e) && this.listAdd(this.edgeChangedList, e)) {
            affectedList = 2;
        }
        boolean leftOutside = false;
        boolean rightOutside = false;
        int face2 = e.boundedFaceL;
        for (int i4 = 0; i4 < 2; ++i4) {
            f = this.getFace(face2);
            Object backupFace = null;
            affectedList = 0;
            if (!this.faceAddedList.contains(f) && this.listAdd(this.faceChangedList, f)) {
                affectedList = 2;
            }
            block33: for (int j = -1; j < f.islandEdges.length; ++j) {
                if (j < 0 && face2 == -1) continue;
                edgeT = j < 0 ? f.boundaryEdge : f.islandEdges[j];
                edgeS = edgeT;
                this.reuseInt.i = Math.abs(edgeS);
                if (!this.edgeHashMap.containsKey(this.reuseInt)) continue;
                do {
                    try {
                        eT = this.getEdge(edgeT);
                    }
                    catch (TopoEntityNotFoundException tn) {
                        // empty catch block
                    }
                    if (Math.abs(edgeT) != edgeID) continue;
                    if (j < 0) {
                        f.boundaryEdge = edgeT;
                        if (!this.faceAddedList.contains(f)) {
                            this.listAdd(this.faceChangedList, f);
                        }
                        if (i4 == 0) {
                            leftOutside = true;
                            break block33;
                        }
                        rightOutside = true;
                        break block33;
                    }
                    f.islandEdges[j] = edgeT;
                    if (this.faceAddedList.contains(f)) break block33;
                    this.listAdd(this.faceChangedList, f);
                    break block33;
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edgeS);
            }
            face2 = e.boundedFaceR;
        }
        edgeT = e.endNode == sNodeID ? e.prevEdgeR : e.prevEdgeL;
        eT = this.getEdge(edgeT);
        Object backupET = null;
        if (edgeT > 0) {
            eT.nextEdgeL = e.endNode == sNodeID ? e.nextEdgeL : e.nextEdgeR;
        } else {
            eT.nextEdgeR = e.endNode == sNodeID ? e.nextEdgeL : e.nextEdgeR;
        }
        affectedList = 0;
        if (!this.edgeAddedList.contains(eT) && this.listAdd(this.edgeChangedList, eT)) {
            affectedList = 2;
        }
        edgeT = e.endNode == sNodeID ? e.nextEdgeL : e.nextEdgeR;
        eT = this.getEdge(edgeT);
        if (edgeT > 0) {
            eT.prevEdgeL = e.endNode == sNodeID ? e.prevEdgeR : e.prevEdgeL;
        } else {
            eT.prevEdgeR = e.endNode == sNodeID ? e.prevEdgeR : e.prevEdgeL;
        }
        affectedList = 0;
        if (!this.edgeAddedList.contains(eT) && this.listAdd(this.edgeChangedList, eT)) {
            affectedList = 2;
        }
        if (Math.abs(nS.startEdge) == edgeID) {
            Object backupNS = null;
            nS.startEdge = edgeT;
            affectedList = 0;
            if (!this.nodeAddedList.contains(nS) && this.listAdd(this.nodeChangedList, nS)) {
                affectedList = 2;
            }
        }
        int[] edgeSeq = new int[2];
        this.faceInto(nT, e.endNode == sNodeID ? e.coords[e.coords.length - 2] : e.coords[1], edgeSeq);
        Edge eS0 = this.getEdge(edgeSeq[0]);
        Edge eS1 = this.getEdge(edgeSeq[1]);
        Object backupES0 = null;
        Object backupES1 = null;
        if (e.endNode == sNodeID) {
            e.prevEdgeR = -edgeSeq[0];
            e.nextEdgeL = edgeSeq[1];
            if (edgeSeq[0] > 0) {
                eS0.nextEdgeR = -edgeID;
            } else {
                eS0.nextEdgeL = -edgeID;
            }
            if (edgeSeq[1] > 0) {
                eS1.prevEdgeL = edgeID;
            } else {
                eS1.prevEdgeR = edgeID;
            }
        } else {
            e.prevEdgeL = -edgeSeq[0];
            e.nextEdgeR = edgeSeq[1];
            if (edgeSeq[0] > 0) {
                eS0.nextEdgeR = edgeID;
            } else {
                eS0.nextEdgeL = edgeID;
            }
            if (edgeSeq[1] > 0) {
                eS1.prevEdgeL = -edgeID;
            } else {
                eS1.prevEdgeR = -edgeID;
            }
        }
        affectedList = 0;
        if (!this.edgeAddedList.contains(eS0) && this.listAdd(this.edgeChangedList, eS0)) {
            affectedList = 2;
        }
        affectedList = 0;
        if (!this.edgeAddedList.contains(eS1) && this.listAdd(this.edgeChangedList, eS1)) {
            affectedList = 2;
        }
        if (e.endNode == sNodeID) {
            e.endNode = tNodeID;
        } else {
            e.originNode = tNodeID;
        }
        Face fL = this.getFace(e.boundedFaceL);
        Face fR = this.getFace(e.boundedFaceR);
        for (i = 0; i < movedIsoNodes.size(); ++i) {
            Object backupNode = null;
            backupFaceFF = null;
            backupFaceFT = null;
            id = (Integer)movedIsoNodes.get(i);
            n = this.getNode(id);
            if (n.containFace == e.boundedFaceL) {
                fF = fL;
                fT = fR;
                n.containFace = e.boundedFaceR;
            } else {
                fF = fR;
                fT = fL;
                n.containFace = e.boundedFaceL;
            }
            fF.trimIslandNodes(id);
            fT.extendIslandNodes(id);
            affectedList = 0;
            if (this.nodeAddedList.contains(n) || !this.listAdd(this.nodeChangedList, n)) continue;
            affectedList = 2;
        }
        for (i = 0; i < movedIsoEdges.size(); ++i) {
            Object backupEdgeT = null;
            backupFaceFF = null;
            backupFaceFT = null;
            id = (Integer)movedIsoEdges.get(i);
            eT = this.getEdge(id);
            if (id > 0 && eT.boundedFaceL == e.boundedFaceL || id < 0 && eT.boundedFaceR == e.boundedFaceL) {
                fF = fL;
                fT = fR;
            } else {
                fF = fR;
                fT = fL;
            }
            fF.trimIslandEdges(id);
            fT.extendIslandEdges(id);
            edgeT = id;
            do {
                eT = this.getEdge(edgeT);
                if (edgeT > 0) {
                    eT.boundedFaceL = fT.id;
                } else {
                    eT.boundedFaceR = fT.id;
                }
                affectedList = 0;
                if (this.edgeAddedList.contains(eT) || !this.listAdd(this.edgeChangedList, eT)) continue;
                affectedList = 2;
            } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != id);
        }
        Point2DD[] mbrE = new Point2DD[]{new Point2DD(), new Point2DD()};
        Point2DD[] mbrA = new Point2DD[2];
        edgeT = edgeID;
        do {
            backupEdgeET = null;
            eT = this.getEdge(edgeT);
            if (edgeT > 0 && eT.boundedFaceL != e.boundedFaceL || edgeT < 0 && eT.boundedFaceR != e.boundedFaceL) {
                if (edgeT > 0) {
                    eT.boundedFaceL = e.boundedFaceL;
                } else {
                    eT.boundedFaceR = e.boundedFaceL;
                }
                affectedList = 0;
                if (!this.edgeAddedList.contains(eT) && this.listAdd(this.edgeChangedList, eT)) {
                    affectedList = 2;
                }
            }
            if (!leftOutside) continue;
            eT.computeMBR(mbrE);
            CompGeom.augmentMBR((Point2DD[])mbrE, (Point2DD[])mbrA);
        } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edgeID);
        if (leftOutside) {
            if (this.areFacesIndexed) {
                mbrD[0][0] = fL.mbr[0].x;
                mbrD[0][1] = fL.mbr[1].x;
                mbrD[1][0] = fL.mbr[0].y;
                mbrD[1][1] = fL.mbr[1].y;
                this.faceRTree.removeEntry(mbrD, (Object)fL);
            }
            Object backupFL = null;
            fL.mbr = mbrA;
            if (this.areFacesIndexed) {
                mbrD[0][0] = fL.mbr[0].x;
                mbrD[0][1] = fL.mbr[1].x;
                mbrD[1][0] = fL.mbr[0].y;
                mbrD[1][1] = fL.mbr[1].y;
                this.faceRTree.addEntry(mbrD, (Object)fL);
            }
        }
        mbrA = new Point2DD[2];
        edgeT = -edgeID;
        do {
            backupEdgeET = null;
            eT = this.getEdge(edgeT);
            if (edgeT > 0 && eT.boundedFaceL != e.boundedFaceR || edgeT < 0 && eT.boundedFaceR != e.boundedFaceR) {
                if (edgeT > 0) {
                    eT.boundedFaceL = e.boundedFaceR;
                } else {
                    eT.boundedFaceR = e.boundedFaceR;
                }
                affectedList = 0;
                if (!this.edgeAddedList.contains(eT) && this.listAdd(this.edgeChangedList, eT)) {
                    affectedList = 2;
                }
            }
            if (!rightOutside) continue;
            eT.computeMBR(mbrE);
            CompGeom.augmentMBR((Point2DD[])mbrE, (Point2DD[])mbrA);
        } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != -edgeID);
        if (rightOutside) {
            if (this.areFacesIndexed) {
                mbrD[0][0] = fR.mbr[0].x;
                mbrD[0][1] = fR.mbr[1].x;
                mbrD[1][0] = fR.mbr[0].y;
                mbrD[1][1] = fR.mbr[1].y;
                this.faceRTree.removeEntry(mbrD, (Object)fR);
            }
            Object backupFR = null;
            fR.mbr = mbrA;
            if (this.areFacesIndexed) {
                mbrD[0][0] = fR.mbr[0].x;
                mbrD[0][1] = fR.mbr[1].x;
                mbrD[1][0] = fR.mbr[0].y;
                mbrD[1][1] = fR.mbr[1].y;
                this.faceRTree.addEntry(mbrD, (Object)fR);
            }
        }
    }

    public int addEdge(int node1, int node2, Point2DD[] coords) throws InvalidTopoOperationException, TopoEntityNotFoundException {
        return this.addEdge(node1, node2, coords, true);
    }

    private int addEdge(int node1, int node2, Point2DD[] coords, boolean doIntersections) throws InvalidTopoOperationException, TopoEntityNotFoundException {
        int affectedList;
        int edgeT;
        Node n2;
        Node n1;
        if (node1 == node2) {
            return this.addLoop(node1, coords, doIntersections);
        }
        try {
            n1 = this.getNode(node1);
            n2 = this.getNode(node2);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("addEdge called with a node ID that does not exist");
        }
        if (!n1.coord.equals(coords[0]) || !n2.coord.equals(coords[coords.length - 1])) {
            throw new InvalidTopoOperationException("Coordinates passed to addEdge do not match node coordinates at endpoints");
        }
        int[] edgeSeq = new int[2];
        int face = this.faceInto(n1, coords[1], edgeSeq);
        int edge1s = edgeSeq[0];
        int edge1n = edgeSeq[1];
        if (this.faceInto(n2, coords[coords.length - 2], edgeSeq) != face) {
            throw new InvalidTopoOperationException("Attempt to add an edge that ends in different faces");
        }
        Face f = this.getFace(face);
        Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
        double[][] mbrD = new double[2][2];
        CompGeom.computeMBR((Point2DD[])coords, (Point2DD[])mbr);
        mbrD[0][0] = mbr[0].x;
        mbrD[0][1] = mbr[1].x;
        mbrD[1][0] = mbr[0].y;
        mbrD[1][1] = mbr[1].y;
        if (doIntersections) {
            if (CompGeom.lineStringSelfIntersects((Point2DD[])coords, (boolean)false)) {
                throw new InvalidTopoOperationException("add edge coordinate string self-intersects");
            }
            ArrayList aL = new ArrayList(6);
            if (this.areEdgesIndexed && this.edgeRTree.search(mbrD, aL)) {
                for (int i = 0; i < aL.size(); ++i) {
                    Edge eR = (Edge)aL.get(i);
                    if (!eR.intersects(coords, true)) continue;
                    throw new InvalidTopoOperationException("add edge coordinate string has an intersection with another edge");
                }
            }
            for (int i = 0; i < f.islandNodes.length; ++i) {
                Node n;
                if (f.islandNodes[i] == node1 || f.islandNodes[i] == node2) continue;
                try {
                    n = this.getNode(f.islandNodes[i]);
                }
                catch (TopoEntityNotFoundException it) {
                    continue;
                }
                for (int j = 0; j < coords.length - 1; ++j) {
                    if (!n.coord.equals(coords[j]) && !CompGeom.onLine((Point2DD)n.coord, (Point2DD)coords[j], (Point2DD)coords[j + 1])) continue;
                    throw new InvalidTopoOperationException("Add edge coordinates would overlap isolated node ID " + n.id);
                }
            }
        }
        int edge2s = edgeSeq[0];
        int edge2n = edgeSeq[1];
        Edge e1s = this.getEdge(edge1s);
        Edge e1n = this.getEdge(edge1n);
        Edge e2s = this.getEdge(edge2s);
        Edge e2n = this.getEdge(edge2n);
        Edge eT = null;
        boolean faceSplit = false;
        if (edge1s != 0 && edge2s != 0) {
            edgeT = edge1n;
            do {
                try {
                    eT = this.getEdge(edgeT);
                }
                catch (TopoEntityNotFoundException tn) {
                    // empty catch block
                }
                if ((edgeT > 0 ? eT.endNode : eT.originNode) != node2) continue;
                faceSplit = true;
                break;
            } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edge1n);
        }
        boolean onBoundary = false;
        if (faceSplit) {
            if (face != -1) {
                edgeT = edge2n;
                do {
                    if (edgeT == f.boundaryEdge) {
                        onBoundary = true;
                        break;
                    }
                    eT = this.getEdge(edgeT);
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edge2n);
            }
            if (!onBoundary) {
                edgeT = edge2n;
                block27: do {
                    for (int i = 0; i < f.islandEdges.length; ++i) {
                        if (edgeT != f.islandEdges[i]) continue;
                        Object backupFace = null;
                        f.trimIslandEdges(edgeT);
                        break block27;
                    }
                    try {
                        eT = this.getEdge(edgeT);
                    }
                    catch (TopoEntityNotFoundException tn) {
                        // empty catch block
                    }
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edge2n);
            }
        }
        Object backupN = null;
        Object backupF = null;
        Object backupELS = null;
        Object backupELN = null;
        int edge = this.newEdgeID();
        Edge e = this.getEdge(edge);
        this.listAdd(this.edgeAddedList, e);
        e.boundedFaceL = e.boundedFaceR = face;
        if (edge1s == 0) {
            e.prevEdgeL = -edge;
            e.nextEdgeR = edge;
            if (!this.faceAddedList.contains(f)) {
                this.listAdd(this.faceChangedList, f);
            }
            n1.startEdge = edge;
            n1.containFace = 0;
            f.trimIslandNodes(node1);
            affectedList = 0;
            if (!this.nodeAddedList.contains(n1) && this.listAdd(this.nodeChangedList, n1)) {
                affectedList = 2;
            }
        } else {
            e.prevEdgeL = -edge1s;
            e.nextEdgeR = edge1n;
            if (edge1s > 0) {
                e1s.nextEdgeR = edge;
            } else {
                e1s.nextEdgeL = edge;
            }
            int affectedListELS = 0;
            if (!this.edgeAddedList.contains(e1s) && this.listAdd(this.edgeChangedList, e1s)) {
                affectedListELS = 2;
            }
            if (edge1n > 0) {
                e1n.prevEdgeL = -edge;
            } else {
                e1n.prevEdgeR = -edge;
            }
            int affectedListELN = 0;
            if (!this.edgeAddedList.contains(e1n) && this.listAdd(this.edgeChangedList, e1n)) {
                affectedListELN = 2;
            }
        }
        if (edge2s == 0) {
            e.nextEdgeL = -edge;
            e.prevEdgeR = edge;
            if (!this.faceAddedList.contains(f)) {
                this.listAdd(this.faceChangedList, f);
            }
            n2.startEdge = -edge;
            n2.containFace = 0;
            f.trimIslandNodes(node2);
            affectedList = 0;
            if (!this.nodeAddedList.contains(n2) && this.listAdd(this.nodeChangedList, n2)) {
                affectedList = 2;
            }
        } else {
            e.prevEdgeR = -edge2s;
            e.nextEdgeL = edge2n;
            if (edge2s > 0) {
                e2s.nextEdgeR = -edge;
            } else {
                e2s.nextEdgeL = -edge;
            }
            int affectedListE2S = 0;
            if (!this.edgeAddedList.contains(e2s) && this.listAdd(this.edgeChangedList, e2s)) {
                affectedListE2S = 2;
            }
            if (edge2n > 0) {
                e2n.prevEdgeL = edge;
            } else {
                e2n.prevEdgeR = edge;
            }
            int affectedListE2N = 0;
            if (!this.edgeAddedList.contains(e2n) && this.listAdd(this.edgeChangedList, e2n)) {
                affectedListE2N = 2;
            }
        }
        e.originNode = node1;
        e.endNode = node2;
        e.fillCoords(coords);
        if (this.areEdgesIndexed) {
            this.edgeRTree.addEntry(mbrD, (Object)e);
        }
        affectedList = 0;
        if (!faceSplit) {
            if (edge1s == 0 && edge2s == 0) {
                f.extendIslandEdges(edge);
            } else if (edge1s != 0 && edge2s != 0) {
                int i;
                block29: for (i = 0; i < f.islandEdges.length; ++i) {
                    edgeT = f.islandEdges[i];
                    do {
                        int nodeT;
                        try {
                            eT = this.getEdge(edgeT);
                        }
                        catch (TopoEntityNotFoundException tn) {
                            // empty catch block
                        }
                        int n = nodeT = edgeT > 0 ? eT.endNode : eT.originNode;
                        if (nodeT == node1 || nodeT == node2) break block29;
                    } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != f.islandEdges[i]);
                }
                if (!this.faceAddedList.contains(f) && this.listAdd(this.faceChangedList, f)) {
                    affectedList = 2;
                }
                f.trimIslandEdges(f.islandEdges[i]);
            }
        } else {
            int i;
            int i2;
            if (this.areFacesIndexed && f.id != -1) {
                mbrD[0][0] = f.mbr[0].x;
                mbrD[0][1] = f.mbr[1].x;
                mbrD[1][0] = f.mbr[0].y;
                mbrD[1][1] = f.mbr[1].y;
                this.faceRTree.removeEntry(mbrD, (Object)f);
            }
            double polyArea = 0.0;
            int faceN = this.newFaceID();
            Face fN = this.getFace(faceN);
            this.listAdd(this.faceAddedList, fN);
            affectedList = 0;
            if (!this.faceAddedList.contains(f) && this.listAdd(this.faceChangedList, f)) {
                affectedList = 2;
            }
            if (onBoundary) {
                fN.boundaryEdge = edge;
                f.boundaryEdge = -edge;
            } else {
                edgeT = edge2n;
                Point2DD offset = new Point2DD();
                do {
                    try {
                        eT = this.getEdge(edgeT);
                    }
                    catch (TopoEntityNotFoundException tn) {
                        // empty catch block
                    }
                    if (edgeT == edge2n) {
                        offset.x = eT.coords[0].x;
                        offset.y = eT.coords[0].y;
                    }
                    double temp = eT.subtendedArea(offset);
                    polyArea += edgeT > 0 ? temp : -temp;
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edge2n);
                fN.boundaryEdge = polyArea > 0.0 ? edge : -edge;
            }
            Point2DD[] mbrE = new Point2DD[2];
            for (int i3 = 0; i3 < 2; ++i3) {
                mbr[i3] = new Point2DD();
                mbrE[i3] = new Point2DD();
            }
            boolean[] islNodeBoolArray = new boolean[f.islandNodes.length];
            boolean[] islEdgeBoolArray = new boolean[f.islandEdges.length];
            boolean[] islNodeLockedArray = new boolean[f.islandNodes.length];
            boolean[] islEdgeLockedArray = new boolean[f.islandEdges.length];
            for (i2 = 0; i2 < f.islandNodes.length; ++i2) {
                islNodeBoolArray[i2] = false;
                islNodeLockedArray[i2] = true;
            }
            for (i2 = 0; i2 < f.islandEdges.length; ++i2) {
                islEdgeBoolArray[i2] = false;
                islEdgeLockedArray[i2] = true;
            }
            edgeT = fN.boundaryEdge;
            do {
                try {
                    eT = this.getEdge(edgeT);
                }
                catch (TopoEntityNotFoundException tn) {
                    // empty catch block
                }
                Object backupET = null;
                if (edgeT > 0) {
                    eT.boundedFaceL = faceN;
                } else {
                    eT.boundedFaceR = faceN;
                }
                int affectedListET = 0;
                if (!this.edgeAddedList.contains(eT) && this.listAdd(this.edgeChangedList, eT)) {
                    affectedListET = 2;
                }
                if (edgeT == fN.boundaryEdge) {
                    eT.computeMBR(mbr);
                } else {
                    eT.computeMBR(mbrE);
                    CompGeom.augmentMBR((Point2DD[])mbrE, (Point2DD[])mbr);
                }
                Node nn = null;
                for (int i4 = 0; i4 < f.islandNodes.length; ++i4) {
                    try {
                        nn = this.getNode(f.islandNodes[i4]);
                    }
                    catch (TopoEntityNotFoundException it) {
                        islNodeLockedArray[i4] = false;
                    }
                    islNodeBoolArray[i4] = CompGeom.incPointInPolygon((Point2DD)nn.coord, (Point2DD[])eT.coords, (boolean)islNodeBoolArray[i4]);
                }
                Edge ee = null;
                for (int i5 = 0; i5 < f.islandEdges.length; ++i5) {
                    try {
                        ee = this.getEdge(f.islandEdges[i5]);
                    }
                    catch (TopoEntityNotFoundException it) {
                        islEdgeLockedArray[i5] = false;
                    }
                    islEdgeBoolArray[i5] = CompGeom.incPointInPolygon((Point2DD)ee.coords[0], (Point2DD[])eT.coords, (boolean)islEdgeBoolArray[i5]);
                }
            } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != fN.boundaryEdge);
            fN.mbr = mbr;
            IntArrayList islNodeMovedList = new IntArrayList(f.islandNodes.length);
            IntArrayList islEdgeMovedList = new IntArrayList(f.islandEdges.length);
            IntArrayList islDummyList = new IntArrayList(0);
            for (i = 0; i < f.islandNodes.length; ++i) {
                if (!islNodeBoolArray[i]) continue;
                islNodeMovedList.add(f.islandNodes[i]);
                Node nn = this.getNode(f.islandNodes[i]);
                nn.containFace = faceN;
                int affectedListNN = 0;
                if (this.nodeAddedList.contains(nn) || !this.listAdd(this.nodeChangedList, nn)) continue;
                affectedListNN = 2;
            }
            for (i = 0; i < f.islandEdges.length; ++i) {
                if (!islEdgeBoolArray[i]) continue;
                edgeT = f.islandEdges[i];
                islEdgeMovedList.add(edgeT);
                do {
                    try {
                        eT = this.getEdge(edgeT);
                    }
                    catch (TopoEntityNotFoundException tn) {
                        // empty catch block
                    }
                    Object backupET = null;
                    if (edgeT > 0) {
                        eT.boundedFaceL = faceN;
                    } else {
                        eT.boundedFaceR = faceN;
                    }
                    int affectedListET = 0;
                    if (this.edgeAddedList.contains(eT) || !this.listAdd(this.edgeChangedList, eT)) continue;
                    affectedListET = 2;
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != f.islandEdges[i]);
            }
            f.adjustIslandNodes(islNodeMovedList, islDummyList);
            f.adjustIslandEdges(islEdgeMovedList, islDummyList);
            fN.adjustIslandNodes(islDummyList, islNodeMovedList);
            fN.adjustIslandEdges(islDummyList, islEdgeMovedList);
            if (!onBoundary) {
                f.extendIslandEdges(polyArea > 0.0 ? -edge : edge);
            }
            if (face != -1) {
                mbr = new Point2DD[2];
                mbrE = new Point2DD[2];
                for (i = 0; i < 2; ++i) {
                    mbr[i] = new Point2DD();
                    mbrE[i] = new Point2DD();
                }
                edgeT = f.boundaryEdge;
                do {
                    eT = this.getEdge(edgeT);
                    if (edgeT == f.boundaryEdge) {
                        eT.computeMBR(mbr);
                        continue;
                    }
                    eT.computeMBR(mbrE);
                    CompGeom.augmentMBR((Point2DD[])mbrE, (Point2DD[])mbr);
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != f.boundaryEdge);
                f.mbr = mbr;
            }
            if (this.areFacesIndexed) {
                if (f.id != -1) {
                    mbrD[0][0] = f.mbr[0].x;
                    mbrD[0][1] = f.mbr[1].x;
                    mbrD[1][0] = f.mbr[0].y;
                    mbrD[1][1] = f.mbr[1].y;
                    this.faceRTree.addEntry(mbrD, (Object)f);
                }
                mbrD[0][0] = fN.mbr[0].x;
                mbrD[0][1] = fN.mbr[1].x;
                mbrD[1][0] = fN.mbr[0].y;
                mbrD[1][1] = fN.mbr[1].y;
                this.faceRTree.addEntry(mbrD, (Object)fN);
            }
            TopoFaceSplitInfo splitInfo = new TopoFaceSplitInfo(fN.id, f.id);
            this.faceSplitInfo.add(splitInfo);
        }
        return edge;
    }

    public int addLoop(int nodeID, Point2DD[] coords) throws TopoEntityNotFoundException, InvalidTopoOperationException {
        return this.addLoop(nodeID, coords, true);
    }

    private int addLoop(int nodeID, Point2DD[] coords, boolean doIntersections) throws TopoEntityNotFoundException, InvalidTopoOperationException {
        int i;
        int nodeT;
        int edgeT;
        int edgeS;
        Node n;
        if (coords.length < 4) {
            throw new InvalidTopoOperationException("Added loop must have at least 4 coordinates");
        }
        try {
            n = this.getNode(nodeID);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("addLoop called with a node ID that does not exist");
        }
        if (!n.coord.equals(coords[0]) || !n.coord.equals(coords[coords.length - 1])) {
            throw new InvalidTopoOperationException("Coordinates passed to addLoop do not match node " + nodeID + " at endpoints");
        }
        Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
        CompGeom.computeMBR((Point2DD[])coords, (Point2DD[])mbr);
        double[][] mbrD = new double[2][2];
        mbrD[0][0] = mbr[0].x;
        mbrD[0][1] = mbr[1].x;
        mbrD[1][0] = mbr[0].y;
        mbrD[1][1] = mbr[1].y;
        if (doIntersections) {
            if (CompGeom.lineStringSelfIntersects((Point2DD[])coords, (boolean)true)) {
                throw new InvalidTopoOperationException(" Added loop has a self-intersection");
            }
            ArrayList aL = new ArrayList(6);
            if (this.areEdgesIndexed && this.edgeRTree.search(mbrD, aL)) {
                for (int i2 = 0; i2 < aL.size(); ++i2) {
                    Edge eR = (Edge)aL.get(i2);
                    if (!eR.intersects(coords, true)) continue;
                    throw new InvalidTopoOperationException("add loop coordinate string has an intersection with another edge");
                }
            }
        }
        boolean innerContext = false;
        boolean outerContext = false;
        int newFace = this.newFaceID();
        Face newF = this.getFace(newFace);
        newF.mbr = mbr;
        int[] edgeSeqS = new int[2];
        int[] edgeSeqE = new int[2];
        int face = this.faceInto(n, coords[1], edgeSeqS);
        if (face != this.faceInto(n, coords[coords.length - 2], edgeSeqE)) {
            throw new InvalidTopoOperationException("addLoop terminates in different faces");
        }
        Face f = this.getFace(face);
        for (int i3 = 0; i3 < f.islandNodes.length; ++i3) {
            Node nI;
            if (f.islandNodes[i3] == nodeID) continue;
            try {
                nI = this.getNode(f.islandNodes[i3]);
            }
            catch (TopoEntityNotFoundException it) {
                continue;
            }
            for (int j = 0; j < coords.length - 1; ++j) {
                if (!nI.coord.equals(coords[j]) && !CompGeom.onLine((Point2DD)nI.coord, (Point2DD)coords[j], (Point2DD)coords[j + 1])) continue;
                throw new InvalidTopoOperationException("Add loop coordinates would overlap isolated node ID " + nI.id);
            }
        }
        Node nT = null;
        Edge eT = null;
        boolean isClockwise = CompGeom.isClockwise((Point2DD[])coords);
        if (this.areFacesIndexed) {
            this.faceRTree.addEntry(mbrD, (Object)newF);
        }
        int edge = this.newEdgeID();
        Edge e = this.getEdge(edge);
        if (this.areEdgesIndexed) {
            this.edgeRTree.addEntry(mbrD, (Object)e);
        }
        if (n.containFace == 0) {
            Object backupFace = null;
            block15: for (int i4 = -1; i4 < f.islandEdges.length; ++i4) {
                if (face == -1 && i4 == -1) continue;
                edgeS = i4 < 0 ? f.boundaryEdge : f.islandEdges[i4];
                edgeT = edgeS;
                do {
                    try {
                        eT = this.getEdge(edgeT);
                    }
                    catch (TopoEntityNotFoundException tn) {
                        // empty catch block
                    }
                    int n2 = nodeT = edgeT > 0 ? eT.endNode : eT.originNode;
                    if (nodeT != nodeID) continue;
                    if (i4 < 0) {
                        f.boundaryEdge = isClockwise ? edge : -edge;
                        break block15;
                    }
                    f.islandEdges[i4] = isClockwise ? edge : -edge;
                    break block15;
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edgeS);
            }
            int[] nodeStar = this.getNodeStar(nodeID);
            for (int i5 = 0; i5 < nodeStar.length; ++i5) {
                eT = this.getEdge(nodeStar[i5]);
                Point2DD p = nodeStar[i5] > 0 ? eT.coords[1] : eT.coords[eT.coords.length - 2];
                boolean inside = CompGeom.incPointInPolygon((Point2DD)p, (Point2DD[])coords, (boolean)false);
                if (!outerContext && !inside) {
                    outerContext = true;
                    if (innerContext) break;
                }
                if (innerContext || !inside) continue;
                innerContext = true;
                if (outerContext) break;
            }
            Edge eS0 = this.getEdge(edgeSeqS[0]);
            Edge eS1 = this.getEdge(edgeSeqS[1]);
            Edge eE0 = this.getEdge(edgeSeqE[0]);
            Edge eE1 = this.getEdge(edgeSeqE[1]);
            Object backupES0 = null;
            Object backupES1 = null;
            Object backupEE0 = null;
            Object backupEE1 = null;
            if (isClockwise) {
                if (!outerContext) {
                    e.nextEdgeL = edge;
                    e.prevEdgeL = edge;
                } else {
                    e.nextEdgeL = edgeSeqE[1];
                    e.prevEdgeL = -edgeSeqS[0];
                    if (edgeSeqS[0] > 0) {
                        eS0.nextEdgeR = edge;
                    } else {
                        eS0.nextEdgeL = edge;
                    }
                    if (edgeSeqE[1] > 0) {
                        eE1.prevEdgeL = edge;
                    } else {
                        eE1.prevEdgeR = edge;
                    }
                }
                if (!innerContext) {
                    e.nextEdgeR = -edge;
                    e.prevEdgeR = -edge;
                } else {
                    e.nextEdgeR = edgeSeqS[1];
                    e.prevEdgeR = -edgeSeqE[0];
                    if (edgeSeqS[1] > 0) {
                        eS1.prevEdgeL = -edge;
                    } else {
                        eS1.prevEdgeR = -edge;
                    }
                    if (edgeSeqE[0] > 0) {
                        eE0.nextEdgeR = -edge;
                    } else {
                        eE0.nextEdgeL = -edge;
                    }
                }
            } else {
                if (!outerContext) {
                    e.nextEdgeR = -edge;
                    e.prevEdgeR = -edge;
                } else {
                    e.nextEdgeR = edgeSeqS[1];
                    e.prevEdgeR = -edgeSeqE[0];
                    if (edgeSeqE[0] > 0) {
                        eE0.nextEdgeR = -edge;
                    } else {
                        eE0.nextEdgeL = -edge;
                    }
                    if (edgeSeqS[1] > 0) {
                        eS1.prevEdgeL = -edge;
                    } else {
                        eS1.prevEdgeR = -edge;
                    }
                }
                if (!innerContext) {
                    e.nextEdgeL = edge;
                    e.prevEdgeL = edge;
                } else {
                    e.nextEdgeL = edgeSeqE[1];
                    e.prevEdgeL = -edgeSeqS[0];
                    if (edgeSeqS[0] > 0) {
                        eS0.nextEdgeR = edge;
                    } else {
                        eS0.nextEdgeL = edge;
                    }
                    if (edgeSeqE[1] > 0) {
                        eE1.prevEdgeL = edge;
                    } else {
                        eE1.prevEdgeR = edge;
                    }
                }
            }
            if (outerContext) {
                Edge eS = isClockwise ? eS0 : eS1;
                Edge eE = isClockwise ? eE1 : eE0;
                Object backupES = null;
                Object backupEE = null;
                int affectedListES = 0;
                if (!this.edgeAddedList.contains(eE) && this.listAdd(this.edgeChangedList, eE)) {
                    affectedListES = 2;
                }
                int affectedListEE = 0;
                if (!this.edgeAddedList.contains(eS) && this.listAdd(this.edgeChangedList, eS)) {
                    affectedListEE = 2;
                }
            }
        } else {
            Object backupN = null;
            Object backupF = null;
            face = n.containFace;
            int affectedList = 0;
            if (!this.nodeAddedList.contains(n) && this.listAdd(this.nodeChangedList, n)) {
                affectedList = 2;
            }
            f = this.getFace(face);
            n.containFace = 0;
            n.startEdge = edge;
            f.trimIslandNodes(nodeID);
            f.extendIslandEdges(isClockwise ? edge : -edge);
            e.nextEdgeL = edge;
            e.prevEdgeL = edge;
            e.nextEdgeR = -edge;
            e.prevEdgeR = -edge;
        }
        e.originNode = nodeID;
        e.endNode = nodeID;
        if (isClockwise) {
            e.boundedFaceL = face;
            newF.boundaryEdge = -edge;
        } else {
            e.boundedFaceR = face;
            newF.boundaryEdge = edge;
        }
        e.fillCoords(coords);
        IntArrayList islNodeMovedList = new IntArrayList(f.islandNodes.length);
        IntArrayList islEdgeMovedList = new IntArrayList(f.islandEdges.length);
        IntArrayList islDummyList = new IntArrayList(0);
        boolean islandsChanged = false;
        for (i = 0; i < f.islandNodes.length; ++i) {
            Object backupN = null;
            try {
                nodeT = f.islandNodes[i];
                nT = this.getNode(nodeT);
            }
            catch (TopoEntityNotFoundException it) {
                continue;
            }
            if (!CompGeom.incPointInPolygon((Point2DD)nT.coord, (Point2DD[])coords, (boolean)false)) continue;
            islandsChanged = true;
            islNodeMovedList.add(nodeT);
            nT.containFace = newFace;
            int affectedListNT = 0;
            if (this.nodeAddedList.contains(nT) || !this.listAdd(this.nodeChangedList, nT)) continue;
            affectedListNT = 2;
        }
        for (i = 0; i < f.islandEdges.length; ++i) {
            edgeT = f.islandEdges[i];
            try {
                eT = this.getEdge(edgeT);
            }
            catch (TopoEntityNotFoundException tn) {
                // empty catch block
            }
            if (eT.endNode == nodeID || !CompGeom.incPointInPolygon((Point2DD)eT.coords[eT.coords.length - 1], (Point2DD[])coords, (boolean)false)) continue;
            islandsChanged = true;
            islEdgeMovedList.add(edgeT);
            do {
                Object backupE = null;
                if (edgeT > 0) {
                    eT.boundedFaceL = newFace;
                } else {
                    eT.boundedFaceR = newFace;
                }
                int affectedListET = 0;
                if (!this.edgeAddedList.contains(eT) && this.listAdd(this.edgeChangedList, eT)) {
                    affectedListET = 2;
                }
                edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR;
                eT = this.getEdge(edgeT);
            } while (edgeT != f.islandEdges[i]);
        }
        Object backupF = null;
        if (islandsChanged) {
            f.adjustIslandNodes(islNodeMovedList, islDummyList);
            f.adjustIslandEdges(islEdgeMovedList, islDummyList);
            newF.adjustIslandNodes(islDummyList, islNodeMovedList);
            newF.adjustIslandEdges(islDummyList, islEdgeMovedList);
        }
        this.listAdd(this.edgeAddedList, e);
        this.listAdd(this.faceAddedList, newF);
        int affectedListF = 0;
        if (!this.faceAddedList.contains(f) && this.listAdd(this.faceChangedList, f)) {
            affectedListF = 2;
        }
        edgeT = isClockwise ? -edge : edge;
        edgeS = edgeT;
        do {
            Object backupE = null;
            eT = this.getEdge(edgeT);
            if (edgeT > 0) {
                eT.boundedFaceL = newFace;
            } else {
                eT.boundedFaceR = newFace;
            }
            int affectedListET = 0;
            if (this.edgeAddedList.contains(eT) || !this.listAdd(this.edgeChangedList, eT)) continue;
            affectedListET = 2;
        } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edgeS);
        TopoFaceSplitInfo splitInfo = new TopoFaceSplitInfo(newFace, face);
        this.faceSplitInfo.add(splitInfo);
        return edge;
    }

    public int[] addLinearGeometry(JGeometry geom) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        int gtype = geom.getType();
        if (gtype != 2 && gtype != 6) {
            throw new InvalidTopoOperationException("addLinearGeometry called with a geometry that is not a line string or multi-linestring");
        }
        if (geom.getSRID() != this.srid) {
            throw new InvalidTopoOperationException("addLinearGeometry called with a geometry whose SRID does not match the topology");
        }
        int[] elemInfo = geom.getElemInfo();
        int numLines = elemInfo.length / 3;
        if (geom.hasCircularArcs()) {
            throw new InvalidTopoOperationException("addLinearGeometry called with a line string(s) that contains circular arcs");
        }
        double[] ordinates = geom.getOrdinatesArray();
        int[][] edgeResults = new int[numLines][];
        Point2DD[] line = null;
        int numEdges = 0;
        for (int i = 0; i < numLines; ++i) {
            int oStartIndex = elemInfo[3 * i] - 1;
            int oLastIndex = i == numLines - 1 ? ordinates.length - 2 : elemInfo[3 * (i + 1)] - 3;
            int numCoords = (oLastIndex - oStartIndex) / 2 + 1;
            line = new Point2DD[numCoords];
            int jj = 0;
            for (int j = oStartIndex; j <= oLastIndex; j += 2) {
                line[jj++] = new Point2DD(ordinates[j], ordinates[j + 1]);
            }
            edgeResults[i] = line[0].equals(line[line.length - 1]) && line.length < 4 ? new int[0] : this.addLinearGeometry(line);
            numEdges += edgeResults[i].length;
        }
        int[] edges = new int[numEdges];
        int index = 0;
        for (int i = 0; i < numLines; ++i) {
            for (int j = 0; j < edgeResults[i].length; ++j) {
                edges[index++] = edgeResults[i][j];
            }
        }
        return edges;
    }

    public int[] addLinearGeometry(Point2DD[] coords) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        return this.addLinearGeometry(coords, 2);
    }

    private int[] addLinearGeometry(Point2DD[] coords, int type) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        SmartPoint spE;
        Comparator comp;
        Object[] sortArray;
        int j;
        int i;
        SmartPoint sp;
        if (this.snapGrid) {
            this.snapToGrid(coords);
        }
        if (type == 2 && coords.length < 2) {
            throw new InvalidTopoOperationException("Line geometry passed to addLinearGeometry must have at least 2 vertices");
        }
        if (type == 3 && coords.length < 4) {
            throw new InvalidTopoOperationException("Polygon geometry passed to addLinearGeometry must have at least 4 vertices");
        }
        if (!this.areEdgesIndexed || !this.areFacesIndexed) {
            throw new InvalidTopoOperationException("addLinearGeometry cannot be processed without both edge and face indexes");
        }
        Face f = null;
        Edge e = null;
        Node n = null;
        int nodeCount = 0;
        Point2DD p = new Point2DD();
        boolean rollback = true;
        boolean anyInsertions = false;
        double[][] mbrD = new double[2][2];
        ArrayList edgeL = new ArrayList();
        double snapTol = this.snapGrid ? 1.0 / this.pGrid : 1.0E-9;
        block8: for (int i2 = 0; i2 < coords.length; ++i2) {
            edgeL.clear();
            mbrD[0][0] = coords[i2].x - snapTol;
            mbrD[0][1] = coords[i2].x + snapTol;
            mbrD[1][0] = coords[i2].y - snapTol;
            mbrD[1][1] = coords[i2].y + snapTol;
            if (!this.edgeRTree.search(mbrD, edgeL)) continue;
            for (int j2 = 0; j2 < edgeL.size(); ++j2) {
                e = (Edge)edgeL.get(j2);
                for (int k = 0; k < e.coords.length; ++k) {
                    if (!(Math.abs(coords[i2].x - e.coords[k].x) < snapTol) || !(Math.abs(coords[i2].y - e.coords[k].y) < snapTol)) continue;
                    coords[i2].x = e.coords[k].x;
                    coords[i2].y = e.coords[k].y;
                    continue block8;
                }
            }
        }
        SmartPoint firstPoint = null;
        SmartPoint currPoint = null;
        SmartPoint prevPoint = null;
        RTree rtS = new RTree(2, 5, 1);
        double[][][] mbhs = new double[coords.length][2][2];
        Object[] o = new Object[coords.length];
        for (int i3 = 0; i3 < coords.length; ++i3) {
            currPoint = new SmartPoint(i3, coords[i3]);
            if (i3 == 0) {
                firstPoint = currPoint;
                currPoint.prev = null;
            } else {
                currPoint.prev = prevPoint;
                prevPoint.next = currPoint;
            }
            mbhs[i3][0][0] = i3 == coords.length - 1 ? coords[i3].x : Math.min(coords[i3].x, coords[i3 + 1].x);
            mbhs[i3][0][1] = i3 == coords.length - 1 ? coords[i3].x : Math.max(coords[i3].x, coords[i3 + 1].x);
            mbhs[i3][1][0] = i3 == coords.length - 1 ? coords[i3].y : Math.min(coords[i3].y, coords[i3 + 1].y);
            mbhs[i3][1][1] = i3 == coords.length - 1 ? coords[i3].y : Math.max(coords[i3].y, coords[i3 + 1].y);
            o[i3] = currPoint;
            prevPoint = currPoint;
        }
        currPoint.next = null;
        SmartPoint lastPoint = currPoint;
        rtS.packTree(mbhs, o);
        currPoint = firstPoint;
        ArrayList<Object> aL = new ArrayList<Object>(6);
        ArrayList segList = new ArrayList(10);
        currPoint = firstPoint;
        while (currPoint.next.next != null) {
            mbrD[0][0] = Math.min(currPoint.coord.x, currPoint.next.coord.x);
            mbrD[0][1] = Math.max(currPoint.coord.x, currPoint.next.coord.x);
            mbrD[1][0] = Math.min(currPoint.coord.y, currPoint.next.coord.y);
            mbrD[1][1] = Math.max(currPoint.coord.y, currPoint.next.coord.y);
            segList.clear();
            rtS.search(mbrD, segList);
            for (int ii = 0; ii < segList.size(); ++ii) {
                SmartPoint compPoint = (SmartPoint)segList.get(ii);
                boolean foundIntersection = false;
                if (compPoint == currPoint.next || compPoint == currPoint.prev || currPoint.index >= compPoint.index) continue;
                if (currPoint.coord.equals(compPoint.coord)) {
                    foundIntersection = true;
                    p.x = currPoint.coord.x;
                    p.y = currPoint.coord.y;
                } else if (CompGeom.onLine((Point2DD)compPoint.coord, (Point2DD)currPoint.coord, (Point2DD)currPoint.next.coord)) {
                    foundIntersection = true;
                    p.x = compPoint.coord.x;
                    p.y = compPoint.coord.y;
                    sp = new SmartPoint(p);
                    if (currPoint.aL == null) {
                        currPoint.aL = new ArrayList(3);
                    }
                    currPoint.aL.add(sp);
                    anyInsertions = true;
                } else if (compPoint.next != null) {
                    if (CompGeom.onLine((Point2DD)currPoint.coord, (Point2DD)compPoint.coord, (Point2DD)compPoint.next.coord)) {
                        foundIntersection = true;
                        p.x = currPoint.coord.x;
                        p.y = currPoint.coord.y;
                        sp = new SmartPoint(p);
                        if (compPoint.aL == null) {
                            compPoint.aL = new ArrayList(3);
                        }
                        compPoint.aL.add(sp);
                        anyInsertions = true;
                    } else if (CompGeom.lineLineIntersect((Point2DD)currPoint.coord, (Point2DD)currPoint.next.coord, (Point2DD)compPoint.coord, (Point2DD)compPoint.next.coord, (Point2DD)p)) {
                        foundIntersection = true;
                        sp = new SmartPoint(p);
                        if (currPoint.aL == null) {
                            currPoint.aL = new ArrayList(3);
                        }
                        currPoint.aL.add(sp);
                        sp = new SmartPoint(p);
                        if (compPoint.aL == null) {
                            compPoint.aL = new ArrayList(3);
                        }
                        compPoint.aL.add(sp);
                        anyInsertions = true;
                    }
                }
                if (!foundIntersection) continue;
                if (type == 3 && (currPoint != firstPoint || compPoint != lastPoint)) {
                    rollback = false;
                    throw new InvalidTopoOperationException("Polygon geometry self-intersects");
                }
                int face = this.getContainingFace(p);
                if (face != 0) {
                    this.addIsolatedNode(face, p);
                    continue;
                }
                boolean gotIt = false;
                aL.clear();
                double d = p.x;
                mbrD[0][1] = d;
                mbrD[0][0] = d;
                double d2 = p.y;
                mbrD[1][1] = d2;
                mbrD[1][0] = d2;
                this.faceRTree.search(mbrD, aL);
                aL.add(this.getFace(-1));
                block14: for (i = 0; i < aL.size(); ++i) {
                    f = (Face)aL.get(i);
                    for (j = 0; j < f.islandNodes.length; ++j) {
                        Node nn;
                        try {
                            nn = this.getNode(f.islandNodes[j]);
                        }
                        catch (TopoEntityNotFoundException it) {
                            continue;
                        }
                        if (!p.equals(nn.coord)) continue;
                        gotIt = true;
                        break block14;
                    }
                }
                if (!gotIt) {
                    aL.clear();
                    if (this.edgeRTree.search(mbrD, aL)) {
                        block16: for (i = 0; i < aL.size(); ++i) {
                            e = (Edge)aL.get(i);
                            if (p.equals(this.getNode((int)e.originNode).coord) || p.equals(this.getNode((int)e.endNode).coord)) {
                                gotIt = true;
                                break;
                            }
                            for (j = 0; j < e.coords.length - 1; ++j) {
                                if (p.equals(e.coords[j])) {
                                    gotIt = true;
                                    this.addNode(e.id, p, j, false, false);
                                    break block16;
                                }
                                if (!CompGeom.onLine((Point2DD)p, (Point2DD)e.coords[j], (Point2DD)e.coords[j + 1])) continue;
                                gotIt = true;
                                this.addNode(e.id, p, j, true, false);
                                break block16;
                            }
                        }
                    }
                }
                if (gotIt) continue;
                throw new Exception("Cannot locate a point in the topology context");
            }
            currPoint = currPoint.next;
        }
        if (anyInsertions) {
            currPoint = firstPoint;
            while (currPoint != lastPoint) {
                if (currPoint.aL != null) {
                    if (currPoint.coord.x < currPoint.next.coord.x) {
                        mbrD[0][0] = currPoint.coord.x;
                        mbrD[0][1] = currPoint.next.coord.x;
                    } else {
                        mbrD[0][1] = currPoint.coord.x;
                        mbrD[0][0] = currPoint.next.coord.x;
                    }
                    if (currPoint.coord.y < currPoint.next.coord.y) {
                        mbrD[1][0] = currPoint.coord.y;
                        mbrD[1][1] = currPoint.next.coord.y;
                    } else {
                        mbrD[1][1] = currPoint.coord.y;
                        mbrD[1][0] = currPoint.next.coord.y;
                    }
                    rtS.removeEntry(mbrD, (Object)currPoint);
                    sortArray = currPoint.aL.toArray();
                    comp = new AlongSegmentComparator(currPoint.coord);
                    Arrays.sort(sortArray, 0, sortArray.length, comp);
                    spE = currPoint.next;
                    sp = currPoint;
                    for (int i4 = 0; i4 < sortArray.length; ++i4) {
                        sp.next = (SmartPoint)sortArray[i4];
                        mbrD[0][0] = sp.coord.x < sp.next.coord.x ? sp.coord.x : sp.next.coord.x;
                        mbrD[0][1] = sp.coord.x > sp.next.coord.x ? sp.coord.x : sp.next.coord.x;
                        mbrD[1][0] = sp.coord.y < sp.next.coord.y ? sp.coord.y : sp.next.coord.y;
                        mbrD[1][1] = sp.coord.y > sp.next.coord.y ? sp.coord.y : sp.next.coord.y;
                        rtS.addEntry(mbrD, (Object)sp);
                        sp.next.prev = sp;
                        sp = sp.next;
                    }
                    sp.next = spE;
                    mbrD[0][0] = sp.coord.x < sp.next.coord.x ? sp.coord.x : sp.next.coord.x;
                    mbrD[0][1] = sp.coord.x > sp.next.coord.x ? sp.coord.x : sp.next.coord.x;
                    mbrD[1][0] = sp.coord.y < sp.next.coord.y ? sp.coord.y : sp.next.coord.y;
                    mbrD[1][1] = sp.coord.y > sp.next.coord.y ? sp.coord.y : sp.next.coord.y;
                    rtS.addEntry(mbrD, (Object)sp);
                    spE.prev = sp;
                    currPoint.aL = null;
                    currPoint = sp;
                }
                currPoint = currPoint.next;
            }
        }
        anyInsertions = false;
        aL.clear();
        ArrayList<EdgeSplit> aLE = new ArrayList<EdgeSplit>(10);
        EdgeSplit es = null;
        double[][] mbrG = rtS.getMBH();
        this.edgeRTree.search(mbrG, aL);
        for (i = 0; i < aL.size(); ++i) {
            int k;
            e = (Edge)aL.get(i);
            for (j = 0; j < 2; ++j) {
                int node = j == 0 ? e.originNode : e.endNode;
                n = this.getNode(node);
                double d = n.coord.x;
                mbrD[0][1] = d;
                mbrD[0][0] = d;
                double d3 = n.coord.y;
                mbrD[1][1] = d3;
                mbrD[1][0] = d3;
                segList.clear();
                rtS.search(mbrD, segList);
                for (k = 0; k < segList.size(); ++k) {
                    currPoint = (SmartPoint)segList.get(k);
                    if (currPoint.nodeList == null) {
                        currPoint.nodeList = new IntArrayList(3);
                    }
                    if (currPoint.nodeList.contains(node)) continue;
                    currPoint.nodeList.add(node);
                    if (currPoint.coord.equals(n.coord)) {
                        ++nodeCount;
                        currPoint.nodeID = n.id;
                        continue;
                    }
                    if (currPoint == lastPoint || !CompGeom.onLine((Point2DD)n.coord, (Point2DD)currPoint.coord, (Point2DD)currPoint.next.coord)) continue;
                    sp = new SmartPoint(n.coord);
                    ++nodeCount;
                    sp.nodeID = n.id;
                    if (currPoint.aL == null) {
                        currPoint.aL = new ArrayList(3);
                    }
                    currPoint.aL.add(sp);
                    anyInsertions = true;
                }
            }
            aLE.clear();
            for (j = 0; j < e.coords.length - 1; ++j) {
                if (e.coords[j].x < e.coords[j + 1].x) {
                    mbrD[0][0] = e.coords[j].x;
                    mbrD[0][1] = e.coords[j + 1].x;
                } else {
                    mbrD[0][1] = e.coords[j].x;
                    mbrD[0][0] = e.coords[j + 1].x;
                }
                if (e.coords[j].y < e.coords[j + 1].y) {
                    mbrD[1][0] = e.coords[j].y;
                    mbrD[1][1] = e.coords[j + 1].y;
                } else {
                    mbrD[1][1] = e.coords[j].y;
                    mbrD[1][0] = e.coords[j + 1].y;
                }
                segList.clear();
                rtS.search(mbrD, segList);
                for (k = 0; k < segList.size(); ++k) {
                    currPoint = (SmartPoint)segList.get(k);
                    if (j > 0) {
                        if (e.coords[j].equals(currPoint.coord)) {
                            if (currPoint != firstPoint && currPoint != lastPoint && (CompGeom.areSegmentsParallel((Point2DD)currPoint.coord, (Point2DD)currPoint.next.coord, (Point2DD)e.coords[j], (Point2DD)e.coords[j + 1], (boolean)true) && CompGeom.areSegmentsParallel((Point2DD)currPoint.coord, (Point2DD)currPoint.prev.coord, (Point2DD)e.coords[j], (Point2DD)e.coords[j - 1], (boolean)true) || CompGeom.areSegmentsParallel((Point2DD)currPoint.coord, (Point2DD)currPoint.next.coord, (Point2DD)e.coords[j], (Point2DD)e.coords[j - 1], (boolean)true) && CompGeom.areSegmentsParallel((Point2DD)currPoint.coord, (Point2DD)currPoint.prev.coord, (Point2DD)e.coords[j], (Point2DD)e.coords[j + 1], (boolean)true))) continue;
                            ++nodeCount;
                            es = new EdgeSplit(currPoint.coord, currPoint, j, false);
                            aLE.add(es);
                            continue;
                        }
                        if (currPoint != lastPoint && CompGeom.onLine((Point2DD)e.coords[j], (Point2DD)currPoint.coord, (Point2DD)currPoint.next.coord)) {
                            sp = new SmartPoint(e.coords[j]);
                            if (currPoint.aL == null) {
                                currPoint.aL = new ArrayList(3);
                            }
                            currPoint.aL.add(sp);
                            anyInsertions = true;
                            if (CompGeom.areSegmentsParallel((Point2DD)currPoint.coord, (Point2DD)currPoint.next.coord, (Point2DD)e.coords[j - 1], (Point2DD)e.coords[j + 1], (boolean)false) && CompGeom.areSegmentsParallel((Point2DD)e.coords[j], (Point2DD)e.coords[j - 1], (Point2DD)e.coords[j], (Point2DD)e.coords[j + 1], (boolean)false)) continue;
                            ++nodeCount;
                            es = new EdgeSplit(e.coords[j], sp, j, false);
                            aLE.add(es);
                            continue;
                        }
                    }
                    if (CompGeom.onLine((Point2DD)currPoint.coord, (Point2DD)e.coords[j], (Point2DD)e.coords[j + 1])) {
                        if (currPoint != firstPoint && currPoint != lastPoint && CompGeom.areSegmentsParallel((Point2DD)currPoint.prev.coord, (Point2DD)currPoint.next.coord, (Point2DD)e.coords[j], (Point2DD)e.coords[j + 1], (boolean)false) && CompGeom.areSegmentsParallel((Point2DD)currPoint.prev.coord, (Point2DD)currPoint.coord, (Point2DD)currPoint.next.coord, (Point2DD)currPoint.coord, (boolean)false)) continue;
                        ++nodeCount;
                        es = new EdgeSplit(currPoint.coord, currPoint, j, true);
                        aLE.add(es);
                        continue;
                    }
                    if (currPoint == lastPoint || !CompGeom.lineLineIntersect((Point2DD)currPoint.coord, (Point2DD)currPoint.next.coord, (Point2DD)e.coords[j], (Point2DD)e.coords[j + 1], (Point2DD)p)) continue;
                    sp = new SmartPoint(p);
                    ++nodeCount;
                    if (currPoint.aL == null) {
                        currPoint.aL = new ArrayList(3);
                    }
                    currPoint.aL.add(sp);
                    anyInsertions = true;
                    es = new EdgeSplit(p, sp, j, true);
                    aLE.add(es);
                }
            }
            if (aLE.size() <= 0) continue;
            sortArray = aLE.toArray();
            comp = new AlongEdgeComparator(e);
            Arrays.sort(sortArray, 0, sortArray.length, comp);
            int vertexLast = 0;
            for (int m = 0; m < sortArray.length; ++m) {
                es = (EdgeSplit)sortArray[m];
                es.sp.nodeID = this.addNode(e.id, es.coord, es.vertex - vertexLast, es.openSet, false);
                e = this.getEdge(e.nextEdgeL);
                vertexLast = es.vertex;
            }
        }
        aL.clear();
        this.faceRTree.search(mbrG, aL);
        this.reuseInt.i = -1;
        if (this.faceHashMap.containsKey(this.reuseInt)) {
            aL.add(this.getFace(-1));
        }
        for (i = 0; i < aL.size(); ++i) {
            f = (Face)aL.get(i);
            for (j = 0; j < f.islandNodes.length; ++j) {
                try {
                    n = this.getNode(f.islandNodes[j]);
                }
                catch (TopoEntityNotFoundException it) {
                    continue;
                }
                double d = n.coord.x;
                mbrD[0][1] = d;
                mbrD[0][0] = d;
                double d4 = n.coord.y;
                mbrD[1][1] = d4;
                mbrD[1][0] = d4;
                segList.clear();
                rtS.search(mbrD, segList);
                for (int k = 0; k < segList.size(); ++k) {
                    currPoint = (SmartPoint)segList.get(k);
                    if (n.coord.equals(currPoint.coord)) {
                        ++nodeCount;
                        currPoint.nodeID = n.id;
                        continue;
                    }
                    if (currPoint == lastPoint || !CompGeom.onLine((Point2DD)n.coord, (Point2DD)currPoint.coord, (Point2DD)currPoint.next.coord)) continue;
                    sp = new SmartPoint(n.coord);
                    ++nodeCount;
                    sp.nodeID = n.id;
                    if (currPoint.aL == null) {
                        currPoint.aL = new ArrayList(3);
                    }
                    currPoint.aL.add(sp);
                    anyInsertions = true;
                }
            }
        }
        if (anyInsertions) {
            currPoint = firstPoint;
            while (currPoint != lastPoint) {
                if (currPoint.aL != null) {
                    sortArray = currPoint.aL.toArray();
                    comp = new AlongSegmentComparator(currPoint.coord);
                    Arrays.sort(sortArray, 0, sortArray.length, comp);
                    spE = currPoint.next;
                    sp = currPoint;
                    for (i = 0; i < sortArray.length; ++i) {
                        sp.next = (SmartPoint)sortArray[i];
                        sp.next.prev = sp;
                        sp = sp.next;
                    }
                    sp.next = spE;
                    spE.prev = sp;
                    currPoint = sp;
                    currPoint.aL = null;
                }
                currPoint = currPoint.next;
            }
        }
        if (firstPoint.nodeID == 0) {
            firstPoint.nodeID = this.addIsolatedNode(firstPoint.coord);
            ++nodeCount;
        }
        if (lastPoint.nodeID == 0) {
            lastPoint.nodeID = this.addIsolatedNode(lastPoint.coord);
            ++nodeCount;
        }
        int[] edges = new int[nodeCount - 1];
        int edgeIndex = -1;
        sp = firstPoint;
        int node2 = firstPoint.nodeID;
        block31: while (sp.next != null) {
            int i5;
            aL.clear();
            ++edgeIndex;
            spE = sp;
            int node1 = node2;
            do {
                aL.add(spE.coord);
                spE = spE.next;
            } while (spE.nodeID == 0);
            sp = spE;
            aL.add(spE.coord);
            node2 = spE.nodeID;
            int[] star1 = this.getNodeStar(node1);
            int[] star2 = this.getNodeStar(node2);
            Point2DD[] insertCoords = new Point2DD[aL.size()];
            for (i5 = 0; i5 < insertCoords.length; ++i5) {
                insertCoords[i5] = new Point2DD((Point2DD)aL.get(i5));
            }
            for (i5 = 0; i5 < star1.length; ++i5) {
                for (int j3 = 0; j3 < star2.length; ++j3) {
                    if (star2[j3] != -star1[i5]) continue;
                    e = this.getEdge(star1[i5]);
                    if ((star1[i5] <= 0 || !CompGeom.areSegmentsParallel((Point2DD)e.coords[0], (Point2DD)e.coords[1], (Point2DD)insertCoords[0], (Point2DD)insertCoords[1], (boolean)true)) && (star1[i5] >= 0 || !CompGeom.areSegmentsParallel((Point2DD)e.coords[e.coords.length - 1], (Point2DD)e.coords[e.coords.length - 2], (Point2DD)insertCoords[0], (Point2DD)insertCoords[1], (boolean)true))) continue;
                    edges[edgeIndex] = star1[i5];
                    continue block31;
                }
            }
            edges[edgeIndex] = this.addEdge(node1, node2, insertCoords, false);
        }
        if (type == 3) {
            try {
                int i6;
                e = this.getEdge(edges[0]);
                this.removeNode(edges[0] > 0 ? e.originNode : e.endNode);
                int[] edgesP = new int[edges.length - 1];
                this.reuseInt.i = Math.abs(edges[edges.length - 1]);
                if (!this.edgeHashMap.containsKey(this.reuseInt)) {
                    for (i6 = 0; i6 < edges.length - 1; ++i6) {
                        edgesP[i6] = edges[i6];
                    }
                } else {
                    for (i6 = 1; i6 < edges.length; ++i6) {
                        edgesP[i6 - 1] = edges[i6];
                    }
                }
                edges = edgesP;
            }
            catch (InvalidTopoOperationException itoe) {
                // empty catch block
            }
        }
        return edges;
    }

    public int[] addPolygonGeometry(JGeometry geom) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        int[] faces;
        int i;
        int elemEtype;
        int gtype = geom.getType();
        if (gtype != 3 && gtype != 7) {
            throw new InvalidTopoOperationException("addPolygonGeometry called with a geometry that is not a polygon or multi-polygon");
        }
        if (geom.getSRID() != this.srid) {
            throw new InvalidTopoOperationException("addPolygonGeometry called with a geometry whose SRID does not match the topology");
        }
        int[] elemInfo = geom.getElemInfo();
        double[] ordinates = geom.getOrdinatesArray();
        int numRings = elemInfo.length / 3;
        for (int i2 = 0; i2 < numRings; ++i2) {
            elemEtype = elemInfo[3 * i2 + 1];
            if (elemEtype != 5 && elemEtype != 1005 && elemEtype != 2005) continue;
            throw new InvalidTopoOperationException("addPolygonGeometry called with a geometry that contains circular arcs");
        }
        IntArrayList outerList = new IntArrayList(40);
        IntArrayList innerList = new IntArrayList(20);
        for (i = numRings - 1; i >= 0; --i) {
            int jj;
            int j;
            elemEtype = elemInfo[3 * i + 1];
            int oStartIndex = elemInfo[3 * i] - 1;
            int oLastIndex = i == numRings - 1 ? ordinates.length - 2 : elemInfo[3 * (i + 1)] - 3;
            int numCoords = (oLastIndex - oStartIndex) / 2 + 1;
            Point2DD[] ring = new Point2DD[numCoords];
            if (elemEtype == 2003) {
                j = oLastIndex;
                jj = 0;
                while (j >= oStartIndex) {
                    ring[jj] = new Point2DD(ordinates[j], ordinates[j + 1]);
                    j -= 2;
                    ++jj;
                }
                faces = this.addPolygonGeometry(ring);
                for (j = 0; j < faces.length; ++j) {
                    innerList.add(faces[j]);
                }
                continue;
            }
            j = oStartIndex;
            jj = 0;
            while (j <= oLastIndex) {
                ring[jj] = new Point2DD(ordinates[j], ordinates[j + 1]);
                j += 2;
                ++jj;
            }
            faces = this.addPolygonGeometry(ring);
            for (j = 0; j < faces.length; ++j) {
                outerList.add(faces[j]);
            }
        }
        for (i = 0; i < innerList.size(); ++i) {
            outerList.remove(outerList.indexOf(innerList.get(i)));
        }
        faces = new int[outerList.size()];
        for (i = 0; i < faces.length; ++i) {
            faces[i] = outerList.getInt(i);
        }
        return faces;
    }

    public int[] addPolygonGeometry(Point2DD[] coords) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        Edge e;
        if (!coords[0].equals(coords[coords.length - 1])) {
            throw new InvalidTopoOperationException("First and last vertex of polygon input do not coincide");
        }
        if (CompGeom.isClockwise((Point2DD[])coords)) {
            throw new InvalidTopoOperationException("Input polygon is clockwise");
        }
        int[] edges = this.addLinearGeometry(coords, 3);
        IntArrayList aL = new IntArrayList(20);
        IntArrayList aR = new IntArrayList(20);
        for (int i = 0; i < edges.length; ++i) {
            int face;
            e = this.getEdge(edges[i]);
            int n = face = edges[i] > 0 ? e.boundedFaceL : e.boundedFaceR;
            if (!aL.contains(face)) {
                aL.add(face);
            }
            int n2 = face = edges[i] > 0 ? e.boundedFaceR : e.boundedFaceL;
            if (aR.contains(face)) continue;
            aR.add(face);
        }
        double[][] mbrD = new double[2][2];
        Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
        ArrayList faces = new ArrayList(40);
        CompGeom.computeMBR((Point2DD[])coords, (Point2DD[])mbr);
        mbrD[0][0] = mbr[0].x;
        mbrD[0][1] = mbr[1].x;
        mbrD[1][0] = mbr[0].y;
        mbrD[1][1] = mbr[1].y;
        Point2DD p = new Point2DD();
        this.faceRTree.search(mbrD, faces);
        for (int i = 0; i < faces.size(); ++i) {
            Face f = (Face)faces.get(i);
            if (aL.contains(f.id) || aR.contains(f.id)) continue;
            e = this.getEdge(f.boundaryEdge);
            p.x = (e.coords[0].x + e.coords[1].x) / 2.0;
            p.y = (e.coords[0].y + e.coords[1].y) / 2.0;
            if (!CompGeom.incPointInPolygon((Point2DD)p, (Point2DD[])coords, (boolean)false)) continue;
            aL.add(f.id);
        }
        int[] returnFaces = new int[aL.size()];
        for (int i = 0; i < aL.size(); ++i) {
            returnFaces[i] = aL.getInt(i);
        }
        return returnFaces;
    }

    public boolean removeObsoleteNodes() throws TopoEntityNotFoundException {
        int i;
        boolean gotSome = false;
        Iterator it = this.getNodeIterator();
        Node[] nodes = new Node[this.nodeHashMap.size()];
        for (i = 0; i < nodes.length; ++i) {
            nodes[i] = (Node)it.next();
        }
        for (i = 0; i < nodes.length; ++i) {
            if (nodes[i].containFace != 0) continue;
            try {
                this.removeNode(nodes[i].id);
                gotSome = true;
                continue;
            }
            catch (InvalidTopoOperationException itoe) {
                // empty catch block
            }
        }
        return gotSome;
    }

    public int addPointGeometry(JGeometry geom) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        if (geom.getType() != 1) {
            throw new InvalidTopoOperationException("addPointGeometry called with a geometry that is not a point");
        }
        Point2D coord = geom.getJavaPoint();
        return this.addPointGeometry(new Point2DD(((Point2D.Double)coord).x, ((Point2D.Double)coord).y));
    }

    public int addPointGeometry(Point2DD coord) throws InvalidTopoOperationException, TopoEntityNotFoundException, Exception {
        Node n;
        if (this.snapGrid) {
            this.snapToGrid(coord);
        }
        int face = this.getContainingFace(coord);
        if (face != 0) {
            return this.addIsolatedNode(face, coord);
        }
        if (!this.areEdgesIndexed || !this.areFacesIndexed) {
            throw new InvalidTopoOperationException("Attempted to add a point geometry without edge and face indexes");
        }
        double[][] mbrD = new double[2][2];
        double d = coord.x;
        mbrD[0][1] = d;
        mbrD[0][0] = d;
        double d2 = coord.y;
        mbrD[1][1] = d2;
        mbrD[1][0] = d2;
        ArrayList<Face> aL = new ArrayList<Face>(5);
        this.edgeRTree.search(mbrD, aL);
        for (int i = 0; i < aL.size(); ++i) {
            Edge e = (Edge)aL.get(i);
            n = this.getNode(e.originNode);
            if (coord.equals(n.coord)) {
                return e.originNode;
            }
            n = this.getNode(e.endNode);
            if (coord.equals(n.coord)) {
                return e.endNode;
            }
            for (int j = 0; j < e.coords.length - 1; ++j) {
                if (coord.equals(e.coords[j])) {
                    return this.addNode(e.id, coord, j, false, false);
                }
                if (!CompGeom.onLine((Point2DD)coord, (Point2DD)e.coords[j], (Point2DD)e.coords[j + 1])) continue;
                return this.addNode(e.id, coord, j, true, false);
            }
        }
        aL.clear();
        this.faceRTree.search(mbrD, aL);
        this.reuseInt.i = -1;
        if (this.faceHashMap.containsKey(this.reuseInt)) {
            aL.add(this.getFace(-1));
        }
        for (int i = 0; i < aL.size(); ++i) {
            Face f = (Face)aL.get(i);
            for (int j = 0; j < f.islandNodes.length; ++j) {
                try {
                    n = this.getNode(f.islandNodes[j]);
                }
                catch (TopoEntityNotFoundException it) {
                    continue;
                }
                if (!coord.equals(n.coord)) continue;
                return n.id;
            }
        }
        return 0;
    }

    public void changeEdgeCoords(int edge, Point2DD[] coords) throws InvalidTopoOperationException, TopoEntityNotFoundException {
        this.changeEdgeCoords(edge, coords, new ArrayList(), new ArrayList(), true);
    }

    public void changeEdgeCoords(int edge, Point2DD[] coords, ArrayList movedIsoNodes, ArrayList movedIsoEdges, boolean allowIsoMoves) throws InvalidTopoOperationException, TopoEntityNotFoundException {
        Edge eT;
        int edgeT;
        Node n;
        Edge e;
        try {
            e = this.getEdge(edge);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("changeEdgeCoords called with an edge ID that does not exist in cache");
        }
        Object backupEdge = null;
        if (coords[0].x != e.coords[0].x || coords[0].y != e.coords[0].y || coords[coords.length - 1].x != e.coords[e.coords.length - 1].x || coords[coords.length - 1].y != e.coords[e.coords.length - 1].y) {
            throw new InvalidTopoOperationException("Changed-edge coordinates cannot move endpoints");
        }
        if (CompGeom.lineStringSelfIntersects((Point2DD[])coords, (e.originNode == e.endNode ? 1 : 0) != 0)) {
            throw new InvalidTopoOperationException("changed edge coordinate string self-intersects");
        }
        Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
        CompGeom.computeMBR((Point2DD[])coords, (Point2DD[])mbr);
        ArrayList aL = new ArrayList(6);
        double[][] mbrD = new double[2][2];
        if (this.areEdgesIndexed) {
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            if (this.edgeRTree.search(mbrD, aL)) {
                for (int i = 0; i < aL.size(); ++i) {
                    Edge eR = (Edge)aL.get(i);
                    if (eR == e || !eR.intersects(coords, true)) continue;
                    throw new InvalidTopoOperationException("changed edge coordinate string has an intersection with another edge");
                }
            }
        }
        Point2DD[] sPts = new Point2DD[]{new Point2DD(), new Point2DD(), new Point2DD()};
        for (int i = 0; i < 2; ++i) {
            n = this.getNode(i == 0 ? e.originNode : e.endNode);
            if ((i == 0 || e.nextEdgeL == -e.prevEdgeR) && (i != 0 || e.nextEdgeR == -e.prevEdgeL)) continue;
            sPts[1].x = n.coord.x;
            sPts[1].y = n.coord.y;
            int edge1 = i != 0 ? -e.prevEdgeR : -e.prevEdgeL;
            int edge2 = i != 0 ? e.nextEdgeL : e.nextEdgeR;
            Edge e1 = this.getEdge(edge1);
            Edge e2 = this.getEdge(edge2);
            if (edge1 > 0) {
                sPts[0].x = e1.coords[1].x;
                sPts[0].y = e1.coords[1].y;
            } else {
                sPts[0].x = e1.coords[e1.coords.length - 2].x;
                sPts[0].y = e1.coords[e1.coords.length - 2].y;
            }
            if (edge2 > 0) {
                sPts[2].x = e2.coords[1].x;
                sPts[2].y = e2.coords[1].y;
            } else {
                sPts[2].x = e2.coords[e2.coords.length - 2].x;
                sPts[2].y = e2.coords[e2.coords.length - 2].y;
            }
            if (CompGeom.inSector((Point2DD)(i == 0 ? coords[1] : coords[coords.length - 2]), (Point2DD[])sPts)) continue;
            throw new InvalidTopoOperationException("Changing edge coordinates attempts to reorder node star at node " + n.id);
        }
        if (e.originNode == e.endNode && e.subtendedArea() * CompGeom.subtendedArea((Point2DD[])coords) < 0.0) {
            throw new InvalidTopoOperationException("Changing a loop's coordinates reverses the sense of the loop");
        }
        if (e.boundedFaceL != e.boundedFaceR && this.getNodeStarCount(e.originNode) == 2 && this.getNodeStarCount(e.endNode) == 2) {
            double area1 = e.subtendedArea();
            double area2 = CompGeom.subtendedArea((Point2DD[])coords);
            edgeT = e.nextEdgeL;
            do {
                eT = this.getEdge(edgeT);
                double incArea = eT.subtendedArea();
                if (edgeT < 0) {
                    area1 -= incArea;
                    area2 -= incArea;
                    continue;
                }
                area1 += incArea;
                area2 += incArea;
            } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != edge);
            if (area1 * area2 < 0.0) {
                throw new InvalidTopoOperationException("Change edge coordinates produces a disallowed mirror image");
            }
        }
        IntArrayList movedNodeListL = new IntArrayList();
        IntArrayList movedEdgeListL = new IntArrayList();
        IntArrayList movedNodeListR = new IntArrayList();
        IntArrayList movedEdgeListR = new IntArrayList();
        Face fL = this.getFace(e.boundedFaceL);
        Face fR = this.getFace(e.boundedFaceR);
        for (int i = 0; i < fL.islandNodes.length; ++i) {
            try {
                n = this.getNode(fL.islandNodes[i]);
            }
            catch (TopoEntityNotFoundException it) {
                continue;
            }
            for (int k = 0; k < coords.length - 1; ++k) {
                if (!n.coord.equals(coords[k]) && !CompGeom.onLine((Point2DD)n.coord, (Point2DD)coords[k], (Point2DD)coords[k + 1])) continue;
                throw new InvalidTopoOperationException("Changed edge coordinates would pass through isolated node ID " + n.id);
            }
        }
        if (e.boundedFaceL != e.boundedFaceR) {
            int i;
            boolean inside = false;
            for (i = 0; i < fL.islandNodes.length; ++i) {
                block72: {
                    try {
                        n = this.getNode(fL.islandNodes[i]);
                    }
                    catch (TopoEntityNotFoundException it) {
                        break block72;
                    }
                    inside = CompGeom.incPointInPolygon((Point2DD)n.coord, (Point2DD[])coords, (boolean)inside);
                    inside = CompGeom.incPointInPolygon((Point2DD)n.coord, (Point2DD[])e.coords, (boolean)inside);
                    if (inside) {
                        movedNodeListL.add(fL.islandNodes[i]);
                    }
                }
                inside = false;
            }
            inside = false;
            for (i = 0; i < fL.islandEdges.length; ++i) {
                block73: {
                    if (Math.abs(edge) != Math.abs(fL.islandEdges[i])) {
                        Point2DD p;
                        try {
                            p = this.getEdge((int)fL.islandEdges[i]).coords[0];
                            inside = CompGeom.incPointInPolygon((Point2DD)p, (Point2DD[])coords, (boolean)inside);
                        }
                        catch (TopoEntityNotFoundException it) {
                            break block73;
                        }
                        inside = CompGeom.incPointInPolygon((Point2DD)p, (Point2DD[])e.coords, (boolean)inside);
                        if (inside) {
                            movedEdgeListL.add(fL.islandEdges[i]);
                        }
                    }
                }
                inside = false;
            }
            inside = false;
            for (i = 0; i < fR.islandNodes.length; ++i) {
                block74: {
                    try {
                        n = this.getNode(fR.islandNodes[i]);
                    }
                    catch (TopoEntityNotFoundException it) {
                        break block74;
                    }
                    for (int k = 0; k < coords.length - 1; ++k) {
                        if (!n.coord.equals(coords[k]) && !CompGeom.onLine((Point2DD)n.coord, (Point2DD)coords[k], (Point2DD)coords[k + 1])) continue;
                        throw new InvalidTopoOperationException("Changed edge coordinates would pass through isolated node ID " + n.id);
                    }
                    inside = CompGeom.incPointInPolygon((Point2DD)n.coord, (Point2DD[])coords, (boolean)inside);
                    if (inside = CompGeom.incPointInPolygon((Point2DD)n.coord, (Point2DD[])e.coords, (boolean)inside)) {
                        movedNodeListR.add(fR.islandNodes[i]);
                    }
                }
                inside = false;
            }
            inside = false;
            for (i = 0; i < fR.islandEdges.length; ++i) {
                block75: {
                    if (Math.abs(edge) != Math.abs(fR.islandEdges[i])) {
                        Point2DD p;
                        try {
                            p = this.getEdge((int)fR.islandEdges[i]).coords[0];
                            inside = CompGeom.incPointInPolygon((Point2DD)p, (Point2DD[])coords, (boolean)inside);
                        }
                        catch (TopoEntityNotFoundException it) {
                            break block75;
                        }
                        inside = CompGeom.incPointInPolygon((Point2DD)p, (Point2DD[])e.coords, (boolean)inside);
                        if (inside) {
                            movedEdgeListR.add(fR.islandEdges[i]);
                        }
                    }
                }
                inside = false;
            }
            try {
                if (!movedNodeListL.isEmpty() || !movedNodeListR.isEmpty()) {
                    movedIsoNodes.addAll(movedNodeListL);
                    movedIsoNodes.addAll(movedNodeListR);
                }
            }
            catch (NullPointerException npe) {
                throw new InvalidTopoOperationException("iso node will move and movedIsoNodes passed null");
            }
            try {
                if (!movedEdgeListL.isEmpty() || !movedEdgeListR.isEmpty()) {
                    movedIsoEdges.addAll(movedEdgeListL);
                    movedIsoEdges.addAll(movedEdgeListR);
                }
            }
            catch (NullPointerException npe) {
                throw new InvalidTopoOperationException("iso edge will move and movedIsoEdges passed null");
            }
            if (!(allowIsoMoves || movedIsoNodes.isEmpty() && movedIsoEdges.isEmpty())) {
                return;
            }
            if (!(fL.id != -1 && fR.id != -1 || movedNodeListL.isEmpty() && movedNodeListR.isEmpty() && movedEdgeListL.isEmpty() && movedEdgeListR.isEmpty() || this.faceChangedList.contains(this.getFace(-1)))) {
                this.listAdd(this.faceChangedList, this.getFace(-1));
            }
        }
        if (this.areEdgesIndexed) {
            e.computeMBR(mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.removeEntry(mbrD, (Object)e);
        }
        e.fillCoords(coords);
        if (this.areEdgesIndexed) {
            e.computeMBR(mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.addEntry(mbrD, (Object)e);
        }
        int affectedList = 0;
        if (!this.edgeAddedList.contains(e) && this.listAdd(this.edgeChangedList, e)) {
            affectedList = 2;
        }
        if (e.boundedFaceL != e.boundedFaceR) {
            int affectedListET;
            Object backupET;
            int affectedListNT;
            Node nT;
            Object backupNode;
            int i;
            Object backupFL = null;
            Object backupFR = null;
            int affectedListFL = 0;
            if (!this.faceAddedList.contains(fL) && e.boundedFaceL != -1 && this.listAdd(this.faceChangedList, fL)) {
                affectedListFL = 2;
            }
            int affectedListFR = 0;
            if (!this.faceAddedList.contains(fR) && e.boundedFaceR != -1 && this.listAdd(this.faceChangedList, fR)) {
                affectedListFR = 2;
            }
            fL.adjustIslandNodes(movedNodeListL, movedNodeListR);
            fL.adjustIslandEdges(movedEdgeListL, movedEdgeListR);
            fR.adjustIslandNodes(movedNodeListR, movedNodeListL);
            fR.adjustIslandEdges(movedEdgeListR, movedEdgeListL);
            for (i = 0; i < movedNodeListL.size(); ++i) {
                backupNode = null;
                nT = this.getNode(movedNodeListL.getInt(i));
                nT.containFace = fR.id;
                affectedListNT = 0;
                if (this.nodeAddedList.contains(nT) || !this.listAdd(this.nodeChangedList, nT)) continue;
                affectedListNT = 2;
            }
            for (i = 0; i < movedNodeListR.size(); ++i) {
                backupNode = null;
                nT = this.getNode(movedNodeListR.getInt(i));
                nT.containFace = fL.id;
                affectedListNT = 0;
                if (this.nodeAddedList.contains(nT) || !this.listAdd(this.nodeChangedList, nT)) continue;
                affectedListNT = 2;
            }
            for (i = 0; i < movedEdgeListL.size(); ++i) {
                edgeT = movedEdgeListL.getInt(i);
                do {
                    backupET = null;
                    eT = this.getEdge(edgeT);
                    if (edgeT > 0) {
                        eT.boundedFaceL = fR.id;
                    } else {
                        eT.boundedFaceR = fR.id;
                    }
                    affectedListET = 0;
                    if (this.edgeAddedList.contains(eT) || !this.listAdd(this.edgeChangedList, eT)) continue;
                    affectedListET = 2;
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != movedEdgeListL.getInt(i));
            }
            for (i = 0; i < movedEdgeListR.size(); ++i) {
                edgeT = movedEdgeListR.getInt(i);
                do {
                    backupET = null;
                    eT = this.getEdge(edgeT);
                    if (edgeT > 0) {
                        eT.boundedFaceL = fL.id;
                    } else {
                        eT.boundedFaceR = fL.id;
                    }
                    affectedListET = 0;
                    if (this.edgeAddedList.contains(eT) || !this.listAdd(this.edgeChangedList, eT)) continue;
                    affectedListET = 2;
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != movedEdgeListR.getInt(i));
            }
            Point2DD[] mbrE = new Point2DD[]{new Point2DD(), new Point2DD()};
            block34: for (int sign = -1; sign < 2; sign += 2) {
                int face;
                Point2DD[] mbrF = new Point2DD[]{new Point2DD(), new Point2DD()};
                edgeT = sign * Math.abs(edge);
                int n2 = face = sign > 0 ? e.boundedFaceL : e.boundedFaceR;
                if (face == -1) continue;
                Face f = this.getFace(face);
                do {
                    eT = this.getEdge(edgeT);
                    for (int k = 0; k < f.islandEdges.length; ++k) {
                        if (eT.id == Math.abs(f.islandEdges[k])) continue block34;
                    }
                    if (Math.abs(edgeT) == Math.abs(edge)) {
                        eT.computeMBR(mbrF);
                        continue;
                    }
                    eT.computeMBR(mbrE);
                    CompGeom.augmentMBR((Point2DD[])mbrE, (Point2DD[])mbrF);
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != sign * Math.abs(edge));
                if (f.mbr[0].x == mbrF[0].x && f.mbr[0].y == mbrF[0].y && f.mbr[1].x == mbrF[1].x && f.mbr[1].y == mbrF[1].y) continue;
                Object backupF = null;
                if (this.areFacesIndexed) {
                    mbrD[0][0] = f.mbr[0].x;
                    mbrD[0][1] = f.mbr[1].x;
                    mbrD[1][0] = f.mbr[0].y;
                    mbrD[1][1] = f.mbr[1].y;
                    this.faceRTree.removeEntry(mbrD, (Object)f);
                }
                f.mbr = mbrF;
                if (!this.areFacesIndexed) continue;
                mbrD[0][0] = f.mbr[0].x;
                mbrD[0][1] = f.mbr[1].x;
                mbrD[1][0] = f.mbr[0].y;
                mbrD[1][1] = f.mbr[1].y;
                this.faceRTree.addEntry(mbrD, (Object)f);
            }
        }
    }

    public int addNode(int edgeID, Point2DD p, int coordIndex, boolean isNewShapePoint) throws TopoEntityNotFoundException, InvalidTopoOperationException {
        return this.addNode(edgeID, p, coordIndex, isNewShapePoint, true);
    }

    private int addNode(int edgeID, Point2DD p, int coordIndex, boolean isNewShapePoint, boolean doIntersections) throws TopoEntityNotFoundException, InvalidTopoOperationException {
        Node n;
        Edge eOld;
        try {
            eOld = this.getEdge(edgeID);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("addNode called with an edge ID that does not exist");
        }
        if (!isNewShapePoint) {
            if (coordIndex <= 0 || coordIndex >= eOld.coords.length - 1) {
                System.out.println("offending node at: " + p);
                throw new InvalidTopoOperationException("Attempted to add a node at an edge terminus or outside the range of the vertex array");
            }
            p = new Point2DD(eOld.coords[coordIndex].x, eOld.coords[coordIndex].y);
        }
        if (isNewShapePoint) {
            for (int i = 0; i < (eOld.boundedFaceL == eOld.boundedFaceR ? 1 : 2); ++i) {
                int face = i == 0 ? eOld.boundedFaceL : eOld.boundedFaceR;
                Face f = this.getFace(face);
                for (int j = 0; j < f.islandNodes.length; ++j) {
                    try {
                        n = this.getNode(f.islandNodes[j]);
                    }
                    catch (TopoEntityNotFoundException it) {
                        continue;
                    }
                    if (!p.equals(n.coord)) continue;
                    throw new InvalidTopoOperationException("addNode coordinate coincides with an existing isolated node");
                }
            }
        }
        int cCount = coordIndex + 1 + (isNewShapePoint ? 1 : 0);
        int oldCount = eOld.coords.length;
        Point2DD[] cOld = eOld.coords;
        Point2DD[] eOldCoords = new Point2DD[cCount];
        for (int i = 0; i <= coordIndex; ++i) {
            eOldCoords[i] = cOld[i];
        }
        if (isNewShapePoint) {
            eOldCoords[coordIndex + 1] = new Point2DD(p.x, p.y);
        }
        cCount = oldCount - coordIndex;
        Point2DD[] eNewCoords = new Point2DD[cCount];
        eNewCoords[0] = new Point2DD(p.x, p.y);
        for (int i = 1; i < cCount; ++i) {
            eNewCoords[i] = cOld[coordIndex + i];
        }
        Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
        double[][] mbrD = new double[2][2];
        if (isNewShapePoint && doIntersections) {
            if (CompGeom.lineStringSelfIntersects((Point2DD[])eOldCoords, (boolean)false)) {
                throw new InvalidTopoOperationException("Add node results in self-intersection of line string");
            }
            if (CompGeom.lineStringSelfIntersects((Point2DD[])eNewCoords, (boolean)false)) {
                throw new InvalidTopoOperationException("Add node results in self-intersection of line string");
            }
            if (CompGeom.lineStringsIntersect((Point2DD[])eOldCoords, (Point2DD[])eNewCoords, (boolean)true)) {
                throw new InvalidTopoOperationException("Add node results in two pieces of split edge intersecting each other");
            }
            if (this.areEdgesIndexed) {
                Edge eR;
                int i;
                CompGeom.computeMBR((Point2DD[])eOldCoords, (Point2DD[])mbr);
                mbrD[0][0] = mbr[0].x;
                mbrD[0][1] = mbr[1].x;
                mbrD[1][0] = mbr[0].y;
                mbrD[1][1] = mbr[1].y;
                ArrayList aL = new ArrayList(6);
                if (this.edgeRTree.search(mbrD, aL)) {
                    for (i = 0; i < aL.size(); ++i) {
                        eR = (Edge)aL.get(i);
                        if (eR == eOld || !eR.intersects(eOldCoords, true)) continue;
                        throw new InvalidTopoOperationException("add node results in an intersection with another edge");
                    }
                }
                CompGeom.computeMBR((Point2DD[])eNewCoords, (Point2DD[])mbr);
                mbrD[0][0] = mbr[0].x;
                mbrD[0][1] = mbr[1].x;
                mbrD[1][0] = mbr[0].y;
                mbrD[1][1] = mbr[1].y;
                if (this.edgeRTree.search(mbrD, aL)) {
                    for (i = 0; i < aL.size(); ++i) {
                        eR = (Edge)aL.get(i);
                        if (eR == eOld || !eR.intersects(eNewCoords, true)) continue;
                        throw new InvalidTopoOperationException("add node results in an intersection with another edge");
                    }
                }
            }
        }
        Object backupEOLD = null;
        if (this.areEdgesIndexed) {
            eOld.computeMBR(mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.removeEntry(mbrD, (Object)eOld);
        }
        eOld.coords = eOldCoords;
        int nID = this.newNodeID();
        n = this.getNode(nID);
        int eID = this.newEdgeID();
        Edge eNew = this.getEdge(eID);
        eNew.coords = eNewCoords;
        int oldEndNode = eOld.endNode;
        Object backupNN = null;
        Node nn = this.getNode(oldEndNode);
        nn.startEdge = -eID;
        int affectedListNN = 0;
        if (!this.nodeAddedList.contains(nn) && this.listAdd(this.nodeChangedList, nn)) {
            affectedListNN = 2;
        }
        eOld.endNode = nID;
        int oldNextEdgeL = eOld.nextEdgeL;
        eOld.nextEdgeL = eID;
        int oldPrevEdgeR = eOld.prevEdgeR;
        eOld.prevEdgeR = -eID;
        if (this.areEdgesIndexed) {
            eOld.computeMBR(mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.addEntry(mbrD, (Object)eOld);
        }
        eNew.originNode = nID;
        eNew.endNode = oldEndNode;
        eNew.boundedFaceL = eOld.boundedFaceL;
        eNew.boundedFaceR = eOld.boundedFaceR;
        eNew.prevEdgeL = edgeID;
        eNew.nextEdgeR = -edgeID;
        if (oldNextEdgeL == -eOld.id) {
            eNew.nextEdgeL = -eID;
            eNew.prevEdgeR = eID;
        } else {
            eNew.nextEdgeL = oldNextEdgeL;
            eNew.prevEdgeR = oldPrevEdgeR;
            Edge eNEL = null;
            Edge ePER = null;
            Object backupENEL = null;
            Object backupEPER = null;
            try {
                eNEL = this.getEdge(oldNextEdgeL);
            }
            catch (TopoEntityNotFoundException tn) {
                // empty catch block
            }
            if (oldNextEdgeL == -oldPrevEdgeR) {
                ePER = eNEL;
            } else {
                try {
                    ePER = this.getEdge(oldPrevEdgeR);
                }
                catch (TopoEntityNotFoundException tn) {
                    // empty catch block
                }
            }
            if (oldNextEdgeL > 0) {
                eNEL.prevEdgeL = eID;
            } else {
                eNEL.prevEdgeR = eID;
            }
            if (oldPrevEdgeR > 0) {
                ePER.nextEdgeL = -eID;
            } else {
                ePER.nextEdgeR = -eID;
            }
            int affectedListENEL = 0;
            if (!this.edgeAddedList.contains(eNEL) && this.listAdd(this.edgeChangedList, eNEL)) {
                affectedListENEL = 2;
            }
            int affectedListEPER = 0;
            if (ePER.id != eNEL.id && !this.edgeAddedList.contains(ePER) && this.listAdd(this.edgeChangedList, ePER)) {
                affectedListEPER = 2;
            }
        }
        if (this.areEdgesIndexed) {
            eNew.computeMBR(mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.addEntry(mbrD, (Object)eNew);
        }
        n.startEdge = eID;
        n.coord = new Point2DD(p.x, p.y);
        this.listAdd(this.edgeAddedList, eNew);
        int affectListEOLD = 0;
        if (!this.edgeAddedList.contains(eOld) && this.listAdd(this.edgeChangedList, eOld)) {
            affectListEOLD = 2;
        }
        this.listAdd(this.nodeAddedList, n);
        return nID;
    }

    public int addIsolatedNode(Point2DD p) throws TopoEntityNotFoundException, InvalidTopoOperationException, Exception {
        int contFaceID = this.getContainingFace(p);
        if (contFaceID == 0) {
            throw new InvalidTopoOperationException("Attempted to add an iso node that lies on an existing edge or node");
        }
        return this.addIsolatedNode(contFaceID, p);
    }

    public int addIsolatedNode(int faceID, Point2DD p) throws TopoEntityNotFoundException, InvalidTopoOperationException {
        Node n;
        Face f;
        try {
            f = this.getFace(faceID);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("addIsolatedNode called with a face ID that does not exist");
        }
        for (int i = 0; i < f.islandNodes.length; ++i) {
            try {
                n = this.getNode(f.islandNodes[i]);
            }
            catch (TopoEntityNotFoundException it) {
                continue;
            }
            if (!p.equals(n.coord)) continue;
            throw new InvalidTopoOperationException("Attempted to add an iso node on top of an existing one");
        }
        Object backupFace = null;
        int affectedList = 0;
        if (!this.faceChangedList.contains(f) && !this.faceAddedList.contains(f)) {
            this.listAdd(this.faceChangedList, f);
            affectedList = 2;
        }
        int nID = this.newNodeID();
        n = this.getNode(nID);
        f.extendIslandNodes(nID);
        n.containFace = faceID;
        n.coord = new Point2DD(p.x, p.y);
        this.listAdd(this.nodeAddedList, n);
        return nID;
    }

    public void removeNode(int nodeID) throws InvalidTopoOperationException, TopoEntityNotFoundException {
        Node n;
        try {
            n = this.getNode(nodeID);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("removeNode called with a node ID that does not exist");
        }
        if (n.startEdge == 0) {
            Object backupF = null;
            Face ff = this.getFace(n.containFace);
            int affectedList = 0;
            if (!this.faceChangedList.contains(ff) && !this.faceAddedList.contains(ff)) {
                this.listAdd(this.faceChangedList, ff);
                affectedList = 2;
            }
            ff.trimIslandNodes(nodeID);
        } else {
            int j;
            int k;
            int i;
            int affectedList;
            int i2;
            int affectedList2;
            int nextnextEdge;
            int nextEdge;
            Edge e = this.getEdge(n.startEdge);
            int n2 = nextEdge = n.startEdge > 0 ? e.nextEdgeR : e.nextEdgeL;
            if (nextEdge == n.startEdge) {
                throw new InvalidTopoOperationException("Attempt to remove node ID " + nodeID + " which bounds a single edge");
            }
            if (nextEdge == -n.startEdge) {
                throw new InvalidTopoOperationException("Attempt to remove node ID " + nodeID + " which is in a loop");
            }
            Edge eN = this.getEdge(nextEdge);
            int n3 = nextnextEdge = nextEdge > 0 ? eN.nextEdgeR : eN.nextEdgeL;
            if (nextnextEdge != n.startEdge) {
                throw new InvalidTopoOperationException("Attempt to remove node ID " + nodeID + " which bounds 3 or more edges");
            }
            int face = eN.boundedFaceR;
            Face f = this.getFace(eN.boundedFaceL);
            Object backupF = null;
            if (Math.abs(f.boundaryEdge) == Math.abs(nextEdge)) {
                affectedList2 = 0;
                if (!this.faceAddedList.contains(f) && this.listAdd(this.faceChangedList, f)) {
                    affectedList2 = 2;
                }
                f.boundaryEdge = nextEdge > 0 ? -n.startEdge : n.startEdge;
            } else {
                for (i2 = 0; i2 < f.islandEdges.length; ++i2) {
                    if (Math.abs(f.islandEdges[i2]) != Math.abs(nextEdge)) continue;
                    affectedList = 0;
                    if (!this.faceAddedList.contains(f) && this.listAdd(this.faceChangedList, f)) {
                        affectedList = 2;
                    }
                    f.islandEdges[i2] = nextEdge > 0 ? -n.startEdge : n.startEdge;
                    break;
                }
            }
            if (eN.boundedFaceR != eN.boundedFaceL) {
                f = this.getFace(eN.boundedFaceR);
                if (Math.abs(f.boundaryEdge) == Math.abs(nextEdge)) {
                    affectedList2 = 0;
                    if (!this.faceAddedList.contains(f) && this.listAdd(this.faceChangedList, f)) {
                        affectedList2 = 2;
                    }
                    f.boundaryEdge = nextEdge > 0 ? n.startEdge : -n.startEdge;
                } else {
                    for (i2 = 0; i2 < f.islandEdges.length; ++i2) {
                        if (Math.abs(f.islandEdges[i2]) != Math.abs(nextEdge)) continue;
                        affectedList = 0;
                        if (!this.faceAddedList.contains(f) && this.listAdd(this.faceChangedList, f)) {
                            affectedList = 2;
                        }
                        f.islandEdges[i2] = nextEdge > 0 ? n.startEdge : -n.startEdge;
                        break;
                    }
                }
            }
            Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
            double[][] mbrD = new double[2][2];
            if (this.areEdgesIndexed) {
                e.computeMBR(mbr);
                mbrD[0][0] = mbr[0].x;
                mbrD[0][1] = mbr[1].x;
                mbrD[1][0] = mbr[0].y;
                mbrD[1][1] = mbr[1].y;
                this.edgeRTree.removeEntry(mbrD, (Object)e);
                eN.computeMBR(mbr);
                mbrD[0][0] = mbr[0].x;
                mbrD[0][1] = mbr[1].x;
                mbrD[1][0] = mbr[0].y;
                mbrD[1][1] = mbr[1].y;
                this.edgeRTree.removeEntry(mbrD, (Object)eN);
            }
            Node n1 = null;
            Edge e1 = null;
            Edge e2 = null;
            Object backupN1 = null;
            Object backupEdge = null;
            Object backupE1 = null;
            Object backupE2 = null;
            boolean haveEndEdges = true;
            if (n.startEdge > 0) {
                if (nextEdge > 0) {
                    e.originNode = eN.endNode;
                    n1 = this.getNode(eN.endNode);
                    n1.startEdge = n.startEdge;
                    if (eN.nextEdgeL == -nextEdge) {
                        haveEndEdges = false;
                        e.prevEdgeL = -n.startEdge;
                        e.nextEdgeR = n.startEdge;
                    } else {
                        e.nextEdgeR = eN.nextEdgeL;
                        e1 = this.getEdge(eN.nextEdgeL);
                        if (eN.nextEdgeL > 0) {
                            e1.prevEdgeL = -n.startEdge;
                        } else {
                            e1.prevEdgeR = -n.startEdge;
                        }
                        e.prevEdgeL = eN.prevEdgeR;
                        e2 = this.getEdge(eN.prevEdgeR);
                        if (eN.prevEdgeR > 0) {
                            e2.nextEdgeL = n.startEdge;
                        } else {
                            e2.nextEdgeR = n.startEdge;
                        }
                    }
                } else {
                    e.originNode = eN.originNode;
                    n1 = this.getNode(eN.originNode);
                    n1.startEdge = n.startEdge;
                    if (eN.nextEdgeR == -nextEdge) {
                        haveEndEdges = false;
                        e.prevEdgeL = -n.startEdge;
                        e.nextEdgeR = n.startEdge;
                    } else {
                        e.nextEdgeR = eN.nextEdgeR;
                        e1 = this.getEdge(eN.nextEdgeR);
                        if (eN.nextEdgeR > 0) {
                            e1.prevEdgeL = -n.startEdge;
                        } else {
                            e1.prevEdgeR = -n.startEdge;
                        }
                        e.prevEdgeL = eN.prevEdgeL;
                        e2 = this.getEdge(eN.prevEdgeL);
                        if (eN.prevEdgeL > 0) {
                            e2.nextEdgeL = n.startEdge;
                        } else {
                            e2.nextEdgeR = n.startEdge;
                        }
                    }
                }
            } else if (nextEdge > 0) {
                e.endNode = eN.endNode;
                n1 = this.getNode(eN.endNode);
                n1.startEdge = n.startEdge;
                if (eN.nextEdgeL == -nextEdge) {
                    haveEndEdges = false;
                    e.nextEdgeL = n.startEdge;
                    e.prevEdgeR = -n.startEdge;
                } else {
                    e.nextEdgeL = eN.nextEdgeL;
                    e1 = this.getEdge(eN.nextEdgeL);
                    if (eN.nextEdgeL > 0) {
                        e1.prevEdgeL = -n.startEdge;
                    } else {
                        e1.prevEdgeR = -n.startEdge;
                    }
                    e.prevEdgeR = eN.prevEdgeR;
                    e2 = this.getEdge(eN.prevEdgeR);
                    if (eN.prevEdgeR > 0) {
                        e2.nextEdgeL = n.startEdge;
                    } else {
                        e2.nextEdgeR = n.startEdge;
                    }
                }
            } else {
                e.endNode = eN.originNode;
                n1 = this.getNode(eN.originNode);
                n1.startEdge = n.startEdge;
                if (eN.nextEdgeR == -nextEdge) {
                    haveEndEdges = false;
                    e.nextEdgeL = n.startEdge;
                    e.prevEdgeR = -n.startEdge;
                } else {
                    e.nextEdgeL = eN.nextEdgeR;
                    e1 = this.getEdge(eN.nextEdgeR);
                    if (eN.nextEdgeR > 0) {
                        e1.prevEdgeL = -n.startEdge;
                    } else {
                        e1.prevEdgeR = -n.startEdge;
                    }
                    e.prevEdgeR = eN.prevEdgeL;
                    e2 = this.getEdge(eN.prevEdgeL);
                    if (eN.prevEdgeL > 0) {
                        e2.nextEdgeL = n.startEdge;
                    } else {
                        e2.nextEdgeR = n.startEdge;
                    }
                }
            }
            int affectedListN1 = 0;
            if (!this.nodeAddedList.contains(n1) && this.listAdd(this.nodeChangedList, n1)) {
                affectedListN1 = 2;
            }
            int affectedListE1 = 0;
            int affectedListE2 = 0;
            if (haveEndEdges) {
                if (!this.edgeAddedList.contains(e1) && this.listAdd(this.edgeChangedList, e1)) {
                    affectedListE1 = 2;
                }
                if (!this.edgeAddedList.contains(e2) && this.listAdd(this.edgeChangedList, e2)) {
                    affectedListE2 = 2;
                }
            }
            Point2DD[] oldCoords = e.coords;
            e.coords = new Point2DD[oldCoords.length + eN.coords.length - 1];
            if (n.startEdge > 0) {
                i = 1;
                k = eN.coords.length;
                while (i < oldCoords.length) {
                    e.coords[k] = oldCoords[i];
                    ++i;
                    ++k;
                }
                if (nextEdge > 0) {
                    k = 0;
                    for (j = eN.coords.length - 1; j >= 0; --j) {
                        e.coords[k] = eN.coords[j];
                        ++k;
                    }
                } else {
                    j = 0;
                    k = 0;
                    while (j < eN.coords.length) {
                        e.coords[k] = eN.coords[j];
                        ++j;
                        ++k;
                    }
                }
            } else {
                i = 0;
                k = 0;
                while (i < oldCoords.length - 1) {
                    e.coords[k] = oldCoords[i];
                    ++i;
                    ++k;
                }
                if (nextEdge > 0) {
                    j = 0;
                    k = oldCoords.length - 1;
                    while (j < eN.coords.length) {
                        e.coords[k] = eN.coords[j];
                        ++j;
                        ++k;
                    }
                } else {
                    j = eN.coords.length - 1;
                    k = oldCoords.length - 1;
                    while (j >= 0) {
                        e.coords[k] = eN.coords[j];
                        --j;
                        ++k;
                    }
                }
            }
            if (this.areEdgesIndexed) {
                e.computeMBR(mbr);
                mbrD[0][0] = mbr[0].x;
                mbrD[0][1] = mbr[1].x;
                mbrD[1][0] = mbr[0].y;
                mbrD[1][1] = mbr[1].y;
                this.edgeRTree.addEntry(mbrD, (Object)e);
            }
            int affectedListE = 0;
            if (!this.edgeAddedList.contains(e) && this.listAdd(this.edgeChangedList, e)) {
                affectedListE = 2;
            }
            int removedFromList = 0;
            if (this.edgeAddedList.remove(eN)) {
                removedFromList = 1;
            } else {
                if (this.edgeChangedList.remove(eN)) {
                    removedFromList = 2;
                }
                this.listAdd(this.edgeDeletedList, eN);
            }
            this.reuseInt.i = Math.abs(nextEdge);
            this.edgeHashMap.remove(this.reuseInt);
        }
        int removedFromList = 0;
        if (this.nodeAddedList.contains(n)) {
            this.nodeAddedList.remove(n);
            removedFromList = 1;
        } else {
            if (this.nodeChangedList.remove(n)) {
                removedFromList = 2;
            }
            this.listAdd(this.nodeDeletedList, n);
        }
        this.reuseInt.i = nodeID;
        this.nodeHashMap.remove(this.reuseInt);
    }

    public void removeEdge(int edgeID) throws TopoEntityNotFoundException, InvalidTopoOperationException {
        int edgeT;
        Edge e;
        edgeID = Math.abs(edgeID);
        try {
            e = this.getEdge(edgeID);
        }
        catch (TopoEntityNotFoundException tnf) {
            throw new InvalidTopoOperationException("removeEdge called with an edge ID that does not exist in cache");
        }
        Face fL = this.getFace(e.boundedFaceL);
        boolean isLoop = e.originNode == e.endNode;
        boolean isCW = false;
        boolean isIsoLoopInner = false;
        boolean isIsoLoopOuter = false;
        Edge eT = null;
        if (isLoop) {
            isCW = CompGeom.isClockwise((Point2DD[])e.coords);
            if (isCW) {
                isIsoLoopOuter = e.nextEdgeL == edgeID;
                isIsoLoopInner = e.nextEdgeR == -edgeID;
            } else {
                isIsoLoopOuter = e.nextEdgeR == -edgeID;
                isIsoLoopInner = e.nextEdgeL == edgeID;
            }
        }
        boolean onBdryL = false;
        boolean onBdryR = false;
        if (isLoop && isCW) {
            onBdryL = true;
        } else {
            edgeT = fL.boundaryEdge;
            if (edgeT != 0) {
                do {
                    if (Math.abs(edgeT) == edgeID) {
                        onBdryL = true;
                        break;
                    }
                    eT = this.getEdge(edgeT);
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != fL.boundaryEdge);
            }
        }
        boolean mergeFaces = e.boundedFaceL != e.boundedFaceR;
        double[][] mbrD = new double[2][2];
        Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
        if (mergeFaces) {
            Face fDropped;
            Face fKept;
            Face fR = this.getFace(e.boundedFaceR);
            Object backupFKept = null;
            if (isLoop) {
                fKept = isCW ? fL : fR;
                fDropped = isCW ? fR : fL;
            } else {
                int affectedList;
                edgeT = fR.boundaryEdge;
                if (edgeT != 0) {
                    do {
                        if (Math.abs(edgeT) == edgeID) {
                            onBdryR = true;
                            break;
                        }
                        eT = this.getEdge(edgeT);
                    } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != fR.boundaryEdge);
                }
                if (onBdryL && onBdryR) {
                    fKept = fL;
                    fDropped = fR;
                    fKept.boundaryEdge = e.nextEdgeL;
                    affectedList = 0;
                    if (!this.faceAddedList.contains(fKept) && this.listAdd(this.faceChangedList, fKept)) {
                        affectedList = 2;
                    }
                } else {
                    fKept = onBdryL ? fR : fL;
                    Face face = fDropped = onBdryL ? fL : fR;
                    if (fKept.trimIslandEdges(edgeID) || fKept.trimIslandEdges(-edgeID)) {
                        fKept.extendIslandEdges(e.boundedFaceL == fKept.id ? e.nextEdgeL : e.nextEdgeR);
                        affectedList = 0;
                        if (!this.faceAddedList.contains(fKept) && this.listAdd(this.faceChangedList, fKept)) {
                            affectedList = 2;
                        }
                    }
                }
            }
            edgeT = fDropped.boundaryEdge;
            Object backupET = null;
            do {
                eT = this.getEdge(edgeT);
                if (edgeT > 0) {
                    eT.boundedFaceL = fKept.id;
                } else {
                    eT.boundedFaceR = fKept.id;
                }
                int affectedListET = 0;
                if (this.edgeAddedList.contains(eT) || !this.listAdd(this.edgeChangedList, eT)) continue;
                affectedListET = 2;
            } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != fDropped.boundaryEdge);
            for (int i = 0; i < fDropped.islandEdges.length; ++i) {
                edgeT = fDropped.islandEdges[i];
                do {
                    eT = this.getEdge(edgeT);
                    if (edgeT > 0) {
                        eT.boundedFaceL = fKept.id;
                    } else {
                        eT.boundedFaceR = fKept.id;
                    }
                    int affectedListET = 0;
                    if (this.edgeAddedList.contains(eT) || !this.listAdd(this.edgeChangedList, eT)) continue;
                    affectedListET = 2;
                } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != fDropped.islandEdges[i]);
            }
            Object backupNN = null;
            for (int i = 0; i < fDropped.islandNodes.length; ++i) {
                Node nn = this.getNode(fDropped.islandNodes[i]);
                nn.containFace = fKept.id;
                int affectedListNN = 0;
                if (this.nodeAddedList.contains(nn) || !this.listAdd(this.nodeChangedList, nn)) continue;
                affectedListNN = 2;
            }
            if (fDropped.islandEdges.length != 0) {
                fKept.adjustIslandEdges(new int[0], fDropped.islandEdges);
                int affectedListF = 0;
                if (!this.faceAddedList.contains(fKept) && this.listAdd(this.faceChangedList, fKept)) {
                    affectedListF = 2;
                }
            }
            if (fDropped.islandNodes.length != 0) {
                fKept.adjustIslandNodes(new int[0], fDropped.islandNodes);
                int affectedListFK = 0;
                if (!this.faceAddedList.contains(fKept) && this.listAdd(this.faceChangedList, fKept)) {
                    affectedListFK = 2;
                }
            }
            if (isLoop) {
                int edge1 = 0;
                int edge2 = 0;
                int edge3 = 0;
                int edge4 = 0;
                Edge e1 = null;
                Edge e2 = null;
                Edge e3 = null;
                Edge e4 = null;
                if (!isIsoLoopInner) {
                    edge1 = isCW ? e.nextEdgeR : e.nextEdgeL;
                    e1 = this.getEdge(edge1);
                    edge2 = isCW ? -e.prevEdgeR : -e.prevEdgeL;
                    e2 = this.getEdge(edge2);
                }
                if (!isIsoLoopOuter) {
                    Object backupE3 = null;
                    Object backupE4 = null;
                    edge3 = isCW ? e.nextEdgeL : e.nextEdgeR;
                    e3 = this.getEdge(edge3);
                    edge4 = isCW ? -e.prevEdgeL : -e.prevEdgeR;
                    e4 = this.getEdge(edge4);
                    if (edge4 > 0) {
                        e4.nextEdgeR = isIsoLoopInner ? edge3 : edge1;
                    } else {
                        int n = e4.nextEdgeL = isIsoLoopInner ? edge3 : edge1;
                    }
                    if (edge3 > 0) {
                        e3.prevEdgeL = isIsoLoopInner ? -edge4 : -edge2;
                    } else {
                        e3.prevEdgeR = isIsoLoopInner ? -edge4 : -edge2;
                    }
                    int affectedListE3 = 0;
                    if (!this.edgeAddedList.contains(e3) && this.listAdd(this.edgeChangedList, e3)) {
                        affectedListE3 = 2;
                    }
                    int affectedListE4 = 0;
                    if (!this.edgeAddedList.contains(e4) && this.listAdd(this.edgeChangedList, e4)) {
                        affectedListE4 = 2;
                    }
                }
                if (!isIsoLoopInner) {
                    Object backupE1 = null;
                    Object backupE2 = null;
                    if (edge1 > 0) {
                        e1.prevEdgeL = isIsoLoopOuter ? -edge2 : -edge4;
                    } else {
                        int n = e1.prevEdgeR = isIsoLoopOuter ? -edge2 : -edge4;
                    }
                    if (edge2 > 0) {
                        e2.nextEdgeR = isIsoLoopOuter ? edge1 : edge3;
                    } else {
                        e2.nextEdgeL = isIsoLoopOuter ? edge1 : edge3;
                    }
                }
                Node n = this.getNode(e.originNode);
                Object backupN = null;
                if (isIsoLoopInner && isIsoLoopOuter) {
                    n.containFace = fKept.id;
                    n.startEdge = 0;
                    fKept.extendIslandNodes(n.id);
                    int affectedListF = 0;
                    if (!this.faceAddedList.contains(fKept) && this.listAdd(this.faceChangedList, fKept)) {
                        affectedListF = 2;
                    }
                } else {
                    n.startEdge = !isIsoLoopInner ? edge1 : edge3;
                }
                int affectedListN = 0;
                if (!this.nodeAddedList.contains(n) && this.listAdd(this.nodeChangedList, n)) {
                    affectedListN = 2;
                }
                boolean fKeptModified = false;
                int affectedListFK = 0;
                for (int i = -1; i < fKept.islandEdges.length; ++i) {
                    int edgeB;
                    int n2 = edgeB = i < 0 ? fKept.boundaryEdge : fKept.islandEdges[i];
                    if (Math.abs(edgeB) != e.id) continue;
                    if (i < 0) {
                        fKept.boundaryEdge = edge3;
                    } else {
                        fKept.trimIslandEdges(fKept.islandEdges[i]);
                        if (!isIsoLoopInner) {
                            fKept.extendIslandEdges(edge1);
                        } else if (!isIsoLoopOuter) {
                            fKept.extendIslandEdges(edge3);
                        }
                    }
                    if (!this.faceAddedList.contains(fKept) && this.listAdd(this.faceChangedList, fKept)) {
                        affectedListFK = 2;
                    }
                    fKeptModified = true;
                }
            } else {
                int affectedListN;
                Object backupN = null;
                Node n = this.getNode(e.originNode);
                if (n.startEdge == edgeID) {
                    n.startEdge = e.nextEdgeR;
                    affectedListN = 0;
                    if (!this.nodeAddedList.contains(n) && this.listAdd(this.nodeChangedList, n)) {
                        affectedListN = 2;
                    }
                }
                n = this.getNode(e.endNode);
                if (n.startEdge == -edgeID) {
                    n.startEdge = e.nextEdgeL;
                    affectedListN = 0;
                    if (!this.nodeAddedList.contains(n) && this.listAdd(this.nodeChangedList, n)) {
                        affectedListN = 2;
                    }
                }
                Edge eNEL = this.getEdge(e.nextEdgeL);
                Edge eNER = this.getEdge(e.nextEdgeR);
                Edge ePEL = this.getEdge(e.prevEdgeL);
                Edge ePER = this.getEdge(e.prevEdgeR);
                Object backupENEL = null;
                Object backupENER = null;
                Object backupEPEL = null;
                Object backupEPER = null;
                if (e.nextEdgeL > 0) {
                    eNEL.prevEdgeL = e.prevEdgeR;
                } else {
                    eNEL.prevEdgeR = e.prevEdgeR;
                }
                int affectedListENEL = 0;
                if (!this.edgeAddedList.contains(eNEL) && this.listAdd(this.edgeChangedList, eNEL)) {
                    affectedListENEL = 2;
                }
                if (e.nextEdgeR > 0) {
                    eNER.prevEdgeL = e.prevEdgeL;
                } else {
                    eNER.prevEdgeR = e.prevEdgeL;
                }
                int affectedListENER = 0;
                if (!this.edgeAddedList.contains(eNER) && this.listAdd(this.edgeChangedList, eNER)) {
                    affectedListENER = 2;
                }
                if (e.prevEdgeL > 0) {
                    ePEL.nextEdgeL = e.nextEdgeR;
                } else {
                    ePEL.nextEdgeR = e.nextEdgeR;
                }
                int affectedListEPEL = 0;
                if (!this.edgeAddedList.contains(ePEL) && this.listAdd(this.edgeChangedList, ePEL)) {
                    affectedListEPEL = 2;
                }
                if (e.prevEdgeR > 0) {
                    ePER.nextEdgeL = e.nextEdgeL;
                } else {
                    ePER.nextEdgeR = e.nextEdgeL;
                }
                int affectedListEPER = 0;
                if (!this.edgeAddedList.contains(ePER) && this.listAdd(this.edgeChangedList, ePER)) {
                    affectedListEPER = 2;
                }
            }
            if (this.areFacesIndexed) {
                mbrD[0][0] = fDropped.mbr[0].x;
                mbrD[0][1] = fDropped.mbr[1].x;
                mbrD[1][0] = fDropped.mbr[0].y;
                mbrD[1][1] = fDropped.mbr[1].y;
                this.faceRTree.removeEntry(mbrD, (Object)fDropped);
            }
            if (onBdryL && onBdryR && !isLoop) {
                if (this.areFacesIndexed) {
                    mbrD[0][0] = fKept.mbr[0].x;
                    mbrD[0][1] = fKept.mbr[1].x;
                    mbrD[1][0] = fKept.mbr[0].y;
                    mbrD[1][1] = fKept.mbr[1].y;
                    this.faceRTree.removeEntry(mbrD, (Object)fKept);
                }
                CompGeom.augmentMBR((Point2DD[])fDropped.mbr, (Point2DD[])fKept.mbr);
                int affectedList = 0;
                if (!this.faceAddedList.contains(fKept) && this.listAdd(this.faceChangedList, fKept)) {
                    affectedList = 2;
                }
                if (this.areFacesIndexed) {
                    mbrD[0][0] = fKept.mbr[0].x;
                    mbrD[0][1] = fKept.mbr[1].x;
                    mbrD[1][0] = fKept.mbr[0].y;
                    mbrD[1][1] = fKept.mbr[1].y;
                    this.faceRTree.addEntry(mbrD, (Object)fKept);
                }
            }
            int removedFromList = 0;
            if (this.faceAddedList.remove(fDropped)) {
                removedFromList = 1;
            } else {
                if (this.faceChangedList.remove(fDropped)) {
                    removedFromList = 2;
                }
                this.listAdd(this.faceDeletedList, fDropped);
            }
            this.reuseInt.i = fDropped.id;
            this.faceHashMap.remove(this.reuseInt);
        } else {
            Face f = this.getFace(e.boundedFaceL);
            int island = 0;
            if (!onBdryL) {
                block13: for (int i = 0; i < f.islandEdges.length; ++i) {
                    edgeT = f.islandEdges[i];
                    do {
                        try {
                            eT = this.getEdge(edgeT);
                        }
                        catch (TopoEntityNotFoundException tn) {
                            // empty catch block
                        }
                        if (Math.abs(edgeT) != edgeID) continue;
                        island = i;
                        break block13;
                    } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != f.islandEdges[i]);
                }
            }
            boolean endNodeIso = false;
            boolean origNodeIso = false;
            Node nOrigin = this.getNode(e.originNode);
            Node nEnd = this.getNode(e.endNode);
            Face backupF = this.cloneFace(f);
            Object backupNE = null;
            Object backupNO = null;
            if (e.nextEdgeL == -edgeID) {
                endNodeIso = true;
                f.extendIslandNodes(e.endNode);
                nEnd.startEdge = 0;
                nEnd.containFace = e.boundedFaceL;
                int affectedListNE = 0;
                if (!this.nodeAddedList.contains(nEnd) && this.listAdd(this.nodeChangedList, nEnd)) {
                    affectedListNE = 2;
                }
            }
            if (e.prevEdgeL == -edgeID) {
                origNodeIso = true;
                f.extendIslandNodes(e.originNode);
                nOrigin.startEdge = 0;
                nOrigin.containFace = e.boundedFaceL;
                int affectedListNO = 0;
                if (!this.nodeAddedList.contains(nOrigin) && this.listAdd(this.nodeChangedList, nOrigin)) {
                    affectedListNO = 2;
                }
            }
            if (endNodeIso && origNodeIso) {
                f.trimIslandEdges(edgeID);
                f.trimIslandEdges(-edgeID);
            } else {
                if (!endNodeIso) {
                    Edge eNEL = this.getEdge(e.nextEdgeL);
                    Edge ePER = this.getEdge(e.prevEdgeR);
                    Object backupENEL = null;
                    Object backupEPER = null;
                    if (e.nextEdgeL > 0) {
                        eNEL.prevEdgeL = e.prevEdgeR;
                    } else {
                        eNEL.prevEdgeR = e.prevEdgeR;
                    }
                    if (e.prevEdgeR > 0) {
                        ePER.nextEdgeL = e.nextEdgeL;
                    } else {
                        ePER.nextEdgeR = e.nextEdgeL;
                    }
                    int affectedListENEL = 0;
                    if (!this.edgeAddedList.contains(eNEL) && this.listAdd(this.edgeChangedList, eNEL)) {
                        affectedListENEL = 2;
                    }
                    int affectedListEPER = 0;
                    if (!this.edgeAddedList.contains(ePER) && this.listAdd(this.edgeChangedList, ePER)) {
                        affectedListEPER = 2;
                    }
                    if (nEnd.startEdge == -edgeID) {
                        nEnd.startEdge = e.nextEdgeL;
                        int affectedListNE = 0;
                        if (!this.nodeAddedList.contains(nEnd) && this.listAdd(this.nodeChangedList, nEnd)) {
                            affectedListNE = 2;
                        }
                    }
                }
                if (!origNodeIso) {
                    Edge eNER = this.getEdge(e.nextEdgeR);
                    Edge ePEL = this.getEdge(e.prevEdgeL);
                    Object backupENER = null;
                    Object backupEPEL = null;
                    if (e.nextEdgeR > 0) {
                        eNER.prevEdgeL = e.prevEdgeL;
                    } else {
                        eNER.prevEdgeR = e.prevEdgeL;
                    }
                    if (e.prevEdgeL > 0) {
                        ePEL.nextEdgeL = e.nextEdgeR;
                    } else {
                        ePEL.nextEdgeR = e.nextEdgeR;
                    }
                    int affectedListENER = 0;
                    if (!this.edgeAddedList.contains(eNER) && this.listAdd(this.edgeChangedList, eNER)) {
                        affectedListENER = 2;
                    }
                    int affectedListEPEL = 0;
                    if (!this.edgeAddedList.contains(ePEL) && this.listAdd(this.edgeChangedList, ePEL)) {
                        affectedListEPEL = 2;
                    }
                    if (nOrigin.startEdge == edgeID) {
                        nOrigin.startEdge = -e.prevEdgeL;
                        int affectedListNO = 0;
                        if (!this.nodeAddedList.contains(nOrigin) && this.listAdd(this.nodeChangedList, nOrigin)) {
                            affectedListNO = 2;
                        }
                    }
                }
                if (onBdryL) {
                    if (endNodeIso && !origNodeIso) {
                        f.boundaryEdge = e.prevEdgeL;
                    } else if (!endNodeIso && origNodeIso) {
                        f.boundaryEdge = e.nextEdgeL;
                    } else {
                        edgeT = e.nextEdgeL;
                        boolean pip = false;
                        do {
                            eT = this.getEdge(edgeT);
                            pip = CompGeom.incPointInPolygon((Point2DD)nOrigin.coord, (Point2DD[])eT.coords, (boolean)pip);
                        } while ((edgeT = edgeT > 0 ? eT.nextEdgeL : eT.nextEdgeR) != e.nextEdgeL);
                        if (pip) {
                            f.boundaryEdge = e.nextEdgeL;
                            f.extendIslandEdges(e.prevEdgeL);
                        } else {
                            f.boundaryEdge = e.prevEdgeL;
                            f.extendIslandEdges(e.nextEdgeL);
                        }
                    }
                } else if (endNodeIso && !origNodeIso) {
                    f.islandEdges[island] = e.prevEdgeL;
                } else if (!endNodeIso && origNodeIso) {
                    f.islandEdges[island] = e.nextEdgeL;
                } else {
                    f.islandEdges[island] = e.prevEdgeL;
                    f.extendIslandEdges(e.nextEdgeL);
                }
            }
            int affectedListFL = 0;
            if (!this.faceAddedList.contains(this.getFace(e.boundedFaceL)) && this.listAdd(this.faceChangedList, this.getFace(e.boundedFaceL))) {
                affectedListFL = 2;
            }
        }
        int removedFromList = 0;
        if (this.edgeAddedList.remove(e)) {
            removedFromList = 1;
        } else {
            if (this.edgeChangedList.remove(e)) {
                removedFromList = 2;
            }
            this.listAdd(this.edgeDeletedList, e);
        }
        if (this.areEdgesIndexed) {
            e.computeMBR(mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.removeEntry(mbrD, (Object)e);
        }
        this.reuseInt.i = edgeID;
        this.edgeHashMap.remove(this.reuseInt);
    }

    public boolean validateCache() throws TopoValidationException, TopoEntityNotFoundException, Exception {
        return this.validateCache(1);
    }

    public boolean validateCache(int level) throws TopoValidationException, TopoEntityNotFoundException, Exception {
        Node n;
        int edge;
        Edge e2;
        Face f;
        if (level < 0 || level > 1) {
            throw new TopoValidationException("Validation called with unsupported level param");
        }
        double[][] mbrD = new double[2][2];
        Point2DD p = new Point2DD();
        int maxEdges = 2 * this.getCacheEdgeCount();
        this.isValid0 = false;
        try {
            f = this.getFace(-1);
            if (!this.edgeHashMap.values().isEmpty() && f.islandEdges.length == 0) {
                throw new TopoValidationException(" Topology contains edges and external face island edge list is empty");
            }
        }
        catch (TopoEntityNotFoundException tenfe) {
            throw new TopoValidationException("Whole topology in cache contains no universe face");
        }
        Iterator it = this.getEdgeIterator();
        while (it.hasNext()) {
            e2 = (Edge)it.next();
            e2.traceCount = 0;
        }
        it = this.getFaceIterator();
        ArrayList aL = new ArrayList(20);
        ArrayList<Edge> eL = new ArrayList<Edge>(20);
        ArrayList<Edge> sameFaceEdgeL = new ArrayList<Edge>(10);
        double area = 0.0;
        double edgeArea = 0.0;
        Point2DD offset = new Point2DD();
        while (it.hasNext()) {
            int i;
            f = (Face)it.next();
            int face = f.id;
            eL.clear();
            sameFaceEdgeL.clear();
            area = 0.0;
            if (face == -1) continue;
            for (i = -1; i < f.islandEdges.length; ++i) {
                int edgeS = i < 0 ? f.boundaryEdge : f.islandEdges[i];
                edge = edgeS;
                e2 = this.getEdge(edge);
                if (level != 0 && i >= 0) {
                    n = this.getNode(e2.originNode);
                    if (!this.pointInFace(n.coord, f, true)) {
                        throw new TopoValidationException("Island edge " + edge + " of face " + face + " is not inside face outer polygon");
                    }
                }
                if (edgeS == 0) continue;
                int edgeCount = 0;
                do {
                    if (face != -1 && i >= 0 && Math.abs(edge) == Math.abs(f.boundaryEdge)) {
                        throw new TopoValidationException("An island of face " + face + " has an edge coincident with outer boundary");
                    }
                    ++e2.traceCount;
                    eL.add(e2);
                    if (e2.boundedFaceL == e2.boundedFaceR) {
                        if (sameFaceEdgeL.contains(e2)) {
                            sameFaceEdgeL.remove(e2);
                        } else {
                            sameFaceEdgeL.add(e2);
                        }
                    }
                    if (e2.coords.length < (e2.originNode == e2.endNode ? 4 : 2)) {
                        throw new TopoValidationException("Edge " + edge + " has less than the required number of coordinates");
                    }
                    if (face != (edge > 0 ? e2.boundedFaceL : e2.boundedFaceR)) {
                        throw new TopoValidationException("Boundary edge " + edge + " of face " + face + " does not point to face");
                    }
                    int edgeN = edge > 0 ? e2.nextEdgeL : e2.nextEdgeR;
                    Edge eN = this.getEdge(edgeN);
                    int nodeT = edge > 0 ? e2.endNode : e2.originNode;
                    if (nodeT != (edgeN > 0 ? eN.originNode : eN.endNode)) {
                        throw new TopoValidationException("Consecutive boundary edges " + edge + " and " + edgeN + " of face " + face + " don't meet at common node");
                    }
                    if (edge != (edgeN > 0 ? eN.prevEdgeL : eN.prevEdgeR)) {
                        throw new TopoValidationException("Boundary edge " + edgeN + " of face " + face + " doesn't point back to predecessor");
                    }
                    if (i < 0) {
                        if (edge == edgeS) {
                            offset.x = e2.coords[0].x;
                            offset.y = e2.coords[0].y;
                        }
                        edgeArea = e2.subtendedArea(offset);
                        area += edge > 0 ? edgeArea : -edgeArea;
                    }
                    edge = edgeN;
                    e2 = eN;
                    if (++edgeCount <= maxEdges) continue;
                    throw new TopoValidationException("The boundary trace of face " + face + " is in an endless loop");
                } while (edge != edgeS);
                if (i >= 0 || !(area < 0.0)) continue;
                throw new TopoValidationException("External boundary of face " + face + " is traced in wrong sense");
            }
            if (!sameFaceEdgeL.isEmpty()) {
                throw new TopoValidationException("An edge on the non-doubly traced outer/inner boundary of face " + f.id + " points to the face on both sides");
            }
            for (i = 0; i < f.islandNodes.length; ++i) {
                n = this.getNode(f.islandNodes[i]);
                if (n.containFace != face) {
                    throw new TopoValidationException("Island node " + f.islandNodes[i] + " does not point to face " + face + " that supposedly contains it");
                }
                if (level == 0 || f.id == -1 || this.pointInFace(n.coord, f, false)) continue;
                throw new TopoValidationException("Island node " + f.islandNodes[i] + " is not inside face " + face + " that supposedly contains it");
            }
            if (f.id == -1) continue;
            mbrD[0][0] = f.mbr[0].x;
            mbrD[0][1] = f.mbr[1].x;
            mbrD[1][0] = f.mbr[0].y;
            mbrD[1][1] = f.mbr[1].y;
            aL.clear();
            this.edgeRTree.search(mbrD, aL);
            for (Edge e2 : aL) {
                if (e2.boundedFaceL != face && e2.boundedFaceR != face || eL.contains(e2)) continue;
                throw new TopoValidationException("A portion of the boundary of face ID " + face + " is unreachable" + " from the face boundary edge or island list");
            }
        }
        it = this.getEdgeIterator();
        Point2DD[] eMBR = new Point2DD[]{new Point2DD(), new Point2DD()};
        while (it.hasNext()) {
            e2 = (Edge)it.next();
            if (e2.traceCount < 2) {
                throw new TopoValidationException("Edge " + e2.id + " is not on the boundary of one or two of the faces it links");
            }
            if (e2.boundedFaceL == -1 || e2.boundedFaceR == -1) {
                if (e2.traceCount == 1) continue;
                throw new TopoValidationException("Edge " + e2.id + " links a face but is not on its boundary");
            }
            if (e2.traceCount >= 2) continue;
            throw new TopoValidationException("Edge " + e2.id + " is not on the boundary of one or two of the faces it links");
        }
        this.isValid0 = true;
        if (level != 0) {
            this.isValid1 = false;
            it = this.getEdgeIterator();
            Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
            RTree rtS = null;
            while (it.hasNext()) {
                int i;
                e2 = (Edge)it.next();
                edge = e2.id;
                n = this.getNode(e2.originNode);
                if (n.coord.x != e2.coords[0].x || n.coord.y != e2.coords[0].y) {
                    throw new TopoValidationException("Edge " + edge + " first coordinate does not match coord. of origin node");
                }
                n = this.getNode(e2.endNode);
                if (n.coord.x != e2.coords[e2.coords.length - 1].x || n.coord.y != e2.coords[e2.coords.length - 1].y) {
                    throw new TopoValidationException("Edge " + edge + " last coordinate does not match coord. of end node");
                }
                boolean haveSegRTree = false;
                if (e2.coords.length > 2) {
                    haveSegRTree = true;
                    rtS = new RTree(2, 4, 1);
                    double[][][] mbhs = new double[e2.coords.length - 1][2][2];
                    Object[] o = new Object[e2.coords.length - 1];
                    for (i = 0; i < e2.coords.length - 1; ++i) {
                        mbhs[i][0][0] = Math.min(e2.coords[i].x, e2.coords[i + 1].x);
                        mbhs[i][0][1] = Math.max(e2.coords[i].x, e2.coords[i + 1].x);
                        mbhs[i][1][0] = Math.min(e2.coords[i].y, e2.coords[i + 1].y);
                        mbhs[i][1][1] = Math.max(e2.coords[i].y, e2.coords[i + 1].y);
                        o[i] = new Integer(i);
                    }
                    rtS.packTree(mbhs, o);
                }
                if (haveSegRTree ? CompGeom.lineStringSelfIntersects((Point2DD[])e2.coords, (e2.originNode == e2.endNode ? 1 : 0) != 0, (RTree)rtS) : CompGeom.lineStringSelfIntersects((Point2DD[])e2.coords, (e2.originNode == e2.endNode ? 1 : 0) != 0)) {
                    throw new TopoValidationException("Edge " + edge + " self-intersects");
                }
                e2.computeMBR(mbr);
                mbrD[0][0] = mbr[0].x;
                mbrD[0][1] = mbr[1].x;
                mbrD[1][0] = mbr[0].y;
                mbrD[1][1] = mbr[1].y;
                if (!this.areEdgesIndexed) {
                    throw new TopoValidationException("Level 1 validation cannot be performed without edge RTree");
                }
                aL.clear();
                if (!this.edgeRTree.search(mbrD, aL)) continue;
                for (i = 0; i < aL.size(); ++i) {
                    Edge eR = (Edge)aL.get(i);
                    if (eR == e2 || eR.coords.length > e2.coords.length) continue;
                    String chkNodes = e2.checkNodes(eR);
                    if (chkNodes != null) {
                        throw new TopoValidationException("Edge " + edge + " Nodes conflict with another Node " + chkNodes);
                    }
                    if (eR.coords.length == e2.coords.length && eR.id > e2.id || !(haveSegRTree ? e2.intersects(eR, true, rtS) : e2.intersects(eR, true))) continue;
                    throw new TopoValidationException("Edge " + edge + " coordinate string has an intersection with another edge");
                }
            }
            it = this.getNodeIterator();
            Point2DD[] sPts = new Point2DD[3];
            for (int i = 0; i < 3; ++i) {
                sPts[i] = new Point2DD();
            }
            boolean isIsoOverlap = false;
            while (it.hasNext()) {
                n = (Node)it.next();
                if (n.containFace != 0) {
                    int j;
                    mbrD[0][0] = n.coord.x;
                    mbrD[0][1] = n.coord.x;
                    mbrD[1][0] = n.coord.y;
                    mbrD[1][1] = n.coord.y;
                    aL.clear();
                    if (this.edgeRTree.search(mbrD, aL)) {
                        for (int i = 0; i < aL.size(); ++i) {
                            e2 = (Edge)aL.get(i);
                            for (j = 0; j < e2.coords.length - 1; ++j) {
                                if (!n.coord.equals(e2.coords[j]) && !CompGeom.onLine((Point2DD)n.coord, (Point2DD)e2.coords[j], (Point2DD)e2.coords[j + 1])) continue;
                                isIsoOverlap = true;
                                break;
                            }
                            if (!isIsoOverlap && !n.coord.equals(e2.coords[e2.coords.length - 1])) continue;
                            throw new TopoValidationException("Isolated node ID " + n.id + " lies on edge ID " + e2.id);
                        }
                    }
                    f = this.getFace(n.containFace);
                    boolean linked = false;
                    for (j = 0; j < f.islandNodes.length; ++j) {
                        if (n.id != f.islandNodes[j]) {
                            Node tmp = this.getNode(f.islandNodes[j]);
                            if (n.getCoord().equals(tmp.getCoord())) {
                                throw new TopoValidationException("Duplicate Isolated nodes " + n.id + " and  " + tmp.id);
                            }
                        }
                        if (n.id != f.islandNodes[j]) continue;
                        linked = true;
                        break;
                    }
                    if (linked) continue;
                    throw new TopoValidationException("Isolated node ID " + n.id + " is not on iso node list of face " + f.id);
                }
                if (n.startEdge == 0) {
                    throw new TopoValidationException("Node ID " + n.id + " does not point to a containing face or an edge");
                }
                e2 = this.getEdge(n.startEdge);
                if (n.startEdge > 0 && e2.originNode != n.id || n.startEdge < 0 && e2.endNode != n.id) {
                    throw new TopoValidationException("Start edge ID " + n.startEdge + " of node ID " + n.id + " has wrong sense");
                }
                int[] star = this.getNodeStar(n.id);
                if (star == null) {
                    throw new TopoValidationException("There is corruption of next edge L/R pointers at node " + n.id);
                }
                if (star.length <= 2) continue;
                sPts[1].x = n.coord.x;
                sPts[1].y = n.coord.y;
                for (int i = 0; i < star.length; ++i) {
                    int ip1 = i - 1;
                    if (ip1 < 0) {
                        ip1 = star.length - 1;
                    }
                    Edge e1 = this.getEdge(star[ip1]);
                    int ip2 = (i + 1) % star.length;
                    Edge e2 = this.getEdge(star[ip2]);
                    e2 = this.getEdge(star[i]);
                    if (star[ip1] > 0) {
                        sPts[0].x = e1.coords[1].x;
                        sPts[0].y = e1.coords[1].y;
                    } else {
                        sPts[0].x = e1.coords[e1.coords.length - 2].x;
                        sPts[0].y = e1.coords[e1.coords.length - 2].y;
                    }
                    if (star[ip2] > 0) {
                        sPts[2].x = e2.coords[1].x;
                        sPts[2].y = e2.coords[1].y;
                    } else {
                        sPts[2].x = e2.coords[e2.coords.length - 2].x;
                        sPts[2].y = e2.coords[e2.coords.length - 2].y;
                    }
                    if (CompGeom.inSector((Point2DD)(star[i] > 0 ? e2.coords[1] : e2.coords[e2.coords.length - 2]), (Point2DD[])sPts)) continue;
                    throw new TopoValidationException("Logical ordering of node star at node " + n.id + " does not" + " match geometric ordering");
                }
            }
            this.isValid1 = true;
        }
        return true;
    }

    public int getContainingFace(Point2DD p) throws TopoEntityNotFoundException, Exception {
        return this.getContainingFace(p, false);
    }

    public int getContainingFace(Point2DD p, boolean allow_iso_coincidence) throws TopoEntityNotFoundException, Exception {
        Face f = null;
        Edge e = null;
        Node n = null;
        Iterator it = null;
        Object srchMBR = null;
        ArrayList<Face> list = null;
        if (this.areEdgesIndexed || this.areFacesIndexed) {
            srchMBR = new double[][]{{p.x, p.x}, {p.y, p.y}};
            list = new ArrayList<Face>(8);
        }
        if (this.areEdgesIndexed) {
            this.edgeRTree.search(srchMBR, list);
            it = list.iterator();
        } else {
            it = this.getEdgeIterator();
        }
        while (it.hasNext()) {
            e = (Edge)it.next();
            for (int i = 0; i < e.coords.length - 1; ++i) {
                if (!p.equals(e.coords[i]) && !CompGeom.onLine((Point2DD)p, (Point2DD)e.coords[i], (Point2DD)e.coords[i + 1])) continue;
                if (!allow_iso_coincidence || e.boundedFaceL != e.boundedFaceR) {
                    return 0;
                }
                return e.boundedFaceL;
            }
            if (!p.equals(e.coords[e.coords.length - 1])) continue;
            if (!allow_iso_coincidence || e.boundedFaceL != e.boundedFaceR) {
                return 0;
            }
            return e.boundedFaceL;
        }
        if (this.areFacesIndexed) {
            list.clear();
            this.faceRTree.search(srchMBR, (ArrayList)list);
            this.reuseInt.i = -1;
            if (this.faceHashMap.containsKey(this.reuseInt)) {
                list.add(this.getFace(-1));
            }
            it = list.iterator();
        } else {
            it = this.getFaceIterator();
        }
        while (it.hasNext()) {
            f = (Face)it.next();
            for (int j = 0; j < f.islandNodes.length; ++j) {
                try {
                    n = this.getNode(f.islandNodes[j]);
                }
                catch (TopoEntityNotFoundException tn) {
                    continue;
                }
                if (!p.equals(n.coord)) continue;
                if (!allow_iso_coincidence) {
                    return 0;
                }
                return n.containFace;
            }
            if (f.id == -1 || !this.pointInFace(p, f, false)) continue;
            return f.id;
        }
        return -1;
    }

    public int getNodeStarCount(int nodeID) throws TopoEntityNotFoundException {
        Edge e;
        int count = 0;
        Node n = this.getNode(nodeID);
        int edge = n.startEdge;
        if (edge == 0) {
            return 0;
        }
        do {
            ++count;
            e = this.getEdge(edge);
        } while ((edge = edge > 0 ? e.nextEdgeR : e.nextEdgeL) != n.startEdge);
        return count;
    }

    public int[] getNodeStar(int nodeID) throws TopoEntityNotFoundException {
        Edge e;
        int count = 0;
        Node n = this.getNode(nodeID);
        int edge = n.startEdge;
        if (edge == 0) {
            return new int[0];
        }
        do {
            if (++count > 200) {
                return null;
            }
            e = this.getEdge(edge);
        } while ((edge = edge > 0 ? e.nextEdgeR : e.nextEdgeL) != n.startEdge);
        int[] star = new int[count];
        count = 0;
        do {
            e = this.getEdge(edge);
            star[count++] = edge;
        } while ((edge = edge > 0 ? e.nextEdgeR : e.nextEdgeL) != n.startEdge);
        return star;
    }

    public int[] getNodeFaceStar(int nodeID) throws TopoEntityNotFoundException {
        Edge e;
        int count = 0;
        Node n = this.getNode(nodeID);
        int edge = n.startEdge;
        if (edge == 0) {
            int[] ii = new int[]{n.containFace};
            return ii;
        }
        do {
            if (++count > 200) {
                return null;
            }
            e = this.getEdge(edge);
        } while ((edge = edge > 0 ? e.nextEdgeR : e.nextEdgeL) != n.startEdge);
        int[] star = new int[count];
        count = 0;
        do {
            e = this.getEdge(edge);
            star[count++] = edge > 0 ? e.boundedFaceR : e.boundedFaceL;
        } while ((edge = edge > 0 ? e.nextEdgeR : e.nextEdgeL) != n.startEdge);
        return star;
    }

    private boolean listAdd(HashSet iL, Object o) {
        this.isValid0 = false;
        this.isValid1 = false;
        return iL.add(o);
    }

    private int faceInto(Node n, Point2DD p, int[] edgeSeq) throws TopoEntityNotFoundException {
        Point2DD[] sectorPoints = new Point2DD[3];
        if (n.startEdge == 0) {
            edgeSeq[0] = 0;
            edgeSeq[1] = 0;
            return n.containFace;
        }
        edgeSeq[0] = n.startEdge;
        Edge e0 = this.getEdge(edgeSeq[0]);
        int n2 = edgeSeq[1] = edgeSeq[0] > 0 ? e0.nextEdgeR : e0.nextEdgeL;
        if (edgeSeq[0] == edgeSeq[1]) {
            return e0.boundedFaceL;
        }
        Edge e1 = this.getEdge(edgeSeq[1]);
        sectorPoints[1] = n.coord;
        do {
            sectorPoints[0] = edgeSeq[0] < 0 ? e0.coords[e0.coords.length - 2] : e0.coords[1];
            Point2DD point2DD = sectorPoints[2] = edgeSeq[1] < 0 ? e1.coords[e1.coords.length - 2] : e1.coords[1];
            if (CompGeom.inSector((Point2DD)p, (Point2DD[])sectorPoints)) break;
            edgeSeq[0] = edgeSeq[1];
            e0 = e1;
            edgeSeq[1] = edgeSeq[0] > 0 ? e0.nextEdgeR : e0.nextEdgeL;
            e1 = this.getEdge(edgeSeq[1]);
        } while (edgeSeq[0] != n.startEdge);
        return edgeSeq[0] < 0 ? e0.boundedFaceL : e0.boundedFaceR;
    }

    private boolean pointInFace(Point2DD p, Face f, boolean outerOnly) throws TopoEntityNotFoundException, Exception {
        if (f.id == -1) {
            if (outerOnly) {
                return true;
            }
            return this.getContainingFace(p) == -1;
        }
        if (!CompGeom.pointInMBR((Point2DD)p, (Point2DD[])f.mbr)) {
            return false;
        }
        boolean in = false;
        int upperLimit = outerOnly ? 0 : f.islandEdges.length;
        for (int i = -1; i < upperLimit; ++i) {
            Edge e;
            int edge = i < 0 ? f.boundaryEdge : f.islandEdges[i];
            int edgeT = edge;
            do {
                e = this.getEdge(edgeT);
                in = CompGeom.incPointInPolygon((Point2DD)p, (Point2DD[])e.coords, (boolean)in);
            } while ((edgeT = edgeT > 0 ? e.nextEdgeL : e.nextEdgeR) != edge);
        }
        return in;
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int id) {
        this.srid = id;
    }

    private int newEdgeID() throws TopoEntityNotFoundException {
        Edge e = new Edge(this.nextEdgeID);
        this.edgeHashMap.put(new Int(this.nextEdgeID), e);
        return this.nextEdgeID++;
    }

    private int newFaceID() throws TopoEntityNotFoundException {
        Face f = new Face(this.nextFaceID);
        this.faceHashMap.put(new Int(this.nextFaceID), f);
        return this.nextFaceID++;
    }

    private int newNodeID() throws TopoEntityNotFoundException {
        Node n = new Node(this.nextNodeID);
        this.nodeHashMap.put(new Int(this.nextNodeID), n);
        return this.nextNodeID++;
    }

    public void insertNode(int id, int startEdge, int containFace, Point2DD coord) throws Exception {
        try {
            if (this.getNode(id) != null) {
                throw new Exception("Node [" + id + "] already exists.");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (coord == null) {
            throw new Exception("Unable to insert node with null coordinate.");
        }
        Node n = new Node(id);
        n.startEdge = startEdge;
        n.containFace = containFace;
        n.coord = coord;
        this.nodeHashMap.put(new Int(id), n);
    }

    public void insertEdge(int id, int originNode, int endNode, int boundedFaceL, int boundedFaceR, int nextEdgeL, int prevEdgeL, int nextEdgeR, int prevEdgeR, Point2DD[] coords, boolean updateIndexTree) throws Exception {
        try {
            if (this.getEdge(id) != null) {
                throw new Exception("Edge [" + id + "] already exists.");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (coords == null || coords.length < 1) {
            throw new Exception("Invalid edge coordinates.");
        }
        Edge e = new Edge(id);
        e.originNode = originNode;
        e.endNode = endNode;
        e.boundedFaceL = boundedFaceL;
        e.boundedFaceR = boundedFaceR;
        e.nextEdgeL = nextEdgeL;
        e.prevEdgeL = prevEdgeL;
        e.nextEdgeR = nextEdgeR;
        e.prevEdgeR = prevEdgeR;
        e.coords = coords;
        if (this.areEdgesIndexed && updateIndexTree) {
            Point2DD[] mbr = new Point2DD[]{new Point2DD(), new Point2DD()};
            double[][] mbrD = new double[2][2];
            e.computeMBR(mbr);
            mbrD[0][0] = mbr[0].x;
            mbrD[0][1] = mbr[1].x;
            mbrD[1][0] = mbr[0].y;
            mbrD[1][1] = mbr[1].y;
            this.edgeRTree.addEntry(mbrD, (Object)e);
        }
        this.edgeHashMap.put(new Int(id), e);
    }

    public void insertFace(int id, int boundaryEdge, int[] islandEdges, int[] islandNodes, Point2DD[] mbr, boolean updateIndexTree) throws Exception {
        try {
            if (this.getFace(id) != null) {
                throw new Exception("Face [" + id + "] already exists.");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        Face f = new Face(id);
        f.boundaryEdge = boundaryEdge;
        if (islandEdges != null) {
            f.islandEdges = islandEdges;
        }
        if (islandNodes != null) {
            f.islandNodes = islandNodes;
        }
        f.mbr = mbr;
        if (this.areFacesIndexed && updateIndexTree) {
            double[][] mbrD = new double[2][2];
            mbrD[0][0] = f.mbr[0].x;
            mbrD[0][1] = f.mbr[1].x;
            mbrD[1][0] = f.mbr[0].y;
            mbrD[1][1] = f.mbr[1].y;
            this.faceRTree.addEntry(mbrD, (Object)f);
        }
        this.faceHashMap.put(new Int(id), f);
    }

    public void setNextNodeID(int id) {
        this.nextNodeID = id;
    }

    public void setNextEdgeID(int id) {
        this.nextEdgeID = id;
    }

    public void setNextFaceID(int id) {
        this.nextFaceID = id;
    }

    public void clearChanges() {
        if (this.edgeChangedList != null) {
            this.edgeChangedList.clear();
        }
        if (this.edgeAddedList != null) {
            this.edgeAddedList.clear();
        }
        if (this.edgeDeletedList != null) {
            this.edgeDeletedList.clear();
        }
        if (this.nodeChangedList != null) {
            this.nodeChangedList.clear();
        }
        if (this.nodeAddedList != null) {
            this.nodeAddedList.clear();
        }
        if (this.nodeDeletedList != null) {
            this.nodeDeletedList.clear();
        }
        if (this.faceChangedList != null) {
            this.faceChangedList.clear();
        }
        if (this.faceAddedList != null) {
            this.faceAddedList.clear();
        }
        if (this.faceDeletedList != null) {
            this.faceDeletedList.clear();
        }
    }

    private Node cloneNode(Node node) {
        if (node == null) {
            return null;
        }
        Node n = new Node(node.getId());
        n.startEdge = node.startEdge;
        n.containFace = node.containFace;
        if (node.coord != null) {
            n.coord = new Point2DD(node.coord);
        }
        return n;
    }

    private Edge cloneEdge(Edge edge) {
        if (edge == null) {
            return null;
        }
        Edge e = new Edge(edge.getId());
        e.originNode = edge.originNode;
        e.endNode = edge.endNode;
        e.boundedFaceL = edge.boundedFaceL;
        e.boundedFaceR = edge.boundedFaceR;
        e.nextEdgeL = edge.nextEdgeL;
        e.prevEdgeL = edge.prevEdgeL;
        e.nextEdgeR = edge.nextEdgeR;
        e.prevEdgeR = edge.prevEdgeR;
        if (edge.coords != null && edge.coords.length > 0) {
            e.fillCoords(edge.coords);
        }
        return e;
    }

    private Face cloneFace(Face face) {
        int i;
        if (face == null) {
            return null;
        }
        Face f = new Face(face.getID());
        f.boundaryEdge = face.boundaryEdge;
        if (face.islandEdges != null && face.islandEdges.length > 0) {
            f.islandEdges = new int[face.islandEdges.length];
            for (i = 0; i < face.islandEdges.length; ++i) {
                f.islandEdges[i] = face.islandEdges[i];
            }
        }
        if (face.islandNodes != null && face.islandNodes.length > 0) {
            f.islandNodes = new int[face.islandNodes.length];
            for (i = 0; i < face.islandNodes.length; ++i) {
                f.islandNodes[i] = face.islandNodes[i];
            }
        }
        if (face.mbr != null) {
            f.mbr = new Point2DD[face.mbr.length];
            for (i = 0; i < face.mbr.length; ++i) {
                f.mbr[i] = new Point2DD(face.mbr[i]);
            }
        }
        return f;
    }

    private void copyNodeAttributes(Node srcNode, Node destNode) {
        if (srcNode == null || destNode == null) {
            return;
        }
        destNode.startEdge = srcNode.startEdge;
        destNode.containFace = srcNode.containFace;
        destNode.coord = srcNode.coord != null ? new Point2DD(srcNode.coord) : null;
    }

    private void copyEdgeAttributes(Edge srcEdge, Edge destEdge) {
        if (srcEdge == null || destEdge == null) {
            return;
        }
        destEdge.originNode = srcEdge.originNode;
        destEdge.endNode = srcEdge.endNode;
        destEdge.boundedFaceL = srcEdge.boundedFaceL;
        destEdge.boundedFaceR = srcEdge.boundedFaceR;
        destEdge.nextEdgeL = srcEdge.nextEdgeL;
        destEdge.prevEdgeL = srcEdge.prevEdgeL;
        destEdge.nextEdgeR = srcEdge.nextEdgeR;
        destEdge.prevEdgeR = srcEdge.prevEdgeR;
        if (srcEdge.coords != null && srcEdge.coords.length > 0) {
            destEdge.fillCoords(srcEdge.coords);
        } else {
            destEdge.coords = new Point2DD[0];
        }
    }

    private void copyFaceAttributes(Face srcFace, Face destFace) {
        int i;
        if (srcFace == null || destFace == null) {
            return;
        }
        destFace.boundaryEdge = srcFace.boundaryEdge;
        if (srcFace.islandEdges != null && srcFace.islandEdges.length > 0) {
            destFace.islandEdges = new int[srcFace.islandEdges.length];
            for (i = 0; i < srcFace.islandEdges.length; ++i) {
                destFace.islandEdges[i] = srcFace.islandEdges[i];
            }
        } else {
            destFace.islandEdges = new int[0];
        }
        if (srcFace.islandNodes != null && srcFace.islandNodes.length > 0) {
            destFace.islandNodes = new int[srcFace.islandNodes.length];
            for (i = 0; i < srcFace.islandNodes.length; ++i) {
                destFace.islandNodes[i] = srcFace.islandNodes[i];
            }
        } else {
            destFace.islandNodes = new int[0];
        }
        if (srcFace.mbr != null) {
            destFace.mbr = new Point2DD[srcFace.mbr.length];
            for (i = 0; i < srcFace.mbr.length; ++i) {
                destFace.mbr[i] = new Point2DD(srcFace.mbr[i]);
            }
        } else {
            destFace.mbr = null;
        }
    }

    public Rectangle2D getNodeMBR(int node) {
        Node nd = null;
        try {
            nd = this.getNode(node);
        }
        catch (TopoEntityNotFoundException ex) {
            return null;
        }
        if (nd == null) {
            return null;
        }
        Point2DD coord = nd.getCoord();
        if (coord == null) {
            return null;
        }
        Rectangle2D.Double mbr = new Rectangle2D.Double();
        mbr.add(coord.getX(), coord.getY());
        return mbr;
    }

    public Rectangle2D getEdgeMBR(int edge) {
        Edge ed = null;
        try {
            ed = this.getEdge(edge);
        }
        catch (TopoEntityNotFoundException ex) {
            return null;
        }
        if (ed == null) {
            return null;
        }
        Point2DD[] coords = ed.getCoords();
        if (coords == null || coords.length == 0) {
            return null;
        }
        Rectangle2D.Double mbr = new Rectangle2D.Double();
        for (int i = 0; i < coords.length; ++i) {
            mbr.add(coords[i].getX(), coords[i].getY());
        }
        return mbr;
    }

    public Rectangle2D getFaceMBR(int face) {
        Face fc = null;
        try {
            fc = this.getFace(face);
        }
        catch (TopoEntityNotFoundException ex) {
            return null;
        }
        if (fc == null) {
            return null;
        }
        Point2DD[] faceMbr = fc.getMbr();
        if (faceMbr == null || faceMbr.length == 0) {
            return null;
        }
        Rectangle2D.Double mbr = new Rectangle2D.Double(faceMbr[0].getX(), faceMbr[0].getY(), faceMbr[1].getX() - faceMbr[0].getX(), faceMbr[1].getY() - faceMbr[0].getY());
        return mbr;
    }

    class PointStackEntry {
        SmartPoint sp;
        boolean fromTree;

        PointStackEntry() {
        }

        PointStackEntry(SmartPoint sp, boolean fromTree) {
            this.sp = sp;
            this.fromTree = fromTree;
        }
    }

    class EdgeSplit {
        Point2DD coord = new Point2DD();
        SmartPoint sp;
        int vertex;
        boolean openSet;

        EdgeSplit() {
        }

        EdgeSplit(Point2DD point, SmartPoint sp, int vertex, boolean openSet) {
            this.coord.x = point.x;
            this.coord.y = point.y;
            this.sp = sp;
            this.vertex = vertex;
            this.openSet = openSet;
        }
    }

    class SmartPoint {
        int index;
        Point2DD coord = new Point2DD();
        SmartPoint next = null;
        SmartPoint prev = null;
        ArrayList aL = null;
        IntArrayList nodeList = null;
        int nodeID;

        SmartPoint() {
        }

        SmartPoint(Point2DD point) {
            this.coord.x = point.x;
            this.coord.y = point.y;
        }

        SmartPoint(int i, Point2DD point) {
            this.index = i;
            this.coord.x = point.x;
            this.coord.y = point.y;
        }
    }

    class AlongEdgeComparator
    implements Comparator {
        Edge e;

        AlongEdgeComparator(Edge e) {
            this.e = e;
        }

        public int compare(Object ob1, Object ob2) {
            EdgeSplit o1 = (EdgeSplit)ob1;
            EdgeSplit o2 = (EdgeSplit)ob2;
            if (o1.vertex > o2.vertex) {
                return 1;
            }
            if (o1.vertex < o2.vertex) {
                return -1;
            }
            if (o1.openSet && !o2.openSet) {
                return 1;
            }
            if (o2.openSet && !o1.openSet) {
                return -1;
            }
            Point2DD p = this.e.coords[o1.vertex];
            double distSquared1 = (o1.coord.x - p.x) * (o1.coord.x - p.x) + (o1.coord.y - p.y) * (o1.coord.y - p.y);
            double distSquared2 = (o2.coord.x - p.x) * (o2.coord.x - p.x) + (o2.coord.y - p.y) * (o2.coord.y - p.y);
            if (distSquared1 > distSquared2) {
                return 1;
            }
            if (distSquared1 == distSquared2) {
                return 0;
            }
            return -1;
        }
    }

    class AlongSegmentComparator
    implements Comparator {
        Point2DD p;

        AlongSegmentComparator(Point2DD p) {
            this.p = new Point2DD(p);
        }

        public int compare(Object o1, Object o2) {
            double distSquared1 = (((SmartPoint)o1).coord.x - this.p.x) * (((SmartPoint)o1).coord.x - this.p.x) + (((SmartPoint)o1).coord.y - this.p.y) * (((SmartPoint)o1).coord.y - this.p.y);
            double distSquared2 = (((SmartPoint)o2).coord.x - this.p.x) * (((SmartPoint)o2).coord.x - this.p.x) + (((SmartPoint)o2).coord.y - this.p.y) * (((SmartPoint)o2).coord.y - this.p.y);
            if (distSquared1 > distSquared2) {
                return 1;
            }
            if (distSquared1 == distSquared2) {
                return 0;
            }
            return -1;
        }
    }

    class Int {
        int i;

        Int(int i) {
            this.i = i;
        }

        Int() {
            this.i = 0;
        }

        public int hashCode() {
            return this.i;
        }

        public boolean equals(Object o) {
            return ((Int)o).i == this.i;
        }
    }
}

