/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import oracle.bali.ewt.border.TitledPane;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.util.HttpConnection;

public class MVServerConnectionPanel
extends JPanel {
    private JTextField serverField = new JTextField();
    private JTextField editorField = new JTextField();
    private JCheckBox secCheckBox = new JCheckBox();
    private TitledPane secTitledPane = new TitledPane();
    private JPanel secPanel = new JPanel();
    private JTextField userTxt = new JTextField();
    private JPasswordField pwdTxt = new JPasswordField();
    private String srvTxt = null;
    private String edtrTxt = null;

    public MVServerConnectionPanel(String serverURL, String editor) {
        this.srvTxt = serverURL;
        this.edtrTxt = editor;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(400, 180));
        this.setPreferredSize(new Dimension(400, 180));
        if (this.srvTxt == null) {
            this.srvTxt = "http://localhost:7001/mapviewer";
        }
        if (this.edtrTxt == null || this.edtrTxt.equalsIgnoreCase("null")) {
            this.edtrTxt = "admin";
        }
        this.editorField.setText(this.edtrTxt);
        this.serverField.setText(this.srvTxt);
        JLabel serverLabel = new JLabel(MessagesBundle.getMessage("Label_mapviewer_server"));
        JLabel editorName = new JLabel(MessagesBundle.getMessage("Label_editor_name"));
        this.secPanel.setLayout(new GridBagLayout());
        this.secPanel.setSize(new Dimension(240, 100));
        this.secPanel.setPreferredSize(new Dimension(240, 10));
        this.secPanel.add((Component)new JLabel(MessagesBundle.getMessage("Label_user")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 55, 0, 0), 0, 0));
        this.secPanel.add((Component)this.userTxt, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.secPanel.add((Component)new JLabel(MessagesBundle.getMessage("Label_password")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 30, 0, 0), 0, 0));
        this.secPanel.add((Component)this.pwdTxt, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.secPanel.add((Component)new JLabel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.secCheckBox.setText(MessagesBundle.getMessage("Checkbox_dataserver_form_authentication"));
        this.secTitledPane.setTitle((Component)this.secCheckBox);
        this.secTitledPane.setContent((Component)this.secPanel);
        this.secCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MVServerConnectionPanel.this.secCheckBox_actionPerformed(e);
            }
        });
        this.add((Component)serverLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.serverField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 10), 0, 0));
        this.add((Component)editorName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.add((Component)this.editorField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 10), 0, 0));
        this.add((Component)this.secTitledPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.secCheckBox_actionPerformed(null);
    }

    public String getMapViewerServer() {
        String mv = this.serverField.getText();
        if (mv == null || mv.trim().length() == 0) {
            return null;
        }
        return mv.trim();
    }

    public String getEditorName() {
        String editor = this.editorField.getText();
        if (editor == null || editor.trim().length() == 0) {
            return null;
        }
        return editor.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillDataSources() {
        String dsrcReq = "<?xml version=\"1.0\" standalone=\"yes\"?>\n <non_map_request>\n   <list_editable_data_sources />\n </non_map_request> ";
        String mvURL = this.getMapViewerServer();
        if (mvURL == null) {
            return;
        }
        HttpConnection httpConn = new HttpConnection();
        if (!httpConn.connect(mvURL = mvURL + "/omserver")) {
            System.out.println(MessagesBundle.getFormattedMessage("Unable_toconnect_with_server", mvURL));
            return;
        }
        String datasources = null;
        try {
            this.setWaitCursor();
            httpConn.setContentTypeProperty("application/x-www-form-urlencoded");
            httpConn.sendXMLRequest("xml_request", dsrcReq);
            datasources = httpConn.getXMLResponse();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return;
        }
        finally {
            this.setDefaultCursor();
            if (httpConn != null) {
                httpConn.disConnect();
            }
        }
        if (datasources == null) {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Unable_toget_mapviewer_info"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        int idx = datasources.indexOf("<map_data_source name=\"");
        while (idx > 0) {
            int idx2 = datasources.indexOf("\"", idx + 24);
            String dsrc = datasources.substring(idx + 23, idx2);
            if (dsrc != null) {
                // empty if block
            }
            datasources = datasources.substring(idx2 + 1);
            idx = datasources.indexOf("<map_data_source name=\"");
        }
    }

    private OlafDialog getOlafDialog() {
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof OlafDialog)) continue;
            return (OlafDialog)c;
        }
        return null;
    }

    private void setWaitCursor() {
        this.setCursor(new Cursor(3));
    }

    private void setDefaultCursor() {
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void secCheckBox_actionPerformed(ActionEvent e) {
        if (this.secCheckBox.isSelected()) {
            this.userTxt.setEnabled(true);
            this.pwdTxt.setEnabled(true);
        } else {
            this.userTxt.setEnabled(false);
            this.pwdTxt.setEnabled(false);
        }
    }

    public boolean isAuthenticationEnabled() {
        return this.secCheckBox.isSelected();
    }

    public String getUser() {
        if (!this.isAuthenticationEnabled()) {
            return null;
        }
        if (this.userTxt.getText().trim().length() == 0) {
            return null;
        }
        return this.userTxt.getText().trim();
    }

    public String getPassword() {
        if (!this.isAuthenticationEnabled()) {
            return null;
        }
        String pwd = String.valueOf(this.pwdTxt.getPassword());
        if (pwd == null || pwd.trim().length() == 0) {
            return null;
        }
        return pwd.trim();
    }
}

