/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model;

import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.Callable;
import oracle.jdbc.OracleDriver;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.geoobject.WorkSpace;
import oracle.mapviewer.share.AnnotationTextMetadata;
import oracle.mapviewer.share.DimensionInfo;
import oracle.mapviewer.share.FeatureConflictDescriptor;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.FieldArray;
import oracle.mapviewer.share.MVThemeMetadata;
import oracle.mapviewer.share.MVTileLayerMetadata;
import oracle.mapviewer.share.NetworkMetadata;
import oracle.mapviewer.share.Sequence;
import oracle.mapviewer.share.SpatialColumnExtent;
import oracle.mapviewer.share.SpatialTableMetadata;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.mapviewer.share.TopologyPrimitives;
import oracle.mapviewer.share.TopologyRelation;
import oracle.sdovis.SRS;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.util.JDBCUtil;
import oracle.sdovis.util.ORADBGeometryOperations;
import oracle.sdovis.util.ORAWorkspaceJDBCUtil;
import oracle.sdovis.util.Util;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataModel;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.model.JDBCDataSource;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.annotationtext.AnnotationTextFeature;
import oracle.spatial.edit.model.annotationtext.AnnotationTextSet;
import oracle.spatial.edit.model.geometry.GeometrySet;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.edit.session.MDSEditSession;
import oracle.spatial.edit.util.TableAttributesMetadata;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.type.SdoTglObject;
import oracle.spatial.type.SdoTglObjectArray;
import oracle.spatial.type.SdoTopoGeometry;
import oracle.spatial.type.SdoTopoObject;
import oracle.spatial.type.SdoTopoObjectArray;
import oracle.sql.ARRAY;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class JDBCDataAccessObject
extends AbstractDataAccessObject {
    private int fetchSize = 100;
    private Connection conn = null;
    private boolean autoCommit = false;

    public JDBCDataAccessObject(JDBCDataSource dsrc) {
        super(dsrc);
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public boolean openConnection() throws Exception {
        if (this.conn != null) {
            return true;
        }
        this.conn = null;
        this.autoCommit = false;
        if (this.dataSource == null) {
            throw new Exception("Data source is null.");
        }
        try {
            Properties props = this.dataSource.getConnectionProperties();
            String host = (String)props.get("host");
            String port = (String)props.get("port");
            String sid = (String)props.get("sid");
            String user = (String)props.get("username");
            String pwd = (String)props.get("password");
            String baseURL = "jdbc:oracle:thin:@" + host + ":" + port + ":" + sid;
            if (!DriverManager.getDrivers().hasMoreElements()) {
                DriverManager.registerDriver((Driver)new OracleDriver());
            }
            this.conn = DriverManager.getConnection(baseURL, user, pwd);
            this.autoCommit = this.conn.getAutoCommit();
            this.conn.setAutoCommit(false);
        }
        catch (Exception ex) {
            this.conn = null;
            System.out.println(ex.getMessage());
            throw ex;
        }
        return true;
    }

    @Override
    public boolean closeConnection() throws Exception {
        if (this.conn == null) {
            return true;
        }
        try {
            this.conn.setAutoCommit(this.autoCommit);
            this.conn.commit();
            this.conn.close();
            this.conn = null;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            throw ex;
        }
        return true;
    }

    public void setFetchSize(int size) {
        if (size > 0) {
            this.fetchSize = size;
        }
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public int loadDataInto(Vector<AbstractFeature> into, Callable callable, PropertyChangeSupport propSupport, Rectangle2D mbr, WorkSpace workspace, String dataType, String query, String baseTable, String spatialColumn, long srid, boolean isGeodeticSRID) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    @Override
    public Vector<AbstractFeature> loadData(Rectangle2D mbr, WorkSpace version, String dataType, String query, String baseTable, String spatialColumn, long srid, boolean isGeodeticSRID) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (query == null) {
            System.out.println("Data set query is null.");
            throw new Exception("Data set query is null.");
        }
        if (spatialColumn == null) {
            System.out.println("Data set spatial column is null.");
            throw new Exception("Data set spatial column is null.");
        }
        if (version != null) {
            this.goToWorkspace(version);
        }
        boolean lockData = false;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String fullQuery = this.buildFullQuery(query, dataType, spatialColumn, mbr, srid, lockData, isGeodeticSRID);
            System.out.println("Query: " + fullQuery);
            stmt = this.conn.prepareStatement(fullQuery);
            stmt.setFetchSize(this.fetchSize);
            rs = stmt.executeQuery();
            Vector<AbstractFeature> vector = this.processFeatures(rs, spatialColumn);
            return vector;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public Vector<AbstractFeature> loadDataFromEditSession(Rectangle2D mbr, String editSession, String layerName) throws Exception {
        throw new Exception("To be implemented.");
    }

    @Override
    public Vector<AbstractFeature> loadFeatures(String[] keys, String table, String keyColumn, String spatialColumn, WorkSpace version, int accessMode) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (keys == null) {
            System.out.println("Feature keys value is null.");
            throw new Exception("Feature keys value is null.");
        }
        if (keys.length == 0) {
            return null;
        }
        if (keyColumn == null) {
            System.out.println("Key column is null.");
            throw new Exception("Key column is null.");
        }
        if (spatialColumn == null) {
            System.out.println("Spatial column is null.");
            throw new Exception("Spatial column is null.");
        }
        String query = "select * from " + table + " where " + keyColumn + " in (";
        for (int i = 0; i < keys.length; ++i) {
            query = i == 0 ? query + "'" : query + "','";
            query = query + keys[i];
        }
        query = query + "')";
        boolean lockData = false;
        if (accessMode == AbstractDataSet.READ_WRITE_SET) {
            lockData = true;
        }
        if (lockData) {
            query = query + " for update NOWAIT";
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        if (version != null) {
            this.goToWorkspace(version);
        }
        try {
            stmt = this.conn.prepareStatement(query);
            stmt.setFetchSize(this.fetchSize);
            rs = stmt.executeQuery();
            Vector<AbstractFeature> vector = this.processFeatures(rs, spatialColumn);
            return vector;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private Vector<AbstractFeature> processFeatures(ResultSet rs, String spatialColumn) throws Exception {
        Vector<AbstractFeature> features = new Vector<AbstractFeature>();
        if (rs == null) {
            throw new Exception("Features result set is null.");
        }
        ResultSetMetaData rsmeta = rs.getMetaData();
        int colCnt = rsmeta.getColumnCount();
        boolean sptCol = false;
        for (int i = 1; i <= colCnt; ++i) {
            String colname = rsmeta.getColumnName(i);
            if (!colname.equalsIgnoreCase(spatialColumn)) continue;
            sptCol = true;
            break;
        }
        if (!sptCol) {
            System.out.println("Spatial column [" + spatialColumn + "] not found in query");
            throw new Exception("Spatial column [" + spatialColumn + "] not found in query");
        }
        while (rs.next()) {
            AbstractFeature feature = null;
            ArrayList<Object> fields = new ArrayList<Object>();
            for (int i = 1; i <= colCnt; ++i) {
                int[] intArray;
                ARRAY a;
                Object var;
                int k;
                int type = rsmeta.getColumnType(i);
                String typename = rsmeta.getColumnTypeName(i);
                String colname = rsmeta.getColumnName(i);
                if (colname.equalsIgnoreCase(spatialColumn)) {
                    SdoTglObjectArray tgarray;
                    STRUCT st;
                    if (typename.equalsIgnoreCase("MDSYS.SDO_GEOMETRY")) {
                        JGeometry geom;
                        feature = new GeometryFeature();
                        st = (STRUCT)rs.getObject(i);
                        if (st == null || (geom = JGeometry.load((STRUCT)st)) == null) continue;
                        ((GeometryFeature)feature).setSpatialAttribute(geom);
                        continue;
                    }
                    if (typename.equalsIgnoreCase("MDSYS.ST_ANNOTATION_TEXT")) {
                        AnnotationText atext;
                        feature = new AnnotationTextFeature();
                        st = (STRUCT)rs.getObject(i);
                        if (st == null || (atext = AnnotationText.load((STRUCT)st)) == null) continue;
                        ((AnnotationTextFeature)feature).setSpatialAttribute(atext);
                        continue;
                    }
                    if (!typename.equalsIgnoreCase("MDSYS.SDO_TOPO_GEOMETRY")) continue;
                    feature = new TopologyFeature();
                    SdoTopoGeometry sdotpgeom = (SdoTopoGeometry)((OracleResultSet)rs).getORAData(i, SdoTopoGeometry.getORADataFactory());
                    if (sdotpgeom == null) continue;
                    TopologyGeometry tpGeom = new TopologyGeometry();
                    feature.setSpatialAttribute(tpGeom);
                    tpGeom.setId(sdotpgeom.getTgId().intValue());
                    tpGeom.setLayerId(sdotpgeom.getTgLayerId().intValue());
                    SdoTopoObjectArray starray = sdotpgeom.getTopoElements();
                    if (starray != null && starray.getArray() != null) {
                        SdoTopoObject[] objarray = starray.getArray();
                        for (int k2 = 0; k2 < objarray.length; ++k2) {
                            int tpid = objarray[k2].getTopoId().intValue();
                            int tptype = objarray[k2].getTopoType().intValue();
                            tpGeom.addTopoPrimitive(tpid, tptype);
                        }
                    }
                    if ((tgarray = sdotpgeom.getTglObjects()) == null || tgarray.getArray() == null) continue;
                    SdoTglObject[] objarray = tgarray.getArray();
                    for (k = 0; k < objarray.length; ++k) {
                        int tgid = objarray[k].getTgId().intValue();
                        int tglid = objarray[k].getTglId().intValue();
                        tpGeom.addChildFeature(tglid, tgid);
                    }
                    continue;
                }
                if (!this.isComplexType(type) && type != 2002) {
                    Field field = null;
                    var = rs.getObject(i);
                    if (var == null) continue;
                    if (var instanceof String) {
                        field = new Field((String)var);
                    } else if (var instanceof Integer) {
                        field = new Field(((Integer)var).intValue());
                    } else if (var instanceof Double) {
                        field = new Field(((Double)var).doubleValue());
                    } else if (var instanceof Float) {
                        field = new Field().setFloat(((Float)var).floatValue());
                    } else if (var instanceof Long) {
                        field = new Field().setLong(((Long)var).longValue());
                    } else if (var instanceof Short) {
                        field = new Field().setShort((int)((Short)var).shortValue());
                    }
                    if (var instanceof BigDecimal) {
                        field = new Field(((BigDecimal)var).doubleValue());
                    } else if (var instanceof Date) {
                        field = new Field().setDate(((Date)var).getTime());
                    } else if (var instanceof Time) {
                        field = new Field().setDate(((Time)var).getTime());
                    } else if (var instanceof Timestamp) {
                        field = new Field().setDate(((Timestamp)var).getTime());
                    } else if (var instanceof ROWID) {
                        field = new Field(var.toString());
                    }
                    if (field == null) continue;
                    field.setName(colname);
                    fields.add(field);
                    continue;
                }
                if (!typename.equalsIgnoreCase("MDSYS.SDO_LIST_TYPE")) continue;
                FieldArray fieldArray = null;
                var = rs.getObject(i);
                if (var == null || (a = (ARRAY)var) == null || (intArray = a.getIntArray()) == null || intArray.length == 0) continue;
                String[] varray = new String[intArray.length];
                for (k = 0; k < intArray.length; ++k) {
                    varray[k] = String.valueOf(intArray[k]);
                }
                fieldArray = new FieldArray(varray, "double");
                if (fieldArray == null) continue;
                fieldArray.setName(colname);
                fields.add(fieldArray);
            }
            if (feature == null) continue;
            if (fields.size() > 0) {
                feature.setAttributes(fields.toArray(new Field[fields.size()]));
            }
            features.add(feature);
        }
        if (features.size() == 0) {
            return null;
        }
        return features;
    }

    private String buildFullQuery(String query, String dataType, String spatialColumn, Rectangle2D mbr, long srid, boolean lockData, boolean isGeodeticSRID) {
        if (query == null) {
            return null;
        }
        String fullQuery = "select * from (" + query + ")";
        String params = ", 'querytype=WINDOW'";
        String tableAlias = "";
        String geomColumn = spatialColumn;
        if (dataType != null && dataType.equalsIgnoreCase(AbstractDataSet.ANNOTATION_TEXT_SET)) {
            tableAlias = "anno_set";
            geomColumn = tableAlias + "." + spatialColumn + ".privateenvelope";
        } else if (dataType != null && dataType.equalsIgnoreCase(AbstractDataSet.TOPOLOGY_FEATURE_SET)) {
            params = "";
        }
        if (mbr != null) {
            double xl = mbr.getX();
            double yl = mbr.getY();
            double xh = xl + mbr.getWidth();
            double yh = yl + mbr.getHeight();
            if (isGeodeticSRID) {
                if (xl < -180.0) {
                    xl = -180.0;
                }
                if (xh > 180.0) {
                    xh = 180.0;
                }
                if (yl < -90.0) {
                    yl = -90.0;
                }
                if (yh > 90.0) {
                    yh = 90.0;
                }
            }
            String filter = " MDSYS.SDO_FILTER(" + geomColumn + ",\n" + "  MDSYS.SDO_GEOMETRY(2003,";
            filter = srid == 0L ? filter + "NULL" : filter + "" + srid;
            filter = filter + ", NULL, MDSYS.SDO_ELEM_INFO_ARRAY(1, 1003, 3), MDSYS.SDO_ORDINATE_ARRAY(" + xl + "," + yl + "," + xh + "," + yh + "))" + params + ") = 'TRUE'";
            fullQuery = fullQuery + " " + tableAlias + " where " + filter;
        }
        if (lockData) {
            fullQuery = fullQuery + " for update NOWAIT";
        }
        return fullQuery;
    }

    @Override
    public long getSequenceNextValue(String sequence) throws Exception {
        if (sequence == null) {
            System.out.println("Sequence name is null.");
            throw new Exception("Sequence name is null.");
        }
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        String sqlSeqString = "select " + sequence + ".nextval from dual";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.prepareStatement(sqlSeqString);
            rs = stmt.executeQuery();
            if (rs.next()) {
                long id;
                long l = id = rs.getLong(1);
                return l;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            throw ex;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
        }
        return -1L;
    }

    @Override
    public long getSequenceCurrentValue(String sequence) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    private boolean isComplexType(int oracleType) {
        return oracleType != -6 && oracleType != 5 && oracleType != 4 && oracleType != -5 && oracleType != 6 && oracleType != 7 && oracleType != 8 && oracleType != 2 && oracleType != 3 && oracleType != 1 && oracleType != 12 && oracleType != -1 && oracleType != 2 && oracleType != 999 && oracleType != 91 && oracleType != 92 && oracleType != 93 && oracleType != -8;
    }

    private String getJavaTypeFromOracleType(int oracleType) {
        if (oracleType == -6 || oracleType == 5) {
            return "Short";
        }
        if (oracleType == 4) {
            return "Integer";
        }
        if (oracleType == -5) {
            return "Long";
        }
        if (oracleType == 6 || oracleType == 7) {
            return "Float";
        }
        if (oracleType == 8 || oracleType == 2 || oracleType == 3 || oracleType == 2) {
            return "Double";
        }
        if (oracleType == 1 || oracleType == 12 || oracleType == -1 || oracleType == 999) {
            return "String";
        }
        if (oracleType == 91) {
            return "Date";
        }
        if (oracleType == 92) {
            return "Time";
        }
        if (oracleType == 93) {
            return "Timestamp";
        }
        return null;
    }

    @Override
    public boolean saveDataSet(AbstractDataSet gset) throws Exception {
        if (gset.getMode() == AbstractDataSet.READ_ONLY_SET) {
            return true;
        }
        if (gset == null) {
            System.out.println("Data set is null.");
            throw new Exception("Data set is null.");
        }
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        Statement iStmt = null;
        Statement uStmt = null;
        Statement dStmt = null;
        String errorMessage = "";
        try {
            String[] remFeatures;
            String[] modFeatures;
            String[] newFeatures = gset.getNewFeatures();
            if (newFeatures != null && newFeatures.length > 0) {
                for (int i = 0; i < newFeatures.length; ++i) {
                    AbstractFeature gf = gset.getFeature(newFeatures[i]);
                    if (gf == null || (iStmt = this.prepareInsertStatement(gset, gf, gset.getBaseTable(), gset.getGeometryColumn(), gset.getKeyColumn())) == null) continue;
                    errorMessage = "Inserting feature: " + newFeatures[i];
                    iStmt.executeUpdate();
                    iStmt.close();
                }
            }
            if ((modFeatures = gset.getModifiedFeatures()) != null && modFeatures.length > 0) {
                for (int i = 0; i < modFeatures.length; ++i) {
                    AbstractFeature gf = gset.getFeature(modFeatures[i]);
                    if (gf == null || (uStmt = this.prepareUpdateStatement(gset, gf, gset.getBaseTable(), gset.getGeometryColumn(), gset.getKeyColumn())) == null) continue;
                    errorMessage = "Updating feature: " + modFeatures[i];
                    uStmt.executeUpdate();
                    uStmt.close();
                }
            }
            if ((remFeatures = gset.getRemovedFeatures()) != null && remFeatures.length > 0) {
                System.out.println("Removing features...");
                String deleteSQL = "delete from " + gset.getBaseTable() + " where " + gset.getKeyColumn() + " = ?";
                System.out.println(deleteSQL);
                dStmt = this.conn.prepareStatement(deleteSQL);
                String keyType = gset.getKeyColumnJavaType();
                for (int i = 0; i < remFeatures.length; ++i) {
                    Field f = Field.createField((String)remFeatures[i], (String)keyType.toLowerCase());
                    if (f == null) continue;
                    errorMessage = "Removing feature: " + remFeatures[i];
                    System.out.println(errorMessage);
                    this.setBindingVariable((PreparedStatement)dStmt, f.getValue(), 1);
                    dStmt.addBatch();
                }
                if (dStmt != null) {
                    ((OraclePreparedStatement)dStmt).executeBatch();
                }
                System.out.println("Done with removing features.");
            }
            if (gset.getDataModel() == null) {
                System.out.println("Commiting changes...");
                this.conn.commit();
                System.out.println("Commit done.");
            }
        }
        catch (Exception ex) {
            System.out.println("Exception while saving edited features.\n" + errorMessage + "\n" + ex.getMessage() + "\nRolling back any database updates.");
            if (gset.getDataModel() == null) {
                this.conn.rollback();
                System.out.println("Locking features after rollback.");
                this.lockTableRecords(gset.getQueryForLoading(), gset.getWorkingArea(), gset.getType(), gset.getGeometryColumn(), gset.getGeometrySrid(), gset.hasGeodeticSRID());
                System.out.println("Save process ended without success.");
            }
            throw ex;
        }
        finally {
            if (iStmt != null) {
                try {
                    iStmt.close();
                }
                catch (Exception e) {}
            }
            if (uStmt != null) {
                try {
                    uStmt.close();
                }
                catch (Exception e) {}
            }
            if (dStmt != null) {
                try {
                    dStmt.close();
                }
                catch (Exception e) {}
            }
        }
        if (gset.getDataModel() == null) {
            gset.clearChanges();
            try {
                System.out.println("Locking features after commit.");
                this.lockTableRecords(gset.getQueryForLoading(), gset.getWorkingArea(), gset.getType(), gset.getGeometryColumn(), gset.getGeometrySrid(), gset.hasGeodeticSRID());
                System.out.println("Save process completed.");
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                throw ex;
            }
        }
        return true;
    }

    @Override
    public boolean saveDataModel(AbstractDataModel model) throws Exception, MDSException {
        if (model == null) {
            System.out.println("Data model is null.");
            throw new Exception("Data model is null.");
        }
        if (!model.isModified()) {
            return true;
        }
        String errorMessage = "";
        return false;
    }

    private boolean lockTableRecords(String query, Rectangle2D mbr, String dataType, String spatialColumn, long srid, boolean isGeodeticSRID) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String fullQuery = this.buildFullQuery(query, dataType, spatialColumn, mbr, srid, true, isGeodeticSRID);
            stmt = this.conn.prepareStatement(fullQuery);
            rs = stmt.executeQuery();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw e;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception ex) {}
            }
        }
        return true;
    }

    private PreparedStatement prepareInsertStatement(AbstractDataSet dset, AbstractFeature feat, String baseTable, String spatialColumn, String keyColumn) throws Exception {
        PreparedStatement stmt;
        block25: {
            int k;
            if (this.conn == null) {
                System.out.println("Connection is null.");
                throw new Exception("Connection is null.");
            }
            if (baseTable == null) {
                System.out.println("Data set base table is null.");
                throw new Exception("Data set base table is null.");
            }
            if (spatialColumn == null) {
                System.out.println("Data set spatial column is null.");
                throw new Exception("Data set spatial column is null.");
            }
            if (keyColumn == null) {
                System.out.println("Data Set key column is null.");
                throw new Exception("Data Set key column is null.");
            }
            String sptCol = spatialColumn;
            String sptBinding = "?";
            String keyValue = "?";
            JGeometry var = null;
            if (dset instanceof GeometrySet) {
                JGeometry geom;
                var = geom = ((GeometryFeature)feat).getSpatialAttribute();
                if (geom == null) {
                    sptCol = null;
                    sptBinding = null;
                }
            } else if (dset instanceof AnnotationTextSet) {
                AnnotationText atext = ((AnnotationTextFeature)feat).getSpatialAttribute();
                var = atext;
                if (atext == null) {
                    sptCol = null;
                    sptBinding = null;
                }
            } else {
                return null;
            }
            Field[] attrs = feat.getAttributes();
            String sql = "insert into " + baseTable + "\n(";
            if (sptCol != null) {
                sql = sql + sptCol;
            }
            if (attrs != null && attrs.length > 0) {
                for (k = 0; k < attrs.length; ++k) {
                    sql = k == 0 && sptCol == null ? sql + attrs[k].getName() : sql + "," + attrs[k].getName();
                    if (!keyColumn.equalsIgnoreCase(attrs[k].getName()) || attrs[k].getValue() == null) continue;
                    keyValue = attrs[k].getValue().toString();
                }
            }
            sql = sql + ") \nvalues\n(";
            if (sptBinding != null) {
                sql = sql + sptBinding;
            }
            if (attrs != null && attrs.length > 0) {
                for (k = 0; k < attrs.length; ++k) {
                    sql = k == 0 && sptBinding == null ? sql + "?" : sql + ",?";
                }
            }
            sql = sql + ")";
            System.out.println("Insert sql for feature: " + keyValue + "\n" + sql);
            stmt = null;
            try {
                stmt = this.conn.prepareStatement(sql);
                if (stmt == null) {
                    return null;
                }
                int attrStartIndex = 2;
                if (var != null) {
                    this.setBindingVariable(stmt, var, 1);
                } else {
                    attrStartIndex = 1;
                }
                if (attrs != null && attrs.length > 0) {
                    for (int k2 = 0; k2 < attrs.length; ++k2) {
                        this.setBindingVariable(stmt, attrs[k2].getValue(), k2 + attrStartIndex);
                    }
                }
            }
            catch (Exception e) {
                if (stmt == null) break block25;
                try {
                    stmt.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw e;
            }
        }
        return stmt;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PreparedStatement prepareUpdateStatement(AbstractDataSet dset, AbstractFeature feat, String baseTable, String spatialColumn, String keyColumn) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (baseTable == null) {
            System.out.println("Data set base table is null.");
            throw new Exception("Data set base table is null.");
        }
        if (spatialColumn == null) {
            System.out.println("Data set spatial column is null.");
            throw new Exception("Data set spatial column is null.");
        }
        if (keyColumn == null) {
            System.out.println("Data Set key column is null.");
            throw new Exception("Data Set key column is null.");
        }
        String sptCol = spatialColumn;
        String keyValue = "?";
        String[] attrs = null;
        Field[] attrFields = null;
        Field keyField = null;
        JGeometry var = null;
        keyField = feat.getAttribute(keyColumn);
        if (keyField == null) return null;
        if (keyField.getValue() == null) {
            return null;
        }
        keyValue = keyField.getValue().toString();
        attrs = dset.getChangedAttributesOfModifiedFeature(keyField.getValue().toString());
        if (attrs != null && attrs.length > 0) {
            attrFields = feat.getAttributes(attrs);
        }
        if (dset.hasSpatialAttributeChanged(keyField.getValue().toString())) {
            if (dset instanceof GeometrySet) {
                JGeometry geom;
                var = geom = ((GeometryFeature)feat).getSpatialAttribute();
                if (geom == null) {
                    sptCol = null;
                }
            } else {
                if (!(dset instanceof AnnotationTextSet)) return null;
                AnnotationText atext = ((AnnotationTextFeature)feat).getSpatialAttribute();
                var = atext;
                if (atext == null) {
                    sptCol = null;
                }
            }
        } else {
            sptCol = null;
        }
        if (sptCol == null && attrs == null) {
            return null;
        }
        String sql = "update " + baseTable + " set ";
        if (sptCol != null) {
            sql = sql + sptCol + "=?";
        }
        if (attrs != null && attrs.length > 0) {
            for (int k = 0; k < attrs.length; ++k) {
                sql = k == 0 && sptCol == null ? sql + attrs[k] + "=?" : sql + ", " + attrs[k] + "=?";
            }
        }
        sql = sql + " where " + keyColumn + " = ?";
        System.out.println("Update sql for feature: " + keyValue + "\n" + sql);
        PreparedStatement stmt = null;
        try {
            stmt = this.conn.prepareStatement(sql);
            if (stmt == null) {
                return null;
            }
            int attrStartIndex = 2;
            if (var != null) {
                this.setBindingVariable(stmt, var, 1);
            } else {
                attrStartIndex = 1;
            }
            int nattrs = 0;
            if (attrs != null && attrs.length > 0) {
                nattrs = attrs.length;
                for (int k = 0; k < attrs.length; ++k) {
                    this.setBindingVariable(stmt, attrFields[k].getValue(), k + attrStartIndex);
                }
            }
            this.setBindingVariable(stmt, keyField.getValue(), attrStartIndex + nattrs);
            return stmt;
        }
        catch (Exception e) {
            if (stmt == null) return stmt;
            try {
                stmt.close();
                throw e;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw e;
        }
    }

    private void setBindingVariable(PreparedStatement stmt, Object var, int idx) throws SQLException, IllegalArgumentException {
        if (this.conn == null) {
            return;
        }
        if (var instanceof String) {
            stmt.setString(idx, (String)var);
        } else if (var instanceof Integer) {
            stmt.setInt(idx, (Integer)var);
        } else if (var instanceof Double) {
            stmt.setDouble(idx, (Double)var);
        } else if (var instanceof Float) {
            stmt.setFloat(idx, ((Float)var).floatValue());
        } else if (var instanceof Long) {
            stmt.setLong(idx, (Long)var);
        } else if (var instanceof Short) {
            stmt.setShort(idx, (Short)var);
        } else if (var instanceof Byte) {
            stmt.setByte(idx, (Byte)var);
        } else if (var instanceof BigDecimal) {
            stmt.setBigDecimal(idx, (BigDecimal)var);
        } else if (var instanceof byte[]) {
            stmt.setBytes(idx, (byte[])var);
        } else if (var instanceof Date) {
            stmt.setDate(idx, (Date)var);
        } else if (var instanceof Time) {
            stmt.setTime(idx, (Time)var);
        } else if (var instanceof Timestamp) {
            stmt.setTimestamp(idx, (Timestamp)var);
        } else if (var instanceof JGeometry) {
            JGeometry g = (JGeometry)var;
            STRUCT geom = null;
            Object[] descs = Util.createDBGeomDescriptors((Connection)this.conn);
            geom = JGeometry.store((JGeometry)g, (Connection)this.conn, (Object[])descs);
            stmt.setObject(idx, geom);
        } else if (var instanceof AnnotationText) {
            AnnotationText atext = (AnnotationText)var;
            STRUCT geom = null;
            Object[] descs = AnnotationText.getDBDescriptors((Connection)this.conn);
            geom = atext.store(this.conn, descs);
            stmt.setObject(idx, geom);
        } else if (var instanceof SdoTopoGeometry) {
            stmt.setObject(idx, var);
        } else {
            throw new IllegalArgumentException("Binding data type not supported: " + var.getClass().toString());
        }
    }

    @Override
    public NetworkMetadata loadNetworkMetadata(String network) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (network == null) {
            System.out.println("Network name is null.");
            throw new Exception("Network name is null.");
        }
        String netquery = "select * from user_sdo_network_metadata where network = '" + network.toUpperCase() + "'";
        NetworkMetadata metadata = new NetworkMetadata();
        Statement netStmt = null;
        ResultSet rs = null;
        try {
            String connectionUser;
            String networkOwner = connectionUser = this.conn.getMetaData().getUserName();
            int index = network.indexOf(".");
            if (index > -1) {
                String tbSchema = network.substring(0, index);
                String ntName = network.substring(index + 1, network.length());
                netquery = "select * from all_sdo_network_metadata where network = '" + ntName.toUpperCase() + "'" + " and owner = '" + tbSchema.toUpperCase() + "'";
            }
            if (!(rs = (netStmt = this.conn.prepareStatement(netquery)).executeQuery()).next()) {
                System.out.println("Unable to load Network " + network);
                NetworkMetadata networkMetadata = null;
                return networkMetadata;
            }
            if (index > -1) {
                networkOwner = rs.getString("owner");
            }
            metadata.setNetworkOwner(networkOwner);
            metadata.setNetworkName(rs.getString("network"));
            metadata.setNetworkId(rs.getInt("network_id"));
            metadata.setNetworkCategory(rs.getString("network_category"));
            metadata.setGeometryType(rs.getString("geometry_type"));
            metadata.setNetworkType(rs.getString("network_type"));
            metadata.setNumberOfHierarchyLevels(rs.getInt("no_of_hierarchy_levels"));
            metadata.setLRSTable(rs.getString("lrs_table_name"));
            metadata.setLRSGeometryColumn(rs.getString("lrs_geom_column"));
            metadata.setNodeTable(rs.getString("node_table_name"));
            metadata.setNodeGeometryColumn(rs.getString("node_geom_column"));
            metadata.setNodeCostColumn(rs.getString("node_cost_column"));
            metadata.setLinkTable(rs.getString("link_table_name"));
            metadata.setLinkGeometryColumn(rs.getString("link_geom_column"));
            metadata.setLinkDirection(rs.getString("link_direction"));
            metadata.setLinkCostColumn(rs.getString("link_cost_column"));
            metadata.setPathTable(rs.getString("path_table_name"));
            metadata.setPathGeometryColumn(rs.getString("path_geom_column"));
            metadata.setPathLinkTable(rs.getString("path_link_table_name"));
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (netStmt != null) {
                try {
                    netStmt.close();
                }
                catch (Exception re) {}
            }
        }
        return metadata;
    }

    @Override
    public boolean goToWorkspace(WorkSpace workspace) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (workspace == null) {
            System.out.println("Workspace is null.");
            throw new Exception("Workspace is null.");
        }
        Statement callstmt = null;
        if (workspace.getName() != null) {
            try {
                String callexe = "{ call dbms_wm.GotoWorkspace('" + workspace.getName() + "') }";
                callstmt = this.conn.prepareCall(callexe);
                callstmt.execute();
                callstmt.close();
                if (workspace.getSavedPoint() != null) {
                    callexe = "{ call dbms_wm.GotoSavepoint('" + workspace.getSavedPoint() + "') }";
                    callstmt = this.conn.prepareCall(callexe);
                    callstmt.execute();
                    callstmt.close();
                }
                if (workspace.getDate() != null) {
                    callexe = "{ call dbms_wm.GotoDate('" + workspace.getDate() + "','" + workspace.getDateFormat() + "'";
                    callexe = workspace.getDateGlobalizationSupport() != null ? callexe + ",'" + workspace.getDateGlobalizationSupport() + "'," + workspace.isDateTimestampWithZone() + ") }" : callexe + ",null," + workspace.isDateTimestampWithZone() + ") }";
                    callstmt = this.conn.prepareCall(callexe);
                    callstmt.execute();
                    callstmt.close();
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                try {
                    if (callstmt != null) {
                        callstmt.close();
                        callstmt = null;
                    }
                }
                catch (Exception e) {}
            }
        }
        return false;
    }

    @Override
    public AnnotationTextMetadata loadAnnotationTextMetadata(String table, String column) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            System.out.println("Table name is null.");
            throw new Exception("Table name is null.");
        }
        if (column == null) {
            System.out.println("Column name is null.");
            throw new Exception("Column name is null.");
        }
        String connectionUser = this.conn.getMetaData().getUserName();
        String atName = table;
        String atOwner = connectionUser;
        int idx = atName.indexOf(".");
        if (idx > -1) {
            atOwner = atName.substring(0, idx);
            atName = atName.substring(idx + 1, atName.length());
        }
        String atquery = "select * from all_annotation_text_metadata where table_name = ?  and column_name = ?  and owner = ?";
        AnnotationTextMetadata metadata = new AnnotationTextMetadata();
        PreparedStatement atStmt = null;
        ResultSet rs = null;
        try {
            atStmt = this.conn.prepareStatement(atquery);
            atStmt.setString(1, atName.toUpperCase());
            atStmt.setString(2, column.toUpperCase());
            atStmt.setString(3, atOwner.toUpperCase());
            rs = atStmt.executeQuery();
            if (!rs.next()) {
                System.out.println("Unable to load Annotation metadata for Table Name " + atName + ", Column Name " + column + ", Annotation Owner " + atOwner);
                AnnotationTextMetadata annotationTextMetadata = null;
                return annotationTextMetadata;
            }
            metadata.setOwner(atOwner);
            metadata.setName(atName.toUpperCase());
            metadata.setSpatialColumn(column.toUpperCase());
            metadata.setTextExpression(rs.getString("text_expression"));
            metadata.setTextAttributes(rs.getString("text_attributes"));
            if (rs.getObject("map_base_scale") != null) {
                metadata.setMapBaseScale(rs.getDouble("map_base_scale"));
            }
        }
        catch (Exception ex) {
            System.out.println("Annotation load metadata Exception: " + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (atStmt != null) {
                try {
                    atStmt.close();
                }
                catch (Exception re) {}
            }
        }
        return metadata;
    }

    @Override
    public boolean createAnnotationTextMetadata(String table, String column, Double baseScale, String textExpression, String textAttributes) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    @Override
    public boolean updateAnnotationTextMetadata(String table, String column, Double baseScale, String textExpression, String textAttributes) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    @Override
    public boolean createTopology(String topology, double tolerance, int srid) throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public boolean relateFeatureTableWithTopology(String topology, String featureTable, String topoColumn, String topoFeatureType, int childLayerId) throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public boolean sequenceExists(String sequence) throws Exception, MDSException {
        if (sequence == null) {
            System.out.println("Sequence name is null.");
            throw new Exception("Sequence name is null.");
        }
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        String sqlSeqString = "select sequence_name from user_sequences where  sequence_name = ?";
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.prepareStatement(sqlSeqString);
            stmt.setString(1, sequence.toUpperCase());
            rs = stmt.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return false;
    }

    @Override
    public boolean createSequence(String sequence, long startWith) throws Exception {
        if (sequence == null) {
            System.out.println("Sequence name is null.");
            throw new Exception("Sequence name is null.");
        }
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        String sqlSeqString = "create sequence " + sequence + " start with " + startWith;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.prepareStatement(sqlSeqString);
            stmt.execute();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return true;
    }

    @Override
    public Vector<Sequence> getSequences() throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public long getNetworkMaxId(String network, String netEntity) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (network == null) {
            System.out.println("Table name is null.");
            throw new Exception("Table name is null.");
        }
        if (netEntity == null) {
            System.out.println("Network entity is null.");
            throw new Exception("Network entity is null.");
        }
        if (!netEntity.equalsIgnoreCase("node") && !netEntity.equalsIgnoreCase("link")) {
            System.out.println("Invalid network entity name (must be node or link).");
            throw new Exception("Invalid network entity name (must be node or link).");
        }
        String column = null;
        String table = null;
        if (netEntity.equalsIgnoreCase("node")) {
            column = "max(node_id)";
            table = network + "_node$";
        } else {
            column = "max(link_id)";
            table = network + "_link$";
        }
        String sqlString = " select " + column + " from " + table;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.prepareStatement(sqlString);
            rs = stmt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return 0L;
    }

    @Override
    public TopologyMetadata loadTopologyMetadata(String topology, String featureTable, String topoColumn) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (topology == null) {
            System.out.println("Feature Table name is null.");
            throw new Exception("Feature Table name is null.");
        }
        PreparedStatement topoStmt = null;
        ResultSet rs = null;
        String connectionUser = this.conn.getMetaData().getUserName();
        String topName = topology;
        String topOwner = connectionUser;
        int index = topName.indexOf(".");
        if (index > -1) {
            topOwner = topName.substring(0, index);
            topName = topName.substring(index + 1, topName.length());
        }
        String tbName = null;
        String tbOwner = connectionUser;
        String topoquery = null;
        if (featureTable != null && topoColumn != null) {
            tbName = featureTable;
            tbOwner = connectionUser;
            index = tbName.indexOf(".");
            if (index > -1) {
                tbOwner = tbName.substring(0, index);
                tbName = tbName.substring(index + 1, tbName.length());
            }
            topoquery = "select * from all_sdo_topo_metadata where topology = ?  and table_name = ?  and column_name = ?  and table_owner = ?  and owner = ?";
        } else {
            topoquery = "select * from all_sdo_topo_metadata where topology = ?  and owner = ?";
        }
        TopologyMetadata metadata = new TopologyMetadata();
        try {
            topoStmt = this.conn.prepareStatement(topoquery);
            if (tbName != null) {
                topoStmt.setString(1, topName.toUpperCase());
                topoStmt.setString(2, tbName.toUpperCase());
                topoStmt.setString(3, topoColumn.toUpperCase());
                topoStmt.setString(4, tbOwner.toUpperCase());
                topoStmt.setString(5, topOwner.toUpperCase());
            } else {
                topoStmt.setString(1, topName.toUpperCase());
                topoStmt.setString(2, topOwner.toUpperCase());
            }
            rs = topoStmt.executeQuery();
            if (!rs.next()) {
                System.out.println("Unable to load Topology " + topName + ", Table Name " + tbName + ", Column Name " + topoColumn + ", Table Owner " + tbOwner + ", Topology Owner " + topOwner);
                throw new Exception("Unable to load Topology " + topName + ", Table Name " + featureTable + ", Column Name " + topoColumn);
            }
            metadata.setTopologyOwner(rs.getString("owner"));
            metadata.setTopology(rs.getString("topology"));
            metadata.setTopologyId(rs.getInt("topology_id"));
            metadata.setTolerance(rs.getDouble("tolerance"));
            metadata.setSrid(rs.getLong("srid"));
            metadata.setNodeSequence(rs.getString("node_sequence"));
            metadata.setEdgeSequence(rs.getString("edge_sequence"));
            metadata.setFaceSequence(rs.getString("face_sequence"));
            metadata.setTopoGeometrySequence(rs.getString("tg_sequence"));
            metadata.setDigitsRightOfDecimal(rs.getInt("digits_right_of_decimal"));
            if (tbName != null) {
                metadata.setFeatureTable(rs.getString("table_name"));
                metadata.setTopoColumn(rs.getString("column_name"));
                metadata.setTopoLayerId(rs.getInt("tg_layer_id"));
                metadata.setTopoLayerType(rs.getString("tg_layer_type"));
                metadata.setTopoLayerLevel(rs.getInt("tg_layer_level"));
                metadata.setChildLayerId(rs.getInt("child_layer_id"));
                metadata.setFeatureTableOwner(rs.getString("table_owner"));
            }
        }
        catch (Exception ex) {
            System.out.println("Topology load metadata Exception: " + ex.getMessage());
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (topoStmt != null) {
                try {
                    topoStmt.close();
                }
                catch (Exception re) {}
            }
        }
        return metadata;
    }

    @Override
    public TopologyMetadata[] loadTopologyLayersMetadata(String topology) throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public TopologyPrimitives loadTopologyPrimitives(String topology, Rectangle2D mbr, WorkSpace workspace) throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public TopologyPrimitives loadTopologyPrimitives(String topology, int[] faceIds, int[] edgeIds, int[] nodeIds, WorkSpace workspace) throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public Vector<AbstractFeature> loadTopologyFeatures(String topology, String featureTable, String topoColumn, Rectangle2D mbr, WorkSpace workspace) throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public String[] getTopologyFeatureTables(String topology) throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public String[] getFeatureTableTopologies(String featureTable, String topoColumn) throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public TopologyRelation[] getRelationsForTopologyPrimitive(String topology, int topo_id, int topo_type, WorkSpace workspace) throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public TopologyRelation[] getRelationsForTopologyChildFeature(String topology, int child_layer_id, int feature_id, WorkSpace workspace) throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public String[] getTopologyNames() throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public String[] getNetworkNames() throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public String[] getVersionedTables() throws Exception, MDSException {
        throw new Exception("To be implemented");
    }

    @Override
    public boolean dataTableExists(String table) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            System.out.println("Feature Table name is null.");
            throw new Exception("Feature Table name is null.");
        }
        String connectionUser = this.conn.getMetaData().getUserName();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String tableName = table;
        String tableOwner = connectionUser;
        int index = tableName.indexOf(".");
        if (index > -1) {
            tableOwner = tableName.substring(0, index);
            tableName = tableName.substring(index + 1, tableName.length());
        }
        String query = "select count(*) from all_tables where owner = ? and table_name= ?";
        try {
            int haveR;
            stmt = this.conn.prepareStatement(query);
            stmt.setString(1, tableOwner.toUpperCase());
            stmt.setString(2, tableName.toUpperCase());
            rs = stmt.executeQuery();
            if (rs.next() && (haveR = rs.getInt(1)) > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return false;
    }

    @Override
    public long getRecordCount(String table, String whereClause) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            System.out.println("Table name is null.");
            throw new Exception("Table name is null.");
        }
        String query = "select count(*) from " + table;
        if (whereClause != null) {
            query = query + " where " + whereClause;
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.prepareStatement(query);
            rs = stmt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception re) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception re) {}
            }
        }
        return 0L;
    }

    @Override
    public boolean topoFacesHaveMismatchOfFeatures(String topoModel, long faceLeft, long faceRight) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (topoModel == null) {
            System.out.println("Topology model name is null.");
            throw new Exception("Topology model name is null.");
        }
        PreparedStatement stmt1 = null;
        Statement stmt2 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String query = "select * from " + topoModel + "_relation$ where topo_type=3 and topo_id=? order by tg_layer_id, tg_id";
        try {
            stmt1 = this.conn.prepareStatement(query);
            stmt1.setLong(1, faceLeft);
            rs1 = stmt1.executeQuery();
            stmt2 = this.conn.prepareStatement(query);
            stmt2.setLong(1, faceRight);
            rs2 = stmt2.executeQuery();
            boolean faceMismatch = false;
            while (rs1.next()) {
                if (!rs2.next()) {
                    faceMismatch = true;
                    break;
                }
                if (rs1.getLong(1) == rs2.getLong(1) && rs1.getLong(2) == rs2.getLong(2)) continue;
                faceMismatch = true;
                break;
            }
            if (faceMismatch || rs2.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (rs1 != null) {
                try {
                    rs1.close();
                }
                catch (Exception re) {}
            }
            if (stmt1 != null) {
                try {
                    stmt1.close();
                }
                catch (Exception re) {}
            }
            if (rs2 != null) {
                try {
                    rs2.close();
                }
                catch (Exception re) {}
            }
            if (stmt2 != null) {
                try {
                    stmt2.close();
                }
                catch (Exception re) {}
            }
        }
        return false;
    }

    @Override
    public boolean topoEdgesHaveMismatchOfFeatures(String topoModel, long firstEdge, long secondEdge) throws Exception {
        if (this.conn == null) {
            System.out.println("Connection is null.");
            throw new Exception("Connection is null.");
        }
        if (topoModel == null) {
            System.out.println("Topology model name is null.");
            throw new Exception("Topology model name is null.");
        }
        PreparedStatement stmt1 = null;
        Statement stmt2 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        String query = "select * from " + topoModel + "_relation$ where topo_type=2 and (topo_id=? or topo_id=?) order by tg_layer_id, tg_id";
        try {
            stmt1 = this.conn.prepareStatement(query);
            stmt1.setLong(1, firstEdge);
            stmt1.setLong(2, -firstEdge);
            rs1 = stmt1.executeQuery();
            stmt2 = this.conn.prepareStatement(query);
            stmt2.setLong(1, secondEdge);
            stmt2.setLong(2, -secondEdge);
            rs2 = stmt2.executeQuery();
            boolean faceMismatch = false;
            while (rs1.next()) {
                if (!rs2.next()) {
                    faceMismatch = true;
                    break;
                }
                if (rs1.getLong(1) == rs2.getLong(1) && rs1.getLong(2) == rs2.getLong(2)) continue;
                faceMismatch = true;
                break;
            }
            if (faceMismatch || rs2.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (rs1 != null) {
                try {
                    rs1.close();
                }
                catch (Exception re) {}
            }
            if (stmt1 != null) {
                try {
                    stmt1.close();
                }
                catch (Exception re) {}
            }
            if (rs2 != null) {
                try {
                    rs2.close();
                }
                catch (Exception re) {}
            }
            if (stmt2 != null) {
                try {
                    stmt2.close();
                }
                catch (Exception re) {}
            }
        }
        return false;
    }

    @Override
    public boolean tableHasAttributeWithValue(String table, String attr, String value, String workspace) throws Exception {
        if (workspace != null && !workspace.equalsIgnoreCase("LIVE")) {
            Util.gotoWorkspace((Connection)this.conn, (String)workspace);
        }
        boolean result = JDBCUtil.tableValueExists((Connection)this.conn, (String)table, (String)attr, (String)value);
        if (workspace != null && !workspace.equalsIgnoreCase("LIVE")) {
            Util.gotoWorkspace((Connection)this.conn, (String)"LIVE");
        }
        return result;
    }

    @Override
    public JGeometry union(JGeometry sourceGeom, JGeometry[] otherGeoms, double tolerance) throws Exception {
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        if (sourceGeom == null) {
            throw new Exception("Source geometry is null");
        }
        if (otherGeoms == null || otherGeoms.length == 0) {
            throw new Exception("At least one other geometry must be defined.");
        }
        return ORADBGeometryOperations.union((Connection)this.conn, (JGeometry)sourceGeom, (JGeometry[])otherGeoms, (double)tolerance);
    }

    @Override
    public JGeometry difference(JGeometry sourceGeom, JGeometry[] otherGeoms, double tolerance) throws Exception {
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        if (sourceGeom == null) {
            throw new Exception("Source geometry is null");
        }
        if (otherGeoms == null || otherGeoms.length == 0) {
            throw new Exception("At least one other geometry must be defined.");
        }
        return ORADBGeometryOperations.difference((Connection)this.conn, (JGeometry)sourceGeom, (JGeometry[])otherGeoms, (double)tolerance);
    }

    @Override
    public JGeometry intersection(JGeometry sourceGeom, JGeometry[] otherGeoms, double tolerance) throws Exception {
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        if (sourceGeom == null) {
            throw new Exception("Source geometry is null");
        }
        if (otherGeoms == null || otherGeoms.length == 0) {
            throw new Exception("At least one other geometry must be defined.");
        }
        return ORADBGeometryOperations.intersection((Connection)this.conn, (JGeometry)sourceGeom, (JGeometry[])otherGeoms, (double)tolerance);
    }

    @Override
    public JGeometry union(AbstractFeature sourceGeom, AbstractFeature[] otherGeoms, double tolerance) throws Exception, MDSException {
        throw new Exception("Not implemented");
    }

    @Override
    public JGeometry difference(AbstractFeature sourceGeom, AbstractFeature[] otherGeoms, double tolerance) throws Exception, MDSException {
        throw new Exception("Not implemented");
    }

    @Override
    public JGeometry intersection(AbstractFeature sourceGeom, AbstractFeature[] otherGeoms, double tolerance) throws Exception, MDSException {
        throw new Exception("Not implemented");
    }

    @Override
    public Hashtable<String, String> validateFeatureGeometries(String keyAttribute, AbstractFeature[] features, double tolerance) throws Exception {
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        if (keyAttribute == null) {
            throw new Exception("key attribute name must be defined.");
        }
        if (features == null || features.length == 0) {
            throw new Exception("At least one feature must be defined.");
        }
        Hashtable<String, String> validation = new Hashtable<String, String>();
        for (int i = 0; i < features.length; ++i) {
            String key = features[i].getAttribute(keyAttribute).getValue().toString();
            if (key == null) {
                throw new Exception("There is a feature ith null key value.");
            }
            JGeometry geom = ((GeometryFeature)features[i]).getSpatialAttribute();
            String valid = ORADBGeometryOperations.validateGeometry((Connection)this.conn, (JGeometry)geom, (double)tolerance);
            if (valid == null) {
                validation.put(key, "");
                continue;
            }
            validation.put(key, valid);
        }
        return validation;
    }

    @Override
    public String getTablePrimaryKey(String table) throws Exception {
        throw new Exception("To be implemented");
    }

    @Override
    public boolean setTablePrimaryKey(String table, String keyAttribute) throws Exception {
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        if (table == null) {
            throw new Exception("Table name is null.");
        }
        if (keyAttribute == null) {
            throw new Exception("Key attribute name is null.");
        }
        if (!ORAWorkspaceJDBCUtil.setTablePrimaryKey((Connection)this.conn, (String)table, (String)keyAttribute)) {
            throw new Exception("Unable to add primary key to table [" + table + "].");
        }
        return true;
    }

    @Override
    public boolean enableVersioning(String dataName, String workspace, boolean isTopology, String historyMode, String undoSpace) throws Exception {
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        if (dataName == null) {
            throw new Exception("Table name is null.");
        }
        if (!ORAWorkspaceJDBCUtil.enableVersioning((Connection)this.conn, (String)dataName, (String)historyMode, (boolean)isTopology, (String)undoSpace)) {
            throw new Exception("Unable to enable versioning for data [" + dataName + "].");
        }
        return true;
    }

    @Override
    public boolean isTableVersioned(String table, String workspace) throws Exception {
        throw new Exception("To be implemented");
    }

    @Override
    public boolean disableVersioning(String dataName, boolean isTopology, boolean force, boolean ignoreLastError) throws Exception {
        if (this.conn == null) {
            throw new Exception("Connection is null.");
        }
        if (dataName == null) {
            throw new Exception("Table name is null.");
        }
        throw new Exception("To be implemented.");
    }

    @Override
    public Vector<FeatureConflictDescriptor> getTableWorkspaceConflicts(String workspace, String table, String keyColumn) throws Exception {
        return new Vector<FeatureConflictDescriptor>();
    }

    @Override
    public int resolveTableWorkspaceConflicts(String workspace, String baseTable, String keyAttribute, Vector<FeatureConflictDescriptor> conflicts) throws Exception {
        return 0;
    }

    @Override
    public boolean mergeTableWorkspaces(String sessionName, String layerName) throws Exception {
        return true;
    }

    @Override
    public String[] getSessionWorkspaceModifiedLayers(String sessionName) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    @Override
    public String[] getModifiedTablesForWorkspace(String workspaceName) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    @Override
    public String[] getModifiedWorkspacesForTopology(String topologyName) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    @Override
    public String[] getModifiedWorkspacesForTable(String tableName) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    @Override
    public String[] getGeometryAttributes(String table) throws Exception {
        return JDBCUtil.getGeometryAttributes((Connection)this.conn, (String)table);
    }

    @Override
    public String[] getNonComplexAttributes(String table) throws Exception {
        return JDBCUtil.getNonComplexAttributes((Connection)this.conn, (String)table, (boolean)false);
    }

    @Override
    public Vector<MVThemeMetadata> getMapViewerThemesMetadata() throws Exception {
        return null;
    }

    @Override
    public Vector<MVTileLayerMetadata> getMapViewerTileLayersMetadata() throws Exception {
        return null;
    }

    @Override
    public Vector<SpatialTableMetadata> getSpatialTablesMetadata() throws Exception {
        SpatialTableMetadata[] tbMetadata = JDBCUtil.getSpatialTablesMetadata((Connection)this.conn);
        Vector<SpatialTableMetadata> stmVec = new Vector<SpatialTableMetadata>(tbMetadata.length);
        for (int i = 0; i < tbMetadata.length; ++i) {
            stmVec.add(tbMetadata[i]);
        }
        return stmVec;
    }

    @Override
    public boolean createEditSession(String sessionName, String description, boolean vesrionEnabled) throws Exception {
        return false;
    }

    @Override
    public boolean removeEditSession(String sessionName) throws Exception {
        return false;
    }

    @Override
    public boolean updateEditSession(MDSEditSession session) throws Exception {
        return false;
    }

    @Override
    public String[] getEditorSessions() throws Exception {
        String editor = this.dataSource.getConnectionProperties().getProperty("editor");
        String[] sessions = JDBCUtil.getEditorSessionNames((Connection)this.conn, (String)editor);
        return sessions;
    }

    @Override
    public String getEditSession(String sessionName) throws Exception {
        return null;
    }

    @Override
    public boolean endEditingSession(String sessionName) throws Exception {
        return false;
    }

    @Override
    public boolean startEditingSession(String sessionName, JGeometry area) throws Exception {
        return false;
    }

    @Override
    public boolean clearCachedSessions() throws Exception {
        return false;
    }

    @Override
    public TableAttributesMetadata getTableAttributesMetadata(String table, String spatialColumn, String spatialType) throws Exception {
        long geomSRID = JDBCUtil.getSRID((Connection)this.conn, (String)table, (String)spatialColumn, (String)spatialType);
        boolean isGeodeticSRID = JDBCUtil.isGeodeticSRID((Connection)this.conn, (long)geomSRID);
        Hashtable attrJavaTypes = JDBCUtil.getAttributesAndJavaTypes((Connection)this.conn, (String)table, (String)spatialColumn);
        String[] nonNullAttributes = JDBCUtil.getNonNullAttributes((Connection)this.conn, (String)table);
        TableAttributesMetadata metadata = new TableAttributesMetadata(table);
        metadata.setSRID(geomSRID);
        metadata.setGeodeticSRID(isGeodeticSRID);
        metadata.setAttributesJavaType(attrJavaTypes);
        if (nonNullAttributes != null && nonNullAttributes.length > 0) {
            Vector<String> nonnullattrs = new Vector<String>();
            for (int i = 0; i < nonNullAttributes.length; ++i) {
                nonnullattrs.add(nonNullAttributes[i]);
            }
            metadata.setNonNullAttributes(nonnullattrs);
        }
        return metadata;
    }

    @Override
    public boolean createTable(String tableName, String[] columns, String[] types, boolean[] notNull, String primaryKey, Vector<SpatialTableMetadata> spatialMetadata) throws Exception {
        int success = 0;
        boolean tAutoCommit = false;
        try {
            int i;
            tAutoCommit = this.conn.getAutoCommit();
            this.conn.setAutoCommit(false);
            success = JDBCUtil.createTable((Connection)this.conn, (String)tableName, (String[])columns, (String[])types, (boolean[])notNull, (String)primaryKey);
            if (spatialMetadata != null) {
                for (i = 0; i < spatialMetadata.size(); ++i) {
                    SpatialTableMetadata stm = spatialMetadata.get(i);
                    Vector diVec = stm.getDimensionInfo();
                    int dimNum = diVec.size();
                    String[] dimName = new String[dimNum];
                    double[] min = new double[dimNum];
                    double[] max = new double[dimNum];
                    double[] tol = new double[dimNum];
                    for (int j = 0; j < dimNum; ++j) {
                        DimensionInfo di = (DimensionInfo)diVec.get(j);
                        dimName[j] = di.getName();
                        min[j] = di.getMin();
                        max[j] = di.getMax();
                        tol[j] = di.getTolerance();
                    }
                    success = success != 0 && JDBCUtil.createGeometryMetadata((Connection)this.conn, (String)tableName, (String)stm.getSpatialColumn(), (String[])dimName, (double[])min, (double[])max, (double[])tol, (long)stm.getSRID()) ? 1 : 0;
                }
            }
            if (success != 0) {
                this.conn.commit();
            } else {
                this.conn.rollback();
            }
            i = success;
            return i != 0;
        }
        catch (Exception e) {
            this.conn.rollback();
            throw e;
        }
        finally {
            this.conn.setAutoCommit(tAutoCommit);
        }
    }

    @Override
    public SpatialColumnExtent getSpatialColumnExtent(String owner, String tableName, String spatialColumn, String spatialType) throws Exception {
        SpatialColumnExtent sce = JDBCUtil.getSpatialColumnExtent((Connection)this.conn, (String)owner, (String)tableName, (String)spatialColumn, (String)spatialType);
        return sce;
    }

    @Override
    public SRS getSRS(String srid) throws Exception {
        return null;
    }

    @Override
    public Vector<String> getMapViewerBaseMaps() throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    @Override
    public String[] getMapViewerBasemapThemeNames(String basemap) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    @Override
    public boolean lockTopologyRows(String workspace, String topology, double xmin, double ymin, double xmax, double ymax) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }

    @Override
    public boolean unlockTopologyRows(String workspace, String topology, double xmin, double ymin, double xmax, double ymax) throws Exception, MDSException {
        throw new Exception("To be implemented.");
    }
}

