/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.model;

import java.awt.geom.Rectangle2D;
import oracle.maps.geoobject.AbstractFeature;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.text.AnnotationText;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.geometry.JGeometry;

public class EditChangeEvent {
    public static int NO_EVENT = 0;
    public static int NEW_EVENT = 1;
    public static int UPDATE_EVENT = 2;
    public static int REMOVE_EVENT = 3;
    public static int NO_UPDATE = 0;
    public static int SPATIAL_UPDATE = 1;
    public static int ATTRIBUTE_UPDATE = 2;
    private int eventType = NO_EVENT;
    private int updateType = NO_UPDATE;
    private String key = null;
    private Object current = null;
    private Object old = null;
    private boolean isNewFeature = false;
    private boolean isModifiedFeature = false;

    public EditChangeEvent(int evType, int upType, String key, Object current, Object old, boolean isNew, boolean isModified) {
        this.eventType = evType;
        this.updateType = upType;
        this.key = key;
        this.current = current;
        this.old = old;
        this.isNewFeature = isNew;
        this.isModifiedFeature = isModified;
    }

    public String getDescriptionString() {
        if (this.eventType == NEW_EVENT) {
            return MessagesBundle.getFormattedMessage("Change_new_feature", this.key);
        }
        if (this.eventType == REMOVE_EVENT) {
            return MessagesBundle.getFormattedMessage("Change_delete_feature", this.key);
        }
        if (this.eventType == UPDATE_EVENT) {
            if (this.updateType == SPATIAL_UPDATE) {
                return MessagesBundle.getFormattedMessage("Change_update_spatial_single", this.key);
            }
            if (this.updateType == ATTRIBUTE_UPDATE) {
                return MessagesBundle.getFormattedMessage("Change_update_attr_single", this.key);
            }
        }
        return "No update";
    }

    public int getEventType() {
        return this.eventType;
    }

    public int getUpdateType() {
        return this.updateType;
    }

    public String getKey() {
        return this.key;
    }

    public Object getCurrentObject() {
        return this.current;
    }

    public Object getOldObject() {
        return this.old;
    }

    public boolean isNewFeature() {
        return this.isNewFeature;
    }

    public boolean isModifiedFeature() {
        return this.isModifiedFeature;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Rectangle2D getAffectedSpatialArea() {
        if (this.eventType == UPDATE_EVENT && this.updateType != SPATIAL_UPDATE) {
            return null;
        }
        if (this.eventType == NEW_EVENT) {
            try {
                AbstractFeature feat = (AbstractFeature)this.current;
                return feat.getMBR();
            }
            catch (Exception e) {
                System.out.println("Expecting AbstractFeature object.\n" + e.getMessage());
                return null;
            }
        }
        if (this.eventType == REMOVE_EVENT) {
            try {
                AbstractFeature feat = (AbstractFeature)this.old;
                return feat.getMBR();
            }
            catch (Exception e) {
                System.out.println("Expecting AbstractFeature object.\n" + e.getMessage());
                return null;
            }
        }
        if (this.eventType != UPDATE_EVENT) return null;
        if (this.updateType != SPATIAL_UPDATE) return null;
        Rectangle2D oldMbr = null;
        Rectangle2D currentMbr = null;
        Rectangle2D resultMbr = null;
        if (this.current instanceof JGeometry) {
            try {
                JGeometry currentGeom;
                JGeometry oldGeom = (JGeometry)this.old;
                if (oldGeom != null) {
                    double[] mbr = oldGeom.getMBR();
                    resultMbr = oldMbr = new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]);
                }
                if ((currentGeom = (JGeometry)this.current) == null) return resultMbr;
                double[] mbr = currentGeom.getMBR();
                currentMbr = new Rectangle2D.Double(mbr[0], mbr[1], mbr[2] - mbr[0], mbr[3] - mbr[1]);
                if (resultMbr == null) {
                    return currentMbr;
                }
                resultMbr.add(currentMbr);
                return resultMbr;
            }
            catch (Exception e) {
                System.out.println("Expecting JGeometry object.\n" + e.getMessage());
                return null;
            }
        }
        if (this.current instanceof AnnotationText) {
            try {
                AnnotationText currentAText;
                AnnotationText oldAText = (AnnotationText)this.old;
                if (oldAText != null) {
                    resultMbr = oldMbr = oldAText.getMBR();
                }
                if ((currentAText = (AnnotationText)this.current) == null) return resultMbr;
                currentMbr = currentAText.getMBR();
                if (resultMbr == null) {
                    return currentMbr;
                }
                resultMbr.add(currentMbr);
                return resultMbr;
            }
            catch (Exception e) {
                System.out.println("Expecting AnnotationText object.\n" + e.getMessage());
                return null;
            }
        }
        if (!(this.current instanceof TopologyGeometry)) return null;
        try {
            TopologyGeometry currentTPgeom;
            TopologyGeometry oldTPgeom = (TopologyGeometry)this.old;
            if (oldTPgeom != null) {
                resultMbr = oldMbr = oldTPgeom.getMBR();
            }
            if ((currentTPgeom = (TopologyGeometry)this.current) == null) return resultMbr;
            currentMbr = currentTPgeom.getMBR();
            if (resultMbr == null) {
                return currentMbr;
            }
            resultMbr.add(currentMbr);
            return resultMbr;
        }
        catch (Exception e) {
            System.out.println("Expecting TopologyGeometry object.\n" + e.getMessage());
            return null;
        }
    }
}

