/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.layer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import oracle.lbs.mapclient.ThemeDescriptor;
import oracle.maps.core.GeoObject;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.graphics.ShadowRenderer;
import oracle.maps.util.RenderUtils;
import oracle.maps.util.StyleModelUtils;
import oracle.mapviewer.share.AnnotationTextMetadata;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleText;
import oracle.sdovis.text.AnnotationText;
import oracle.sdovis.text.AnnotationTextElement;
import oracle.sdovis.text.jaxb.TextAttributesType;
import oracle.sdovis.theme.AnnotationTextThemeProducer;
import oracle.spatial.edit.index.annotationtext.IndexedAnnotationTextSet;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.annotationtext.AnnotationTextFeature;
import oracle.spatial.edit.model.annotationtext.AnnotationTextSet;
import oracle.spatial.edit.producer.AnnotationTextSetProducer;
import oracle.spatial.geometry.JGeometry;
import org.w3c.dom.Element;

public class AnnotationTextSetLayer
extends AbstractDataSetLayer {
    protected AnnotationTextMetadata atextMetadata = null;

    public AnnotationTextSetLayer(MapCanvas canvas, IndexedAnnotationTextSet set) {
        super(canvas);
        this.indexedSet = set;
        if (this.indexedSet != null) {
            this.indexedSet.setDataSetLayer(this);
        }
    }

    public AnnotationTextSetLayer() {
        this(null, null);
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon("annotext.png");
    }

    @Override
    public void fromXMLElement(Element element) {
        super.fromXMLElement(element);
        AnnotationTextSet atset = new AnnotationTextSet();
        atset.setName(this.getName());
        this.indexedSet = new IndexedAnnotationTextSet(atset);
        this.indexedSet.setDataSetLayer(this);
        this.updateDataSetSpatialInfo();
        this.liveProducer = new AnnotationTextSetProducer(this);
    }

    @Override
    public ThemeDescriptor getThemeDescriptor() {
        ThemeDescriptor td = new ThemeDescriptor();
        td.name = this.getName();
        td.type = 12;
        td.featureTableName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable");
        td.spatialColumn = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn");
        td.renderStyleName = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle");
        td.labelColumn = this.getAnnotationTextExpressionColumn();
        String query = "select " + td.spatialColumn + " from " + td.featureTableName;
        td.WFS_queryCondition = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition");
        if (td.WFS_queryCondition != null && td.WFS_queryCondition.trim().length() > 0) {
            query = query + " where " + td.WFS_queryCondition.trim();
        }
        td.query = query;
        td.SRID = this.getSRID();
        return td;
    }

    private String getAnnotationTextExpressionColumn() {
        String exprColumn = null;
        AnnotationTextMetadata atextMetadata = this.getAnnotationTextMetadata();
        if (atextMetadata != null) {
            String textExpr = atextMetadata.getTextExpression();
            String[] attrs = this.getNonComplexAttributes();
            if (textExpr != null && attrs != null && attrs.length > 0) {
                for (int i = 0; i < attrs.length; ++i) {
                    if (!textExpr.equalsIgnoreCase(attrs[i])) continue;
                    exprColumn = attrs[i];
                    break;
                }
            }
        }
        return exprColumn;
    }

    @Override
    protected String getModelString() {
        return "annotationtext";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnnotationTextMetadata getAnnotationTextMetadata() {
        if (this.atextMetadata != null) {
            return this.atextMetadata;
        }
        if (this.getDataSource() == null) {
            return null;
        }
        AbstractDataAccessObject da = this.getDataSource().getDataAccessObject();
        try {
            da.openConnection();
            this.atextMetadata = da.loadAnnotationTextMetadata(this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable"), this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn"));
        }
        catch (MDSException ex) {
            this.atextMetadata = null;
        }
        catch (Exception ex) {
            this.atextMetadata = null;
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception ee) {
                ee.printStackTrace();
            }
        }
        return this.atextMetadata;
    }

    @Override
    public boolean propagateEvent(EventObject evt) {
        return false;
    }

    @Override
    protected void renderFeature(Graphics2D g, AbstractFeature feat, AffineTransform at, Style leaderlineStyle) {
        Field attr;
        StyleText metaStyle = this.getMetadataTextStyle();
        double metaScale = ((AnnotationTextSet)this.indexedSet.getDataSet()).getMetadata().getMapBaseScale();
        String defaultText = ((AnnotationTextSet)this.indexedSet.getDataSet()).getMetadata().getTextExpression();
        boolean isDefaultTextFromColumn = this.isMetadataTextExpressionFromTableColumn();
        String textexpr = defaultText;
        if (isDefaultTextFromColumn && (attr = ((AnnotationTextFeature)feat).getAttribute(defaultText)) != null) {
            textexpr = attr.getValue() != null ? attr.getValue().toString() : null;
        }
        RenderUtils.renderAnnotationtextObject(g, at, (AnnotationTextFeature)feat, metaStyle, textexpr, metaScale, leaderlineStyle, new Rectangle2D.Double(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight()), this.canvas.getMapRegion().getDataWindow(), this.canvas.getMapRegion().getSRS());
    }

    @Override
    protected void doRealRendering() {
        Field attr;
        String renderStyle = this.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle");
        if (renderStyle == null) {
            return;
        }
        StyleText metaStyle = this.getMetadataTextStyle();
        double metaScale = ((AnnotationTextSet)this.indexedSet.getDataSet()).getMetadata().getMapBaseScale();
        String defaultText = ((AnnotationTextSet)this.indexedSet.getDataSet()).getMetadata().getTextExpression();
        boolean isDefaultTextFromColumn = this.isMetadataTextExpressionFromTableColumn();
        int w = this.canvas.getWidth();
        int h = this.canvas.getHeight();
        BufferedImage tmpImg = new BufferedImage(w, h, 2);
        StyleModel styModel = StyleModelUtils.getStyleModel(renderStyle);
        Style leaderlineStyle = StyleFactory.createStyleFromXML((String)styModel.toXMLString());
        long t1 = System.currentTimeMillis();
        Graphics2D g = tmpImg.createGraphics();
        AffineTransform xfm = this.canvas.getViewportTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        String textexpr = defaultText;
        List<GeoObject> data = this.indexedSet.getFeatures(this.canvas.getMapRegion().getDataWindow());
        for (GeoObject o : data) {
            if (this.myDeleteObjects.size() > 0 && this.myDeleteObjects.get(o.getKey().toString()) != null) continue;
            textexpr = defaultText;
            if (isDefaultTextFromColumn && (attr = ((AnnotationTextFeature)o).getAttribute(defaultText)) != null) {
                textexpr = attr.getValue() != null ? attr.getValue().toString() : null;
            }
            RenderUtils.renderAnnotationtextObject(g, xfm, (AnnotationTextFeature)o, metaStyle, textexpr, metaScale, leaderlineStyle, new Rectangle2D.Double(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight()), this.canvas.getMapRegion().getDataWindow(), this.canvas.getMapRegion().getSRS());
        }
        Enumeration enumer = this.myNewObjects.elements();
        while (enumer.hasMoreElements()) {
            GeoObject o;
            o = (GeoObject)enumer.nextElement();
            textexpr = defaultText;
            if (isDefaultTextFromColumn && (attr = ((AnnotationTextFeature)o).getAttribute(defaultText)) != null) {
                textexpr = attr.getValue() != null ? attr.getValue().toString() : null;
            }
            RenderUtils.renderAnnotationtextObject(g, xfm, (AnnotationTextFeature)o, metaStyle, textexpr, metaScale, leaderlineStyle, new Rectangle2D.Double(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight()), this.canvas.getMapRegion().getDataWindow(), this.canvas.getMapRegion().getSRS());
        }
        g.dispose();
        this.liveImg = tmpImg;
        long t2 = System.currentTimeMillis();
        System.out.println(this.getName() + "(" + this.getClass().getSimpleName() + "): Time spent on actual rendering: " + (t2 - t1) + "ms.");
    }

    public boolean isMetadataTextExpressionFromTableColumn() {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null || ((AnnotationTextSet)this.indexedSet.getDataSet()).getMetadata() == null) {
            return false;
        }
        String defaultText = ((AnnotationTextSet)this.indexedSet.getDataSet()).getMetadata().getTextExpression();
        boolean isDefaultTextFromColumn = false;
        String[] attrs = ((AnnotationTextSet)this.indexedSet.getDataSet()).getAttributeNames();
        if (defaultText != null) {
            for (int i = 0; i < attrs.length; ++i) {
                if (!defaultText.equalsIgnoreCase(attrs[i])) continue;
                isDefaultTextFromColumn = true;
                break;
            }
        }
        return isDefaultTextFromColumn;
    }

    public String getMetadataTextExpression() {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null || ((AnnotationTextSet)this.indexedSet.getDataSet()).getMetadata() == null) {
            return null;
        }
        return ((AnnotationTextSet)this.indexedSet.getDataSet()).getMetadata().getTextExpression();
    }

    private StyleText getMetadataTextStyle() {
        JAXBContext jc = null;
        Unmarshaller u = null;
        AnnotationTextMetadata metadata = ((AnnotationTextSet)this.indexedSet.getDataSet()).getMetadata();
        if (metadata == null) {
            return (StyleText)StyleFactory.getDefaultTextStyle();
        }
        String metaattrs = metadata.getTextAtttributes();
        if (metaattrs == null) {
            return (StyleText)StyleFactory.getDefaultTextStyle();
        }
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((String)"oracle.sdovis.text.jaxb");
                u = jc.createUnmarshaller();
            }
            StringBuffer xmlStr = new StringBuffer(metaattrs);
            JAXBElement jaxbEl = (JAXBElement)u.unmarshal((InputStream)new ByteArrayInputStream(xmlStr.toString().getBytes()));
            TextAttributesType txtattrs = (TextAttributesType)jaxbEl.getValue();
            return AnnotationTextThemeProducer.getTextStyle((TextAttributesType)txtattrs);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Unable to build text style for metadata.");
            return (StyleText)StyleFactory.getDefaultTextStyle();
        }
    }

    @Override
    protected void labelFeature(Graphics2D g, AffineTransform xfm, AbstractFeature feat) {
    }

    @Override
    protected void renderHoverShape(GeoObject object, Shape shape, Graphics2D dest, AffineTransform transf) {
        Rectangle2D mbr = shape.getBounds2D();
        int x = (int)mbr.getMinX();
        int y = (int)mbr.getMinY();
        int w = (int)mbr.getWidth() + 1;
        int h = (int)mbr.getHeight() + 1;
        int imgW = Math.min((int)mbr.getWidth(), this.canvas.getWidth());
        int imgH = Math.min((int)mbr.getHeight(), this.canvas.getHeight());
        if (imgW <= 0) {
            imgW = 1;
        }
        if (imgH <= 0) {
            imgH = 1;
        }
        BufferedImage image = new BufferedImage(imgW, imgH, 2);
        Graphics2D g = image.createGraphics();
        g.translate(-x, -y);
        g.setColor(this.hoverBorderColor);
        g.setStroke(this.hoverStroke);
        g.draw(shape);
        g.dispose();
        ShadowRenderer sr = new ShadowRenderer();
        BufferedImage shadow = sr.createShadow(image);
        dest.drawImage((Image)shadow, (int)mbr.getMinX(), (int)mbr.getMinY(), null);
        dest.drawImage((Image)image, (int)mbr.getMinX(), (int)mbr.getMinY(), null);
        shadow = null;
        image = null;
    }

    public boolean addTextElement(String key, AnnotationTextElement atelem) throws Exception {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null) {
            throw new Exception("null");
        }
        if (key == null || atelem == null) {
            throw new Exception("null");
        }
        ((IndexedAnnotationTextSet)this.indexedSet).addTextElement(key, atelem);
        this.fireStateChanged();
        return true;
    }

    public boolean removeTextElement(String key, int elemIndex) throws Exception {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null) {
            throw new Exception("null");
        }
        if (key == null || elemIndex < 0) {
            throw new Exception("null");
        }
        ((IndexedAnnotationTextSet)this.indexedSet).removeTextElement(key, elemIndex);
        this.fireStateChanged();
        return true;
    }

    public boolean removeTextElementLeaderLine(String key, int elemIndex) throws Exception {
        return this.updateTextElementLeaderLine(key, elemIndex, null);
    }

    public boolean updateTextElementLeaderLine(String key, int elemIndex, JGeometry geom) throws Exception {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null) {
            throw new Exception("null");
        }
        if (key == null || elemIndex < 0) {
            throw new Exception("null");
        }
        ((IndexedAnnotationTextSet)this.indexedSet).updateTextElementLeaderLine(key, elemIndex, geom);
        this.fireStateChanged();
        return true;
    }

    public boolean updateTextElementLocation(String key, int elemIndex, JGeometry geom) throws Exception {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null || geom == null) {
            throw new Exception("null");
        }
        if (key == null || elemIndex < 0) {
            throw new Exception("null");
        }
        ((IndexedAnnotationTextSet)this.indexedSet).updateTextElementLocation(key, elemIndex, geom);
        this.fireStateChanged();
        return true;
    }

    @Override
    public int transformFeatures(GeoObject[] features, AffineTransform at) throws Exception {
        if (features == null || features.length == 0) {
            return 0;
        }
        String changeName = MessagesBundle.getMessage("Change_transform_features");
        Icon changeIcon = null;
        this.startChangeBlock(changeName, changeIcon);
        int processed = 0;
        for (GeoObject f : features) {
            if (f == null) continue;
            AnnotationTextFeature feature = (AnnotationTextFeature)f;
            feature.setSpatialAttribute(((AnnotationTextFeature)this.getObject(f.getKey())).getSpatialAttribute());
            AnnotationText text = feature.createTransformedSpatialAttribute(at);
            if (text == null) continue;
            ((IndexedAnnotationTextSet)this.getIndexedDataSet()).updateEnvelope(text);
            try {
                this.getIndexedDataSet().updateSpatialAttribute(feature.getKey(), text);
                ++processed;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.endChangeBlock(changeName, changeIcon);
        if (processed > 0) {
            this.fireStateChanged();
        }
        return processed;
    }
}

