/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.edit.layer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import oracle.maps.core.DataProducer;
import oracle.maps.core.DefaultSelectionManager;
import oracle.maps.core.Drawable;
import oracle.maps.core.EditChangeListener;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoDataProducer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.HoverableLayer;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManagerEvent;
import oracle.maps.core.MVThemeLayer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.core.SelectableLayer;
import oracle.maps.core.SelectionEvent;
import oracle.maps.core.SelectionListener;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.ImageObject;
import oracle.maps.geoobject.WorkSpace;
import oracle.maps.graphics.AnimatedStroke;
import oracle.maps.layer.BasicLayer;
import oracle.maps.producer.MVImageProducer;
import oracle.maps.producer.SDODataProducer;
import oracle.maps.util.PropertySupportObject;
import oracle.maps.util.StyleModelUtils;
import oracle.mapviewer.share.FeatureConflictDescriptor;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.SpatialColumnExtent;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.util.LogFactory;
import oracle.mdeditor.session.layer.WorkspaceLayer;
import oracle.mdeditor.ui.AttributeValueTablePanel;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.StyleFactory;
import oracle.sdovis.XFViewPort;
import oracle.sdovis.style.Style;
import oracle.sdovis.style.StyleColor;
import oracle.sdovis.style.StyleText;
import oracle.spatial.edit.index.AbstractIndexedDataSet;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.AbstractDataSet;
import oracle.spatial.edit.model.AbstractDataSource;
import oracle.spatial.edit.model.EditChangeEvent;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.edit.model.XMLDataSource;
import oracle.spatial.edit.producer.AbstractDataSetProducer;
import oracle.spatial.edit.session.MDSEditSession;
import oracle.spatial.edit.ui.VersioningTablePanel;
import oracle.spatial.geometry.JGeometry;
import org.w3c.dom.Element;

public abstract class AbstractDataSetLayer
extends BasicLayer
implements EditableLayer,
SelectableLayer,
HoverableLayer,
WorkspaceLayer,
MVThemeLayer,
ChangeListener {
    private static final Logger log = LogFactory.getLogger((LogFactory.LoggerEnum)LogFactory.LoggerEnum.MAPEDITOR);
    public static final String PROPERTY_SERVERURL = "oracle.lbs.mapviewer.serverURL";
    public static final String PROPERTY_DATASOURCE = "oracle.lbs.mapviewer.dataSource";
    public static final String PROPERTY_EDITOR = "oracle.lbs.mapviewer.editor";
    public static final String PROPERTY_JSESSIONID = "oracle.lbs.mapviewer.jsessionID";
    public static final String PROPERTY_OWNER = "oracle.spatial.edit.layer.AbstractDataSetLayer.owner";
    public static final String PROPERTY_BASETABLE = "oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable";
    public static final String PROPERTY_KEYCOLUMN = "oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn";
    public static final String PROPERTY_SPATIALCOLUMN = "oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn";
    public static final String PROPERTY_QUERYCONDITION = "oracle.spatial.edit.layer.AbstractDataSetLayer.queryCondition";
    public static final String PROPERTY_KEYSEQUENCE = "oracle.spatial.edit.layer.AbstractDataSetLayer.keySequence";
    public static final String PROPERTY_RENDERSTYLE = "oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle";
    public static final String PROPERTY_RENDERSTYLE_NONLIVE = "oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyleNonLive";
    public static final String PROPERTY_LABELCOLUMN = "oracle.spatial.edit.layer.AbstractDataSetLayer.labelColumn";
    public static final String PROPERTY_LABELSTYLE = "oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle";
    public static final String PROPERTY_RENDER_MVNOTEDITING = "oracle.spatial.edit.layer.AbstractDataSetLayer.renderOnMapviewer";
    public static final String PROPERTY_LIVESCALE = "oracle.spatial.edit.layer.AbstractDataSetLayer.liveScale";
    public static final String PROPERTY_RENDER_ONZOOMOUT = "oracle.spatial.edit.layer.AbstractDataSetLayer.reRenderOnZoomOut";
    public static final String PROPERTY_RENDER_ONZOOMIN = "oracle.spatial.edit.layer.AbstractDataSetLayer.reRenderOnZoomIn";
    public static final String PROPERTY_OPTIMIZE_GEOMOP = "oracle.spatial.edit.layer.AbstractDataSetLayer.optimizeGeometryOperation";
    protected Color hoverColor = new Color(255, 255, 0, 200);
    protected Color hoverBorderColor = Color.darkGray;
    protected Stroke simpleStroke = new BasicStroke(1.0f);
    protected Stroke hoverStroke = new BasicStroke(2.0f);
    protected Color boundaryColor = Color.magenta;
    protected AnimatedStroke animatedStroke = null;
    protected AnimatedStroke nontargetAnimatedStroke = null;
    protected AnimatedStroke highliteAnimatedStroke = new AnimatedStroke(Color.red);
    private JGeometry[] highliteGeoms = null;
    protected AbstractDataSource dataSource = null;
    protected String[] nonComplexAttrs = null;
    protected Boolean versionEnabled = null;
    protected BufferedImage liveImg = null;
    protected AbstractDataSetProducer liveProducer = null;
    protected BufferedImage mvImg = null;
    protected MVImageProducer mvProducer = null;
    protected AffineTransform mvLastViewXFM = null;
    protected AffineTransform lastViewXFM = null;
    protected Rectangle2D lastDataWindow = null;
    protected DefaultSelectionManager selectionManager = new DefaultSelectionManager(this);
    protected DefaultSelectionManager hoverManager = new DefaultSelectionManager(this);
    protected AbstractIndexedDataSet indexedSet = null;
    protected Hashtable<String, AbstractFeature> myNewObjects = new Hashtable();
    protected Hashtable<String, AbstractFeature> myDeleteObjects = new Hashtable();
    protected EventListenerList listenerList = new EventListenerList();
    private boolean loadingProps = false;

    protected AbstractDataSetLayer(MapCanvas canvas) {
        super(canvas);
        this.highliteAnimatedStroke.setDash(new float[]{4.0f, 4.0f});
        this.highliteAnimatedStroke.setWidth(3.0f);
        this.properties.setDefaultProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(false));
        this.properties.setDefaultProperty(PROPERTY_LABELSTYLE, "text_Dialog_black_12_false_false");
        this.properties.setDefaultProperty(PROPERTY_LIVESCALE, Double.toString(Double.NaN));
        this.properties.setDefaultProperty(PROPERTY_RENDER_MVNOTEDITING, Boolean.toString(true));
        this.properties.setDefaultProperty(PROPERTY_RENDERSTYLE_NONLIVE, "color_gray_black_155");
        this.properties.setDefaultProperty(PROPERTY_RENDER_ONZOOMOUT, Boolean.toString(true));
        this.properties.setDefaultProperty(PROPERTY_RENDER_ONZOOMIN, Boolean.toString(true));
        this.properties.setDefaultProperty(PROPERTY_OPTIMIZE_GEOMOP, Boolean.toString(true));
        StyleModel stymodel = StyleModelUtils.getDefaultRenderStyle();
        this.properties.setDefaultProperty(PROPERTY_RENDERSTYLE, stymodel.getName());
        this.addEditChangeListener(new EditChangeListener(){

            @Override
            public void editStateChanged(ChangeEvent evt) {
                AbstractDataSetLayer.this.mapRegionChanged(null);
            }
        });
        this.addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent evt) {
                AbstractDataSetLayer.this.mapRegionChanged(null);
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){
            private boolean supressEvent = false;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (AbstractDataSetLayer.this.loadingProps) {
                    return;
                }
                String propName = evt.getPropertyName();
                if (propName.equals(AbstractDataSetLayer.PROPERTY_RENDERSTYLE) || propName.equals(AbstractDataSetLayer.PROPERTY_LABELCOLUMN) || propName.equals(AbstractDataSetLayer.PROPERTY_LABELSTYLE)) {
                    AbstractDataSetLayer.this.mapRegionChanged(null);
                }
                String newValue = null;
                if (evt.getNewValue() != null) {
                    newValue = evt.getNewValue().toString();
                }
                if (!this.supressEvent && (propName.equals("oracle.maps.core.EditableLayer.editable") || propName.equals(AbstractDataSetLayer.PROPERTY_KEYCOLUMN))) {
                    if (AbstractDataSetLayer.this.isEditable()) {
                        this.supressEvent = true;
                        try {
                            AbstractDataSetLayer.this.checkEditReady();
                        }
                        catch (Exception ex) {
                            AbstractDataSetLayer.this.setEditable(false);
                            JOptionPane.showMessageDialog(AbstractDataSetLayer.this.getCanvas().getFrameForDialog(), ex.getMessage(), MessagesBundle.getMessage("Warning"), 1);
                        }
                        this.supressEvent = false;
                    }
                    AbstractDataSetLayer.this.mapRegionChanged(null);
                }
                if (propName.equals("oracle.maps.core.Layer.visible") && Boolean.parseBoolean(newValue)) {
                    AbstractDataSetLayer.this.mapRegionChanged(null);
                }
                if (propName.equals(AbstractDataSetLayer.PROPERTY_DATASOURCE) || propName.equals(AbstractDataSetLayer.PROPERTY_EDITOR) || propName.equals(AbstractDataSetLayer.PROPERTY_SERVERURL)) {
                    AbstractDataSetLayer.this.updateDataSource();
                }
                if (propName.equals(AbstractDataSetLayer.PROPERTY_BASETABLE) || propName.equals(AbstractDataSetLayer.PROPERTY_KEYCOLUMN) || propName.equals(AbstractDataSetLayer.PROPERTY_SPATIALCOLUMN) || propName.equals(AbstractDataSetLayer.PROPERTY_QUERYCONDITION) || propName.equals(AbstractDataSetLayer.PROPERTY_KEYSEQUENCE)) {
                    AbstractDataSetLayer.this.updateDataSetSpatialInfo();
                }
            }
        });
        this.animatedStroke = new AnimatedStroke(Color.magenta);
        this.animatedStroke.setDash(new float[]{4.0f, 4.0f});
        this.animatedStroke.setWidth(2.0f);
        this.nontargetAnimatedStroke = new AnimatedStroke(Color.yellow);
        this.nontargetAnimatedStroke.setDash(new float[]{4.0f, 4.0f});
        this.nontargetAnimatedStroke.setWidth(2.0f);
    }

    protected boolean updateDataSetSpatialInfo() {
        boolean status = true;
        String baseTable = this.getProperty(PROPERTY_BASETABLE);
        String keyColumn = this.getProperty(PROPERTY_KEYCOLUMN);
        String spatialColumn = this.getProperty(PROPERTY_SPATIALCOLUMN);
        String queryCondition = this.getProperty(PROPERTY_QUERYCONDITION);
        String keySequence = this.getProperty(PROPERTY_KEYSEQUENCE);
        String workspace = "LIVE";
        try {
            workspace = this.getWorkspace().getName();
        }
        catch (Exception ex) {
            log.warning("Unable to get workspace name for layer [" + this.getName() + "].");
            status = false;
        }
        AbstractDataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            dataSet.setSpatialInfo(baseTable, keyColumn, spatialColumn);
            dataSet.addToNonNullAttributes(keyColumn);
            dataSet.setQueryCondition(queryCondition);
            dataSet.setSequenceName(keySequence);
            dataSet.setWorkspace(workspace);
        }
        return status;
    }

    protected void updateDataSource() {
        String serverURL = this.getProperty(PROPERTY_SERVERURL);
        String dataSourceName = this.getProperty(PROPERTY_DATASOURCE);
        String editor = this.getProperty(PROPERTY_EDITOR);
        String jsessionID = this.getProperty(PROPERTY_JSESSIONID);
        Properties props = new Properties();
        props.setProperty("serverURL", serverURL);
        props.setProperty("dataSource", dataSourceName);
        props.setProperty("editor", editor);
        if (jsessionID != null && !jsessionID.trim().isEmpty()) {
            props.setProperty("jsessionID", jsessionID);
        }
        this.dataSource = new XMLDataSource(dataSourceName);
        this.dataSource.init(props);
        this.mvProducer = new MVImageProducer(this, serverURL + "/omserver", dataSourceName);
        this.mvProducer.addMVThemeLayer(this);
    }

    protected String getModelString() {
        return "geometry";
    }

    protected void checkEditReady() throws Exception {
        MDSEditSession ed;
        if (this.editSession instanceof MDSEditSession && (ed = (MDSEditSession)this.editSession).isVersioned()) {
            ArrayList<AbstractDataSetLayer> layers = new ArrayList<AbstractDataSetLayer>();
            layers.add(this);
            String[] tableModel = new String[]{this.getModelString()};
            VersioningTablePanel vpanel = new VersioningTablePanel(this.canvas.getFrameForDialog(), layers, tableModel);
            if (!vpanel.isReadyForEditing()) {
                OlafDialog vpDlg = new OlafDialog(this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Check_parameters_for_versioning"), vpanel);
                vpDlg.setVisible(true);
                vpDlg.dispose();
                if (!vpDlg.isCancelled()) {
                    if (!vpanel.isReadyForEditing()) {
                        throw new Exception(MessagesBundle.getMessage("Layer_not_prepared_for_editing"));
                    }
                } else {
                    throw new Exception(MessagesBundle.getMessage("Layer_not_prepared_for_editing"));
                }
            }
        }
        if ((this.getProperty(PROPERTY_KEYCOLUMN) == null || this.getProperty(PROPERTY_KEYCOLUMN).equalsIgnoreCase("ROWID")) && (this.getWorkspace() == null || this.getWorkspace().getName().equalsIgnoreCase("LIVE"))) {
            throw new Exception(MessagesBundle.getFormattedMessage("Invalid_key_column", this.getName()));
        }
    }

    @Override
    public void fromXMLElement(Element element) {
        String backupJSessionID = this.getProperty(PROPERTY_JSESSIONID);
        this.loadingProps = true;
        super.fromXMLElement(element);
        if (backupJSessionID != null && !backupJSessionID.trim().isEmpty()) {
            this.setProperty(PROPERTY_JSESSIONID, backupJSessionID);
        } else {
            this.setProperty(PROPERTY_JSESSIONID, null);
        }
        this.setProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(false));
        this.loadingProps = false;
        this.updateDataSource();
        String propKeyCol = this.getProperty(PROPERTY_KEYCOLUMN);
        if (propKeyCol == null) {
            this.getTableKeyColumn();
        }
    }

    @Override
    public void setCanvas(MapCanvas canvas) {
        super.setCanvas(canvas);
        if (canvas != null) {
            canvas.getLayerManager().addChangeListener(this);
            if (this.isVisible() && canvas.getMapRegion().getDataWindow() != null) {
                this.mapRegionChanged(null);
            }
        }
    }

    public void getTableKeyColumn() {
        String column = null;
        AbstractDataAccessObject dataAccess = null;
        try {
            dataAccess = this.dataSource.getDataAccessObject();
            dataAccess.openConnection();
            column = dataAccess.getTablePrimaryKey(this.getProperty(PROPERTY_BASETABLE));
            if (column == null) {
                column = "ROWID";
            }
            this.setProperty(PROPERTY_KEYCOLUMN, column);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (MDSException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void update(long elapsedTime) {
        this.animatedStroke.update(elapsedTime);
        this.nontargetAnimatedStroke.update(elapsedTime);
    }

    @Override
    public WorkSpace getWorkspace() throws Exception {
        String workspace = "LIVE";
        if (this.isVersionEnabled() && this.editSession instanceof MDSEditSession && ((MDSEditSession)this.editSession).isVersioned()) {
            workspace = this.getVersionedWorkspace();
        }
        return new WorkSpace(workspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDisableVersioning() {
        AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
        Object exception = null;
        try {
            dataAccess.openConnection();
            String[] modifiedWorkspaces = dataAccess.getModifiedWorkspacesForTable(this.getProperty(PROPERTY_BASETABLE));
            if (modifiedWorkspaces != null && modifiedWorkspaces.length > 0) {
                for (String workspace : modifiedWorkspaces) {
                    if (workspace.equalsIgnoreCase("LIVE") || workspace.equalsIgnoreCase(this.getWorkspace().getName())) continue;
                    boolean bl = false;
                    return bl;
                }
            }
        }
        catch (MDSException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (dataAccess != null) {
                try {
                    dataAccess.closeConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    @Override
    public boolean isVersionEnabled() throws Exception {
        if (this.versionEnabled == null && this.dataSource != null) {
            AbstractDataAccessObject dataAccess = null;
            try {
                String workspace = this.getVersionedWorkspace();
                dataAccess = this.dataSource.getDataAccessObject();
                dataAccess.openConnection();
                this.versionEnabled = dataAccess.isTableVersioned(this.getProperty(PROPERTY_BASETABLE), workspace);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
            catch (MDSException ex) {
                ex.printStackTrace();
                throw new Exception(ex.getMessage());
            }
            finally {
                if (dataAccess != null) {
                    try {
                        dataAccess.closeConnection();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        if (this.versionEnabled == null) {
            return false;
        }
        return this.versionEnabled;
    }

    private String getVersionedWorkspace() {
        String workspace = null;
        if (this.editSession != null) {
            workspace = (this.getProperty(PROPERTY_EDITOR) + "_" + this.editSession.getName() + "_" + this.getProperty(PROPERTY_DATASOURCE)).toUpperCase();
        }
        return workspace;
    }

    @Override
    public boolean enableVersioning() throws Exception {
        AbstractDataAccessObject dataAccess = null;
        try {
            dataAccess = this.dataSource.getDataAccessObject();
            dataAccess.openConnection();
            String workspace = this.getVersionedWorkspace();
            this.versionEnabled = dataAccess.enableVersioning(this.getProperty(PROPERTY_BASETABLE), workspace, false, null, null);
        }
        catch (MDSException ex) {
            throw new Exception(ex);
        }
        finally {
            if (dataAccess != null) {
                dataAccess.closeConnection();
            }
        }
        if (this.isVersionEnabled()) {
            this.updateDataSetSpatialInfo();
            if (this.liveProducer instanceof SDODataProducer) {
                ((SDODataProducer)((Object)this.liveProducer)).setTargetWorkspace(this.getWorkspace());
            }
        }
        return this.isVersionEnabled();
    }

    @Override
    public boolean disableVersioning() throws Exception {
        throw new Exception();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vector<FeatureConflictDescriptor> getConflicts() throws Exception {
        Vector<FeatureConflictDescriptor> conflicts;
        block16: {
            conflicts = null;
            Exception exception = null;
            AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
            try {
                dataAccess.openConnection();
                conflicts = dataAccess.getTableWorkspaceConflicts(this.getWorkspace().getName(), this.getProperty(PROPERTY_BASETABLE), this.getProperty(PROPERTY_KEYCOLUMN));
            }
            catch (MDSException ex) {
                exception = new Exception(ex);
                return exception;
            }
            catch (Exception ex) {
                exception = ex;
                return exception;
            }
            finally {
                if (dataAccess != null) {
                    try {
                        dataAccess.closeConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (exception == null) break block16;
                throw exception;
            }
        }
        return conflicts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resolveConflicts(Vector<FeatureConflictDescriptor> conflicts) throws Exception {
        int solved;
        block16: {
            solved = 0;
            Exception exception = null;
            AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
            try {
                dataAccess.openConnection();
                solved = dataAccess.resolveTableWorkspaceConflicts(this.getWorkspace().getName(), this.getProperty(PROPERTY_BASETABLE), this.getProperty(PROPERTY_KEYCOLUMN), conflicts);
            }
            catch (MDSException ex) {
                exception = new Exception(ex);
                return (boolean)exception;
            }
            catch (Exception ex) {
                exception = ex;
                return (boolean)exception;
            }
            finally {
                if (dataAccess != null) {
                    try {
                        dataAccess.closeConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (exception == null) break block16;
                throw exception;
            }
        }
        return solved > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mergeWorkspace() throws Exception {
        boolean success;
        block16: {
            success = false;
            Exception exception = null;
            AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
            try {
                dataAccess.openConnection();
                success = dataAccess.mergeTableWorkspaces(this.getWorkspace().getName(), this.getProperty(PROPERTY_BASETABLE));
            }
            catch (MDSException ex) {
                exception = new Exception(ex);
                return (boolean)exception;
            }
            catch (Exception ex) {
                exception = ex;
                return (boolean)exception;
            }
            finally {
                if (dataAccess != null) {
                    try {
                        dataAccess.closeConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (exception == null) break block16;
                throw exception;
            }
        }
        return success;
    }

    public boolean getRenderOnZoomOut() {
        return Boolean.parseBoolean(this.getProperty(PROPERTY_RENDER_ONZOOMOUT));
    }

    public void setRenderOnZoomOut(boolean render) {
        this.setProperty(PROPERTY_RENDER_ONZOOMOUT, Boolean.toString(render));
    }

    public boolean getRenderOnZoomIn() {
        return Boolean.parseBoolean(this.getProperty(PROPERTY_RENDER_ONZOOMIN));
    }

    public void setRenderOnZoomIn(boolean render) {
        this.setProperty(PROPERTY_RENDER_ONZOOMIN, Boolean.toString(render));
    }

    public AbstractIndexedDataSet getIndexedDataSet() {
        return this.indexedSet;
    }

    public void setIndexedDataSet(AbstractIndexedDataSet indexedSet) {
        this.indexedSet = indexedSet;
        if (indexedSet != null) {
            indexedSet.setDataSetLayer(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getNonComplexAttributes() {
        if (this.nonComplexAttrs == null) {
            AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
            try {
                dataAccess.openConnection();
                this.nonComplexAttrs = dataAccess.getNonComplexAttributes(this.getProperty(PROPERTY_BASETABLE));
            }
            catch (MDSException ex) {
                System.out.println(MessagesBundle.getMessage("Exception") + ": " + ex.getMessage());
                ex.printStackTrace();
            }
            catch (Exception ex) {
                System.out.println(MessagesBundle.getMessage("Exception") + ": " + ex.getMessage());
                ex.printStackTrace();
            }
            finally {
                if (dataAccess != null) {
                    try {
                        dataAccess.closeConnection();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.nonComplexAttrs;
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        if (evt instanceof MouseEvent && ((MouseEvent)evt).getID() == 505) {
            this.clearHover();
        }
        return true;
    }

    public AbstractDataSet getDataSet() {
        AbstractIndexedDataSet is = this.getIndexedDataSet();
        if (is != null) {
            return is.getDataSet();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rectangle2D getFullExtent() {
        String owner = this.getProperty(PROPERTY_OWNER);
        String baseTable = this.getProperty(PROPERTY_BASETABLE);
        String spatialColumn = this.getProperty(PROPERTY_SPATIALCOLUMN);
        if (baseTable == null || spatialColumn == null) {
            return null;
        }
        AbstractDataAccessObject dao = null;
        try {
            Rectangle2D.Double extent;
            dao = this.dataSource.getDataAccessObject();
            dao.openConnection();
            SpatialColumnExtent sce = dao.getSpatialColumnExtent(owner, baseTable, spatialColumn, "geometry");
            double xmin = sce.getExtent()[0];
            double ymin = sce.getExtent()[1];
            double xmax = sce.getExtent()[2];
            double ymax = sce.getExtent()[3];
            Rectangle2D.Double double_ = extent = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
            return double_;
        }
        catch (MDSException ex) {
            ErrorDialog.showErrorDialog(ex, this.canvas.getFrameForDialog(), MessagesBundle.getFormattedMessage("Unable_toget_spatial_extent", spatialColumn, baseTable), MessagesBundle.getMessage("Error"), 2);
            Rectangle2D rectangle2D = null;
            return rectangle2D;
        }
        catch (Exception e) {
            Rectangle2D rectangle2D = null;
            return rectangle2D;
        }
        finally {
            try {
                dao.closeConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setEditable(boolean editable) {
        this.setProperty("oracle.maps.core.EditableLayer.editable", Boolean.toString(editable));
    }

    @Override
    public boolean isEditable() {
        return Boolean.parseBoolean(this.getProperty("oracle.maps.core.EditableLayer.editable"));
    }

    @Override
    public boolean isModified() {
        AbstractDataSet set = this.getDataSet();
        if (set == null) {
            return false;
        }
        return set.isModified();
    }

    @Override
    public boolean save() {
        boolean success = false;
        Throwable exception = null;
        try {
            success = this.getDataSet().save(this.dataSource.getDataAccessObject());
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        if (!success || exception != null) {
            ErrorDialog.showErrorDialog(exception, this.canvas.getFrameForDialog(), MessagesBundle.getFormattedMessage("Unable_tosave_data_set", this.getName()), MessagesBundle.getMessage("Error"), 2);
        }
        return success;
    }

    @Override
    public void clearChanges() {
        this.getDataSet().clearChanges();
    }

    protected UndoableEdit startChangeBlock(String changeName, Icon changeIcon) {
        this.getDataSet().setHoldLayerUpdate(true);
        return this.canvas.getUndoManager().startChangeBlock(changeName);
    }

    protected UndoableEdit endChangeBlock(String changeName, Icon changeIcon) {
        this.getDataSet().setHoldLayerUpdate(false);
        this.setToUpdate();
        return this.canvas.getUndoManager().endChangeBlock(changeName);
    }

    @Override
    public GeoObject[] getObjects() {
        return this.getDataSet().getFeatures().toArray(new GeoObject[this.getDataSet().getFeatures().size()]);
    }

    @Override
    public GeoObject getObject(Object key) {
        return this.getDataSet().getFeature(key.toString());
    }

    @Override
    public GeoObject newObject(Object spatialObject, Object[] params) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public boolean appendToObject(Object key, Object spatialObject) throws Exception {
        throw new UnsupportedOperationException("Not supported");
    }

    private int size() {
        int s = 0;
        if (this.getDataSet() != null) {
            s = this.getDataSet().size();
        }
        return s;
    }

    @Override
    public List<GeoObject> hitTest(int x, int y, int granularity) {
        Vector<GeoObject> result = new Vector<GeoObject>();
        if (this.size() == 0 && this.myNewObjects.size() == 0) {
            return result;
        }
        AffineTransform xfm = this.canvas.getMapRegion().getViewportTransform();
        try {
            xfm = xfm.createInverse();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return result;
        }
        double searchTolerance = 3.0;
        Point2D.Double ptC = new Point2D.Double(0.0, 0.0);
        xfm.transform(new Point2D.Double(x, y), ptC);
        Point2D.Double ptUL = new Point2D.Double(0.0, 0.0);
        xfm.transform(new Point2D.Double((double)x - searchTolerance, (double)y - searchTolerance), ptUL);
        double tolerance = Math.max(((Point2D)ptC).getX() - ((Point2D)ptUL).getX(), ((Point2D)ptUL).getY() - ((Point2D)ptC).getY());
        AbstractFeature afeat = this.indexedSet.identify(ptC, tolerance, granularity);
        if (afeat != null) {
            AbstractFeature clone = afeat;
            result.add(clone);
        }
        return result;
    }

    @Override
    public List<GeoObject> hitTest(Rectangle2D box, int granularity) {
        Vector<GeoObject> result = new Vector<GeoObject>();
        if (this.myNewObjects.size() != 0 || this.size() != 0) {
            try {
                AffineTransform xfm = this.canvas.getMapRegion().getViewportTransform().createInverse();
                Rectangle2D searchMBR = xfm.createTransformedShape(box).getBounds2D();
                List<GeoObject> feats = this.indexedSet.getFeatures(searchMBR);
                for (GeoObject feat : feats) {
                    AbstractFeature clone = (AbstractFeature)feat;
                    result.add(clone);
                }
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public void setGeoDataProducer(AbstractDataSetProducer geoProducer) {
        this.liveProducer = geoProducer;
        if (geoProducer != null) {
            geoProducer.setLayer(this);
        }
    }

    public GeoDataProducer getGeoDataProducer() {
        return this.liveProducer;
    }

    public void onDataException(DataProducer producer, Throwable exception) {
        if (exception == null) {
            return;
        }
        log.severe(exception.getMessage());
        exception.printStackTrace();
    }

    @Override
    public GeoObject updateObject(Object key, GeoObject changedObject) {
        return null;
    }

    public boolean updateObjectAttributes(String key, Field[] updAttrs) throws Exception {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null) {
            return false;
        }
        boolean status = this.indexedSet.getDataSet().updateFeatureAttributes(key, updAttrs);
        return status;
    }

    public int updateObjectSpatialAttribute(String key, Object spatialChange) {
        return this.updateObjectsSpatialAttribute(new String[]{key}, new Object[]{spatialChange});
    }

    public int updateObjectsSpatialAttribute(String[] keys, Object[] spatialChanges) {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null) {
            return 0;
        }
        if (keys == null || spatialChanges == null || keys.length != spatialChanges.length) {
            return 0;
        }
        int updated = 0;
        String changeName = MessagesBundle.getMessage("Change_update_spatial_several");
        Icon changeIcon = null;
        if (keys.length > 1) {
            this.startChangeBlock(changeName, changeIcon);
        }
        for (int i = 0; i < keys.length; ++i) {
            AbstractFeature feat = this.indexedSet.getDataSet().getFeature(keys[i]);
            try {
                this.indexedSet.updateSpatialAttribute(keys[i], spatialChanges[i]);
                ++updated;
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (keys.length > 1) {
            this.endChangeBlock(changeName, changeIcon);
        }
        return updated;
    }

    @Override
    public GeoObject deleteObject(Object key) {
        return null;
    }

    public int deleteObjects(String[] keys) {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null || keys == null || keys.length == 0) {
            return 0;
        }
        int deleted = 0;
        String changeName = MessagesBundle.getMessage("Change_delete_features");
        Icon changeIcon = null;
        if (keys.length > 1) {
            this.startChangeBlock(changeName, changeIcon);
        }
        for (int i = 0; i < keys.length; ++i) {
            AbstractFeature feat = this.indexedSet.getDataSet().getFeature(keys[i]);
            try {
                this.myDeleteObjects.put(keys[i], feat);
                this.indexedSet.removeFeature(feat);
                ++deleted;
                continue;
            }
            catch (Exception ex) {
                this.myDeleteObjects.remove(keys[i]);
                ex.printStackTrace();
            }
        }
        if (keys.length > 1) {
            this.endChangeBlock(changeName, changeIcon);
        }
        return deleted;
    }

    @Override
    public boolean insertObject(Object key, GeoObject obj) throws Exception {
        if (key == null) {
            throw new Exception("key is null");
        }
        if (!(obj instanceof AbstractFeature)) {
            throw new Exception("AbstractFeature type expected");
        }
        try {
            this.myNewObjects.put(key.toString(), (AbstractFeature)obj);
            this.indexedSet.addFeature((AbstractFeature)obj);
        }
        catch (Exception ex) {
            this.myNewObjects.remove(key.toString());
            throw ex;
        }
        return true;
    }

    public void undo(EditChangeEvent change) throws Exception {
        this.indexedSet.undo(change);
        String keyColumn = this.indexedSet.getDataSet().getKeyColumn();
        if (change.getEventType() == EditChangeEvent.NEW_EVENT) {
            AbstractFeature feat = (AbstractFeature)change.getCurrentObject();
            String key = feat.getAttribute(keyColumn).getValue().toString();
            this.myNewObjects.remove(key);
            Vector<GeoObject> v = new Vector<GeoObject>(1);
            v.add(feat);
            this.unselect(v);
        } else if (change.getEventType() == EditChangeEvent.REMOVE_EVENT) {
            AbstractFeature feat = (AbstractFeature)change.getOldObject();
            String key = feat.getAttribute(keyColumn).getValue().toString();
            this.myDeleteObjects.remove(key);
        }
        this.fireStateChanged();
    }

    public void redo(EditChangeEvent change) throws Exception {
        this.indexedSet.redo(change);
        String keyColumn = this.indexedSet.getDataSet().getKeyColumn();
        if (change.getEventType() == EditChangeEvent.NEW_EVENT) {
            AbstractFeature feat = (AbstractFeature)change.getCurrentObject();
            String key = feat.getAttribute(keyColumn).getValue().toString();
            this.myNewObjects.put(key, feat);
        } else if (change.getEventType() == EditChangeEvent.REMOVE_EVENT) {
            AbstractFeature feat = (AbstractFeature)change.getOldObject();
            String key = feat.getAttribute(keyColumn).getValue().toString();
            this.myDeleteObjects.put(key, feat);
        }
        this.fireStateChanged();
    }

    private boolean useMVRendering() {
        boolean useMV = false;
        try {
            String ls = this.getProperty(PROPERTY_LIVESCALE);
            String rmv = this.getProperty(PROPERTY_RENDER_MVNOTEDITING);
            if (ls != null && rmv != null) {
                useMV = !this.canvas.getLayerManager().getTags(this).contains("selectionLayer") && (this.canvas.getMapRegion().getDataWindow().getHeight() >= Double.parseDouble(ls) || !this.isEditable() && Boolean.parseBoolean(rmv));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return useMV;
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
        if (!this.isVisible()) {
            return;
        }
        if (this.canvas == null || !this.canvas.isVisible() || this.canvas.getWidth() == 0 || this.canvas.getHeight() == 0) {
            return;
        }
        Rectangle2D dataWindow = this.canvas.getMapRegion().getDataWindow();
        if (dataWindow == null || dataWindow.isEmpty()) {
            return;
        }
        boolean useMV = this.useMVRendering();
        if (useMV && this.mvProducer != null) {
            this.mvProducer.abortLoad();
            this.mvProducer.loadData(dataWindow, this.getSRID());
        }
        Area affectedArea = new Area(dataWindow);
        boolean reuseImg = true;
        if (this.lastDataWindow != null) {
            affectedArea.subtract(new Area(this.lastDataWindow));
            if (affectedArea.isEmpty() && this.getRenderOnZoomIn() || dataWindow.contains(this.lastDataWindow) && this.getRenderOnZoomOut()) {
                affectedArea = new Area(dataWindow);
                reuseImg = false;
            }
        }
        this.lastDataWindow = dataWindow;
        Raster oldImgRaster = null;
        if (reuseImg && this.liveImg != null) {
            oldImgRaster = this.liveImg.getData();
        }
        if (this.liveImg == null || this.canvas.getWidth() != this.liveImg.getWidth() || this.canvas.getHeight() != this.liveImg.getHeight()) {
            this.liveImg = new BufferedImage(this.canvas.getWidth(), this.canvas.getHeight(), 2);
        }
        if (!useMV && this.liveProducer != null) {
            this.liveProducer.loadData(dataWindow, this.getSRID());
        }
        Graphics2D g = this.liveImg.createGraphics();
        g.setBackground(new Color(0, 0, 0, 0));
        g.clearRect(0, 0, this.liveImg.getWidth(), this.liveImg.getHeight());
        AffineTransform vpTFM = this.canvas.getViewportTransform();
        if (reuseImg && oldImgRaster != null) {
            AffineTransform diff = null;
            if (this.lastViewXFM != null && !vpTFM.equals(this.lastViewXFM)) {
                try {
                    diff = new AffineTransform(this.lastViewXFM.createInverse());
                    diff.preConcatenate(vpTFM);
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
            }
            if (diff == null) {
                int x = (this.canvas.getWidth() - oldImgRaster.getWidth()) / 2;
                int y = (this.canvas.getHeight() - oldImgRaster.getHeight()) / 2;
                diff = AffineTransform.getTranslateInstance(x, y);
            }
            AffineTransformOp atop = new AffineTransformOp(diff, 2);
            atop.filter(oldImgRaster, this.liveImg.getRaster());
        }
        this.lastViewXFM = new AffineTransform(vpTFM);
        new RenderThread(g, vpTFM, affectedArea).start();
    }

    public void onDataReady(DataProducer producer, List<AbstractFeature> data) {
        if (producer == this.mvProducer) {
            try {
                Image mvi = ((ImageObject)this.mvProducer.getData()[0]).getImage();
                this.mvImg = new BufferedImage(mvi.getWidth(null), mvi.getHeight(null), 2);
                this.mvImg.createGraphics().drawImage(mvi, 0, 0, null);
                this.mvLastViewXFM = new AffineTransform(this.canvas.getViewportTransform());
            }
            catch (Exception ex) {}
        } else if (producer == this.liveProducer) {
            Graphics2D g = this.liveImg.createGraphics();
            StyleModel styModel = StyleModelUtils.getStyleModel(this.getProperty(PROPERTY_RENDERSTYLE));
            Style style = StyleFactory.createStyleFromXML((String)styModel.toXMLString());
            for (AbstractFeature feat : data) {
                feat.setLayer(this);
                String key = feat.getKey().toString();
                if (this.getDataSet().isRemovedFeature(key) || this.getDataSet().getFeature(key) != null) continue;
                try {
                    this.getIndexedDataSet().appendFeature(feat);
                    this.renderFeature(g, feat, this.canvas.getViewportTransform(), style);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.myNewObjects.clear();
        }
    }

    protected abstract void renderFeature(Graphics2D var1, AbstractFeature var2, AffineTransform var3, Style var4);

    @Override
    public long render(Graphics2D g) {
        Integer i;
        Layer l;
        int y;
        AffineTransform diff;
        if (this.canvas == null) {
            return 0L;
        }
        long t1 = System.currentTimeMillis();
        AffineTransform xfm = this.canvas.getViewportTransform();
        boolean useMV = this.useMVRendering();
        if (this.mvImg != null && useMV) {
            diff = null;
            if (this.mvLastViewXFM != null && !xfm.equals(this.mvLastViewXFM)) {
                try {
                    diff = new AffineTransform(this.mvLastViewXFM.createInverse());
                    diff.preConcatenate(xfm);
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
            }
            if (diff == null) {
                int x = (this.canvas.getWidth() - this.mvImg.getWidth()) / 2;
                y = (this.canvas.getHeight() - this.mvImg.getHeight()) / 2;
                diff = AffineTransform.getTranslateInstance(x, y);
            }
            g.drawImage(this.mvImg, diff, null);
        }
        if (this.liveImg != null && !useMV) {
            diff = null;
            if (this.lastViewXFM != null && !xfm.equals(this.lastViewXFM)) {
                try {
                    diff = new AffineTransform(this.lastViewXFM.createInverse());
                    diff.preConcatenate(xfm);
                }
                catch (NoninvertibleTransformException ex) {
                    // empty catch block
                }
            }
            if (diff == null) {
                int x = (this.canvas.getWidth() - this.liveImg.getWidth()) / 2;
                y = (this.canvas.getHeight() - this.liveImg.getHeight()) / 2;
                diff = AffineTransform.getTranslateInstance(x, y);
            }
            g.drawImage(this.liveImg, diff, null);
        }
        if (this.numHovered() > 0) {
            GeoObject hoverShape;
            l = this.canvas.getLayerManager().getLayerByTag("featureSelectionConfigLayer");
            if (l != null && l.getProperties() instanceof PropertySupportObject) {
                try {
                    i = Integer.decode(l.getProperties().getProperty("oracle.maps.tools.configurable.FeatureSelectionConfigurable.mouseoverFeatureColor"));
                    this.hoverColor = new Color(i);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if ((hoverShape = this.getHover().get(0)).getLayer() == this && !this.isSelected(hoverShape)) {
                for (Drawable drawable = hoverShape.getDrawable(xfm); drawable != null; drawable = drawable.getNext()) {
                    Shape shp = drawable.getShape();
                    Point2D shppt = drawable.getPoint();
                    if (shp != null) {
                        this.renderHoverShape(hoverShape, shp, g, xfm);
                    } else if (shppt != null) {
                        this.renderHoverPoint(shppt, g);
                    }
                    this.labelFeature(g, xfm, (AbstractFeature)hoverShape);
                }
            }
        }
        if ((l = this.canvas.getLayerManager().getLayerByTag("featureSelectionConfigLayer")) != null && l.getProperties() instanceof PropertySupportObject) {
            try {
                i = Integer.decode(l.getProperties().getProperty("oracle.maps.tools.configurable.FeatureSelectionConfigurable.targetFeatureColor"));
                this.animatedStroke.setColor(new Color(i));
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                i = Integer.decode(l.getProperties().getProperty("oracle.maps.tools.configurable.FeatureSelectionConfigurable.nontargetFeatureColor"));
                this.nontargetAnimatedStroke.setColor(new Color(i));
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                i = Integer.decode(l.getProperties().getProperty("oracle.maps.tools.configurable.FeatureSelectionConfigurable.featureElementColor"));
                this.highliteAnimatedStroke.setColor(new Color(i));
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        boolean imTarget = this.canvas.getLayerManager().getTags(this).contains("targetLayer");
        List<GeoObject> selected = this.getSelection();
        for (GeoObject selectedObj : selected) {
            Drawable drawable;
            if (imTarget) {
                g.setColor(this.animatedStroke.getColor());
                g.setStroke(this.animatedStroke.getStroke());
            } else {
                g.setColor(this.nontargetAnimatedStroke.getColor());
                g.setStroke(this.nontargetAnimatedStroke.getStroke());
            }
            if ((drawable = selectedObj.getDrawable(xfm)) == null) continue;
            drawable.draw(g);
        }
        if (this.highliteGeoms != null && this.highliteGeoms.length > 0) {
            g.setColor(this.highliteAnimatedStroke.getColor());
            g.setStroke(this.highliteAnimatedStroke.getStroke());
            for (int hg = 0; hg < this.highliteGeoms.length; ++hg) {
                Drawable ghdraw = Drawable.createDrawable(this.highliteGeoms[hg], xfm);
                if (ghdraw == null) continue;
                ghdraw.draw(g);
            }
        }
        Shape loadingArea = null;
        if (!useMV && this.liveProducer != null && !this.liveProducer.getLoadingArea().isEmpty()) {
            loadingArea = xfm.createTransformedShape(this.liveProducer.getLoadingArea());
        }
        if (loadingArea != null) {
            Shape oldClip = g.getClip();
            Composite oldComp = g.getComposite();
            g.setComposite(AlphaComposite.getInstance(10, 0.35f));
            g.setColor(new Color(115, 115, 115));
            g.draw(loadingArea);
            g.setClip(loadingArea);
            for (int i2 = 0; i2 < this.canvas.getWidth(); i2 += 6) {
                int x = (int)((float)i2 + this.animatedStroke.getPhase());
                g.fillRect(x, 0, 3, this.canvas.getHeight());
            }
            g.setClip(oldClip);
            g.setComposite(oldComp);
        }
        long t2 = System.currentTimeMillis();
        return t2 - t1;
    }

    protected abstract void doRealRendering();

    protected void labelFeature(Graphics2D g, AffineTransform xfm, AbstractFeature feat) {
        Field label;
        String labelAttribute = this.getProperty(PROPERTY_LABELCOLUMN);
        String labelStyle = this.getProperty(PROPERTY_LABELSTYLE);
        if (labelAttribute != null && labelStyle != null && (label = feat.getAttribute(labelAttribute)) != null) {
            StyleModel txtmodel = StyleModelUtils.getStyleModel(labelStyle);
            StyleText style = (StyleText)StyleFactory.createStyleFromXML((String)txtmodel.toXMLString());
            Rectangle2D bnds = feat.getDrawable(xfm).getBounds2D();
            Point2D.Double location = new Point2D.Double(bnds.getCenterX(), bnds.getCenterY());
            if (bnds.getWidth() == 0.0 && bnds.getHeight() == 0.0) {
                ((Point2D)location).setLocation(((Point2D)location).getX() + 5.0, ((Point2D)location).getY() + 12.0);
            }
            try {
                if (location != null) {
                    style.apply(g, (float)((Point2D)location).getX(), (float)((Point2D)location).getY(), label.getValue().toString(), null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected abstract void renderHoverShape(GeoObject var1, Shape var2, Graphics2D var3, AffineTransform var4);

    protected void renderHoverPoint(Point2D pt, Graphics2D g) {
        Color oc = g.getColor();
        g.setColor(this.hoverColor);
        g.fillOval((int)(pt.getX() - 6.5), (int)(pt.getY() - 6.5), 13, 13);
        g.setColor(oc);
    }

    @Override
    public void addEditChangeListener(EditChangeListener l) {
        this.listenerList.add(EditChangeListener.class, l);
    }

    @Override
    public void removeEditChangeListener(EditChangeListener l) {
        this.listenerList.remove(EditChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent changeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((EditChangeListener)listeners[i + 1]).editStateChanged(changeEvent);
        }
    }

    public AbstractFeature[] getCurrentDeletedFeatures() {
        if (this.myDeleteObjects.size() == 0) {
            return null;
        }
        ArrayList<AbstractFeature> feats = new ArrayList<AbstractFeature>();
        Enumeration<AbstractFeature> enumer = this.myDeleteObjects.elements();
        while (enumer.hasMoreElements()) {
            AbstractFeature o = enumer.nextElement();
            feats.add(o);
        }
        return feats.toArray(new AbstractFeature[feats.size()]);
    }

    public void replaceFeatureGroup(String[] keys, AbstractFeature newFeature) throws Exception {
        if (this.indexedSet == null || this.indexedSet.getDataSet() == null || keys == null || keys.length == 0 || newFeature == null) {
            return;
        }
        int deleted = 0;
        int inserted = 0;
        String changeName = MessagesBundle.getMessage("Change_replace_features");
        Icon changeIcon = null;
        this.startChangeBlock(changeName, changeIcon);
        try {
            for (int i = 0; i < keys.length; ++i) {
                AbstractFeature feat = this.indexedSet.getDataSet().getFeature(keys[i]);
                if (feat == null || !this.indexedSet.removeFeature(feat)) continue;
                this.myDeleteObjects.put(keys[i], feat);
                ++deleted;
            }
            if (this.indexedSet.addFeature(newFeature)) {
                this.myNewObjects.put(newFeature.getKey().toString(), newFeature);
                ++inserted;
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.endChangeBlock(changeName, changeIcon);
        }
    }

    protected void checkTableKeyExists(String table, String attr, String value, String workspace) throws Exception {
        AbstractDataAccessObject da = this.dataSource.getDataAccessObject();
        try {
            da.openConnection();
            if (da.tableHasAttributeWithValue(table, attr, value, workspace)) {
                throw new Exception(MessagesBundle.getFormattedMessage("Key_value_already_exists", value, attr));
            }
        }
        catch (MDSException ex) {
            throw new Exception(MessagesBundle.getFormattedMessage("Unable_toverify_attribute_value", attr, value));
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception re) {
                re.printStackTrace();
            }
        }
    }

    public Field[] getFieldsForFeature(AbstractFeature feat, boolean forceShowPanel) {
        return this.getFieldsForFeature(feat, forceShowPanel, null);
    }

    public Field[] getFieldsForFeature(AbstractFeature feat, boolean forceShowPanel, JPanel customPanel) {
        AbstractDataSet dset = this.indexedSet.getDataSet();
        if (dset == null) {
            return null;
        }
        boolean isNewFeature = feat == null || feat.getKey() == null || dset.getFeature(feat.getKey().toString()) == null;
        Vector<String> requiredAttrNames = dset.getNonNullAttributes();
        int rowidIndex = -1;
        if (requiredAttrNames != null) {
            for (int i = 0; i < requiredAttrNames.size(); ++i) {
                if (!requiredAttrNames.get(i).equalsIgnoreCase("ROWID")) continue;
                rowidIndex = i;
                break;
            }
        }
        if (rowidIndex != -1) {
            requiredAttrNames.remove(rowidIndex);
        }
        int requiredAttrsGot = 0;
        Object[] attrNames = dset.getAttributeNames();
        Arrays.sort(attrNames);
        String keyCol = dset.getKeyColumn();
        AttributeValueTablePanel attrPanel = new AttributeValueTablePanel();
        AttributeValueTablePanel otherattrPanel = new AttributeValueTablePanel();
        Vector<Field> attrFields = new Vector<Field>();
        boolean showOtherTable = false;
        for (int i = 0; i < attrNames.length; ++i) {
            Field fo;
            Object attrName = attrNames[i];
            String attrVal = "";
            String javaType = dset.getAttributeJavaType((String)attrName);
            if (((String)attrName).equalsIgnoreCase(dset.getGeometryColumn()) || ((String)attrName).equalsIgnoreCase("ROWID") || javaType.equals("JGeometry") || javaType.equals("AnnotationText")) continue;
            if (feat != null && (fo = feat.getAttribute((String)attrName)) != null) {
                attrVal = fo.getValue().toString();
            }
            boolean editAttr = true;
            if (((String)attrName).equalsIgnoreCase(keyCol)) {
                if (!isNewFeature) {
                    editAttr = false;
                }
                if (attrVal == null || attrVal.isEmpty()) {
                    String keySequence = dset.getSequenceName();
                    String keySeqValue = null;
                    if (keySequence != null) {
                        keySeqValue = this.getNextKeyValueForDataset(keySequence);
                    }
                    if (keySeqValue != null) {
                        attrVal = keySeqValue;
                    }
                }
            }
            if (!attrVal.isEmpty()) {
                Field nf = Field.createField((String)attrVal, (String)javaType);
                nf.setName((String)attrName);
                attrFields.add(nf);
                if (requiredAttrNames.contains(attrName)) {
                    ++requiredAttrsGot;
                }
            }
            if (requiredAttrNames.contains(attrName)) {
                attrPanel.addRow((String)attrName, attrVal, editAttr);
                continue;
            }
            otherattrPanel.addRow((String)attrName, attrVal, true);
            showOtherTable = true;
        }
        if (attrNames.length == 0 || !forceShowPanel && requiredAttrsGot == requiredAttrNames.size()) {
            return attrFields.toArray(new Field[attrFields.size()]);
        }
        attrPanel.getTable().changeSelection(0, 1, false, false);
        if (showOtherTable) {
            otherattrPanel.getTable().changeSelection(0, 1, false, false);
        }
        JPanel nonNullAttrsPnl = new JPanel();
        nonNullAttrsPnl.setLayout(new GridBagLayout());
        JLabel msgLabel = new JLabel();
        msgLabel.setForeground(Color.red);
        JLabel nonnullattrLabel = new JLabel(MessagesBundle.getMessage("Non_null_attributes"));
        JLabel nullattrlabel = new JLabel(MessagesBundle.getMessage("Other_attributes"));
        int gridY = 0;
        Image icon = null;
        Object spatialAttr = null;
        if (feat != null && (spatialAttr = feat.getSpatialAttribute()) instanceof JGeometry && !((JGeometry)spatialAttr).isPoint()) {
            icon = AbstractDataSetLayer.generateGeometryIcon(new StyleColor(Color.RED, Color.RED), (JGeometry)spatialAttr);
        }
        if (icon != null) {
            JLabel jPanel1 = new JLabel(new ImageIcon(icon));
            JLabel sptrepLabel = new JLabel(MessagesBundle.getMessage("Spatial_representation"));
            nonNullAttrsPnl.add((Component)sptrepLabel, new GridBagConstraints(0, gridY++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            nonNullAttrsPnl.add((Component)jPanel1, new GridBagConstraints(0, gridY++, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        }
        if (customPanel != null) {
            nonNullAttrsPnl.add((Component)customPanel, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        nonNullAttrsPnl.add((Component)nonnullattrLabel, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        nonNullAttrsPnl.add((Component)attrPanel, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        nonNullAttrsPnl.add((Component)nullattrlabel, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        nonNullAttrsPnl.add((Component)otherattrPanel, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        nonNullAttrsPnl.add((Component)msgLabel, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        nonNullAttrsPnl.setPreferredSize(new Dimension(300, 440));
        OlafDialog nnDlg = new OlafDialog(this.canvas.getFrameForDialog(), MessagesBundle.getMessage("Feature_attributes"), nonNullAttrsPnl, 0.9f);
        nnDlg.setVisible(true);
        if (nnDlg.isCancelled()) {
            return null;
        }
        Field[] fields = null;
        Vector<Field> otherFields = new Vector<Field>();
        boolean success = false;
        boolean first = true;
        block8: while (!success) {
            String javaType;
            String value;
            String attr;
            int i;
            if (!first) {
                nnDlg.validate();
                nnDlg.setVisible(true);
                if (nnDlg.isCancelled()) {
                    return null;
                }
            } else {
                first = false;
            }
            attrPanel.forceTableEndEditing();
            otherattrPanel.forceTableEndEditing();
            success = false;
            fields = new Field[attrPanel.getTableModel().getRowCount()];
            otherFields.clear();
            int validFields = 0;
            for (i = 0; i < attrPanel.getTableModel().getRowCount(); ++i) {
                attr = attrPanel.getAttributeName(i);
                value = attrPanel.getAttributeValue(i);
                if (value == null || value.trim().length() == 0) {
                    msgLabel.setText(MessagesBundle.getFormattedMessage("Undefined_feature_attribute", attr));
                    continue block8;
                }
                javaType = dset.getAttributeJavaType(attr);
                if (javaType == null) {
                    msgLabel.setText(MessagesBundle.getFormattedMessage("Unable_toget_java_type", attr));
                    continue block8;
                }
                Field fo = null;
                try {
                    fo = AbstractDataSetLayer.getFieldObject(javaType, value);
                    if (fo == null) {
                        msgLabel.setText(MessagesBundle.getFormattedMessage("Unsupported_attribute_java_type", javaType, attr));
                        continue block8;
                    }
                    fo.setName(attr);
                }
                catch (Exception ex) {
                    msgLabel.setText(MessagesBundle.getFormattedMessage("Invalid_attribute_value", attr, javaType));
                    continue block8;
                }
                if (isNewFeature && keyCol != null && keyCol.equalsIgnoreCase(attr)) {
                    AbstractFeature afeat = dset.getFeature(value);
                    if (afeat != null && afeat != feat) {
                        msgLabel.setText(MessagesBundle.getFormattedMessage("Key_value_already_exists", value, attr));
                        continue block8;
                    }
                    try {
                        this.checkTableKeyExists(dset.getBaseTable(), attr, value, this.getWorkspace().getName());
                    }
                    catch (Exception ex) {
                        msgLabel.setText(ex.getMessage());
                        continue block8;
                    }
                }
                fields[i] = fo;
                ++validFields;
            }
            if (validFields == attrPanel.getTableModel().getRowCount()) {
                success = true;
            }
            if (otherattrPanel.getTableModel().getRowCount() <= 0) continue;
            for (i = 0; i < otherattrPanel.getTableModel().getRowCount(); ++i) {
                attr = otherattrPanel.getAttributeName(i);
                value = otherattrPanel.getAttributeValue(i);
                if (value == null || value.trim().length() == 0) continue;
                javaType = dset.getAttributeJavaType(attr);
                if (javaType == null) {
                    System.out.println(MessagesBundle.getFormattedMessage("Unable_toget_java_type", attr));
                    continue;
                }
                try {
                    Field f = AbstractDataSetLayer.getFieldObject(javaType, value);
                    if (f == null) {
                        System.out.println(MessagesBundle.getFormattedMessage("Unsupported_attribute_java_type", javaType, attr));
                        continue;
                    }
                    f.setName(attr);
                    otherFields.add(f);
                    continue;
                }
                catch (Exception ex) {
                    System.out.println(MessagesBundle.getFormattedMessage("Invalid_attribute_value", attr, javaType));
                }
            }
        }
        if (otherFields.size() > 0) {
            int i;
            if (fields == null) {
                return null;
            }
            Field[] outFields = new Field[fields.length + otherFields.size()];
            int count = 0;
            for (i = 0; i < fields.length; ++i) {
                outFields[count++] = fields[i];
            }
            for (i = 0; i < otherFields.size(); ++i) {
                outFields[count++] = (Field)otherFields.get(i);
            }
            return outFields;
        }
        return fields;
    }

    private static Field getFieldObject(String javaType, String value) {
        Field f = null;
        if (javaType == null || value == null) {
            return null;
        }
        if (javaType.equalsIgnoreCase("String")) {
            f = new Field(value);
        } else if (javaType.equalsIgnoreCase("Integer")) {
            f = new Field(Integer.parseInt(value));
        } else if (javaType.equalsIgnoreCase("Double")) {
            f = new Field(Double.parseDouble(value));
        } else if (javaType.equalsIgnoreCase("Float")) {
            f = new Field().setFloat(Float.parseFloat(value));
        } else if (javaType.equalsIgnoreCase("Long")) {
            f = new Field().setLong(Long.parseLong(value));
        } else if (javaType.equalsIgnoreCase("Short")) {
            f = new Field().setShort((int)Short.parseShort(value));
        } else if (javaType.equalsIgnoreCase("BigDecimal")) {
            f = new Field(Double.parseDouble(value));
        } else if (javaType.equalsIgnoreCase("Date")) {
            f = new Field().setDate(Date.valueOf(value).getTime());
        } else if (javaType.equalsIgnoreCase("Time")) {
            f = new Field().setDate(Time.valueOf(value).getTime());
        } else if (javaType.equalsIgnoreCase("Timestamp")) {
            f = new Field().setDate(Timestamp.valueOf(value).getTime());
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image generateGeometryIcon(StyleColor sty, JGeometry geom) {
        if (sty == null || geom == null) {
            return null;
        }
        int width = 64;
        int height = 64;
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2 = (Graphics2D)((Image)img).getGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, width, height);
        XFViewPort mXFViewPort = new XFViewPort();
        mXFViewPort.setDeviceView((Rectangle2D)new Rectangle2D.Double(2.0, 2.0, (double)width - 4.0, (double)height - 4.0));
        double[] mbr = geom.getMBR();
        double dx = mbr[2] - mbr[0];
        double dy = mbr[3] - mbr[1];
        mXFViewPort.setStrict(true);
        mXFViewPort.setDataView((Rectangle2D)new Rectangle2D.Double(mbr[0], mbr[1], dx, dy));
        AffineTransform mAT = mXFViewPort.getAffineTransform();
        Shape shp = geom.createShape(mAT, true);
        try {
            sty.apply(null, g2, shp, geom.getType(), null);
        }
        catch (Exception ex) {
            img.flush();
            img = null;
        }
        finally {
            g2.dispose();
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNextKeyValueForDataset(String sequence) {
        AbstractDataSet set = this.indexedSet.getDataSet();
        if (set == null || sequence == null) {
            return null;
        }
        String keySeqValue = null;
        AbstractDataAccessObject dataAccess = this.dataSource.getDataAccessObject();
        try {
            dataAccess.openConnection();
            String value = "" + dataAccess.getSequenceNextValue(sequence);
            keySeqValue = set.getFeature(value) != null || set.isRemovedFeature(value) || dataAccess.tableHasAttributeWithValue(set.getBaseTable(), set.getKeyColumn(), value, this.getWorkspace().getName()) ? null : value;
        }
        catch (MDSException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                dataAccess.closeConnection();
            }
            catch (Exception re) {
                re.printStackTrace();
            }
        }
        return keySeqValue;
    }

    public void setToUpdate() {
        this.mapRegionChanged(null);
    }

    public abstract int transformFeatures(GeoObject[] var1, AffineTransform var2) throws Exception;

    @Override
    public boolean isSelected(GeoObject obj) {
        return this.selectionManager.isSelected(obj);
    }

    @Override
    public boolean clearSelection() {
        boolean res = this.selectionManager.clear();
        return res;
    }

    @Override
    public int numSelected() {
        return this.selectionManager.size();
    }

    @Override
    public List<GeoObject> getSelection() {
        return this.selectionManager.getSelection();
    }

    @Override
    public List<GeoObject> getSelection(GeoObject obj) {
        return this.selectionManager.getSelection(obj);
    }

    @Override
    public boolean setSelection(List<GeoObject> objs) {
        boolean res = this.selectionManager.setSelection(objs);
        return res;
    }

    @Override
    public boolean select(List<GeoObject> objs) {
        boolean res = this.selectionManager.select(objs);
        return res;
    }

    @Override
    public boolean unselect(List<GeoObject> objs) {
        boolean res = this.selectionManager.unselect(objs);
        return res;
    }

    @Override
    public void addSelectionListener(SelectionListener l) {
        this.selectionManager.addSelectionListener(l);
    }

    @Override
    public void removeSelectionListener(SelectionListener l) {
        this.selectionManager.removeSelectionListener(l);
    }

    @Override
    public boolean setHover(List<GeoObject> objs) {
        return this.hoverManager.setSelection(objs);
    }

    @Override
    public boolean clearHover() {
        return this.hoverManager.clear();
    }

    @Override
    public List<GeoObject> getHover() {
        return this.hoverManager.getSelection();
    }

    @Override
    public boolean isHover(GeoObject obj) {
        return this.hoverManager.isSelected(obj);
    }

    @Override
    public int numHovered() {
        return this.hoverManager.size();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        LayerManagerEvent evt;
        Object src = e.getSource();
        if (src instanceof UndoManager) {
            this.setToUpdate();
        } else if (e instanceof LayerManagerEvent && ((evt = (LayerManagerEvent)e).getType() == 4 || evt.getType() == 3) && evt.getTags().contains("selectionLayer")) {
            this.mapRegionChanged(null);
        }
    }

    public AbstractDataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(AbstractDataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected void loadMetadata() {
        try {
            this.getDataSet().loadMetaData(this.dataSource.getDataAccessObject());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (MDSException ex) {
            ex.printStackTrace();
        }
    }

    public void setHighliteGeometries(JGeometry[] geoms) {
        this.highliteGeoms = geoms;
    }

    private class RenderThread
    extends Thread {
        private Graphics2D g = null;
        private AffineTransform tfm = null;
        private Area area = null;
        private int progress = 0;
        private int lastReportedProgress = -1;

        public RenderThread(Graphics2D g, AffineTransform tfm, Area area) {
            this.g = g;
            this.tfm = tfm;
            this.area = area;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set<GeoObject> features = null;
            AbstractDataSetLayer abstractDataSetLayer = AbstractDataSetLayer.this;
            synchronized (abstractDataSetLayer) {
                AbstractIndexedDataSet ids = AbstractDataSetLayer.this.getIndexedDataSet();
                if (ids != null) {
                    features = ids.getFeatures(this.area);
                }
            }
            if (features != null && features.size() > 0) {
                Shape tfmdAA = this.tfm.createTransformedShape(this.area);
                this.g.setColor(new Color(0, 0, 0, 0));
                this.g.fill(tfmdAA);
                Shape oldClip = this.g.getClip();
                this.g.setClip(tfmdAA);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MapCanvas mapCanvas = AbstractDataSetLayer.this.canvas;
                        AbstractDataSetLayer.this.canvas;
                        mapCanvas.propertyChange(new PropertyChangeEvent(RenderThread.this, "progressString", null, MessagesBundle.getMessage("Progressbar_renderfeatures")));
                    }
                });
                StyleModel styModel = StyleModelUtils.getStyleModel(AbstractDataSetLayer.this.getProperty(AbstractDataSetLayer.PROPERTY_RENDERSTYLE));
                Style style = StyleFactory.createStyleFromXML((String)styModel.toXMLString());
                int count = 0;
                for (GeoObject feat : features) {
                    if (Thread.interrupted()) break;
                    AbstractDataSetLayer.this.renderFeature(this.g, (AbstractFeature)feat, this.tfm, style);
                    this.progress = (int)(100.0 * (double)(++count) / (double)features.size());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (RenderThread.this.progress > RenderThread.this.lastReportedProgress) {
                                MapCanvas mapCanvas = AbstractDataSetLayer.this.canvas;
                                AbstractDataSetLayer.this.canvas;
                                mapCanvas.propertyChange(new PropertyChangeEvent(RenderThread.this, "progress", 0, RenderThread.this.progress));
                                RenderThread.this.lastReportedProgress = RenderThread.this.progress;
                            }
                        }
                    });
                }
                this.g.setClip(oldClip);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MapCanvas mapCanvas = AbstractDataSetLayer.this.canvas;
                        AbstractDataSetLayer.this.canvas;
                        mapCanvas.propertyChange(new PropertyChangeEvent(RenderThread.this, "state", null, (Object)SwingWorker.StateValue.DONE));
                    }
                });
            }
        }
    }
}

