/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui.actiongroup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.tools.PenTool;
import oracle.maps.tools.TopoChildFeaturePickTool;
import oracle.maps.tools.TopoPrimitivePickTool;
import oracle.mapviewer.share.Field;
import oracle.mapviewer.share.TopoChildFeatureDescriptor;
import oracle.mapviewer.share.TopologyMetadata;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.TopoFeaturePrimitivesPanel;
import oracle.mdeditor.ui.actiongroup.BasicToolsPane;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.edit.index.topology.IndexedTopologySet;
import oracle.spatial.edit.layer.TopologySetLayer;
import oracle.spatial.edit.model.topology.TopologyFeature;
import oracle.spatial.edit.model.topology.TopologyGeometry;
import oracle.spatial.edit.model.topology.TopologySet;

public class TopologyToolsPane
extends BasicToolsPane {
    private JToggleButton addnode = new JToggleButton(Icons.getIcon("addtoponode.png"));
    private JToggleButton addedge = new JToggleButton(Icons.getIcon("addtopoline.png"));
    private JToggleButton addface = new JToggleButton(Icons.getIcon("addtopoface.png"));
    private JToggleButton remnode = new JToggleButton(Icons.getIcon("remtoponode.png"));
    private JToggleButton remedge = new JToggleButton(Icons.getIcon("remtopoline.png"));
    private JToggleButton addprimitofeat = new JToggleButton(Icons.getIcon("connect_ena.png"));
    private JToggleButton remprimifromfeat = new JToggleButton(Icons.getIcon("disconnect_ena.png"));
    private JButton createfromlowlevfeat = new JButton(Icons.getIcon("addtopofeathier.png"));
    private JToggleButton addchildfeattohighfeat = new JToggleButton(Icons.getIcon("addtopochild.png"));
    private JToggleButton remchildfeatfromhighfeat = new JToggleButton(Icons.getIcon("remtopochild.png"));
    private JButton viewfeatprimi = new JButton(Icons.getIcon("viewtopoprim.png"));

    public TopologyToolsPane(MainAppPanel mainApp) {
        super(mainApp);
        this.buttons = new AbstractButton[]{this.addnode, this.addedge, this.addface, this.remnode, this.remedge, this.addprimitofeat, this.remprimifromfeat, this.createfromlowlevfeat, this.addchildfeattohighfeat, this.remchildfeatfromhighfeat, this.viewfeatprimi};
        this.setName(MessagesBundle.getMessage("Topology_tools"));
        this.addnode.setToolTipText(MessagesBundle.getMessage("Tooltip_topo_add_node_primitive"));
        this.addnode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    PenTool penTool = new PenTool(canvas);
                    penTool.setModifier("penpoint");
                    penTool.setMainApp(TopologyToolsPane.this.getMainApp());
                    TopologyToolsPane.this.getMainApp().setTool(penTool);
                }
            }
        });
        this.addedge.setToolTipText(MessagesBundle.getMessage("Tooltip_topo_add_edge_primitive"));
        this.addedge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    PenTool penTool = new PenTool(canvas);
                    penTool.setAsClosedPath(false);
                    penTool.setModifier("addlinkoredge");
                    penTool.setMainApp(TopologyToolsPane.this.getMainApp());
                    TopologyToolsPane.this.getMainApp().setTool(penTool);
                }
            }
        });
        this.addface.setToolTipText(MessagesBundle.getMessage("Tooltip_topo_add_face_primitive"));
        this.addface.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    PenTool penTool = new PenTool(canvas);
                    penTool.setAsClosedPath(true);
                    penTool.setModifier("addface");
                    penTool.setMainApp(TopologyToolsPane.this.getMainApp());
                    TopologyToolsPane.this.getMainApp().setTool(penTool);
                }
            }
        });
        this.remnode.setToolTipText(MessagesBundle.getMessage("Tooltip_topo_remove_node_primitive"));
        this.remnode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    TopoPrimitivePickTool topoTool = new TopoPrimitivePickTool(canvas);
                    topoTool.setModifier("removenode");
                    topoTool.setMainApp(TopologyToolsPane.this.getMainApp());
                    TopologyToolsPane.this.getMainApp().setTool(topoTool);
                }
            }
        });
        this.remedge.setToolTipText(MessagesBundle.getMessage("Tooltip_topo_remove_edge_primitive"));
        this.remedge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    TopoPrimitivePickTool topoTool = new TopoPrimitivePickTool(canvas);
                    topoTool.setModifier("removelinkoredge");
                    topoTool.setMainApp(TopologyToolsPane.this.getMainApp());
                    TopologyToolsPane.this.getMainApp().setTool(topoTool);
                }
            }
        });
        this.addprimitofeat.setToolTipText(MessagesBundle.getMessage("Tooltip_topo_add_primitive"));
        this.addprimitofeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    TopoPrimitivePickTool topoTool = new TopoPrimitivePickTool(canvas);
                    topoTool.setModifier("assignprimitive");
                    topoTool.setMainApp(TopologyToolsPane.this.getMainApp());
                    TopologyToolsPane.this.getMainApp().setTool(topoTool);
                }
            }
        });
        this.remprimifromfeat.setToolTipText(MessagesBundle.getMessage("Tooltip_topo_remove_primitive"));
        this.remprimifromfeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    TopoPrimitivePickTool topoTool = new TopoPrimitivePickTool(canvas);
                    topoTool.setModifier("removeprimitive");
                    topoTool.setMainApp(TopologyToolsPane.this.getMainApp());
                    TopologyToolsPane.this.getMainApp().setTool(topoTool);
                }
            }
        });
        this.createfromlowlevfeat.setToolTipText(MessagesBundle.getMessage("Tooltip_create_from_low_level_features"));
        this.createfromlowlevfeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                Layer targetLayer = canvas.getLayerManager().getLayerByTag("targetLayer");
                TopologySetLayer tl = (TopologySetLayer)targetLayer;
                TopologySetLayer childLayer = tl.getChildLayer();
                if (childLayer == null) {
                    return;
                }
                List<GeoObject> childSelected = childLayer.getSelection();
                if (childSelected == null || childSelected.size() < 1) {
                    return;
                }
                TopologyMetadata topoMeta = ((TopologySet)tl.getIndexedDataSet().getDataSet()).getMetadata();
                List<GeoObject> selected = tl.getSelection();
                boolean newFeature = true;
                if (selected != null && selected.size() == 1) {
                    newFeature = false;
                }
                Field[] fields = null;
                if (newFeature && ((fields = tl.getFieldsForFeature(null, false)) == null || fields.length == 0)) {
                    return;
                }
                String keyColumn = tl.getIndexedDataSet().getDataSet().getKeyColumn();
                if (newFeature) {
                    TopologyFeature tfeat = new TopologyFeature();
                    TopologyGeometry tpgeom = new TopologyGeometry();
                    tpgeom.setLayerId(topoMeta.getTopoLayerId());
                    tpgeom.setTopoType(topoMeta.getTopoLayerType());
                    tpgeom.setId(tl.getNextTemporaryTopoGeometryId());
                    for (int i = 0; i < childSelected.size(); ++i) {
                        TopologyFeature feat = (TopologyFeature)childSelected.get(i);
                        TopologyGeometry featgeom = feat.getSpatialAttribute();
                        if (featgeom == null) continue;
                        tpgeom.addChildFeature(featgeom.getLayerId(), featgeom.getId());
                    }
                    tfeat.setTopologyModel(tl.getIndexedTopologyModel().getTopologyModel());
                    tfeat.setSpatialAttribute(tpgeom);
                    tfeat.setAttributes(fields);
                    String fkey = tfeat.getAttribute(keyColumn).getValue().toString();
                    tfeat.setKey(fkey);
                    tfeat.setLayer(tl);
                    try {
                        tl.insertObject(fkey, tfeat);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(canvas.getFrameForDialog(), ex.getMessage(), "Warning", 2);
                    }
                } else {
                    TopologyFeature tfeat = (TopologyFeature)selected.get(0);
                    String fkey = tfeat.getAttribute(keyColumn).getValue().toString();
                    try {
                        ArrayList<TopoChildFeatureDescriptor> childs = new ArrayList<TopoChildFeatureDescriptor>();
                        for (int i = 0; i < childSelected.size(); ++i) {
                            TopologyFeature feat = (TopologyFeature)childSelected.get(i);
                            TopologyGeometry featgeom = feat.getSpatialAttribute();
                            if (featgeom == null) continue;
                            TopoChildFeatureDescriptor tcfd = new TopoChildFeatureDescriptor(featgeom.getLayerId(), featgeom.getId());
                            childs.add(tcfd);
                        }
                        tl.assignChildFeaturesToFeature(fkey, childs.toArray(new TopoChildFeatureDescriptor[childs.size()]));
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(canvas.getFrameForDialog(), ex.getMessage(), "Warning", 2);
                    }
                }
            }
        });
        this.addchildfeattohighfeat.setToolTipText(MessagesBundle.getMessage("Tooltip_topo_add_child_feature"));
        this.addchildfeattohighfeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    TopoChildFeaturePickTool topoTool = new TopoChildFeaturePickTool(canvas);
                    topoTool.setEditMode(TopoChildFeaturePickTool.ADD_EDIT_MODE);
                    topoTool.setModifier("assignchildfeature");
                    topoTool.setMainApp(TopologyToolsPane.this.getMainApp());
                    TopologyToolsPane.this.getMainApp().setTool(topoTool);
                }
            }
        });
        this.remchildfeatfromhighfeat.setToolTipText(MessagesBundle.getMessage("Tooltip_topo_remove_child_feature"));
        this.remchildfeatfromhighfeat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    TopoChildFeaturePickTool topoTool = new TopoChildFeaturePickTool(canvas);
                    topoTool.setEditMode(TopoChildFeaturePickTool.REMOVE_EDIT_MODE);
                    topoTool.setModifier("removechildfeature");
                    topoTool.setMainApp(TopologyToolsPane.this.getMainApp());
                    TopologyToolsPane.this.getMainApp().setTool(topoTool);
                }
            }
        });
        this.viewfeatprimi.setToolTipText(MessagesBundle.getMessage("Tooltip_view_feature_primitives"));
        this.viewfeatprimi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = TopologyToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                TopologySetLayer layer = (TopologySetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                if (layer == null) {
                    return;
                }
                List<GeoObject> objects = layer.getSelection();
                if (objects == null || objects.size() == 0) {
                    return;
                }
                TopologyFeature feat = (TopologyFeature)objects.get(0);
                TopoFeaturePrimitivesPanel ivp = new TopoFeaturePrimitivesPanel((IndexedTopologySet)layer.getIndexedDataSet(), feat, canvas);
                OlafDialog ivpDlg = new OlafDialog(canvas.getFrameForDialog(), MessagesBundle.getMessage("Topology_primitives"), ivp, 0.9f);
                ivpDlg.setSize(360, 340);
                ivpDlg.setAsCloseSelection(true);
                ivpDlg.setVisible(true);
                ivpDlg.dispose();
            }
        });
        ButtonGroup grp = mainApp.getButtonGroup("toolsBG");
        for (AbstractButton btn : this.buttons) {
            if (btn instanceof JToggleButton) {
                grp.add(btn);
            }
            this.add(btn);
        }
        this.updateUIStatus();
    }

    @Override
    public void updateButtonsStatus() {
        TopologySetLayer childLayer;
        MapCanvas canvas = this.getMapCanvas();
        if (canvas == null) {
            return;
        }
        LayerManager lm = canvas.getLayerManager();
        Layer targetLayer = lm.getLayerByTag("targetLayer");
        if (!(targetLayer instanceof TopologySetLayer)) {
            return;
        }
        List<GeoObject> targetSelected = null;
        List<GeoObject> nonTargetSelected = null;
        TopologySetLayer tplayer = (TopologySetLayer)targetLayer;
        TopologySet set = (TopologySet)tplayer.getIndexedDataSet().getDataSet();
        int layerLevel = 0;
        int childLayerId = 0;
        TopologyMetadata metadata = set.getMetadata();
        if (metadata != null) {
            layerLevel = metadata.getTopoLayerLevel();
            childLayerId = metadata.getChildLayerId();
        }
        if ((childLayer = tplayer.getChildLayer()) != null) {
            nonTargetSelected = childLayer.getSelection();
        }
        targetSelected = ((TopologySetLayer)targetLayer).getSelection();
        if (layerLevel == 0) {
            this.addprimitofeat.setEnabled(true);
            this.remprimifromfeat.setEnabled(true);
            if (targetSelected.size() < 1) {
                this.addnode.setEnabled(true);
                this.addedge.setEnabled(true);
                this.addface.setEnabled(true);
                this.remnode.setEnabled(true);
                this.remedge.setEnabled(true);
                this.remprimifromfeat.setEnabled(false);
                this.viewfeatprimi.setEnabled(false);
            } else {
                this.addnode.setEnabled(false);
                this.addedge.setEnabled(false);
                this.addface.setEnabled(false);
                this.remnode.setEnabled(false);
                this.remedge.setEnabled(false);
                if (targetSelected.size() > 1) {
                    this.addprimitofeat.setEnabled(false);
                    this.remprimifromfeat.setEnabled(false);
                    this.viewfeatprimi.setEnabled(false);
                } else {
                    this.viewfeatprimi.setEnabled(true);
                }
            }
            this.createfromlowlevfeat.setEnabled(false);
            this.addchildfeattohighfeat.setEnabled(false);
            this.remchildfeatfromhighfeat.setEnabled(false);
        } else if (targetSelected.size() <= 1) {
            this.addprimitofeat.setEnabled(false);
            this.remprimifromfeat.setEnabled(false);
            this.addnode.setEnabled(false);
            this.addedge.setEnabled(false);
            this.addface.setEnabled(false);
            this.remnode.setEnabled(false);
            this.remedge.setEnabled(false);
            this.viewfeatprimi.setEnabled(false);
            if (nonTargetSelected.size() > 0) {
                this.createfromlowlevfeat.setEnabled(true);
            } else {
                this.createfromlowlevfeat.setEnabled(false);
            }
            if (targetSelected.size() == 1) {
                this.addchildfeattohighfeat.setEnabled(true);
                this.remchildfeatfromhighfeat.setEnabled(true);
            } else {
                this.addchildfeattohighfeat.setEnabled(false);
                this.remchildfeatfromhighfeat.setEnabled(false);
            }
        }
    }
}

