/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui.actiongroup;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.geoobject.AbstractFeature;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.layer.ActiveFeaturesLayer;
import oracle.maps.tools.FeatureElementRemoveTool;
import oracle.maps.util.TransformUtils;
import oracle.mapviewer.share.Field;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.ErrorDialog;
import oracle.mdeditor.ui.GeometryUnionPanel;
import oracle.mdeditor.ui.MainAppPanel;
import oracle.mdeditor.ui.OlafDialog;
import oracle.mdeditor.ui.ProgressDialog;
import oracle.mdeditor.ui.actiongroup.BasicToolsPane;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.util.GeometryUtil;
import oracle.sdovis.edit.util.JGeometryUtil;
import oracle.spatial.edit.index.geometry.IndexedGeometrySet;
import oracle.spatial.edit.layer.AbstractDataSetLayer;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.model.AbstractDataAccessObject;
import oracle.spatial.edit.model.MDSException;
import oracle.spatial.geometry.JGeometry;

public class GroupingToolsPane
extends BasicToolsPane {
    private JButton group = new JButton(Icons.getIcon("group_dwn.png"));
    private JButton ungroup = new JButton(Icons.getIcon("ungroup_dwn.png"));
    private JToggleButton removefromgroup = new JToggleButton(Icons.getIcon("removefromgroup_dwn.png"));
    private JButton union = new JButton(Icons.getIcon("union.png"));
    private JButton intersect = new JButton(Icons.getIcon("intersect_dwn.png"));
    private JButton difference = new JButton(Icons.getIcon("difference_dwn.png"));
    private JButton uniontotargetlayer = new JButton(Icons.getIcon("newhierarchymembergroup_ena.png"));

    public GroupingToolsPane(MainAppPanel mainApp) {
        super(mainApp);
        this.buttons = new AbstractButton[]{this.group, this.ungroup, this.removefromgroup, this.union, this.intersect, this.difference, this.uniontotargetlayer};
        this.setName(MessagesBundle.getMessage("Grouping_tools"));
        this.group.setToolTipText(MessagesBundle.getMessage("Tooltip_group_features"));
        this.group.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = GroupingToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                GeometrySetLayer layer = (GeometrySetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
                if (layer == null) {
                    return;
                }
                List<GeoObject> layerObjects = layer.getSelection();
                if (layerObjects == null || layerObjects.size() < 2) {
                    return;
                }
                GroupingToolsPane.this.groupFeatures(layer, layerObjects);
            }
        });
        this.ungroup.setToolTipText(MessagesBundle.getMessage("Tooltip_ungroup_feature_elements"));
        this.ungroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.removefromgroup.setToolTipText(MessagesBundle.getMessage("Tooltip_remove_feature_element"));
        this.removefromgroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = GroupingToolsPane.this.getMapCanvas();
                if (canvas != null) {
                    ActiveFeaturesLayer featureLayer = new ActiveFeaturesLayer(canvas);
                    FeatureElementRemoveTool tool = new FeatureElementRemoveTool(canvas);
                    tool.setElementType(FeatureElementRemoveTool.FULL_ELEMENT);
                    tool.setFeatureLayer(featureLayer);
                    featureLayer.setTool(tool);
                    GroupingToolsPane.this.getMainApp().setTool(featureLayer);
                }
            }
        });
        this.union.setToolTipText(MessagesBundle.getMessage("Tooltip_union"));
        this.union.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupingToolsPane.this.performGeometryOperation("union");
            }
        });
        this.intersect.setToolTipText(MessagesBundle.getMessage("Tooltip_intersection"));
        this.intersect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupingToolsPane.this.performGeometryOperation("intersection");
            }
        });
        this.difference.setToolTipText(MessagesBundle.getMessage("Tooltip_difference"));
        this.difference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupingToolsPane.this.performGeometryOperation("difference");
            }
        });
        this.uniontotargetlayer.setToolTipText(MessagesBundle.getMessage("Tooltip_union_by_attribute"));
        this.uniontotargetlayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MapCanvas canvas = GroupingToolsPane.this.getMapCanvas();
                if (canvas == null) {
                    return;
                }
                LayerManager lm = canvas.getLayerManager();
                Layer targetLayer = lm.getLayerByTag("targetLayer");
                Layer selectionLayer = lm.getLayerByTag("selectionLayer");
                List<GeoObject> selectionSelected = ((GeometrySetLayer)selectionLayer).getSelection();
                if (selectionSelected.size() == 0) {
                    return;
                }
                GeometryUnionPanel gupanel = new GeometryUnionPanel((GeometrySetLayer)targetLayer, (GeometrySetLayer)selectionLayer);
                OlafDialog gudlg = new OlafDialog(canvas.getFrameForDialog(), "Update Target Geometries with Union", gupanel, 0.9f);
                gudlg.setSize(400, 240);
                gudlg.setVisible(true);
                if (!gudlg.isCancelled()) {
                    gudlg.dispose();
                    ProgressDialog pgd = new ProgressDialog(canvas.getFrameForDialog());
                    updateTargetLayerWithUnionThread unionThread = new updateTargetLayerWithUnionThread(gupanel.getTargetKeyColumn(), gupanel.getSelectionJoinColumn(), pgd);
                    unionThread.start();
                    pgd.setVisible(true);
                    if (pgd.isCancelled()) {
                        unionThread.endThread();
                    }
                    pgd.dispose();
                } else {
                    gudlg.dispose();
                }
            }
        });
        ButtonGroup grp = mainApp.getButtonGroup("toolsBG");
        for (AbstractButton btn : this.buttons) {
            if (btn instanceof JToggleButton) {
                grp.add(btn);
            }
            this.add(btn);
        }
        this.updateUIStatus();
    }

    @Override
    public void updateButtonsStatus() {
        MapCanvas canvas = this.getMapCanvas();
        if (canvas == null) {
            return;
        }
        LayerManager lm = canvas.getLayerManager();
        Layer targetLayer = lm.getLayerByTag("targetLayer");
        if (!(targetLayer instanceof EditableLayer) || !((EditableLayer)targetLayer).isEditable()) {
            return;
        }
        if (!(targetLayer instanceof GeometrySetLayer)) {
            return;
        }
        List<GeoObject> targetSelected = ((GeometrySetLayer)targetLayer).getSelection();
        List<GeoObject> nonTargetSelected = lm.getAllSelections();
        nonTargetSelected.removeAll(targetSelected);
        if (targetSelected.size() == 1) {
            boolean isComplex;
            GeometryFeature gf = (GeometryFeature)targetSelected.get(0);
            JGeometry geom = gf.getSpatialAttribute();
            int gtype = geom.getType();
            boolean bl = isComplex = gtype == 5 || gtype == 6 || gtype == 7 || gtype == 4;
            if (isComplex) {
                this.removefromgroup.setEnabled(true);
            }
        }
        if (targetSelected.size() > 1) {
            this.group.setEnabled(true);
        }
        if (targetSelected.size() + nonTargetSelected.size() > 1) {
            int geoms = 0;
            for (GeoObject go : nonTargetSelected) {
                if (!(go instanceof GeometryFeature)) continue;
                ++geoms;
            }
            if (geoms >= 1 && targetSelected.size() <= 1) {
                this.union.setEnabled(true);
                if (targetSelected.size() == 1) {
                    this.difference.setEnabled(true);
                    this.intersect.setEnabled(true);
                }
            }
        }
        LayerManager selectionLayers = canvas.getLayerManager().filterSetByTags(new String[]{"selectionLayer"});
        int layerCount = 0;
        if (selectionLayers.size() > 0) {
            for (Layer selectionLayer : selectionLayers) {
                List<GeoObject> selectionSelected;
                if (!(selectionLayer instanceof GeometrySetLayer) || selectionLayer == targetLayer || (selectionSelected = ((GeometrySetLayer)selectionLayer).getSelection()).size() <= 0) continue;
                ++layerCount;
            }
        }
        if (layerCount == 1) {
            this.uniontotargetlayer.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performGeometryOperation(String type) {
        AbstractFeature absFeat;
        MapCanvas canvas = this.getMapCanvas();
        if (canvas == null) {
            return false;
        }
        AbstractDataSetLayer targetLayer = (AbstractDataSetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
        if (targetLayer == null) {
            return false;
        }
        AbstractDataAccessObject da = targetLayer.getDataSource().getDataAccessObject();
        if (da == null) {
            return false;
        }
        List<GeoObject> targetObjects = targetLayer.getSelection();
        List<GeoObject> nonTargetObjects = canvas.getLayerManager().getAllSelections();
        nonTargetObjects.removeAll(targetObjects);
        AbstractFeature srcFeat = null;
        AbstractFeature dstFeat = null;
        ArrayList<AbstractFeature> otherFeats = new ArrayList<AbstractFeature>();
        for (GeoObject feat : targetObjects) {
            absFeat = (AbstractFeature)feat;
            if (absFeat.getSpatialAttribute() == null) continue;
            if (dstFeat == null) {
                dstFeat = absFeat;
            }
            if (srcFeat == null) {
                srcFeat = absFeat;
                continue;
            }
            otherFeats.add(absFeat);
        }
        for (GeoObject feat : nonTargetObjects) {
            absFeat = (AbstractFeature)feat;
            if (absFeat.getSpatialAttribute() == null) continue;
            if (srcFeat == null) {
                srcFeat = absFeat;
                continue;
            }
            otherFeats.add(absFeat);
        }
        if (srcFeat == null || otherFeats.size() < 1) {
            return false;
        }
        JGeometry result = null;
        double tolerance = 5.0E-7;
        String errorKey = null;
        Throwable exception = null;
        try {
            da.openConnection();
            if (type.equalsIgnoreCase("union")) {
                errorKey = "Unable_togroup_features";
                result = da.union(srcFeat, otherFeats.toArray(new AbstractFeature[otherFeats.size()]), tolerance);
            } else if (type.equalsIgnoreCase("intersection")) {
                errorKey = "Unable_tocompute_intersection";
                result = da.intersection(srcFeat, otherFeats.toArray(new AbstractFeature[otherFeats.size()]), tolerance);
            } else if (type.equalsIgnoreCase("difference")) {
                errorKey = "Unable_tocompute_difference";
                result = da.difference(srcFeat, otherFeats.toArray(new AbstractFeature[otherFeats.size()]), tolerance);
            }
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception re) {
                re.printStackTrace();
            }
        }
        if (exception != null || result == null) {
            ErrorDialog.showErrorDialog(exception, canvas.getFrameForDialog(), MessagesBundle.getMessage(errorKey) + (result == null ? " " + MessagesBundle.getMessage("Null_geometry_returned") : ""), MessagesBundle.getMessage("Warning"), 2);
            return false;
        }
        IndexedGeometrySet dset = (IndexedGeometrySet)targetLayer.getIndexedDataSet();
        String keyColumn = dset.getDataSet().getKeyColumn();
        if (dstFeat != null) {
            String key = dstFeat.getAttribute(keyColumn).getValue().toString();
            targetLayer.updateObjectSpatialAttribute(key, result);
        } else {
            GeometryFeature gfeat = new GeometryFeature();
            gfeat.setSpatialAttribute(result);
            Field[] fields = targetLayer.getFieldsForFeature(gfeat, false);
            if (fields == null || fields.length == 0) {
                ErrorDialog.showErrorDialog(null, canvas.getFrameForDialog(), MessagesBundle.getMessage("Undefined_feature_nonnull_attributes"), MessagesBundle.getMessage("Warning"), 2);
                return false;
            }
            gfeat.setAttributes(fields);
            String fkey = gfeat.getAttribute(keyColumn).getValue().toString();
            gfeat.setKey(fkey);
            gfeat.setLayer(targetLayer);
            try {
                targetLayer.insertObject(fkey, gfeat);
            }
            catch (Exception ex) {
                ErrorDialog.showErrorDialog(ex, canvas.getFrameForDialog(), MessagesBundle.getMessage("Unable_toinsert_object"), MessagesBundle.getMessage("Error"), 2);
                return false;
            }
        }
        canvas.getLayerManager().clearAllSelections();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void groupFeatures(GeometrySetLayer layer, List<GeoObject> features) {
        if (layer == null || features == null || features.size() < 2) {
            return;
        }
        AbstractDataAccessObject da = layer.getDataSource().getDataAccessObject();
        if (da == null) {
            return;
        }
        IndexedGeometrySet dset = (IndexedGeometrySet)layer.getIndexedDataSet();
        String keyColumn = dset.getDataSet().getKeyColumn();
        JGeometry union = null;
        Throwable exception = null;
        try {
            da.openConnection();
            GeometryFeature srcFeat = null;
            ArrayList<GeometryFeature> extgeoms = new ArrayList<GeometryFeature>();
            for (GeometryFeature geometryFeature : features) {
                JGeometry geom = geometryFeature.getSpatialAttribute();
                if (geom == null) continue;
                if (srcFeat == null) {
                    srcFeat = geometryFeature;
                    continue;
                }
                extgeoms.add(geometryFeature);
            }
            double d = 5.0E-7;
            if (extgeoms.size() > 0) {
                union = da.union(srcFeat, extgeoms.toArray(new AbstractFeature[extgeoms.size()]), d);
            }
        }
        catch (MDSException ex) {
            exception = ex;
        }
        catch (Exception ex) {
            exception = ex;
        }
        finally {
            try {
                da.closeConnection();
            }
            catch (Exception re) {
                re.printStackTrace();
            }
        }
        if (exception != null || union == null) {
            ErrorDialog.showErrorDialog(exception, this.getMainApp().getFrameForDialog(), MessagesBundle.getMessage("Unable_togroup_features") + (union == null ? " " + MessagesBundle.getMessage("Null_geometry_returned") : ""), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        GeometryFeature gfeat = new GeometryFeature();
        gfeat.setSpatialAttribute(union);
        Field[] fields = layer.getFieldsForFeature(gfeat, false);
        if (fields == null || fields.length == 0) {
            ErrorDialog.showErrorDialog(null, this.getMainApp().getFrameForDialog(), MessagesBundle.getMessage("Undefined_feature_nonnull_attributes"), MessagesBundle.getMessage("Warning"), 2);
            return;
        }
        gfeat.setAttributes(fields);
        String fkey = gfeat.getAttribute(keyColumn).getValue().toString();
        gfeat.setKey(fkey);
        gfeat.setLayer(layer);
        String[] stringArray = new String[features.size()];
        for (int k = 0; k < features.size(); ++k) {
            stringArray[k] = ((GeometryFeature)features.get(k)).getAttribute(keyColumn).getValue().toString();
        }
        try {
            layer.replaceFeatureGroup(stringArray, gfeat);
        }
        catch (Exception ex) {
            ErrorDialog.showErrorDialog(ex, this.getMainApp().getFrameForDialog(), MessagesBundle.getMessage("Unable_toreplace_feature_group"), MessagesBundle.getMessage("Error"), 0);
        }
        layer.clearSelection();
    }

    private JGeometry removeSmallVoidElements(JGeometry geom, double areaThreshold) {
        if (geom == null || Double.isNaN(areaThreshold)) {
            return geom;
        }
        int gtype = geom.getType();
        if (gtype != 3) {
            return geom;
        }
        int[] eInfo = geom.getElemInfo();
        double[] oords = geom.getOrdinatesArray();
        if (eInfo == null || oords == null) {
            return geom;
        }
        int dim = geom.getDimensions();
        int numRings = eInfo.length / 3;
        if (numRings < 2) {
            return geom;
        }
        int startoords = eInfo[0];
        int endoords = eInfo[3];
        int size = endoords - startoords;
        int[] newEinfo = new int[]{1, 1003, eInfo[2]};
        double[] newOords = new double[size];
        for (int i = 0; i < size; ++i) {
            newOords[i] = oords[i + startoords - 1];
        }
        JGeometry outGeom = new JGeometry(dim * 1000 + 3, geom.getSRID(), newEinfo, newOords);
        for (int i = 1; i < numRings; ++i) {
            double varea;
            double[] voords;
            JGeometry voidElem = JGeometryUtil.getVoidBoundaryAsGeometry((JGeometry)geom, (int)i);
            if (voidElem == null || voidElem.getType() != 3 || (voords = voidElem.getOrdinatesArray()) == null || !((varea = Math.abs(GeometryUtil.getPolygonArea((double[])voords))) > areaThreshold)) continue;
            outGeom = JGeometryUtil.addVoidPolygon((JGeometry)outGeom, (int)0, (JGeometry)voidElem);
        }
        return outGeom;
    }

    private class updateTargetLayerWithUnionThread
    extends Thread {
        private String targetKeyAttribute = null;
        private String selectionJoinAttribute = null;
        private ProgressDialog pgrdlg = null;
        private boolean stop = false;

        public updateTargetLayerWithUnionThread(String targetKeyAttribute, String selectionJoinAttribute, ProgressDialog dlg) {
            this.targetKeyAttribute = targetKeyAttribute;
            this.selectionJoinAttribute = selectionJoinAttribute;
            this.pgrdlg = dlg;
        }

        @Override
        public void run() {
            this.updateTargetLayerWithUnion(this.targetKeyAttribute, this.selectionJoinAttribute);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateTargetLayerWithUnion(String targetKeyAttribute, String selectionJoinAttribute) {
            MapCanvas canvas = GroupingToolsPane.this.getMapCanvas();
            if (canvas == null) {
                return false;
            }
            if (targetKeyAttribute == null || selectionJoinAttribute == null) {
                this.pgrdlg.setVisible(false);
                return false;
            }
            AbstractDataSetLayer targetLayer = (AbstractDataSetLayer)canvas.getLayerManager().getLayerByTag("targetLayer");
            if (targetLayer == null) {
                this.pgrdlg.setVisible(false);
                return false;
            }
            AbstractDataSetLayer selectionLayer = (AbstractDataSetLayer)canvas.getLayerManager().getLayerByTag("selectionLayer");
            if (selectionLayer == null) {
                this.pgrdlg.setVisible(false);
                return false;
            }
            AbstractDataAccessObject da = targetLayer.getDataSource().getDataAccessObject();
            if (da == null) {
                this.pgrdlg.setVisible(false);
                return false;
            }
            this.pgrdlg.setTitle("Union Operations");
            this.pgrdlg.setTaskMessage("Building feature list...");
            List<GeoObject> nonTargetObjects = ((GeometrySetLayer)selectionLayer).getSelection();
            ArrayList<String> keys = new ArrayList<String>();
            Hashtable<String, ArrayList<AbstractFeature>> featsToProcess = new Hashtable<String, ArrayList<AbstractFeature>>();
            for (GeoObject feat : nonTargetObjects) {
                AbstractFeature absFeat = (AbstractFeature)feat;
                JGeometry geom = (JGeometry)absFeat.getSpatialAttribute();
                if (geom == null) continue;
                Field f = absFeat.getAttribute(selectionJoinAttribute);
                String value = null;
                if (f == null || f.getValue() == null || (value = f.getValue().toString()) == null) continue;
                ArrayList<AbstractFeature> features = (ArrayList<AbstractFeature>)featsToProcess.get(value);
                if (features == null) {
                    features = new ArrayList<AbstractFeature>();
                    featsToProcess.put(value, features);
                    keys.add(value);
                }
                features.add(absFeat);
            }
            GeometrySetLayer gsetl = (GeometrySetLayer)targetLayer;
            double areaThreshold = Double.NaN;
            AffineTransform at = canvas.getViewportTransform();
            if (at != null) {
                Point2D.Double pt = new Point2D.Double(canvas.getMapRegion().getDataWindow().getCenterX(), canvas.getMapRegion().getDataWindow().getCenterY());
                double wcTolerance = TransformUtils.getWCTolerance(pt, 4, at);
                areaThreshold = wcTolerance * wcTolerance;
                System.out.println("4x4 pixels=" + wcTolerance + " Area: " + areaThreshold);
            }
            targetLayer.getCanvas().getUndoManager().startChangeBlock("union of features");
            try {
                da.openConnection();
                for (int i = 0; i < keys.size(); ++i) {
                    if (this.stop) {
                        break;
                    }
                    String key = (String)keys.get(i);
                    this.pgrdlg.setTaskMessage("Processing target feature [" + key + "] ...");
                    AbstractFeature tgf = gsetl.getDataSet().getFeature(key);
                    if (tgf == null) continue;
                    ArrayList features = (ArrayList)featsToProcess.get(key);
                    if (features.size() == 1) {
                        GeometryFeature feat = (GeometryFeature)features.get(0);
                        JGeometry change = (JGeometry)feat.getSpatialAttribute().clone();
                        if (change == null) continue;
                        targetLayer.updateObjectSpatialAttribute(key, change);
                        continue;
                    }
                    JGeometry result = null;
                    double tolerance = 5.0E-7;
                    AbstractFeature sourceFeat = (AbstractFeature)features.remove(0);
                    Throwable exception = null;
                    try {
                        result = da.union(sourceFeat, features.toArray(new AbstractFeature[features.size()]), tolerance);
                        if (result != null && !Double.isNaN(areaThreshold)) {
                            JGeometry output = null;
                            JGeometry[] resElems = JGeometryUtil.getElements((JGeometry)result);
                            if (resElems != null && resElems.length > 0) {
                                for (int k = 0; k < resElems.length; ++k) {
                                    JGeometry elem = GroupingToolsPane.this.removeSmallVoidElements(resElems[k], areaThreshold);
                                    if (elem == null) continue;
                                    if (output == null) {
                                        output = elem;
                                        continue;
                                    }
                                    if (elem.getType() == 1) {
                                        output = JGeometryUtil.addPoint((JGeometry)output, (JGeometry)elem);
                                        continue;
                                    }
                                    if (elem.getType() == 2) {
                                        output = JGeometryUtil.addLine((JGeometry)output, (JGeometry)elem);
                                        continue;
                                    }
                                    if (elem.getType() != 3) continue;
                                    output = JGeometryUtil.addPolygon((JGeometry)output, (JGeometry)elem);
                                }
                                result = output;
                            }
                        }
                    }
                    catch (MDSException ex) {
                        exception = ex;
                    }
                    catch (Exception ex) {
                        exception = ex;
                    }
                    if (exception != null) {
                        System.out.println("Unable to generate union for feature key: " + key + " Exception: " + exception.getMessage());
                        exception.printStackTrace();
                        result = null;
                    }
                    if (result == null) continue;
                    targetLayer.updateObjectSpatialAttribute(key, result);
                }
            }
            catch (Exception ex) {
            }
            finally {
                targetLayer.getCanvas().getUndoManager().endChangeBlock("union of features");
                try {
                    da.closeConnection();
                }
                catch (Exception re) {
                    re.printStackTrace();
                }
                this.pgrdlg.setVisible(false);
            }
            selectionLayer.setSelection(new Vector<GeoObject>());
            targetLayer.setToUpdate();
            return true;
        }

        public void endThread() {
            this.stop = true;
        }
    }
}

