/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.sdovis.edit.session.layer.EditSessionLayer;
import oracle.spatial.edit.util.DataSourceMetadata;

public class SpatialDataPanel
extends JPanel {
    private String[] typeNames = new String[]{"Geometry", "Annotation Text", "Topology"};
    private String[] types = new String[]{EditSessionLayer.GEOMETRY_TYPE, EditSessionLayer.ANNOTATION_TYPE, EditSessionLayer.TOPOFEATURE_TYPE};
    private DefaultListModel attrListModel = new DefaultListModel();
    private JList jList1 = new JList(this.attrListModel);
    private JScrollPane scrollPane1 = new JScrollPane(this.jList1);
    private JLabel dataLabel = new JLabel();
    private JComboBox dataType = new JComboBox();
    private DataSourceMetadata metadata = null;

    public SpatialDataPanel(DataSourceMetadata dsrcMetadata) {
        this.metadata = dsrcMetadata;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(355, 233));
        this.dataLabel.setText(MessagesBundle.getMessage("Label_spatial_data"));
        for (String type : this.typeNames) {
            this.dataType.addItem(type);
        }
        this.dataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpatialDataPanel.this.dataType_actionPerformed(e);
            }
        });
        this.add((Component)this.dataLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.dataType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 0), 70, 0));
        this.add((Component)this.scrollPane1, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 5, 10), 0, 0));
        this.refreshDataList();
    }

    private void refreshDataList() {
        DefaultListModel lmodel = (DefaultListModel)this.jList1.getModel();
        lmodel.clear();
        String[] names = null;
        int index = this.dataType.getSelectedIndex();
        names = this.metadata.getSpatialTables(this.types[index]);
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (names[i].indexOf(".") > -1) continue;
                lmodel.addElement(names[i]);
            }
        }
    }

    public String getSpatialDataType() {
        return this.types[this.dataType.getSelectedIndex()];
    }

    public Object[] getSelectedItems() {
        Object[] items = this.jList1.getSelectedValues();
        if (items == null || items.length == 0) {
            return null;
        }
        return items;
    }

    private void dataType_actionPerformed(ActionEvent e) {
        this.refreshDataList();
    }

    public boolean isDataEditable() {
        return false;
    }
}

