/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import oracle.maps.core.DefaultLayerProvider;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.mdeditor.EditorAppletInfo;
import oracle.mdeditor.MapConstants;
import oracle.mdeditor.SDEPlugin;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.session.EditSession;
import oracle.mdeditor.session.EditSessionProvider;
import oracle.mdeditor.session.layer.LayerProvider;
import oracle.mdeditor.ui.CollapsibleDockFrame;
import oracle.mdeditor.ui.CollapsiblePanel;
import oracle.mdeditor.ui.EditSessionPanel;
import oracle.mdeditor.ui.LabelingStylePicker;
import oracle.mdeditor.ui.MapRenderingPanel;
import oracle.mdeditor.ui.RenderingStylePicker;
import oracle.mdeditor.ui.SDEUIComponent;
import oracle.mdeditor.ui.actiongroup.DrawingToolsPane;
import oracle.mdeditor.ui.actiongroup.FeatureToolsPane;
import oracle.mdeditor.ui.actiongroup.GeometryToolsPane;
import oracle.mdeditor.ui.actiongroup.GroupingToolsPane;
import oracle.mdeditor.ui.actiongroup.ManipulatorPane;
import oracle.mdeditor.ui.actiongroup.VertexToolsPane;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.mdeditor.wfs.layer.WFSLayerProvider;
import oracle.spatial.edit.layer.MVLayerProvider;
import oracle.spatial.edit.session.MDSEditSessionProvider;
import oracle.spatial.edit.util.MVConnection;

public class MainAppPanel
extends JPanel {
    public static final String DEFAULT_LAYERPROVIDER = "oracle.mdeditor.defaultLayerProvider";
    protected Hashtable<String, CollapsibleDockFrame> dockFrames = new Hashtable();
    protected Hashtable<String, ButtonGroup> buttonGroups = new Hashtable();
    protected Hashtable<SDEUIComponent, ComponentOriginalLocation> componentList = new Hashtable();
    protected ArrayList<SDEPlugin> pluginList = new ArrayList();
    protected Hashtable<String, EditSessionProvider> sessionProviderList = new Hashtable();
    protected Hashtable<String, LayerProvider> layerProviderList = new Hashtable();
    protected Hashtable<String, EditSession> loadedSessionList = new Hashtable();
    protected JDesktopPane contentPanel = new JDesktopPane();
    protected EditSessionPanel sessionPanel = null;
    protected MapRenderingPanel renderPanel = null;
    protected EditorAppletInfo contextBean = null;
    protected Hashtable<String, String> tablePKeys = new Hashtable();
    protected RenderingStylePicker renderStylePicker = null;
    protected LabelingStylePicker labelStylePicker = null;

    public MainAppPanel() {
        this(null, null);
    }

    public MainAppPanel(Object[] plugins) {
        this(plugins, null);
    }

    public MainAppPanel(EditorAppletInfo contextBean) {
        this(null, contextBean);
    }

    public MainAppPanel(Object[] plugins, EditorAppletInfo contextBean) {
        this.contextBean = contextBean;
        this.sessionPanel = new EditSessionPanel(this);
        this.renderPanel = new MapRenderingPanel(this);
        this.contentPanel.setDesktopManager(new MyDesktopManager());
        this.contentPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MainAppPanel.this.resizeGUI();
            }
        });
        this.contentPanel.addMouseListener(new MouseAdapter(){

            private void mouseEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem mi = new JMenuItem("Reset window positions");
                    mi.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MainAppPanel.this.resetGUI();
                        }
                    });
                    menu.add(mi);
                    menu.show(MainAppPanel.this.contentPanel, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.mouseEvent(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseEvent(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mouseEvent(e);
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.contentPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        CollapsibleDockFrame sessionFrame = this.getDockFrame("sessionFrame");
        sessionFrame.setFrameIcon(Icons.getIcon("ora_mapItem.png"));
        sessionFrame.setClosable(false);
        sessionFrame.setMaximizable(false);
        sessionFrame.setSize(225, 0);
        this.getContentPanel().setLayer(sessionFrame, -1);
        CollapsiblePanel esCP = (CollapsiblePanel)this.addUIComponent(this.sessionPanel, sessionFrame, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        esCP.getHeaderPanel().setVisible(false);
        esCP.setUndockable(false);
        esCP.setExpanded(true);
        this.renderStylePicker = new RenderingStylePicker(this.sessionPanel);
        this.labelStylePicker = new LabelingStylePicker(this.sessionPanel);
        this.addUIComponent(this.renderStylePicker, sessionFrame, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addUIComponent(this.labelStylePicker, sessionFrame, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        CollapsibleDockFrame canvasFrame = this.getDockFrame("canvasFrame");
        canvasFrame.setFrameIcon(Icons.getIcon("earth32.gif"));
        canvasFrame.setClosable(false);
        canvasFrame.setAcceptingDrops(false);
        this.getContentPanel().setLayer(canvasFrame, -2);
        CollapsiblePanel mrCP = (CollapsiblePanel)this.addUIComponent(this.renderPanel, canvasFrame, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        mrCP.getHeaderPanel().setVisible(false);
        mrCP.setUndockable(false);
        mrCP.setExpanded(true);
        CollapsibleDockFrame toolsFrame = this.getDockFrame("toolsFrame");
        toolsFrame.setTitle(MessagesBundle.getMessage("Tools"));
        toolsFrame.setFrameIcon(Icons.getIcon("configure.png"));
        toolsFrame.setClosable(false);
        toolsFrame.setMaximizable(false);
        toolsFrame.setSize(132, 0);
        this.getContentPanel().setLayer(toolsFrame, -1);
        int gridY = 0;
        this.addUIComponent(new FeatureToolsPane(this), toolsFrame, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.addUIComponent(new DrawingToolsPane(this), toolsFrame, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.addUIComponent(new VertexToolsPane(this), toolsFrame, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.addUIComponent(new GroupingToolsPane(this), toolsFrame, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.addUIComponent(new GeometryToolsPane(this), toolsFrame, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.addUIComponent(new ManipulatorPane(this), toolsFrame, new GridBagConstraints(0, gridY++, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 3, 0), 0, 0));
        this.getLayerProviders().put(DEFAULT_LAYERPROVIDER, new DefaultLayerProvider());
        try {
            ArrayList<MVConnection> connections = new ArrayList<MVConnection>(1);
            MDSEditSessionProvider sessionProv = new MDSEditSessionProvider(this, connections);
            MVLayerProvider layerProv = new MVLayerProvider(this, connections);
            this.getEditSessionProviders().put("oracle.spatial.edit.session.MDSEditSessionProvider", sessionProv);
            this.getLayerProviders().put("oracle.maps.core.MVLayerProvider", layerProv);
            WFSLayerProvider wfsProv = new WFSLayerProvider(this);
            this.getLayerProviders().put("oracle.mdeditor.wfs.layer.WFSLayerProvider", wfsProv);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (plugins != null) {
            for (int i = 0; i < plugins.length - 1; i += 2) {
                SDEPlugin plugin = null;
                try {
                    String mainPluginClass = (String)plugins[i];
                    URL[] jars = (URL[])plugins[i + 1];
                    URLClassLoader loader = new URLClassLoader(jars, this.getClass().getClassLoader());
                    plugin = (SDEPlugin)Class.forName(mainPluginClass, true, loader).newInstance();
                    plugin.init(this);
                    this.pluginList.add(plugin);
                    continue;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    if (plugin == null) continue;
                    plugin.destroy();
                }
            }
        }
        this.updateGUIStatus();
    }

    public MapRenderingPanel getRenderPanel() {
        return this.renderPanel;
    }

    public MapCanvas getMapCanvas() {
        if (this.getEditSessionPanel().getEditSession() != null) {
            return this.getEditSessionPanel().getEditSession().getMapCanvas();
        }
        return null;
    }

    public EditSessionPanel getEditSessionPanel() {
        return this.sessionPanel;
    }

    public void checkForChanges() {
        if (this.contextBean == null) {
            return;
        }
        EditSession ed = this.sessionPanel.getEditSession();
        if (ed != null && ed.isModified()) {
            this.contextBean.setJSExitMessage(MessagesBundle.getMessage("Question_js_changes"));
        }
    }

    public Layer getTool() {
        Layer tool = null;
        MapCanvas canvas = this.getMapCanvas();
        if (canvas != null) {
            LayerManager lm = canvas.getLayerManager();
            tool = lm.getLayerByTag("toolLayer");
        }
        return tool;
    }

    public void setTool(Layer tool) {
        MapCanvas canvas = this.getMapCanvas();
        if (canvas != null) {
            LayerManager lm = canvas.getLayerManager();
            Layer old = lm.getLayerByTag("toolLayer");
            lm.remove(old);
            if (tool != null) {
                lm.add(tool, MapConstants.POSITION_OVERDATA_LAYERS);
                lm.tag(tool, "toolLayer");
            }
        }
    }

    public EditorAppletInfo getContextBean() {
        return this.contextBean;
    }

    public Map<String, EditSessionProvider> getEditSessionProviders() {
        return this.sessionProviderList;
    }

    public Map<String, LayerProvider> getLayerProviders() {
        return this.layerProviderList;
    }

    public Map<String, EditSession> getLoadedEditSessions() {
        return this.loadedSessionList;
    }

    public Container addUIComponent(SDEUIComponent c, Container parent, Object constraints) {
        this.componentList.put(c, new ComponentOriginalLocation(parent, constraints));
        Container result = null;
        try {
            if (parent instanceof CollapsibleDockFrame) {
                CollapsiblePanel cp = new CollapsiblePanel(c.getComponent());
                parent.add((Component)cp, constraints);
                ((CollapsibleDockFrame)parent).checkHeaders();
                result = cp;
            } else {
                parent.add(c.getComponent(), constraints);
                result = parent;
            }
            this.updateGUIStatus();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.componentList.remove(c);
        }
        return result;
    }

    public CollapsibleDockFrame getDockFrame(String frameHandle) {
        CollapsibleDockFrame df = this.dockFrames.get(frameHandle);
        if (df == null) {
            df = new CollapsibleDockFrame();
            JMenuItem mi = new JMenuItem("Restore frame contents");
            mi.addActionListener(new RestoreContainerActionListener(df));
            df.getComponentPopupMenu().add(mi);
            this.dockFrames.put(frameHandle, df);
            this.contentPanel.add(df);
        }
        return df;
    }

    public ButtonGroup getButtonGroup(String name) {
        ButtonGroup bg = this.buttonGroups.get(name);
        if (bg == null) {
            bg = new ButtonGroup();
            this.buttonGroups.put(name, bg);
        }
        return bg;
    }

    public JDesktopPane getContentPanel() {
        return this.contentPanel;
    }

    private void adjustFramePositions() {
        for (Component c : this.contentPanel.getComponents()) {
            int minx = c.getX();
            int miny = c.getY();
            int maxx = minx + c.getWidth();
            int maxy = miny + c.getHeight();
            int newx = minx;
            int newy = miny;
            if (minx < 0) {
                newx = 0;
            }
            if (maxx > this.contentPanel.getWidth()) {
                newx = this.contentPanel.getWidth() - c.getWidth();
            }
            if (miny < 0) {
                newy = 0;
            }
            if (maxy > this.contentPanel.getHeight()) {
                newy = this.contentPanel.getHeight() - c.getHeight();
            }
            c.setLocation(newx, newy);
            int width = c.getWidth();
            int height = c.getHeight();
            int newWidth = width;
            int newHeight = height;
            if (width > this.contentPanel.getWidth()) {
                newWidth = this.contentPanel.getWidth();
            }
            if (height > this.contentPanel.getHeight()) {
                newHeight = this.contentPanel.getHeight();
            }
            c.setSize(newWidth, newHeight);
        }
    }

    private void resetContainer(Container container) {
        for (Map.Entry<SDEUIComponent, ComponentOriginalLocation> e : this.componentList.entrySet()) {
            CollapsibleDockFrame df;
            Component comp = null;
            try {
                comp = e.getKey().getComponent();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                continue;
            }
            ComponentOriginalLocation loc = e.getValue();
            Container parent = null;
            CollapsiblePanel cp = CollapsiblePanel.getCollapsiblePanelParent(comp);
            if (cp != null) {
                comp = cp;
                df = cp.getDockFrame();
                parent = df != null ? df : cp.getParent();
            } else {
                parent = comp.getParent();
            }
            if (container != null && !parent.equals(container) && !loc.parent.equals(container)) continue;
            parent.remove(comp);
            loc.parent.add(comp, loc.constraints);
            if (parent instanceof CollapsibleDockFrame) {
                ((CollapsibleDockFrame)parent).checkHeaders();
            }
            if (loc.parent instanceof CollapsibleDockFrame) {
                df = (CollapsibleDockFrame)loc.parent;
                if (df.isClosed()) {
                    df.setVisible(true);
                    this.contentPanel.add(df);
                }
                df.checkHeaders();
            }
            parent.validate();
            loc.parent.validate();
        }
        this.contentPanel.repaint();
    }

    private void resizeGUI() {
        int contentHeight = this.contentPanel.getHeight();
        CollapsibleDockFrame sessionFrame = this.getDockFrame("sessionFrame");
        try {
            sessionFrame.setIcon(false);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        try {
            sessionFrame.setMaximum(false);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        CollapsibleDockFrame toolsFrame = this.getDockFrame("toolsFrame");
        try {
            toolsFrame.setIcon(false);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        try {
            toolsFrame.setMaximum(false);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        CollapsibleDockFrame canvasFrame = this.getDockFrame("canvasFrame");
        try {
            canvasFrame.setIcon(false);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        try {
            canvasFrame.setMaximum(false);
        }
        catch (PropertyVetoException ex) {
            ex.printStackTrace();
        }
        sessionFrame.setBounds(0, 0, sessionFrame.getWidth(), contentHeight);
        toolsFrame.setBounds(this.contentPanel.getWidth() - toolsFrame.getWidth(), 0, toolsFrame.getWidth(), contentHeight);
        canvasFrame.setBounds(sessionFrame.getX() + sessionFrame.getWidth(), 0, toolsFrame.getX() - (sessionFrame.getX() + sessionFrame.getWidth()), contentHeight);
    }

    private void resetGUI() {
        this.resetContainer(null);
    }

    public void updateGUIStatus() {
        for (SDEUIComponent c : this.componentList.keySet()) {
            try {
                c.updateUIStatus();
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public Frame getFrameForDialog() {
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    public RenderingStylePicker getRenderStylePicker() {
        return this.renderStylePicker;
    }

    public LabelingStylePicker getLabelStylePicker() {
        return this.labelStylePicker;
    }

    private class MyDesktopManager
    extends DefaultDesktopManager {
        private MyDesktopManager() {
        }

        @Override
        public void resizeFrame(JComponent f, int newX, int newY, int newWidth, int newHeight) {
            super.resizeFrame(f, newX, newY, newWidth, newHeight);
            CollapsibleDockFrame sessionFrame = MainAppPanel.this.getDockFrame("sessionFrame");
            CollapsibleDockFrame toolsFrame = MainAppPanel.this.getDockFrame("toolsFrame");
            CollapsibleDockFrame canvasFrame = MainAppPanel.this.getDockFrame("canvasFrame");
            if (f.equals(sessionFrame) || f.equals(toolsFrame) || f.equals(canvasFrame)) {
                MainAppPanel.this.resizeGUI();
            }
        }

        @Override
        public void beginDraggingFrame(JComponent f) {
            CollapsibleDockFrame src;
            super.beginDraggingFrame(f);
            if (f instanceof CollapsibleDockFrame && (src = (CollapsibleDockFrame)f).canUndock()) {
                CollapsiblePanel cp = (CollapsiblePanel)src.getContentPane().getComponent(0);
                cp.getFloater().prepare();
            }
        }

        @Override
        public void endDraggingFrame(JComponent f) {
            CollapsibleDockFrame src;
            super.endDraggingFrame(f);
            if (f instanceof CollapsibleDockFrame && (src = (CollapsibleDockFrame)f).canUndock()) {
                CollapsiblePanel cp = (CollapsiblePanel)src.getContentPane().getComponent(0);
                cp.getFloater().setVisible(false);
                src.moveComponent(cp, MouseInfo.getPointerInfo().getLocation());
            }
        }

        @Override
        public void dragFrame(JComponent f, int newX, int newY) {
            CollapsibleDockFrame src;
            super.dragFrame(f, newX, newY);
            if (f instanceof CollapsibleDockFrame && (src = (CollapsibleDockFrame)f).canUndock()) {
                CollapsiblePanel cp = (CollapsiblePanel)src.getContentPane().getComponent(0);
                Point p = MouseInfo.getPointerInfo().getLocation();
                CollapsibleDockFrame over = src.findSiblingOn(p);
                if (over != null && over.isAcceptingDrops()) {
                    cp.getFloater().setLocation((int)p.getX() + 10, (int)p.getY() + 10);
                    cp.getFloater().setVisible(true);
                    src.setVisible(false);
                } else {
                    cp.getFloater().setVisible(false);
                    src.setVisible(true);
                }
            }
        }

        @Override
        protected boolean wasIcon(JInternalFrame f) {
            return super.wasIcon(f);
        }

        @Override
        protected Rectangle getBoundsForIconOf(JInternalFrame f) {
            return super.getBoundsForIconOf(f);
        }

        @Override
        public void iconifyFrame(JInternalFrame f) {
            super.iconifyFrame(f);
            f.setIconifiable(false);
        }

        @Override
        public void deiconifyFrame(JInternalFrame f) {
            super.deiconifyFrame(f);
            f.setIconifiable(true);
        }
    }

    private class RestoreContainerActionListener
    implements ActionListener {
        Container container;

        public RestoreContainerActionListener(Container container) {
            this.container = container;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainAppPanel.this.resetContainer(this.container);
        }
    }

    private class ComponentOriginalLocation {
        Container parent;
        Object constraints;

        public ComponentOriginalLocation(Container parent, Object constraints) {
            this.parent = parent;
            this.constraints = constraints;
        }
    }
}

