/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.mdeditor.ui.resources.MessagesBundle;
import oracle.spatial.geometry.JGeometry;

public class GeometryElementsTree
extends JTree {
    private JGeometry geometry = null;
    private DefaultMutableTreeNode rootNode = null;
    private DefaultTreeModel treeModel = null;

    public GeometryElementsTree(JGeometry geom) {
        this.geometry = geom;
        this.rootNode = new DefaultMutableTreeNode(MessagesBundle.getMessage("Geometry"));
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.setModel(this.treeModel);
        this.refresh();
    }

    public void refresh() {
        this.clear();
        if (this.geometry == null) {
            return;
        }
        JGeometry[] elements = this.geometry.getElements();
        if (elements == null || elements.length == 0) {
            return;
        }
        for (int i = 0; i < elements.length; ++i) {
            int nrings;
            JGeometry elem = elements[i];
            DefaultMutableTreeNode child = this.insertAtParentNode(this.rootNode, "Element_" + (i + 1));
            if (elem.getType() != 3 || (nrings = elem.getElemInfo().length / 3) <= 1) continue;
            for (int k = 1; k < nrings; ++k) {
                this.insertAtParentNode(child, "Void_" + k);
            }
        }
        this.expandRow(0);
    }

    public void clear() {
        while (this.rootNode.getChildCount() > 0) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)this.treeModel.getChild(this.rootNode, 0);
            this.treeModel.removeNodeFromParent(child);
        }
    }

    private DefaultMutableTreeNode insertAtParentNode(DefaultMutableTreeNode parentNode, String name) {
        if (parentNode == null || name == null) {
            return null;
        }
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(name);
        this.treeModel.insertNodeInto(newNode, parentNode, parentNode.getChildCount());
        return newNode;
    }

    public JGeometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(JGeometry geom) {
        this.geometry = geom;
        this.refresh();
    }
}

