/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.maps.core.Layer;
import oracle.mdeditor.resources.icons.Icons;
import oracle.mdeditor.ui.EditSessionPanel;
import oracle.mdeditor.ui.EditSessionTableModel;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class EditSessionTablePanel
extends JPanel {
    private EditSessionPanel panel = null;
    private JTable table = null;
    private ImageIcon checkboxImage = Icons.getIcon("check.png");
    private ImageIcon uncheckboxImage = Icons.getIcon("uncheck.png");
    private ImageIcon nonselectableImage = Icons.getIcon("delete.gif");
    private ImageIcon iconIcon = Icons.getIcon("mark_as_fav.png");
    private ImageIcon editImage = Icons.getIcon("edit16.png");
    private ImageIcon snapIcon = Icons.getIcon("snap.png");
    private ImageIcon selectIcon = Icons.getIcon("select-point.png");
    private ImageIcon targetIcon = Icons.getIcon("target.png");
    private ImageIcon glassIcon = Icons.getIcon("glass.png");
    private String[] headerTooltip = new String[]{null, MessagesBundle.getMessage("Tooltip_data_layer"), MessagesBundle.getMessage("Tooltip_layer_visible"), MessagesBundle.getMessage("Tootltip_layer_editable"), MessagesBundle.getMessage("Tooltip_current_target"), MessagesBundle.getMessage("Tooltip_snapping_layer"), MessagesBundle.getMessage("Tooltip_selection_layer")};
    private JPopupMenu dataLayerPopup = new JPopupMenu();
    private JMenuItem dataLayerPopupMenuProps = null;

    public EditSessionTablePanel(EditSessionPanel panel) {
        this.panel = panel;
        this.table = new JTable(new EditSessionTableModel(panel));
        this.getSelectionModel().addListSelectionListener(panel);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(0, 0));
        this.table.setSelectionMode(0);
        TableColumnModel columnModel = this.table.getColumnModel();
        TableHeaderRenderer headerRenderer = new TableHeaderRenderer();
        DataPanelCellRenderer cellRenderer = new DataPanelCellRenderer();
        int iconColumnMaxWidth = 20;
        TableColumn column = columnModel.getColumn(0);
        column.setHeaderRenderer(headerRenderer);
        column.setHeaderValue(this.iconIcon);
        column.setCellRenderer(cellRenderer);
        column.setMaxWidth(iconColumnMaxWidth);
        column = columnModel.getColumn(1);
        column.setHeaderRenderer(headerRenderer);
        column.setCellRenderer(cellRenderer);
        column = columnModel.getColumn(2);
        column.setHeaderRenderer(headerRenderer);
        column.setHeaderValue(this.glassIcon);
        column.setCellRenderer(cellRenderer);
        column.setMaxWidth(iconColumnMaxWidth);
        column = columnModel.getColumn(3);
        column.setHeaderRenderer(headerRenderer);
        column.setHeaderValue(this.editImage);
        column.setCellRenderer(cellRenderer);
        column.setMaxWidth(iconColumnMaxWidth);
        column = columnModel.getColumn(4);
        column.setHeaderRenderer(headerRenderer);
        column.setHeaderValue(this.targetIcon);
        column.setCellRenderer(cellRenderer);
        column.setMaxWidth(iconColumnMaxWidth);
        column = columnModel.getColumn(5);
        column.setHeaderRenderer(headerRenderer);
        column.setHeaderValue(this.snapIcon);
        column.setCellRenderer(cellRenderer);
        column.setMaxWidth(iconColumnMaxWidth);
        column = columnModel.getColumn(6);
        column.setHeaderRenderer(headerRenderer);
        column.setHeaderValue(this.selectIcon);
        column.setCellRenderer(cellRenderer);
        column.setMaxWidth(iconColumnMaxWidth);
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dataLayerPopupMenuProps = new JMenuItem(MessagesBundle.getMessage("Properties"));
        this.dataLayerPopup.add(this.dataLayerPopupMenuProps);
    }

    public int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    public ListSelectionModel getSelectionModel() {
        return this.table.getSelectionModel();
    }

    public Layer getSelectedLayer() {
        int selRow = this.getSelectedRow();
        if (selRow != -1) {
            return ((EditSessionTableModel)this.table.getModel()).getLayer(selRow);
        }
        return null;
    }

    public int getRowCount() {
        return ((EditSessionTableModel)this.table.getModel()).getRowCount();
    }

    public void tableDataChanged() {
        ((EditSessionTableModel)this.table.getModel()).fireTableDataChanged();
    }

    private class TableHeaderRenderer
    extends DefaultTableCellRenderer {
        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int h = 32;
            GradientPaint paint = new GradientPaint(new Point2D.Double((double)this.getWidth() / 2.0, 0.0), Color.lightGray, new Point2D.Double((double)this.getWidth() / 2.0, this.getHeight()), Color.white);
            g2.setPaint(paint);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setColor(Color.lightGray);
            g2.drawRect(-1, 0, this.getWidth() - 1, this.getHeight() - 1);
            super.paintComponent(g);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTableHeader header;
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table != null && (header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText(null);
                this.setHorizontalAlignment(0);
            } else {
                this.setIcon(null);
                this.setText(value == null ? null : value.toString());
                this.setHorizontalAlignment(2);
            }
            this.setPreferredSize(new Dimension(0, 24));
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            if (column >= 0 && column < EditSessionTablePanel.this.headerTooltip.length) {
                this.setToolTipText(EditSessionTablePanel.this.headerTooltip[column]);
            }
            return this;
        }
    }

    private class DataPanelCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            EditSessionTableModel model = (EditSessionTableModel)table.getModel();
            this.setHorizontalAlignment(0);
            Icon icon = null;
            String txt = null;
            if (value instanceof Icon) {
                icon = (Icon)value;
            } else if (value instanceof String) {
                txt = (String)value;
            } else {
                icon = !model.isCellEditable(row, column) ? EditSessionTablePanel.this.nonselectableImage : ((Boolean)value != false ? EditSessionTablePanel.this.checkboxImage : EditSessionTablePanel.this.uncheckboxImage);
            }
            this.setIcon(icon);
            this.setText(txt);
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(txt == null ? 0 : 2);
            return this;
        }
    }
}

