/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mdeditor.ui.ColorIcon;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class ColorPanel
extends JPanel {
    private JLabel jLabel3 = new JLabel();
    private JSlider jSlider = new JSlider(0, 255);
    private JButton jButton_colorChooser = new JButton();
    private JLabel jLabel_filler = new JLabel();
    private ColorIcon icon = new ColorIcon(48, 16, Color.black);
    private JLabel jLabel5 = new JLabel();
    private JComboBox jComboBox1 = new JComboBox();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel hexLabel = new JLabel();
    private JTextField hexTxt = new JTextField();

    public ColorPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setSize(new Dimension(255, 70));
        this.setPreferredSize(new Dimension(255, 70));
        this.jLabel3.setText(MessagesBundle.getMessage("Label_opacity"));
        this.jSlider.setValue(255);
        this.jSlider.setMaximumSize(new Dimension(150, 24));
        this.jSlider.setMinimumSize(new Dimension(120, 24));
        this.jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ColorPanel.this.jSlider_stateChanged(e);
            }
        });
        this.jButton_colorChooser.setIcon(this.icon);
        this.jButton_colorChooser.setVerticalTextPosition(0);
        this.jButton_colorChooser.setHorizontalTextPosition(4);
        this.jButton_colorChooser.setToolTipText(MessagesBundle.getFormattedMessage("Tooltip_choose_color", " 0,0,0"));
        this.jButton_colorChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.jButton_colorChooser_actionPerformed(e);
            }
        });
        this.jLabel_filler.setPreferredSize(new Dimension(0, 0));
        this.jLabel5.setText(MessagesBundle.getMessage("Label_color"));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.jComboBox1_actionPerformed(e);
            }
        });
        this.hexLabel.setText(MessagesBundle.getMessage("Label_hexadecimal"));
        this.hexTxt.setToolTipText(MessagesBundle.getMessage("Tooltip_hexadecimal_value"));
        this.hexTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorPanel.this.hexTxt_actionPerformed(e);
            }
        });
        this.add((Component)this.jSlider, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 75, 0, 0), 0, 0));
        this.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 5), 0, 0));
        this.add((Component)this.jButton_colorChooser, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.hexLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 90, 0, 0), 0, 0));
        this.add((Component)this.hexTxt, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 118, 0, 10), 65, 0));
        this.add((Component)this.jLabel_filler, new GridBagConstraints(1, 2, 1, 0, 0.0, 1.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.jLabel5, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.jComboBox1, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 15, 0));
        for (int i = 0; i <= 100; ++i) {
            String value = 100 - i + "%";
            this.jComboBox1.addItem(value);
        }
        this.jComboBox1.setSelectedIndex(0);
        this.updateSlider();
        this.updateHexValue();
    }

    public Color getColor() {
        return this.icon.getColor();
    }

    public Color getColorWithOpacity() {
        Color c = this.icon.getColor();
        if (c == null) {
            return null;
        }
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), this.getColorOpacity());
    }

    public void setColor(Color c) {
        if (c == null) {
            this.icon.setColor(null);
            this.setColorOpacity(255);
            this.jButton_colorChooser.setToolTipText(MessagesBundle.getFormattedMessage("Tooltip_choose_color", " null"));
        } else {
            Color cl = new Color(c.getRed(), c.getGreen(), c.getBlue());
            this.jButton_colorChooser.setToolTipText(MessagesBundle.getFormattedMessage("Tooltip_choose_color", " " + cl.getRed() + "," + cl.getGreen() + "," + cl.getBlue()));
            this.icon.setColor(cl);
            this.jButton_colorChooser.repaint();
            this.setColorOpacity(c.getAlpha());
        }
        this.updateHexValue();
    }

    private void jButton_colorChooser_actionPerformed(ActionEvent e) {
        Color c = null;
        Color fc = this.icon.getColor() != null ? this.icon.getColor() : null;
        c = JColorChooser.showDialog(((Component)e.getSource()).getParent(), MessagesBundle.getMessage("Choose_color"), fc);
        if (c != null) {
            Color cl = new Color(c.getRed(), c.getGreen(), c.getBlue());
            this.jButton_colorChooser.setToolTipText(MessagesBundle.getFormattedMessage("Tooltip_choose_color", " " + cl.getRed() + "," + cl.getGreen() + "," + cl.getBlue()));
            this.icon.setColor(cl);
            this.jButton_colorChooser.repaint();
            this.updateHexValue();
        }
    }

    private void updateColorButton() {
        Color c = this.getColor();
        if (c == null) {
            return;
        }
        c = new Color(c.getRed(), c.getGreen(), c.getBlue());
        this.icon.setColor(c);
        this.jButton_colorChooser.repaint();
    }

    private void jComboBox1_actionPerformed(ActionEvent e) {
        this.updateSlider();
    }

    private void updateSlider() {
        int index = this.jComboBox1.getSelectedIndex();
        int sdvalue = (int)((double)((100 - index) * 255 / 100) + 0.5);
        this.jSlider.setValue(sdvalue);
    }

    private void updateOpacityComboBox() {
        double value = this.jSlider.getValue();
        int cbvalue = (int)(value / 255.0 * 100.0 + 0.5);
        String cbstr = cbvalue + "%";
        this.jComboBox1.setSelectedItem(cbstr);
    }

    public int getColorOpacity() {
        return this.jSlider.getValue();
    }

    public void setColorOpacity(int value) {
        if (value >= 0 && value <= 255) {
            this.jSlider.setValue(value);
            this.updateOpacityComboBox();
        }
    }

    private void jSlider_stateChanged(ChangeEvent e) {
        int opacity = this.jSlider.getValue();
        this.updateOpacityComboBox();
    }

    private void hexTxt_actionPerformed(ActionEvent e) {
        if (this.hexTxt.getText().indexOf("#") != -1) {
            try {
                Color c = Color.decode(this.hexTxt.getText());
                this.icon.setColor(c);
                this.jButton_colorChooser.repaint();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Unable_todecode_hexadecimal"), MessagesBundle.getMessage("Error"), 0);
                this.updateHexValue();
            }
        } else {
            JOptionPane.showMessageDialog(this, MessagesBundle.getMessage("Invalid_hexadecimal_value"), MessagesBundle.getMessage("Error"), 0);
            this.updateHexValue();
        }
    }

    private void updateHexValue() {
        Color c = this.getColor();
        if (c != null) {
            this.hexTxt.setText(StyleUtils.getHexidecimalString((Color)c));
        } else {
            this.hexTxt.setText("");
        }
    }

    public void allowChanges(boolean enable) {
        this.jButton_colorChooser.setEnabled(enable);
        this.hexTxt.setEnabled(enable);
        this.jComboBox1.setEnabled(enable);
        this.jSlider.setEnabled(enable);
    }
}

