/*
 * Decompiled with CFR 0.152.
 */
package oracle.mdeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.JApplet;
import oracle.mdeditor.EditorAppletInfo;
import oracle.mdeditor.ui.LookAndFeelHelper;
import oracle.mdeditor.ui.MainAppPanel;

public class MapEditorApplet
extends JApplet {
    private MainAppPanel mainApp = null;

    @Override
    public void init() {
        LookAndFeelHelper.setupLookAndFeel();
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MapEditorApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void checkForChanges() {
        this.mainApp.checkForChanges();
    }

    private void initComponents() {
        Object[] plugins = null;
        try {
            String pluginParam = this.getParameter("plugins");
            if (pluginParam != null && !pluginParam.isEmpty()) {
                String url = this.getDocumentBase().toString();
                url = url.substring(0, url.indexOf("mapviewer") + 9) + "/editor/plugins";
                String[] sets = pluginParam.split(";");
                plugins = new Object[sets.length * 2];
                String sessionID = this.getParameter("session_id");
                sessionID = sessionID.substring(0, sessionID.lastIndexOf("!"));
                for (int i = 0; i < sets.length; ++i) {
                    String[] a = sets[i].split(":");
                    String mainClass = a[0];
                    String pluginSub = URLEncoder.encode(a[1], "utf-8");
                    URL[] jars = new URL[a.length - 1];
                    jars[0] = new URL(url + "/" + pluginSub + "/" + pluginSub + ".jar;jsessionid=" + sessionID);
                    for (int j = 2; j < a.length; ++j) {
                        jars[j - 1] = new URL(url + "/" + pluginSub + "/" + URLEncoder.encode(a[j], "utf-8") + ";jsessionid=" + sessionID);
                    }
                    plugins[i * 2] = mainClass;
                    plugins[i * 2 + 1] = jars;
                }
            }
        }
        catch (Exception ex) {
            System.err.println("Failed to load plugins. Parameter value:(" + this.getParameter("plugins") + ")");
            ex.printStackTrace();
        }
        EditorAppletInfo bean = new EditorAppletInfo(this);
        this.mainApp = new MainAppPanel(plugins, bean);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainApp, "Center");
        bean.callJSFunction("setEditorLoaded", new Object[0]);
    }
}

