/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.util;

import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import oracle.mapviewer.share.style.ColorStyleModel;
import oracle.mapviewer.share.style.LineStyleModel;
import oracle.mapviewer.share.style.MarkerStyleModel;
import oracle.mapviewer.share.style.StyleModel;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mapviewer.share.style.TextStyleModel;

public class StyleModelUtils {
    public static String defaultColorName = "color_green_black_255";
    public static String defaultLineName = "line_red_1_255";
    public static String defaultMarkerName = "marker_circle_red_black_8_255";
    public static String defaultTextName = "text_Dialog_red_12_false_false";
    private static final Hashtable<String, SimpleMarker> markers = new Hashtable(4);

    public static StyleModel getStyleModel(String name) {
        if (name == null || name.trim().isEmpty()) {
            return null;
        }
        String[] params = name.split("_");
        String styleType = params[0];
        if (styleType.equalsIgnoreCase("color")) {
            if (params.length != 4) {
                return StyleModelUtils.getStyleModel(defaultColorName);
            }
            int opacity = StyleModelUtils.parseInt(params[3], 255);
            Color fillColor = StyleModelUtils.parseColor(params[1], opacity, Color.green);
            Color strokeColor = StyleModelUtils.parseColor(params[2], opacity, Color.black);
            StringBuilder modelName = new StringBuilder("color");
            modelName.append("_" + StyleUtils.getHexidecimalString((Color)fillColor));
            modelName.append("_" + StyleUtils.getHexidecimalString((Color)strokeColor));
            modelName.append("_" + opacity);
            ColorStyleModel stymodel = new ColorStyleModel();
            stymodel.setName(modelName.toString());
            stymodel.setFillColor(fillColor);
            stymodel.setStrokeColor(strokeColor);
            return stymodel;
        }
        if (styleType.equalsIgnoreCase("line")) {
            if (params.length != 4) {
                return StyleModelUtils.getStyleModel(defaultLineName);
            }
            int opacity = StyleModelUtils.parseInt(params[3], 255);
            Color fillColor = StyleModelUtils.parseColor(params[1], opacity, Color.red);
            float lineWidth = StyleModelUtils.parseFloat(params[2], 1.0f);
            StringBuilder modelName = new StringBuilder("line");
            modelName.append("_" + StyleUtils.getHexidecimalString((Color)fillColor));
            modelName.append("_" + lineWidth);
            modelName.append("_" + opacity);
            LineStyleModel stymodel = new LineStyleModel();
            stymodel.setName(modelName.toString());
            stymodel.setFillColor(fillColor);
            stymodel.setLineWidth(lineWidth);
            return stymodel;
        }
        if (styleType.equalsIgnoreCase("marker")) {
            if (params.length != 6) {
                return StyleModelUtils.getStyleModel(defaultMarkerName);
            }
            SimpleMarker marker = StyleModelUtils.parseMarker(params[1], markers.get("circle"));
            int opacity = StyleModelUtils.parseInt(params[5], 255);
            Color fillColor = StyleModelUtils.parseColor(params[2], opacity, Color.red);
            Color strokeColor = StyleModelUtils.parseColor(params[3], opacity, Color.black);
            double markerSize = StyleModelUtils.parseDouble(params[4], 8.0);
            StringBuilder modelName = new StringBuilder("marker");
            modelName.append("_" + marker.toString());
            modelName.append("_" + StyleUtils.getHexidecimalString((Color)fillColor));
            modelName.append("_" + StyleUtils.getHexidecimalString((Color)strokeColor));
            modelName.append("_" + markerSize);
            modelName.append("_" + opacity);
            MarkerStyleModel stymodel = new MarkerStyleModel();
            stymodel.setName(modelName.toString());
            stymodel.setVectorFillColor(fillColor);
            stymodel.setVectorStrokeColor(strokeColor);
            stymodel.setMarkerType(marker.type);
            stymodel.setVector(marker.points);
            stymodel.setMarkerWidth(markerSize);
            return stymodel;
        }
        if (styleType.equalsIgnoreCase("text")) {
            if (params.length != 6) {
                return StyleModelUtils.getStyleModel(defaultTextName);
            }
            String fontName = params[1];
            Color fillColor = StyleModelUtils.parseColor(params[2], 255, Color.red);
            float fontSize = StyleModelUtils.parseFloat(params[3], 12.0f);
            boolean italic = StyleModelUtils.parseBoolean(params[4], false);
            boolean bold = StyleModelUtils.parseBoolean(params[5], false);
            int fontStyle = 0;
            if (italic && bold) {
                fontStyle = 3;
            } else if (italic) {
                fontStyle = 2;
            } else if (bold) {
                fontStyle = 1;
            }
            TextStyleModel stymodel = new TextStyleModel();
            stymodel.setName("");
            stymodel.setColor(fillColor);
            stymodel.setFontSize(fontSize, null);
            stymodel.setFont(new Font(fontName, fontStyle, (int)fontSize));
            return stymodel;
        }
        return StyleModelUtils.getStyleModel(defaultColorName);
    }

    public static StyleModel getDefaultRenderStyle() {
        return StyleModelUtils.getStyleModel(defaultColorName);
    }

    public static StyleModel getDefaultColorStyle() {
        return StyleModelUtils.getStyleModel(defaultColorName);
    }

    public static StyleModel getDefaultLineStyle() {
        return StyleModelUtils.getStyleModel(defaultLineName);
    }

    public static StyleModel getDefaultMarkerStyle() {
        return StyleModelUtils.getStyleModel(defaultMarkerName);
    }

    public static StyleModel getDefaultLabelStyle() {
        return StyleModelUtils.getStyleModel(defaultTextName);
    }

    private static Color parseColor(String str, int opacity, Color defaultColor) {
        Color res = null;
        if (str != null && !str.trim().isEmpty()) {
            res = StyleUtils.getColor((String)str);
            if (res == null && str.toUpperCase().equals("DARKGRAY")) {
                res = Color.darkGray;
            }
            if (res != null && opacity < 255 && opacity >= 0) {
                res = new Color(res.getRed(), res.getGreen(), res.getBlue(), opacity);
            }
        }
        if (res != null) {
            return res;
        }
        return defaultColor;
    }

    private static int parseInt(String str, int defaultInt) {
        try {
            return Integer.parseInt(str);
        }
        catch (Exception ex) {
            return defaultInt;
        }
    }

    private static float parseFloat(String str, float defaultFloat) {
        try {
            return Float.parseFloat(str);
        }
        catch (Exception ex) {
            return defaultFloat;
        }
    }

    private static double parseDouble(String str, double defaultDouble) {
        try {
            return Double.parseDouble(str);
        }
        catch (Exception ex) {
            return defaultDouble;
        }
    }

    private static boolean parseBoolean(String str, boolean defaultBoolean) {
        try {
            return Boolean.parseBoolean(str);
        }
        catch (Exception ex) {
            return defaultBoolean;
        }
    }

    private static SimpleMarker parseMarker(String str, SimpleMarker defaultMarker) {
        SimpleMarker marker = null;
        if (str != null && !str.trim().isEmpty() && (marker = markers.get(str)) == null) {
            try {
                String[] pts = str.split(",");
                double[] points = new double[pts.length];
                for (int i = 0; i < pts.length; ++i) {
                    points[i] = Double.parseDouble(pts[i]);
                }
                marker = new SimpleMarker();
                marker.points = points;
                marker.type = 1;
                marker.name = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (marker != null) {
            return marker;
        }
        return defaultMarker;
    }

    static {
        SimpleMarker m = new SimpleMarker();
        m.points = new double[]{138.0, 123.0, 161.0, 198.0, 100.0, 152.0, 38.0, 198.0, 61.0, 123.0, 0.0, 76.0, 76.0, 76.0, 100.0, 0.0, 123.0, 76.0, 199.0, 76.0};
        m.type = 1;
        m.name = "star";
        markers.put(m.name, m);
        m = new SimpleMarker();
        m.points = new double[]{50.0, 100.0, 100.0, 100.0, 100.0, 120.0, 130.0, 90.0, 100.0, 60.0, 100.0, 80.0, 50.0, 80.0, 50.0, 100.0};
        m.type = 1;
        m.name = "arrow";
        markers.put(m.name, m);
        m = new SimpleMarker();
        m.points = new double[]{0.0, 0.0, 100.0, 100.0};
        m.type = 4;
        m.name = "rect";
        markers.put(m.name, m);
        m = new SimpleMarker();
        m.points = new double[]{0.0, 0.0};
        m.type = 3;
        m.name = "circle";
        markers.put(m.name, m);
    }

    private static class SimpleMarker {
        String name = null;
        double[] points = null;
        int type = -1;

        private SimpleMarker() {
        }

        public String toString() {
            if (this.name != null) {
                return this.name;
            }
            StringBuilder sb = new StringBuilder();
            String sep = "";
            for (double pt : this.points) {
                sb.append(sep + pt);
                sep = ",";
            }
            return sb.toString();
        }
    }
}

