/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import oracle.maps.ui.ColorButton;
import oracle.maps.ui.PredefinedMarker;
import oracle.maps.ui.StyleBean;

public class StylingPanel
extends JPanel {
    StyleBean bean = new StyleBean();
    Image lineColorImage = new BufferedImage(12, 12, 1);
    Image fillColorImage = new BufferedImage(12, 12, 1);
    ImageIcon lineColorIcon = new ImageIcon(this.lineColorImage);
    ImageIcon fillColorIcon = new ImageIcon(this.fillColorImage);
    private JCheckBox alphaCheckBox;
    private JButton fillColorButton;
    private JComboBox jComboBoxMarker;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanelFill;
    private JPanel jPanelLine;
    private JPanel jPanelMarker;
    private JPanel jPanelText;
    private JTabbedPane jTabbedPane;
    private JTextField jTextFieldFillColor;
    private JTextField jTextFieldLineColor;
    private JTextField labelColumnTexField;
    private JButton lineColorButton;
    private JComboBox lineStyleComboBox;

    public StylingPanel() {
        this.updateIconImageColor(Color.red, this.lineColorImage);
        this.updateIconImageColor(Color.blue, this.fillColorImage);
        this.initComponents();
        this.syncFromBean();
    }

    private void updateIconImageColor(Color nc, Image img) {
        Graphics g = img.getGraphics();
        g.setColor(nc);
        g.fillRect(0, 0, 12, 12);
    }

    public StyleBean getBean() {
        return this.bean;
    }

    public void setBean(StyleBean bean) {
        this.bean = bean;
        this.syncFromBean();
    }

    private void syncFromBean() {
        ((ColorButton)this.lineColorButton).setColor(this.bean.getLineColor());
        this.jTextFieldLineColor.setText(this.bean.getLineColorHex());
        ((ColorButton)this.fillColorButton).setColor(this.bean.getFillColor());
        this.jTextFieldFillColor.setText(this.bean.getFillColorHex());
    }

    private void initComponents() {
        this.jTabbedPane = new JTabbedPane();
        this.jPanelLine = new JPanel();
        this.jTextFieldLineColor = new JTextField();
        this.lineColorButton = new ColorButton();
        this.lineStyleComboBox = new JComboBox<ImageIcon>(this.bean.getStrokeThumbnails());
        this.jLabel1 = new JLabel();
        this.jPanelFill = new JPanel();
        this.jLabel2 = new JLabel();
        this.jTextFieldFillColor = new JTextField();
        this.fillColorButton = new ColorButton();
        this.alphaCheckBox = new JCheckBox();
        this.jPanelMarker = new JPanel();
        this.jLabel4 = new JLabel();
        StylingPanel stylingPanel = this;
        this.jComboBoxMarker = new JComboBox<ImageIcon>(stylingPanel.bean.getMarkerThumbnails());
        this.jPanelText = new JPanel();
        this.jLabel3 = new JLabel();
        this.labelColumnTexField = new JTextField();
        this.jPanelLine.setMinimumSize(new Dimension(150, 45));
        this.jTextFieldLineColor.setMinimumSize(new Dimension(70, 22));
        this.jTextFieldLineColor.setPreferredSize(new Dimension(70, 20));
        this.jTextFieldLineColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StylingPanel.this.jTextFieldLineColorActionPerformed(evt);
            }
        });
        this.lineColorButton.setPreferredSize(new Dimension(32, 21));
        this.lineColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StylingPanel.this.lineColorButtonActionPerformed(evt);
            }
        });
        this.lineStyleComboBox.setMinimumSize(new Dimension(110, 22));
        this.lineStyleComboBox.setPreferredSize(new Dimension(125, 20));
        this.lineStyleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StylingPanel.this.lineStyleComboBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Line:");
        GroupLayout jPanelLineLayout = new GroupLayout(this.jPanelLine);
        this.jPanelLine.setLayout(jPanelLineLayout);
        jPanelLineLayout.setHorizontalGroup(jPanelLineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLineLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLineLayout.createSequentialGroup().addGap(27, 27, 27).addComponent(this.lineStyleComboBox, -2, 164, -2).addContainerGap()).addGroup(jPanelLineLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldLineColor, -1, 91, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lineColorButton, -2, 23, -2).addGap(54, 54, 54)))));
        jPanelLineLayout.setVerticalGroup(jPanelLineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLineLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLineLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lineColorButton, -2, -1, -2).addGroup(jPanelLineLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldLineColor, -2, 22, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lineStyleComboBox, -2, -1, -2).addContainerGap(19, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("", new ImageIcon(this.getClass().getResource("/oracle/maps/resources/icons/line.png")), this.jPanelLine);
        this.jLabel2.setText("Fill:");
        this.jTextFieldFillColor.setMinimumSize(new Dimension(70, 22));
        this.jTextFieldFillColor.setPreferredSize(new Dimension(70, 20));
        this.jTextFieldFillColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StylingPanel.this.jTextFieldFillColorActionPerformed(evt);
            }
        });
        this.fillColorButton.setPreferredSize(new Dimension(32, 21));
        this.fillColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StylingPanel.this.fillColorButtonActionPerformed(evt);
            }
        });
        this.alphaCheckBox.setText("translucent");
        this.alphaCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StylingPanel.this.alphaCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanelFillLayout = new GroupLayout(this.jPanelFill);
        this.jPanelFill.setLayout(jPanelFillLayout);
        jPanelFillLayout.setHorizontalGroup(jPanelFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFillLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.alphaCheckBox).addGroup(jPanelFillLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldFillColor, -2, 108, -2).addGap(6, 6, 6).addComponent(this.fillColorButton, -2, 24, -2))).addContainerGap(43, Short.MAX_VALUE)));
        jPanelFillLayout.setVerticalGroup(jPanelFillLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFillLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFillLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.fillColorButton, -2, -1, -2).addGroup(jPanelFillLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldFillColor, -2, 22, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.alphaCheckBox).addContainerGap(20, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("", new ImageIcon(this.getClass().getResource("/oracle/maps/resources/icons/polygon.png")), this.jPanelFill);
        this.jLabel4.setText("Marker:");
        this.jComboBoxMarker.setMinimumSize(new Dimension(50, 30));
        this.jComboBoxMarker.setPreferredSize(new Dimension(50, 35));
        this.jComboBoxMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StylingPanel.this.jComboBoxMarkerActionPerformed(evt);
            }
        });
        GroupLayout jPanelMarkerLayout = new GroupLayout(this.jPanelMarker);
        this.jPanelMarker.setLayout(jPanelMarkerLayout);
        jPanelMarkerLayout.setHorizontalGroup(jPanelMarkerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMarkerLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4).addGap(10, 10, 10).addComponent(this.jComboBoxMarker, -2, 104, -2).addContainerGap(50, Short.MAX_VALUE)));
        jPanelMarkerLayout.setVerticalGroup(jPanelMarkerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMarkerLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMarkerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jComboBoxMarker, -2, 43, -2)).addContainerGap(24, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("", new ImageIcon(this.getClass().getResource("/oracle/maps/resources/icons/point.png")), this.jPanelMarker);
        this.jLabel3.setText("Label column:");
        GroupLayout jPanelTextLayout = new GroupLayout(this.jPanelText);
        this.jPanelText.setLayout(jPanelTextLayout);
        jPanelTextLayout.setHorizontalGroup(jPanelTextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTextLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelColumnTexField, -1, 122, Short.MAX_VALUE).addGap(24, 24, 24)));
        jPanelTextLayout.setVerticalGroup(jPanelTextLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTextLayout.createSequentialGroup().addContainerGap().addGroup(jPanelTextLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.labelColumnTexField, -2, -1, -2)).addContainerGap(47, Short.MAX_VALUE)));
        this.jTabbedPane.addTab("", new ImageIcon(this.getClass().getResource("/oracle/maps/resources/icons/text.png")), this.jPanelText);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 216, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane, -1, 116, Short.MAX_VALUE));
    }

    private void jTextFieldLineColorActionPerformed(ActionEvent evt) {
        String tx = this.jTextFieldLineColor.getText();
        try {
            this.bean.setLineColorHex(tx);
        }
        catch (Exception ex) {
            System.err.println("invalid hex string for line color entered.");
        }
        this.syncFromBean();
    }

    private void lineColorButtonActionPerformed(ActionEvent evt) {
        Color nc = JColorChooser.showDialog(this, "Choose Line/Border color", this.bean.lineColor);
        if (nc != null) {
            this.bean.setLineColorHex(Integer.toHexString(nc.getRGB()).substring(2));
            this.syncFromBean();
        }
    }

    private void lineStyleComboBoxActionPerformed(ActionEvent evt) {
        int idx = this.lineStyleComboBox.getSelectedIndex();
        this.bean.setSelectedStroke(StyleBean.getPredefinedStrokes()[idx]);
    }

    private void jTextFieldFillColorActionPerformed(ActionEvent evt) {
        String tx = this.jTextFieldFillColor.getText();
        try {
            this.bean.setFillColorHex(tx);
        }
        catch (Exception ex) {
            System.err.println("invalid hex string for fill color entered.");
        }
        this.syncFromBean();
    }

    private void fillColorButtonActionPerformed(ActionEvent evt) {
        Color nc = JColorChooser.showDialog(this, "Choose area color", this.bean.fillColor);
        if (nc != null) {
            this.bean.setFillColorHex(Integer.toHexString(nc.getRGB()).substring(2));
            this.syncFromBean();
        }
    }

    private void alphaCheckBoxActionPerformed(ActionEvent evt) {
        this.bean.setTranslucent(this.alphaCheckBox.isSelected());
    }

    private void jComboBoxMarkerActionPerformed(ActionEvent evt) {
        int idx = this.jComboBoxMarker.getSelectedIndex();
        this.bean.setMarker(PredefinedMarker.list[idx]);
    }
}

