/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;
import oracle.maps.ui.IconMarker;
import oracle.maps.ui.PredefinedMarker;

public class StyleBean {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final Stroke STROKE001 = new BasicStroke(1.0f);
    public static final Stroke STROKE002 = new BasicStroke(2.0f, 1, 1);
    public static final Stroke STROKE003 = new BasicStroke(4.0f, 1, 1);
    public static final Stroke STROKE004 = new BasicStroke(8.0f, 1, 1);
    private static final float[] dash1 = new float[]{5.0f, 4.0f};
    public static final Stroke STROKE005 = new BasicStroke(1.0f, 1, 1, 1.0f, dash1, 0.0f);
    public static final Stroke STROKE006 = new BasicStroke(2.0f, 1, 1, 1.0f, dash1, 0.0f);
    private static final float[] dash2 = new float[]{7.0f, 4.0f, 3.0f, 4.0f};
    public static final Stroke STROKE007 = new BasicStroke(1.0f, 0, 1, 1.0f, dash2, 0.0f);
    public static final Stroke STROKE008 = new BasicStroke(2.0f, 0, 1, 1.0f, dash2, 0.0f);
    public static final Stroke[] predefinedStrokes = new Stroke[]{STROKE001, STROKE002, STROKE003, STROKE004, STROKE005, STROKE006, STROKE007, STROKE008};
    public static ImageIcon[] strokeThumbnails = new ImageIcon[predefinedStrokes.length];
    public static ImageIcon[] markerThumbnails = null;
    Color lineColor = Color.black;
    Color fillColor = Color.LIGHT_GRAY;
    Stroke selectedStroke = predefinedStrokes[0];
    boolean translucent;
    String labelColumn = "";
    IconMarker marker = PredefinedMarker.list[0];

    public StyleBean() {
        if (strokeThumbnails[0] == null) {
            StyleBean.generateStrokeThumbnails();
        }
        if (markerThumbnails == null) {
            StyleBean.generateMarkerThumbnails();
        }
    }

    private static void generateStrokeThumbnails() {
        int w = 100;
        int h = 18;
        for (int i = 0; i < predefinedStrokes.length; ++i) {
            BufferedImage img = new BufferedImage(w, h, 2);
            Graphics2D g2 = (Graphics2D)((Image)img).getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setBackground(new Color(0, 0, 0, 0));
            g2.clearRect(0, 0, w, h);
            g2.setColor(Color.black);
            g2.setStroke(predefinedStrokes[i]);
            g2.drawLine(0, h / 2, w, h / 2);
            g2.dispose();
            StyleBean.strokeThumbnails[i] = new ImageIcon(img);
        }
    }

    private static void generateMarkerThumbnails() {
        markerThumbnails = new ImageIcon[PredefinedMarker.getList().length];
        for (int i = 0; i < PredefinedMarker.list.length; ++i) {
            StyleBean.markerThumbnails[i] = PredefinedMarker.list[i].getIcon();
        }
    }

    public String getFillColorHex() {
        return Integer.toHexString(this.fillColor.getRGB()).substring(2);
    }

    public void setFillColorHex(String nc) {
        Color oldC = this.fillColor;
        this.fillColor = Color.decode("0x" + nc);
        this.pcs.firePropertyChange("fill-color", oldC, this.fillColor);
    }

    public Color getFillColor() {
        return this.translucent ? new Color(this.fillColor.getRed(), this.fillColor.getGreen(), this.fillColor.getBlue(), 128) : this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        Color oldC = this.fillColor;
        this.fillColor = fillColor;
        this.pcs.firePropertyChange("fill-color", oldC, fillColor);
    }

    public String getLabelColumn() {
        return this.labelColumn;
    }

    public void setLabelColumn(String labelColumn) {
        String oldLabel = this.labelColumn;
        this.labelColumn = labelColumn;
        this.pcs.firePropertyChange("label-column", oldLabel, labelColumn);
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public String getLineColorHex() {
        return Integer.toHexString(this.lineColor.getRGB()).substring(2);
    }

    public void setLineColorHex(String hex) {
        Color oldC = this.lineColor;
        this.lineColor = Color.decode("0x" + hex);
        this.pcs.firePropertyChange("line-color", oldC, this.lineColor);
    }

    public void setLineColor(Color lineColor) {
        Color oldC = this.lineColor;
        this.lineColor = lineColor;
        this.pcs.firePropertyChange("line-color", oldC, lineColor);
    }

    public void setSelectedStroke(Stroke st) {
        Stroke old = this.selectedStroke;
        this.selectedStroke = st;
        this.pcs.firePropertyChange("stroke", old, this.selectedStroke);
    }

    public Stroke getSelectedStroke() {
        return this.selectedStroke;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public void setTranslucent(boolean translucent) {
        boolean oldTr = this.translucent;
        this.translucent = translucent;
        this.pcs.firePropertyChange("translucent", oldTr, this.translucent);
    }

    public ImageIcon[] getStrokeThumbnails() {
        return strokeThumbnails;
    }

    public static ImageIcon[] getMarkerThumbnails() {
        return markerThumbnails;
    }

    public static Stroke[] getPredefinedStrokes() {
        return predefinedStrokes;
    }

    public IconMarker getMarker() {
        return this.marker;
    }

    public void setMarker(IconMarker marker) {
        IconMarker old = this.marker;
        this.marker = marker;
        this.pcs.firePropertyChange("marker", old, this.marker);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }
}

