/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.tools.configurable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.maps.core.MapCanvas;
import oracle.maps.layer.BasicLayer;
import oracle.mapviewer.share.style.StyleUtils;
import oracle.mdeditor.session.layer.ConfigurableLayer;
import oracle.mdeditor.ui.ColorIcon;
import oracle.mdeditor.ui.resources.MessagesBundle;

public class FeatureSelectionConfigurable
extends BasicLayer
implements ConfigurableLayer {
    public static final String TAG_FEATURESELECTION_CONFIG = "featureSelectionConfigLayer";
    public static final String PROPERTY_MOUSEOVER_FEATURE_COLOR = "oracle.maps.tools.configurable.FeatureSelectionConfigurable.mouseoverFeatureColor";
    public static final String PROPERTY_TARGET_FEATURE_COLOR = "oracle.maps.tools.configurable.FeatureSelectionConfigurable.targetFeatureColor";
    public static final String PROPERTY_NONTARGET_FEATURE_COLOR = "oracle.maps.tools.configurable.FeatureSelectionConfigurable.nontargetFeatureColor";
    public static final String PROPERTY_FEATURE_ELEMENT_COLOR = "oracle.maps.tools.configurable.FeatureSelectionConfigurable.featureElementColor";

    public FeatureSelectionConfigurable(MapCanvas mapCanvas) {
        super(mapCanvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Feature Selection");
        this.properties.setDefaultProperty("oracle.maps.core.Layer.visible", Boolean.toString(true));
        this.properties.setDefaultProperty(PROPERTY_MOUSEOVER_FEATURE_COLOR, StyleUtils.getHexidecimalString((Color)Color.yellow));
        this.properties.setDefaultProperty(PROPERTY_TARGET_FEATURE_COLOR, StyleUtils.getHexidecimalString((Color)Color.magenta));
        this.properties.setDefaultProperty(PROPERTY_NONTARGET_FEATURE_COLOR, StyleUtils.getHexidecimalString((Color)Color.yellow));
        this.properties.setDefaultProperty(PROPERTY_FEATURE_ELEMENT_COLOR, StyleUtils.getHexidecimalString((Color)Color.red));
    }

    @Override
    public JPanel getConfigurationPanel(Component parent) {
        FeatureSelectionPreferencesPanel p = new FeatureSelectionPreferencesPanel(parent);
        return p;
    }

    private Color getColorProperty(String property) {
        try {
            Integer i = Integer.decode(this.getProperty(property));
            return new Color(i);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void setColorProperty(String property, Color c) {
        this.setProperty(property, StyleUtils.getHexidecimalString((Color)c));
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        return true;
    }

    private class FeatureSelectionPreferencesPanel
    extends JPanel {
        private Component parent = null;
        private Color mouseoverFeatureColor = null;
        private Color targetFeatureColor = null;
        private Color nontargetFeatureColor = null;
        private Color featureElementColor = null;

        public FeatureSelectionPreferencesPanel(Component parent) {
            this.parent = parent;
            this.mouseoverFeatureColor = FeatureSelectionConfigurable.this.getColorProperty(FeatureSelectionConfigurable.PROPERTY_MOUSEOVER_FEATURE_COLOR);
            this.targetFeatureColor = FeatureSelectionConfigurable.this.getColorProperty(FeatureSelectionConfigurable.PROPERTY_TARGET_FEATURE_COLOR);
            this.nontargetFeatureColor = FeatureSelectionConfigurable.this.getColorProperty(FeatureSelectionConfigurable.PROPERTY_NONTARGET_FEATURE_COLOR);
            this.featureElementColor = FeatureSelectionConfigurable.this.getColorProperty(FeatureSelectionConfigurable.PROPERTY_FEATURE_ELEMENT_COLOR);
            try {
                this.jbInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void jbInit() throws Exception {
            this.setLayout(new GridBagLayout());
            this.setSize(new Dimension(305, 154));
            JLabel mouseoverFeatureLabel = new JLabel(MessagesBundle.getMessage("Label_pref_mouse_over_color"));
            JButton mouseoverFeatureButton = new JButton(new ColorIcon(32, 16, this.mouseoverFeatureColor));
            mouseoverFeatureButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    FeatureSelectionPreferencesPanel.this.mouseoverFeatureColor = color;
                }
            });
            JLabel targetFeatureLabel = new JLabel(MessagesBundle.getMessage("Label_pref_target_feature_color"));
            JButton targetFeatureButton = new JButton(new ColorIcon(32, 16, this.targetFeatureColor));
            targetFeatureButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    FeatureSelectionPreferencesPanel.this.targetFeatureColor = color;
                }
            });
            JLabel nontargetFeatureLabel = new JLabel(MessagesBundle.getMessage("Label_pref_nontarget_feature_color"));
            JButton nontargetFeatureButton = new JButton(new ColorIcon(32, 16, this.nontargetFeatureColor));
            nontargetFeatureButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    FeatureSelectionPreferencesPanel.this.nontargetFeatureColor = color;
                }
            });
            JLabel featureElementLabel = new JLabel(MessagesBundle.getMessage("Label_pref_feature_element_color"));
            JButton featureElementButton = new JButton(new ColorIcon(32, 16, this.featureElementColor));
            featureElementButton.addActionListener(new ColorIconButtonActionListener(this.parent){

                @Override
                public void colorChanged(Color color) {
                    FeatureSelectionPreferencesPanel.this.featureElementColor = color;
                }
            });
            JButton applyButton = new JButton(MessagesBundle.getMessage("Button_apply"));
            applyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FeatureSelectionConfigurable.this.setColorProperty(FeatureSelectionConfigurable.PROPERTY_MOUSEOVER_FEATURE_COLOR, FeatureSelectionPreferencesPanel.this.mouseoverFeatureColor);
                    FeatureSelectionConfigurable.this.setColorProperty(FeatureSelectionConfigurable.PROPERTY_TARGET_FEATURE_COLOR, FeatureSelectionPreferencesPanel.this.targetFeatureColor);
                    FeatureSelectionConfigurable.this.setColorProperty(FeatureSelectionConfigurable.PROPERTY_NONTARGET_FEATURE_COLOR, FeatureSelectionPreferencesPanel.this.nontargetFeatureColor);
                    FeatureSelectionConfigurable.this.setColorProperty(FeatureSelectionConfigurable.PROPERTY_FEATURE_ELEMENT_COLOR, FeatureSelectionPreferencesPanel.this.featureElementColor);
                }
            });
            int y = 0;
            this.add((Component)mouseoverFeatureLabel, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 13, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)mouseoverFeatureButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.add((Component)targetFeatureLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)targetFeatureButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)nontargetFeatureLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)nontargetFeatureButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)featureElementLabel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)featureElementButton, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)applyButton, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 13, 0, new Insets(15, 0, 0, 0), 0, 0));
        }
    }

    private abstract class ColorIconButtonActionListener
    implements ActionListener {
        Component parent = null;

        public ColorIconButtonActionListener(Component parent) {
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JButton button = (JButton)e.getSource();
            ColorIcon ci = (ColorIcon)button.getIcon();
            Color c = JColorChooser.showDialog(this.parent, MessagesBundle.getMessage("Choose_color"), ci.getColor());
            if (c != null) {
                ci.setColor(c);
                this.colorChanged(c);
            }
        }

        public abstract void colorChanged(Color var1);
    }
}

