/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer.ui;

import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;
import oracle.maps.core.GeoObject;
import oracle.maps.core.HoverableLayer;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManager;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectableLayer;
import oracle.maps.graphics.MapTip;
import oracle.maps.layer.BasicLayer;

public class FeatureTipLayer
extends BasicLayer {
    public static final String PROPERTY_TIPALWAYSON = "oracle.maps.layer.ui.FeatureTipLayer.tipAlwaysOn";
    private Point2D topLeftCorner = new Point2D.Double(0.0, 0.0);
    private MapTip tipper;

    public FeatureTipLayer(MapCanvas canvas) {
        super(canvas);
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Feature Tip Layer");
        this.properties.setDefaultProperty(PROPERTY_TIPALWAYSON, Boolean.toString(false));
        this.tipper = new MapTip();
    }

    @Override
    public void update(long elapsedTime) {
        PointerInfo pi = MouseInfo.getPointerInfo();
        if (pi == null) {
            return;
        }
        Point p = pi.getLocation();
        Point p2 = new Point(p.x, p.y + 25);
        SwingUtilities.convertPointFromScreen(p2, this.canvas);
        this.topLeftCorner.setLocation(p2);
    }

    @Override
    public long render(Graphics2D g) {
        LayerManager selectionLayers = this.canvas.getLayerManager().filterSetByTags(new String[]{"selectionLayer"});
        if (selectionLayers.isEmpty()) {
            return 0L;
        }
        StringBuilder tipperText = new StringBuilder();
        for (Layer l : selectionLayers) {
            GeoObject hoverObj;
            HoverableLayer hoverLayer;
            if (!l.isVisible() || !(l instanceof HoverableLayer) || !(l instanceof SelectableLayer) || (hoverLayer = (HoverableLayer)l).numHovered() == 0 || ((SelectableLayer)l).isSelected(hoverObj = hoverLayer.getHover().get(0)) && !this.isTipAlwaysOn()) continue;
            if (tipperText.length() > 0) {
                tipperText.append(", ");
            }
            tipperText.append(hoverObj.getKey().toString());
        }
        if (tipperText.length() == 0) {
            return 0L;
        }
        AffineTransform oldXfm = g.getTransform();
        g.setTransform(new AffineTransform());
        this.tipper.setText(tipperText.toString());
        long res = this.tipper.render(g, this.topLeftCorner);
        g.setTransform(oldXfm);
        return res;
    }

    public boolean isTipAlwaysOn() {
        return Boolean.parseBoolean(this.getProperty(PROPERTY_TIPALWAYSON));
    }

    public void setTipAlwaysOn(boolean tipAlwaysOn) {
        this.setProperty(PROPERTY_TIPALWAYSON, Boolean.toString(tipAlwaysOn));
    }
}

