/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.layer;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventObject;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;
import oracle.maps.core.Drawable;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.MapRegionEvent;
import oracle.maps.geoobject.GeometryFeature;
import oracle.maps.graphics.AnimatedStroke;
import oracle.maps.layer.BasicLayer;
import oracle.maps.tools.Tool;
import oracle.maps.tools.VertexMoveTool;
import oracle.maps.tools.VertexRemoveTool;
import oracle.maps.util.DynamicVertexSet;
import oracle.maps.util.PropertySupportObject;
import oracle.maps.util.TransformUtils;
import oracle.spatial.geometry.JGeometry;

public class ActiveFeaturesLayer
extends BasicLayer {
    protected DynamicVertexSet vertexHandles = new DynamicVertexSet(4.0);
    private GeoObject vertexFeature = null;
    private Stroke simpleStroke = new BasicStroke(1.0f);
    private Color activeVertexColorCenter = new Color(1, 107, 177, 255);
    private Stroke activeVertexBorderStroke = new BasicStroke(2.0f);
    private int activeVertex = -1;
    private AnimatedStroke animatedStroke = null;
    private AnimatedStroke nontargetAnimatedStroke = null;
    private AnimatedStroke highliteAnimatedStroke = null;
    private JGeometry[] highliteGeoms = null;
    private Point2D snapPoint = null;
    private Color snapVertexColorCenter = new Color(0, 0, 255, 255);
    private Color snapVertexColorBorder = new Color(0, 0, 255);
    private Stroke snapVertexBorderStroke = new BasicStroke(2.0f);
    private Rectangle2D dragBox = null;
    private EventListenerList listenerList = new EventListenerList();
    private Tool tool = null;

    public ActiveFeaturesLayer(MapCanvas canvas) {
        super(canvas);
        Layer l;
        this.properties.setDefaultProperty("oracle.maps.core.Layer.name", "Active Features Layer");
        if (canvas != null && (l = canvas.getLayerManager().getLayerByTag("drawingToolsConfigLayer")) != null && l.getProperties() instanceof PropertySupportObject) {
            this.properties = (PropertySupportObject)l.getProperties();
        }
        this.animatedStroke = new AnimatedStroke(Color.magenta);
        this.animatedStroke.setDash(new float[]{2.0f, 2.0f});
        this.nontargetAnimatedStroke = new AnimatedStroke(Color.yellow);
        this.nontargetAnimatedStroke.setDash(new float[]{4.0f, 4.0f});
        this.nontargetAnimatedStroke.setWidth(3.0f);
        this.highliteAnimatedStroke = new AnimatedStroke(Color.red);
        this.highliteAnimatedStroke.setDash(new float[]{4.0f, 4.0f});
        this.highliteAnimatedStroke.setWidth(3.0f);
    }

    public GeoObject getActiveFeature() {
        return this.vertexFeature;
    }

    @Override
    public boolean handleEvent(EventObject evt) {
        MouseEvent e;
        int id;
        boolean propagate = true;
        if (evt instanceof MouseEvent && (id = (e = (MouseEvent)evt).getID()) == 503) {
            List<GeoObject> hits = this.hitTest(e.getX(), e.getY(), 0);
            if (hits.size() > 0) {
                this.vertexFeature = hits.get(0);
            }
            AffineTransform xfm = this.canvas.getViewportTransform();
            if (this.vertexFeature != null) {
                Drawable drawable = this.vertexFeature.getDrawable(null);
                Point2D.Double p = new Point2D.Double(e.getX(), e.getY());
                double tolerance = 1.22;
                double boxWidth = 4.0;
                Layer l = this.canvas.getLayerManager().getLayerByTag("vertexToolsConfigLayer");
                if (l != null && l.getProperties() instanceof PropertySupportObject) {
                    boxWidth = Integer.parseInt(l.getProperties().getProperty("oracle.maps.tools.configurable.VertexToolsConfigurable.vertexBoxSize"));
                }
                try {
                    AffineTransform inv = xfm.createInverse();
                    inv.transform(p, p);
                    tolerance = TransformUtils.transformMagnitude(45.0, inv);
                    boxWidth = TransformUtils.transformMagnitude(boxWidth, inv);
                }
                catch (NoninvertibleTransformException ex) {
                    ex.printStackTrace();
                }
                this.vertexHandles.setBoxWidth(boxWidth);
                this.vertexHandles.createVertexHandles(drawable, p, (float)tolerance);
                this.activeVertex = this.vertexHandles.hitTest(((Point2D)p).getX(), ((Point2D)p).getY());
            }
        }
        if (this.tool != null) {
            propagate = this.tool.handleEvent(evt);
        }
        return propagate;
    }

    @Override
    public void mapRegionChanged(MapRegionEvent e) {
        this.vertexHandles.clear();
        this.activeVertex = -1;
        this.snapPoint = null;
    }

    @Override
    public void update(long elapsedTime) {
        this.animatedStroke.update(elapsedTime);
        this.nontargetAnimatedStroke.update(elapsedTime);
        this.highliteAnimatedStroke.update(elapsedTime);
    }

    @Override
    public long render(Graphics2D g) {
        List<GeoObject> selected = this.canvas.getLayerManager().getAllSelections();
        if (selected.size() == 0) {
            return 0L;
        }
        AffineTransform xfm = this.canvas.getViewportTransform();
        Layer targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
        Layer l = this.canvas.getLayerManager().getLayerByTag("featureSelectionConfigLayer");
        Color c = null;
        if (l != null && l.getProperties() instanceof PropertySupportObject) {
            c = this.decodeColor(l.getProperties().getProperty("oracle.maps.tools.configurable.FeatureSelectionConfigurable.targetFeatureColor"));
            if (c != null) {
                this.animatedStroke.setColor(c);
            }
            if ((c = this.decodeColor(l.getProperties().getProperty("oracle.maps.tools.configurable.FeatureSelectionConfigurable.nontargetFeatureColor"))) != null) {
                this.nontargetAnimatedStroke.setColor(c);
            }
            if ((c = this.decodeColor(l.getProperties().getProperty("oracle.maps.tools.configurable.FeatureSelectionConfigurable.featureElementColor"))) != null) {
                this.highliteAnimatedStroke.setColor(c);
            }
        }
        for (GeoObject selectedObj : selected) {
            Drawable drawable;
            GeometryFeature vmo;
            if (targetLayer == null || selectedObj.getLayer() == targetLayer) {
                g.setColor(this.animatedStroke.getColor());
                g.setStroke(this.animatedStroke.getStroke());
            } else {
                g.setColor(this.nontargetAnimatedStroke.getColor());
                g.setStroke(this.nontargetAnimatedStroke.getStroke());
            }
            if (this.tool instanceof VertexMoveTool && (targetLayer == null || selectedObj.getLayer() == targetLayer) && (vmo = ((VertexMoveTool)this.tool).getCurrentGeomObject()) != null) {
                selectedObj = vmo;
            }
            if ((drawable = selectedObj.getDrawable(xfm)) == null) continue;
            drawable.draw(g);
        }
        if (this.highliteGeoms != null && this.highliteGeoms.length > 0) {
            g.setColor(this.highliteAnimatedStroke.getColor());
            g.setStroke(this.highliteAnimatedStroke.getStroke());
            for (int hg = 0; hg < this.highliteGeoms.length; ++hg) {
                Drawable ghdraw = Drawable.createDrawable(this.highliteGeoms[hg], xfm);
                if (ghdraw == null) continue;
                ghdraw.draw(g);
            }
        }
        if (this.snapPoint != null) {
            this.drawSnapPoint(g);
        }
        Boolean showVertexes = new Boolean(true);
        l = this.canvas.getLayerManager().getLayerByTag("vertexToolsConfigLayer");
        if (l != null && l.getProperties() instanceof PropertySupportObject) {
            showVertexes = new Boolean(l.getProperties().getProperty("oracle.maps.tools.configurable.VertexToolsConfigurable.showVertexes"));
        }
        if (showVertexes.booleanValue() && this.vertexHandles.size() > 0) {
            if (l != null && l.getProperties() instanceof PropertySupportObject) {
                c = this.decodeColor(l.getProperties().getProperty("oracle.maps.tools.configurable.VertexToolsConfigurable.vertexBoxColor"));
                if (c != null) {
                    g.setColor(c);
                } else {
                    g.setColor(Color.blue);
                }
            } else {
                g.setColor(Color.blue);
            }
            g.setStroke(this.simpleStroke);
            Rectangle2D[] boxes = this.vertexHandles.getBoxes(xfm);
            for (int i = 0; i < boxes.length; ++i) {
                if (i == this.activeVertex) continue;
                g.draw(boxes[i]);
            }
        }
        if (this.dragBox != null) {
            float BOX_BORDER_ALPHA = 0.4f;
            float BOX_BKGND_ALPHA = 0.4f;
            Composite origComposite = g.getComposite();
            g.setColor(Color.BLUE);
            g.setComposite(AlphaComposite.getInstance(3, BOX_BKGND_ALPHA));
            g.fill(this.dragBox);
            g.setComposite(AlphaComposite.getInstance(3, BOX_BORDER_ALPHA));
            g.draw(this.dragBox);
            g.setComposite(origComposite);
        }
        return 0L;
    }

    private void drawActiveVertex(Graphics2D g, Rectangle2D box) {
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.tool instanceof VertexRemoveTool) {
            g.setColor(Color.red);
        } else {
            g.setColor(Color.green);
        }
        g.setStroke(this.activeVertexBorderStroke);
        double cx = box.getCenterX();
        double cy = box.getCenterY();
        double w = box.getWidth();
        double h = box.getHeight();
        g.drawOval((int)(cx - w * 0.5 - 2.0), (int)(cy - h * 0.5 - 2.0), (int)(w + 4.0), (int)(h + 4.0));
        g.setColor(this.activeVertexColorCenter);
        g.setStroke(this.simpleStroke);
        g.drawLine((int)(cx - 2.5), (int)cy, (int)(cx + 2.5), (int)cy);
        g.drawLine((int)cx, (int)(cy - 2.5), (int)cx, (int)(cy + 2.5));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
    }

    private void drawSnapPoint(Graphics2D g) {
        if (this.snapPoint == null) {
            return;
        }
        Object aa = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = this.getColorProperty("oracle.maps.tools.configurable.DrawToolsConfigurable.snapBorderColor");
        g.setColor(color);
        g.setStroke(this.snapVertexBorderStroke);
        Point2D.Double p = new Point2D.Double();
        this.canvas.getViewportTransform().transform(this.snapPoint, p);
        double cx = ((Point2D)p).getX();
        double cy = ((Point2D)p).getY();
        double w = 8.0;
        double h = 8.0;
        g.drawOval((int)(cx - w * 0.5 - 2.0), (int)(cy - h * 0.5 - 2.0), (int)(w + 4.0), (int)(h + 4.0));
        g.setColor(this.snapVertexColorCenter);
        g.setStroke(this.simpleStroke);
        g.drawLine((int)(cx - 2.5), (int)cy, (int)(cx + 2.5), (int)cy);
        g.drawLine((int)cx, (int)(cy - 2.5), (int)cx, (int)(cy + 2.5));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aa);
    }

    @Override
    public List<GeoObject> hitTest(int x, int y, int granularity) {
        Vector<GeoObject> result = new Vector<GeoObject>();
        List<GeoObject> selected = this.canvas.getLayerManager().getAllSelections();
        AffineTransform xfm = this.canvas.getViewportTransform();
        Layer targetLayer = this.canvas.getLayerManager().getLayerByTag("targetLayer");
        for (GeoObject f : selected) {
            Drawable dr;
            if (f.getLayer() != targetLayer || (dr = f.getDrawable(xfm)) == null || !dr.hitTest(new Point2D.Double(x, y), 3.0)) continue;
            result.add(f);
        }
        return result;
    }

    public DynamicVertexSet getVertexHandles() {
        return this.vertexHandles;
    }

    public int getActiveVertex() {
        return this.activeVertex;
    }

    public void setActiveVertex(int activeVertex) {
        this.activeVertex = activeVertex;
    }

    public Point2D getSnapPoint() {
        return this.snapPoint;
    }

    public void setSnapPoint(Point2D snap) {
        this.snapPoint = snap;
    }

    public void setDragBox(Rectangle2D box) {
        this.dragBox = box;
    }

    public void setHighliteGeometries(JGeometry[] geoms) {
        this.highliteGeoms = geoms;
    }

    public void setTool(Tool tool) {
        this.tool = tool;
    }

    private Color getColorProperty(String property) {
        return this.decodeColor(this.getProperty(property));
    }

    private Color decodeColor(String color) {
        Color c = null;
        if (color == null) {
            return null;
        }
        try {
            Integer i = Integer.decode(color);
            c = new Color(i);
        }
        catch (Exception ex) {
            c = null;
        }
        return c;
    }
}

