/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import javax.swing.event.ChangeEvent;

public class MapRegionEvent
extends ChangeEvent {
    public static int TYPE_ZOOMIN = 0;
    public static int TYPE_ZOOMOUT = 1;
    public static int TYPE_PAN = 2;
    private AffineTransform oldXFM = null;
    private AffineTransform newXFM = null;
    private Rectangle2D oldDataWindow = null;
    private Rectangle2D newDataWindow = null;

    public MapRegionEvent(Object src, AffineTransform newXFM, Rectangle2D newDataWindow) {
        this(src, null, newXFM, null, newDataWindow);
    }

    public MapRegionEvent(Object src, AffineTransform oldXFM, AffineTransform newXFM, Rectangle2D oldDataWindow, Rectangle2D newDataWindow) {
        super(src);
        if (oldXFM != null) {
            this.oldXFM = new AffineTransform(oldXFM);
        }
        if (newXFM != null) {
            this.newXFM = new AffineTransform(newXFM);
        }
        if (oldDataWindow != null) {
            this.oldDataWindow = new Rectangle2D.Double();
            this.oldDataWindow.setRect(oldDataWindow);
        }
        if (newDataWindow != null) {
            this.newDataWindow = new Rectangle2D.Double();
            this.newDataWindow.setRect(newDataWindow);
        }
    }

    public AffineTransform getOldViewportTransform() {
        return this.oldXFM;
    }

    public AffineTransform getNewViewportTransform() {
        return this.newXFM;
    }

    public AffineTransform getTransformDifference() {
        AffineTransform diff = null;
        if (this.oldXFM != null && this.newXFM != null) {
            try {
                diff = new AffineTransform(this.oldXFM.createInverse());
                diff.preConcatenate(this.newXFM);
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        return diff;
    }

    public Rectangle2D[] getAffectedAreas() {
        throw new IllegalArgumentException("not implemented");
    }

    public int getType() {
        throw new IllegalArgumentException("not implemented");
    }

    public Rectangle2D getOldDataWindow() {
        return this.oldDataWindow;
    }

    public Rectangle2D getNewDataWindow() {
        return this.newDataWindow;
    }
}

