/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.util.Collection;
import java.util.TreeSet;
import javax.swing.event.ChangeEvent;
import oracle.maps.core.Layer;

public class LayerManagerEvent
extends ChangeEvent {
    public static final int LAYER_ADDED = 0;
    public static final int LAYER_REMOVED = 1;
    public static final int LAYER_POSITION_CHANGED = 2;
    public static final int LAYER_TAGGED = 3;
    public static final int LAYER_UNTAGGED = 4;
    private int type = -1;
    private Layer layer = null;
    private Integer oldPosition = null;
    private Integer newPosition = null;
    private TreeSet<String> tags = null;

    public LayerManagerEvent(Object src, int type, Layer layer, Integer position) {
        super(src);
        this.type = type;
        this.layer = layer;
        this.newPosition = position;
    }

    public LayerManagerEvent(Object src, int type, Layer layer, Integer newPosition, Integer oldPosition) {
        this(src, type, layer, newPosition);
        this.oldPosition = oldPosition;
    }

    public LayerManagerEvent(Object src, int type, Layer layer, Integer position, Collection<String> tags) {
        this(src, type, layer, position);
        this.tags = new TreeSet<String>(tags);
    }

    public int getType() {
        return this.type;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public Integer getOldPosition() {
        return this.oldPosition;
    }

    public Integer getPosition() {
        return this.newPosition;
    }

    public Collection<String> getTags() {
        return this.tags;
    }
}

