/*
 * Decompiled with CFR 0.152.
 */
package oracle.maps.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import oracle.maps.core.EditChangeListener;
import oracle.maps.core.EditableLayer;
import oracle.maps.core.Filter;
import oracle.maps.core.GeoObject;
import oracle.maps.core.HoverableLayer;
import oracle.maps.core.Layer;
import oracle.maps.core.LayerManagerEvent;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectableLayer;
import oracle.maps.core.SelectionEvent;
import oracle.maps.core.SelectionListener;
import oracle.mdeditor.session.layer.LayerProvider;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class LayerManager
implements Collection<Layer>,
EditChangeListener,
SelectionListener,
PropertyChangeListener {
    protected MapCanvas canvas = null;
    protected TreeMap<Integer, LinkedEntry<Integer, Layer>> positionStartMap = new TreeMap();
    protected HashMap<Layer, LinkedEntry<Integer, Layer>> entries = new HashMap();
    protected LinkedEntry<Integer, Layer> header = new LinkedEntry<Object, Object>(null, null, null, null, null);
    protected EventListenerList listenerList = new EventListenerList();
    protected PropertyChangeSupport propChangeSupport = new PropertyChangeSupport(this);

    public LayerManager(MapCanvas canvas) {
        this.setMapCanvas(canvas);
        this.header.previous = this.header;
        this.header.next = this.header.previous;
    }

    public LayerManager(MapCanvas canvas, Collection<? extends Layer> lm) {
        this(canvas);
        this.addAll(lm);
    }

    @Override
    public synchronized boolean add(Layer layer) {
        return this.addLast(layer, null, null, true);
    }

    public synchronized boolean add(Layer layer, Integer position) {
        return this.addLast(layer, position, null, true);
    }

    public synchronized boolean addFirst(Layer layer) {
        return this.addFirst(layer, null, null, true);
    }

    public synchronized boolean addFirst(Layer layer, Integer position) {
        return this.addFirst(layer, position, null, true);
    }

    private synchronized boolean addFirst(Layer layer, Integer position, TreeSet<String> tags, boolean fireEvent) {
        if (layer != null && !this.contains(layer)) {
            if (position == null) {
                position = this.isEmpty() ? Integer.valueOf(1) : this.positionStartMap.firstKey();
            }
            LinkedEntry<Integer, Layer> startPos = this.header;
            Map.Entry<Integer, LinkedEntry<Integer, Layer>> ceiling = this.positionStartMap.ceilingEntry(position);
            if (ceiling != null) {
                startPos = ceiling.getValue();
            }
            if (this.addBefore(position, layer, tags, startPos, fireEvent) != null) {
                return true;
            }
        }
        return false;
    }

    public synchronized boolean addLast(Layer layer) {
        return this.addLast(layer, null, null, true);
    }

    public synchronized boolean addLast(Layer layer, Integer position) {
        return this.addLast(layer, position, null, true);
    }

    private synchronized boolean addLast(Layer layer, Integer position, TreeSet<String> tags, boolean fireEvent) {
        if (layer != null && !this.contains(layer)) {
            if (position == null) {
                position = this.isEmpty() ? Integer.valueOf(1) : this.positionStartMap.lastKey();
            }
            LinkedEntry<Integer, Layer> startPos = this.header;
            Map.Entry<Integer, LinkedEntry<Integer, Layer>> ceiling = this.positionStartMap.higherEntry(position);
            if (ceiling != null) {
                startPos = ceiling.getValue();
            }
            if (this.addBefore(position, layer, tags, startPos, fireEvent) != null) {
                return true;
            }
        }
        return false;
    }

    public synchronized Layer removeFirst() {
        return this.remove(this.header.next, true);
    }

    public synchronized Layer removeFirst(Integer position) {
        return this.remove(this.positionStartMap.get(position), true);
    }

    public synchronized Layer removeLast() {
        return this.remove(this.header.previous, true);
    }

    public synchronized Layer removeLast(Integer position) {
        LinkedEntry<Integer, Layer> high = this.header;
        Map.Entry<Integer, LinkedEntry<Integer, Layer>> mh = this.positionStartMap.higherEntry(position);
        if (mh != null) {
            high = mh.getValue();
        }
        if (!position.equals(high.previous.position)) {
            return null;
        }
        return this.remove(high.previous, true);
    }

    public synchronized Layer get(int i) {
        if (i < 0 || i >= this.size()) {
            throw new IndexOutOfBoundsException("Index [" + i + "] out of bounds 0-" + (this.size() - 1));
        }
        Layer res = null;
        Iterator<Layer> itr = this.iterator();
        for (int c = -1; c < i && itr.hasNext(); ++c) {
            res = itr.next();
        }
        return res;
    }

    public synchronized Layer getFirst() {
        return (Layer)this.header.next.element;
    }

    public synchronized Layer getFirst(Integer position) {
        Layer result = null;
        LinkedEntry<Integer, Layer> e = this.positionStartMap.get(position);
        if (e != null) {
            result = (Layer)e.element;
        }
        return result;
    }

    public synchronized Layer getLast() {
        return (Layer)this.header.previous.element;
    }

    public synchronized Layer getLast(Integer position) {
        LinkedEntry<Integer, Layer> high = this.header;
        Map.Entry<Integer, LinkedEntry<Integer, Layer>> mh = this.positionStartMap.higherEntry(position);
        if (mh != null) {
            high = mh.getValue();
        }
        if (!position.equals(high.previous.position)) {
            return null;
        }
        return (Layer)high.previous.element;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean addAll(Collection<? extends Layer> c) {
        boolean changed = false;
        if (c instanceof LayerManager) {
            void var4_6;
            LayerManager lm = (LayerManager)c;
            LinkedEntry linkedEntry = lm.header.next;
            while (var4_6 != lm.header) {
                if (this.addLast((Layer)var4_6.element, (Integer)var4_6.position, var4_6.tags, true)) {
                    changed = true;
                }
                LinkedEntry linkedEntry2 = var4_6.next;
            }
        } else {
            for (Layer layer : c) {
                if (!this.addLast(layer)) continue;
                changed = true;
            }
        }
        return changed;
    }

    public synchronized boolean tag(Layer layer, String tag) {
        return this.tag(layer, new String[]{tag});
    }

    public synchronized boolean tag(Layer layer, String[] tags) {
        ArrayList<String> added = new ArrayList<String>(tags.length);
        LinkedEntry<Integer, Layer> e = this.entry(layer);
        if (e != null) {
            if (e.tags == null) {
                e.tags = new TreeSet();
            }
            for (String tag : tags) {
                if (!e.tags.add(tag)) continue;
                added.add(tag);
            }
        }
        if (added.size() > 0) {
            this.fireStateChanged(new LayerManagerEvent((Object)this, 3, layer, (Integer)e.position, added));
        }
        return added.size() > 0;
    }

    public synchronized boolean untag(String tag) {
        Iterator<Layer> itr = this.iterator();
        while (itr.hasNext()) {
            this.untag(itr.next(), tag);
        }
        return true;
    }

    public synchronized boolean untag(Layer layer, String tag) {
        return this.untag(layer, new String[]{tag});
    }

    public synchronized boolean untag(Layer layer, String[] tags) {
        ArrayList<String> removed = new ArrayList<String>(tags.length);
        LinkedEntry<Integer, Layer> e = this.entry(layer);
        if (e != null && e.tags != null && e.tags.size() > 0) {
            for (String tag : tags) {
                if (!e.tags.remove(tag)) continue;
                removed.add(tag);
            }
        }
        if (removed.size() > 0) {
            this.fireStateChanged(new LayerManagerEvent((Object)this, 4, layer, (Integer)e.position, removed));
        }
        return removed.size() > 0;
    }

    public synchronized Integer getPosition(Layer layer) {
        Integer res = null;
        LinkedEntry<Integer, Layer> e = this.entry(layer);
        if (e != null) {
            res = (Integer)e.position;
        }
        return res;
    }

    public synchronized Collection<String> getTags(Layer layer) {
        LinkedEntry<Integer, Layer> e = this.entry(layer);
        if (e == null) {
            return null;
        }
        if (e.tags != null) {
            return new TreeSet<String>((SortedSet<String>)e.tags);
        }
        return new TreeSet<String>();
    }

    public synchronized Integer setPositionFirst(Layer layer, Integer position) {
        Integer res = null;
        LinkedEntry<Integer, Layer> e = this.entry(layer);
        if (e != null) {
            res = (Integer)e.position;
            TreeSet<String> tags = e.tags;
            this.remove(e, false);
            this.addFirst(layer, position, tags, false);
            this.fireStateChanged(new LayerManagerEvent((Object)this, 2, layer, position, res));
        }
        return res;
    }

    public synchronized Integer setPositionLast(Layer layer, Integer position) {
        Integer res = null;
        LinkedEntry<Integer, Layer> e = this.entry(layer);
        if (e != null) {
            res = (Integer)e.position;
            TreeSet<String> tags = e.tags;
            this.remove(e, false);
            this.addLast(layer, position, tags, false);
            this.fireStateChanged(new LayerManagerEvent((Object)this, 2, layer, position, res));
        }
        return res;
    }

    public synchronized Integer moveUp(Layer layer, boolean crossPositions) {
        LinkedEntry<Integer, Layer> e = this.entry(layer);
        if (e != null) {
            if (e.previous == this.header) {
                return null;
            }
            if (!((Integer)e.position).equals(e.previous.position)) {
                if (!crossPositions) {
                    return null;
                }
                if (e.next == this.header || !((Integer)e.position).equals(e.next.position)) {
                    this.positionStartMap.remove(e.position);
                } else {
                    this.positionStartMap.put((Integer)e.position, e.next);
                }
            }
            TreeSet<String> myTags = e.tags;
            Integer oldPosition = (Integer)e.position;
            e.element = e.previous.element;
            e.tags = e.previous.tags;
            e.position = e.previous.position;
            e.previous.element = layer;
            e.previous.tags = myTags;
            this.entries.put((Layer)e.element, e);
            this.entries.put((Layer)e.previous.element, e.previous);
            this.fireStateChanged(new LayerManagerEvent((Object)this, 2, layer, (Integer)e.position, oldPosition));
            return (Integer)e.position;
        }
        return null;
    }

    public synchronized Integer moveDown(Layer layer, boolean crossPositions) {
        LinkedEntry<Integer, Layer> e = this.entry(layer);
        if (e != null) {
            if (e.next == this.header) {
                return null;
            }
            if (!((Integer)e.position).equals(e.next.position)) {
                if (!crossPositions) {
                    return null;
                }
                if (e.previous == this.header || !((Integer)e.position).equals(e.previous.position)) {
                    this.positionStartMap.remove(e.position);
                }
                this.positionStartMap.put((Integer)e.next.position, e);
            }
            TreeSet<String> myTags = e.tags;
            Integer oldPosition = (Integer)e.position;
            e.element = e.next.element;
            e.tags = e.next.tags;
            e.position = e.next.position;
            e.next.element = layer;
            e.next.tags = myTags;
            this.entries.put((Layer)e.element, e);
            this.entries.put((Layer)e.next.element, e.next);
            this.fireStateChanged(new LayerManagerEvent((Object)this, 2, layer, (Integer)e.position, oldPosition));
            return (Integer)e.position;
        }
        return null;
    }

    public synchronized LayerManager filterSet(Filter<Layer> filter, int stopAt) {
        LayerManager view = new LayerManager(this.canvas);
        LinkedEntry e = this.header.next;
        while (e != this.header) {
            if (filter.accept((Layer)e.element, new Object[]{e.position, e.tags})) {
                view.addBefore((Integer)e.position, (Layer)e.element, e.tags, view.header, false);
                if (view.size() >= stopAt) break;
            }
            e = e.next;
        }
        return view;
    }

    public synchronized LayerManager filterSet(Filter<Layer> filter) {
        return this.filterSet(filter, Integer.MAX_VALUE);
    }

    public synchronized LayerManager filterSetByTags(String[] tags) {
        return this.filterSet(new TagFilter(tags));
    }

    public synchronized Layer getLayerByTag(String tag) {
        Iterator<Entry> itr = this.entryIterator();
        while (itr.hasNext()) {
            Entry e = itr.next();
            if (!e.getTags().contains(tag)) continue;
            return e.getLayer();
        }
        return null;
    }

    public synchronized Layer getLayerByName(String name) {
        if (name == null) {
            return null;
        }
        Iterator<Entry> itr = this.entryIterator();
        while (itr.hasNext()) {
            Entry e = itr.next();
            if (!e.getLayer().getName().equals(name)) continue;
            return e.getLayer();
        }
        return null;
    }

    public synchronized Layer getLayerByPosition(Integer position) {
        return this.getFirst(position);
    }

    public synchronized ListIterator<Entry> entryIterator(Integer position) {
        LinkedEntry<Integer, Layer> e = this.header;
        Map.Entry<Integer, LinkedEntry<Integer, Layer>> m = this.positionStartMap.ceilingEntry(position);
        if (m != null) {
            e = m.getValue();
        }
        return new EntryIterator(e);
    }

    public synchronized ListIterator<Layer> layerIterator(Integer position) {
        LinkedEntry<Integer, Layer> e = this.header;
        Map.Entry<Integer, LinkedEntry<Integer, Layer>> m = this.positionStartMap.ceilingEntry(position);
        if (m != null) {
            e = m.getValue();
        }
        return new LayerIterator(e);
    }

    public synchronized ListIterator<Entry> entryIterator(Layer layer) {
        return new EntryIterator(this.entry(layer));
    }

    public synchronized ListIterator<Layer> layerIterator(Layer layer) {
        return new LayerIterator(this.entry(layer));
    }

    public synchronized Iterator<Entry> entryIterator() {
        return new EntryIterator(this.header.next);
    }

    public synchronized Iterator<Layer> layerIterator() {
        return new LayerIterator(this.header.next);
    }

    public synchronized Iterator<Entry> descendingEntryIterator() {
        return new DescendingEntryItrtr(this.header);
    }

    public synchronized Iterator<Layer> descendingLayerIterator() {
        return new DescendingItrtr(this.header);
    }

    @Override
    public synchronized Iterator<Layer> iterator() {
        return new LayerIterator(this.header.next);
    }

    public synchronized LayerManager subSet(Integer fromPosition, boolean fromInclusive, Integer toPosition, boolean toInclusive) {
        LayerManager view = new LayerManager(this.canvas);
        if (!this.isEmpty() && fromPosition != null && toPosition != null) {
            Map.Entry<Integer, LinkedEntry<Integer, Layer>> mf;
            Map.Entry<Integer, LinkedEntry<Integer, Layer>> entry = mf = fromInclusive ? this.positionStartMap.ceilingEntry(fromPosition) : this.positionStartMap.higherEntry(fromPosition);
            if (mf == null) {
                return view;
            }
            Map.Entry<Integer, LinkedEntry<Integer, Layer>> mt = toInclusive ? this.positionStartMap.higherEntry(toPosition) : this.positionStartMap.ceilingEntry(toPosition);
            LinkedEntry<Integer, Layer> fromEntry = mf.getValue();
            LinkedEntry<Integer, Layer> toEntry = this.header;
            if (mt != null) {
                toEntry = mt.getValue();
            }
            if (toEntry == this.header || ((Integer)fromEntry.position).compareTo((Integer)toEntry.position) <= 0) {
                LinkedEntry<Integer, Layer> e = fromEntry;
                while (e != toEntry) {
                    view.addBefore((Integer)e.position, (Layer)e.element, e.tags, view.header, false);
                    e = e.next;
                }
            }
        }
        return view;
    }

    public synchronized LayerManager subSet(Integer fromPosition, Integer toPosition) {
        return this.subSet(fromPosition, true, toPosition, false);
    }

    public synchronized LayerManager headSet(Integer toPosition) {
        return this.subSet(this.positionStartMap.firstKey(), true, toPosition, false);
    }

    public synchronized LayerManager headSet(Integer toPosition, boolean inclusive) {
        return this.subSet(this.positionStartMap.firstKey(), true, toPosition, inclusive);
    }

    public synchronized LayerManager tailSet(Integer fromPosition) {
        return this.subSet(fromPosition, true, this.positionStartMap.lastKey(), true);
    }

    public synchronized LayerManager tailSet(Integer fromPosition, boolean inclusive) {
        return this.subSet(fromPosition, inclusive, this.positionStartMap.lastKey(), true);
    }

    @Override
    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LayerManager) {
            LayerManager lm = (LayerManager)o;
            if (this.size() != lm.size()) {
                return false;
            }
            LinkedEntry e = this.header.next;
            LinkedEntry s = lm.header.next;
            while (e != this.header && s != lm.header) {
                if (!((Integer)e.position).equals(s.position) || !((Layer)e.element).equals(s.element) || e.tags == null ^ s.tags == null || e.tags != null && !e.tags.equals(s.tags)) {
                    return false;
                }
                e = e.next;
                s = s.next;
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        LinkedEntry<Integer, Layer> e = this.header.next;
        while (e != this.header) {
            LinkedEntry next = e.next;
            this.remove(e, true);
            e = next;
        }
        this.header.next = this.header;
        this.header.previous = this.header;
        this.positionStartMap.clear();
        this.entries.clear();
    }

    @Override
    public synchronized boolean contains(Object o) {
        return this.entry(o) != null;
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public synchronized boolean remove(Object o) {
        LinkedEntry<Integer, Layer> e = this.entry(o);
        return this.remove(e, true) != null;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        boolean changed = false;
        LinkedEntry e = this.header.next;
        while (e != this.header) {
            if (!c.contains(e.element)) {
                this.remove(e);
                changed = true;
            }
            e = e.next;
        }
        return changed;
    }

    @Override
    public synchronized int size() {
        return this.entries.size();
    }

    public synchronized Layer[] toArray() {
        Layer[] result = new Layer[this.size()];
        int i = 0;
        LinkedEntry e = this.header.next;
        while (e != this.header) {
            result[i++] = (Layer)e.element;
            e = e.next;
        }
        return result;
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        if (a.length < this.size()) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int i = 0;
        T[] result = a;
        LinkedEntry e = this.header.next;
        while (e != this.header) {
            result[i++] = e.element;
            e = e.next;
        }
        if (a.length > this.size()) {
            a[this.size()] = null;
        }
        return a;
    }

    public synchronized void clearAllHover() {
        for (Layer l : this) {
            if (!(l instanceof HoverableLayer)) continue;
            ((HoverableLayer)l).clearHover();
        }
    }

    public synchronized void clearAllSelections() {
        for (Layer l : this) {
            if (!(l instanceof SelectableLayer)) continue;
            ((SelectableLayer)l).clearSelection();
        }
    }

    public synchronized List<GeoObject> getAllSelections() {
        Vector<GeoObject> res = new Vector<GeoObject>();
        for (Layer l : this) {
            if (!(l instanceof SelectableLayer)) continue;
            res.addAll(((SelectableLayer)l).getSelection());
        }
        return res;
    }

    public synchronized Element toXMLElement() {
        XMLDocument doc = new XMLDocument();
        doc.setXmlVersion("1.0");
        Element root = doc.createElement("layerManager");
        doc.appendChild((Node)root);
        int order = 0;
        Iterator<Entry> itr = this.entryIterator();
        while (itr.hasNext()) {
            Entry e = itr.next();
            Element layerElem = doc.createElement("entry");
            root.appendChild(layerElem);
            String provID = e.getLayer().getProviderID();
            if (provID != null) {
                layerElem.setAttribute("providerID", e.getLayer().getProviderID());
            }
            layerElem.setAttribute("order", "" + order++);
            layerElem.setAttribute("position", e.getPosition().toString());
            for (String tag : e.getTags()) {
                Element tagElem = doc.createElement("tag");
                Text tagTxt = doc.createTextNode(tag);
                tagElem.appendChild(tagTxt);
                layerElem.appendChild(tagElem);
            }
            layerElem.appendChild(doc.adoptNode((Node)e.getLayer().toXMLElement()));
        }
        return root;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        int order = 0;
        Iterator<Entry> itr = this.entryIterator();
        while (itr.hasNext()) {
            Entry e = itr.next();
            sb.append("Order: " + order++ + "\n");
            sb.append("Position: " + e.getPosition() + "\n");
            sb.append("Layer:" + e.getLayer().getName() + "\n");
            sb.append("Tags: ");
            for (String tag : e.getTags()) {
                sb.append(tag + ", ");
            }
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    public void fromXMLElement(Element element, Map<String, LayerProvider> layerProviders) {
        int i;
        this.clear();
        if (element == null || layerProviders == null || layerProviders.size() == 0) {
            return;
        }
        NodeList layerNodeList = element.getChildNodes();
        LinkedEntry[] layerEntries = new LinkedEntry[layerNodeList.getLength()];
        for (i = 0; i < layerNodeList.getLength(); ++i) {
            LinkedEntry<Integer, Layer> entry;
            Node layerNode = layerNodeList.item(i);
            NamedNodeMap attrs = layerNode.getAttributes();
            Integer position = Integer.parseInt(attrs.getNamedItem("position").getTextContent());
            int order = Integer.parseInt(attrs.getNamedItem("order").getTextContent());
            String[] tagArray = attrs.getNamedItem("tags").getTextContent().split(";");
            TreeSet<String> tags = new TreeSet<String>();
            for (String tag : tagArray) {
                tags.add(tag);
            }
            Element layerDefinition = (Element)layerNode.getFirstChild();
            String providerID = attrs.getNamedItem("providerID").getTextContent();
            LayerProvider provider = layerProviders.get(providerID);
            Layer layer = provider.createLayer(layerDefinition);
            layerEntries[order] = entry = new LinkedEntry<Integer, Layer>(position, layer, tags, null, null);
            this.entries.put(layer, entry);
        }
        for (i = 0; i < layerEntries.length; ++i) {
            LinkedEntry e = layerEntries[i];
            this.addLast((Layer)e.element, (Integer)e.position);
            this.tag((Layer)e.element, e.tags.toArray(new String[e.tags.size()]));
        }
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        PropertyChangeSupport pc = new PropertyChangeSupport(evt.getSource());
        for (PropertyChangeListener listener : this.propChangeSupport.getPropertyChangeListeners()) {
            pc.addPropertyChangeListener(listener);
        }
        pc.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.propChangeSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.propChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void selectionChanged(SelectionEvent evt) {
        this.fireSelectionChanged(evt);
    }

    public synchronized void addSelectionListener(SelectionListener l) {
        this.listenerList.add(SelectionListener.class, l);
    }

    public synchronized void removeSelectionListener(SelectionListener l) {
        this.listenerList.remove(SelectionListener.class, l);
    }

    protected synchronized void fireSelectionChanged(SelectionEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SelectionListener.class) continue;
            ((SelectionListener)listeners[i + 1]).selectionChanged(evt);
        }
    }

    @Override
    public void editStateChanged(ChangeEvent e) {
        this.fireEditStateChanged(e);
    }

    public synchronized void addEditChangeListener(EditChangeListener l) {
        this.listenerList.add(EditChangeListener.class, l);
    }

    public synchronized void removeEditChangeListener(EditChangeListener l) {
        this.listenerList.remove(EditChangeListener.class, l);
    }

    protected synchronized void fireEditStateChanged(ChangeEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditChangeListener.class) continue;
            ((EditChangeListener)listeners[i + 1]).editStateChanged(evt);
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected synchronized void fireStateChanged(ChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (event == null) {
                event = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(event);
        }
    }

    private synchronized Layer remove(LinkedEntry<Integer, Layer> e, boolean fireEvent) {
        if (e == null || e == this.header || this.size() == 0) {
            return null;
        }
        Integer position = (Integer)e.position;
        Layer result = (Layer)e.element;
        TreeSet<String> tags = e.tags;
        if (e == this.positionStartMap.get(position)) {
            if (((Integer)e.position).equals(e.next.position)) {
                this.positionStartMap.put(position, e.next);
            } else {
                this.positionStartMap.remove(position);
            }
        }
        this.entries.remove(result);
        e.previous.next = e.next;
        e.next.previous = e.previous;
        e.previous = null;
        e.next = null;
        e.position = null;
        e.element = null;
        e.tags = null;
        if (fireEvent) {
            result.removePropertyChangeListener(this);
            if (result instanceof SelectableLayer) {
                ((SelectableLayer)result).removeSelectionListener(this);
            }
            if (result instanceof EditableLayer) {
                ((EditableLayer)result).removeEditChangeListener(this);
            }
            result.removed(this.canvas);
            this.fireStateChanged(new LayerManagerEvent((Object)this, 1, result, position, tags));
        }
        return result;
    }

    private synchronized LinkedEntry<Integer, Layer> entry(Object o) {
        if (this.size() > 0 && o instanceof Layer) {
            return this.entries.get(o);
        }
        return null;
    }

    private synchronized LinkedEntry<Integer, Layer> addBefore(Integer position, Layer layer, TreeSet<String> tags, LinkedEntry<Integer, Layer> entry, boolean fireEvent) {
        if (position == null || layer == null) {
            return null;
        }
        LinkedEntry<Integer, Layer> newEntry = new LinkedEntry<Integer, Layer>(position, layer, tags, entry, entry.previous);
        newEntry.previous.next = newEntry;
        newEntry.next.previous = newEntry;
        LinkedEntry<Integer, Layer> startPos = this.positionStartMap.get(position);
        if (startPos == null || entry == startPos && position.equals(entry.position)) {
            this.positionStartMap.put(position, newEntry);
        }
        this.entries.put(layer, newEntry);
        MapCanvas oldParent = layer.getCanvas();
        if (!this.canvas.equals(oldParent) && oldParent != null) {
            oldParent.getLayerManager().remove(layer);
        }
        if (fireEvent) {
            layer.addPropertyChangeListener(this);
            if (layer instanceof SelectableLayer) {
                ((SelectableLayer)layer).addSelectionListener(this);
            }
            if (layer instanceof EditableLayer) {
                ((EditableLayer)layer).addEditChangeListener(this);
            }
            layer.added(this.canvas);
            this.fireStateChanged(new LayerManagerEvent(this, 0, layer, position));
        }
        return newEntry;
    }

    public MapCanvas getMapCanvas() {
        return this.canvas;
    }

    public void setMapCanvas(MapCanvas canvas) {
        if (canvas == null) {
            throw new IllegalArgumentException("canvas is null");
        }
        this.canvas = canvas;
    }

    private class NameFilter
    implements Filter<Layer> {
        private String name = null;

        public NameFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean accept(Layer l, Object[] p) {
            return l.getName() != null && l.getName().equals(this.name);
        }
    }

    private class TagFilter
    implements Filter<Layer> {
        private String[] tags = null;

        public TagFilter(String[] tags) {
            this.tags = tags;
        }

        public TagFilter(String tag) {
            this.tags = new String[]{tag};
        }

        @Override
        public boolean accept(Layer l, Object[] p) {
            if (p[1] == null) {
                return false;
            }
            TreeSet pt = (TreeSet)p[1];
            for (String tag : this.tags) {
                if (pt.contains(tag)) continue;
                return false;
            }
            return true;
        }
    }

    private class DescendingItrtr
    extends LayerIterator {
        public DescendingItrtr(LinkedEntry<Integer, Layer> linkedEntry) {
            super(linkedEntry);
        }

        @Override
        public boolean hasNext() {
            return super.hasPrevious();
        }

        @Override
        public Layer next() {
            return super.previous();
        }

        @Override
        public boolean hasPrevious() {
            return super.hasNext();
        }

        @Override
        public Layer previous() {
            return super.next();
        }
    }

    private class DescendingEntryItrtr
    extends EntryIterator {
        public DescendingEntryItrtr(LinkedEntry<Integer, Layer> linkedEntry) {
            super(linkedEntry);
        }

        @Override
        public boolean hasNext() {
            return super.hasPrevious();
        }

        @Override
        public Entry next() {
            return super.previous();
        }

        @Override
        public boolean hasPrevious() {
            return super.hasNext();
        }

        @Override
        public Entry previous() {
            return super.next();
        }
    }

    private class LayerIterator
    implements ListIterator<Layer> {
        EntryIterator itr = null;

        public LayerIterator(LinkedEntry<Integer, Layer> linkedEntry) {
            this.itr = new EntryIterator(linkedEntry);
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Layer next() {
            return this.itr.next().getLayer();
        }

        @Override
        public boolean hasPrevious() {
            return this.itr.hasPrevious();
        }

        @Override
        public Layer previous() {
            return this.itr.previous().getLayer();
        }

        @Override
        public void set(Layer e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Layer e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    implements ListIterator<Entry> {
        LinkedEntry<Integer, Layer> next = null;

        public EntryIterator(LinkedEntry<Integer, Layer> linkedEntry) {
            this.next = linkedEntry;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next != LayerManager.this.header;
        }

        @Override
        public Entry next() {
            Entry result = new Entry(this.next);
            this.next = this.next.next;
            return result;
        }

        @Override
        public boolean hasPrevious() {
            return this.next != null && this.next.previous != LayerManager.this.header;
        }

        @Override
        public Entry previous() {
            Entry result = new Entry(this.next.previous);
            this.next = this.next.previous;
            return result;
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Entry e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Entry e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class LinkedEntry<P, Q> {
        LinkedEntry<P, Q> previous = null;
        LinkedEntry<P, Q> next = null;
        P position = null;
        Q element = null;
        TreeSet<String> tags = null;

        LinkedEntry(P position, Q element, TreeSet<String> tags, LinkedEntry<P, Q> next, LinkedEntry<P, Q> previous) {
            this.position = position;
            this.element = element;
            this.tags = tags;
            this.next = next;
            this.previous = previous;
        }
    }

    public static final class Entry {
        private final LinkedEntry<Integer, Layer> e;

        public Entry(LinkedEntry<Integer, Layer> e) {
            this.e = e;
        }

        public Integer getPosition() {
            return (Integer)this.e.position;
        }

        public Layer getLayer() {
            return (Layer)this.e.element;
        }

        public Collection<String> getTags() {
            return this.e.tags == null ? new TreeSet<String>() : new TreeSet<String>((SortedSet<String>)this.e.tags);
        }
    }
}

