/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.util.Iterator;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.x3p.X3PHandler;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.impl.Event;

class X3PReaderAdaptor
implements X3PReader,
Iterable<X3PReader> {
    private final Iterator<Event> eventIterator;
    private X3PHandler handler;

    private X3PReaderAdaptor(Iterator<Event> eventIterator) {
        this.eventIterator = eventIterator;
    }

    @Override
    public void close() {
        Closeables.close(this.eventIterator);
    }

    @Override
    public X3PHandler getHandler() {
        return this.handler;
    }

    @Override
    public Iterator<X3PReader> iterator() {
        return new ReaderIterator();
    }

    @Override
    public boolean next() {
        if (this.eventIterator.hasNext()) {
            this.eventIterator.next().invoke(this.handler);
            return true;
        }
        return false;
    }

    @Override
    public void setHandler(X3PHandler handler) {
        this.handler = handler;
    }

    public String toString() {
        return this.eventIterator.toString();
    }

    private X3PReader asReader() {
        return this;
    }

    public static Iterable<X3PReader> compose(X3PReader reader) {
        if (reader instanceof X3PReaderAdaptor) {
            return (Iterable)X3PReaderAdaptor.class.cast(reader);
        }
        throw new RuntimeException("Cannot compose: " + reader.getClass());
    }

    public static Iterator<Event> unwrap(Iterable<X3PReader> reader) {
        if (reader instanceof X3PReaderAdaptor) {
            return ((X3PReaderAdaptor)reader).eventIterator;
        }
        Iterator<X3PReader> iter = reader.iterator();
        if (iter instanceof ReaderIterator) {
            return ((ReaderIterator)iter).eventIterator();
        }
        return new CompoundIterator(iter);
    }

    public static Iterable<X3PReader> wrap(Iterator<Event> eventIterator) {
        return new X3PReaderAdaptor(eventIterator);
    }

    private static Iterator<Event> unwrap(X3PReader r) {
        if (r instanceof X3PReaderAdaptor) {
            return ((X3PReaderAdaptor)r).eventIterator;
        }
        throw new RuntimeException("Cannot unwrap: " + r.getClass());
    }

    private final class ReaderIterator
    implements Iterator<X3PReader> {
        private boolean done = false;

        private ReaderIterator() {
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public X3PReader next() {
            this.done = true;
            return X3PReaderAdaptor.this.asReader();
        }

        @Override
        public void remove() {
        }

        private Iterator<Event> eventIterator() {
            return X3PReaderAdaptor.this.eventIterator;
        }
    }

    private static final class CompoundIterator
    extends AbstractIterator<Event> {
        private Iterator<Event> current;
        private final Iterator<X3PReader> elements;
        private boolean end = false;

        public CompoundIterator(Iterator<X3PReader> elements) {
            this.elements = elements;
        }

        public void close() {
            if (this.current != null) {
                Closeables.close(this.current);
            }
            while (this.elements.hasNext()) {
                Closeables.close(this.elements.next());
            }
            Closeables.close(this.elements);
        }

        public String toString() {
            return this.elements.toString();
        }

        @Override
        protected final Event advance() {
            Event e = null;
            while (!this.end && e == null) {
                while (this.current == null || !this.current.hasNext()) {
                    if (this.current != null) {
                        Closeables.close(this.current);
                    }
                    if (this.elements.hasNext()) {
                        this.current = X3PReaderAdaptor.unwrap(this.elements.next());
                        continue;
                    }
                    this.end = true;
                    this.close();
                    break;
                }
                if (this.current == null) continue;
                e = this.current.next();
            }
            return e;
        }
    }
}

