/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.servlet.ServletResponse;

public abstract class Text {
    private static final char[] AMPERSAND = "&amp;".toCharArray();
    private static final String COMMA_DELIMITED = "\\s*,\\s*";
    private static final String DEFAULT = "UTF-8";
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final char[] DOUBLE_QUOTE = "&quot;".toCharArray();
    private static final String[] EMPTY = new String[0];
    private static final String ESCAPED_QUOTED = "\\\"";
    private static final char[] GREATER_THAN = "&gt;".toCharArray();
    private static final char[] LESS_THAN = "&lt;".toCharArray();
    private static final char[] QUOTE = "&#x27;".toCharArray();
    private static final String QUOTED = "\"";
    private static final char[] SLASH = "&#x2F;".toCharArray();
    private static final String SPACE_DELIMITED = "\\s+";

    private Text() {
    }

    public static String abbreivate(String text, int maxLength) {
        int length;
        if (text == null) {
            return null;
        }
        if (maxLength < 7) {
            maxLength = 7;
        }
        if ((length = (text = text.trim()).length()) <= maxLength) {
            return text;
        }
        StringBuilder b = new StringBuilder(maxLength);
        b.append(text.substring(0, 3));
        b.append("...");
        int remaining = maxLength - 6;
        b.append(text.substring(length - remaining, length));
        return b.toString();
    }

    public static String[] commaDelimited(String text) {
        String delimiter = COMMA_DELIMITED;
        return Text.delimited(text, COMMA_DELIMITED);
    }

    public static final Charset defaultCharset() {
        return DEFAULT_CHARSET;
    }

    public static final String defaultEncoding() {
        return DEFAULT;
    }

    public static String escapeHtml(CharSequence text) {
        if (text == null) {
            return null;
        }
        char[] unchanged = new char[1];
        StringBuilder b = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); ++i) {
            char c;
            unchanged[0] = c = text.charAt(i);
            char[] escaped = unchanged;
            switch (c) {
                case '&': {
                    escaped = AMPERSAND;
                    break;
                }
                case '<': {
                    escaped = LESS_THAN;
                    break;
                }
                case '>': {
                    escaped = GREATER_THAN;
                    break;
                }
                case '\"': {
                    escaped = DOUBLE_QUOTE;
                    break;
                }
                case '\'': {
                    escaped = QUOTE;
                    break;
                }
                case '/': {
                    escaped = SLASH;
                }
            }
            b.append(escaped);
        }
        return b.toString();
    }

    public static byte[] getBytes(String text) {
        return text.getBytes(DEFAULT_CHARSET);
    }

    public static String quote(String text) {
        StringBuilder b = new StringBuilder(text.length() + 10);
        b.append(QUOTED);
        b.append(text.replace(QUOTED, ESCAPED_QUOTED));
        b.append(QUOTED);
        return b.toString();
    }

    public static Reader reader(InputStream in) {
        return new InputStreamReader(in, DEFAULT_CHARSET);
    }

    public static void setCharacterEncoding(ServletResponse res) {
        String contentType = res.getContentType();
        if (Text.isText(contentType)) {
            res.setCharacterEncoding(DEFAULT);
        }
    }

    public static String[] spaceDelimited(String text) {
        return Text.delimited(text, SPACE_DELIMITED);
    }

    public static String stripSuffix(String text, String suffix) {
        if (text.endsWith(suffix)) {
            return text.substring(0, text.length() - suffix.length());
        }
        return text;
    }

    public static String toString(byte[] bytes) {
        return new String(bytes, DEFAULT_CHARSET);
    }

    public static String upper(String text) {
        if (null == text) {
            return null;
        }
        return text.toUpperCase();
    }

    public static Writer writer(OutputStream out) {
        return new OutputStreamWriter(out, DEFAULT_CHARSET);
    }

    private static String[] delimited(String text, String delimiter) {
        String[] values = EMPTY;
        if (text != null && (values = text.trim().split(delimiter, -1)).length == 1 && values[0].isEmpty()) {
            values = EMPTY;
        }
        return values;
    }

    public static boolean isText(String contentType) {
        return contentType != null && (contentType.startsWith("text/") || contentType.startsWith("application/") && contentType.indexOf("+xml") != -1);
    }
}

