/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.IOStreamsProvider;
import oracle.dbtools.plugin.api.io.IOStreams;

public class StreamCopy {
    private static final IOStreams STREAMS = new IOStreamsProvider();

    public static long drain(InputStream is, OutputStream os) throws IOException {
        return STREAMS.copy(is, os);
    }

    public static long drain(Readable source, Appendable destination) throws IOException {
        return STREAMS.copy(source, destination);
    }

    public static long drain(ReadableByteChannel source, WritableByteChannel destination) throws IOException {
        return STREAMS.copy(source, destination);
    }

    public static InputStream emptyStream() {
        return STREAMS.emptyStream();
    }

    public static boolean isEmptyStream(InputStream stream) {
        return STREAMS.isEmptyStream(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String string(InputStream is) throws IOException {
        try {
            String string = STREAMS.asString(is);
            return string;
        }
        finally {
            Closeables.close(is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String string(Readable r) throws IOException {
        try {
            String string = STREAMS.asString(r);
            return string;
        }
        finally {
            Closeables.close(r);
        }
    }

    public static InputStream toInputStream(CharSequence string) throws IOException {
        return STREAMS.asInputStream(string);
    }

    public static InputStream uncloseable(InputStream in) {
        return STREAMS.uncloseable(in);
    }
}

