/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;

public class SortedProperties
extends Properties {
    private static final EntryComparator COMPARATOR = new EntryComparator();

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        TreeSet<Map.Entry<Object, Object>> sorted = new TreeSet<Map.Entry<Object, Object>>(COMPARATOR);
        sorted.addAll(super.entrySet());
        return sorted;
    }

    @Override
    public synchronized Enumeration<Object> keys() {
        return Iterators.enumeration(this.sortedKeys().iterator());
    }

    @Override
    public Set<Object> keySet() {
        return this.sortedKeys();
    }

    @Override
    public Enumeration<?> propertyNames() {
        Enumeration<?> keys = super.propertyNames();
        TreeSet sorted = new TreeSet();
        while (keys.hasMoreElements()) {
            sorted.add(keys.nextElement());
        }
        return Collections.enumeration(sorted);
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        return super.put(key, value);
    }

    @Override
    public Set<String> stringPropertyNames() {
        Enumeration<Object> keys = super.keys();
        TreeSet<String> sorted = new TreeSet<String>();
        while (keys.hasMoreElements()) {
            sorted.add(keys.nextElement().toString());
        }
        return sorted;
    }

    @Override
    public synchronized String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{");
        b.append(Iterables.join(Iterables.transform(this.sortedKeys(), new Transform<Object, String>(){

            @Override
            public String apply(Object key) {
                StringBuilder b = new StringBuilder();
                Object value = SortedProperties.this.get(key);
                b.append(key);
                b.append("=");
                b.append(value);
                return b.toString();
            }
        }), ", "));
        b.append("}");
        return b.toString();
    }

    private Set<Object> sortedKeys() {
        Enumeration<Object> keys = super.keys();
        TreeSet<Object> sorted = new TreeSet<Object>();
        while (keys.hasMoreElements()) {
            sorted.add(keys.nextElement());
        }
        return sorted;
    }

    private static final class EntryComparator
    implements Comparator<Map.Entry<Object, Object>> {
        private EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
            Comparable k1 = (Comparable)o1.getKey();
            Comparable k2 = (Comparable)o2.getKey();
            return k1.compareTo(k2);
        }
    }
}

