/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;

public abstract class Selectors {
    private Selectors() {
    }

    public static final <E> Selector<E> and(Iterable<Selector<E>> selectors) {
        return new And<E>(selectors);
    }

    public static final <E> Selector<E> and(Selector<E> a, Selector<E> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Selectors.and(Selectors.list(a, b));
    }

    public static final <E> Selector<E> distinct() {
        return new DistinctSelector();
    }

    public static final <E> Selector<E> eq(E rhs) {
        return new Eq((Object)rhs);
    }

    public static final Selector<String> equalsIgnoreCase(String rhs) {
        return new EqualsIgnoreCase(rhs);
    }

    public static final <E extends Comparable<E>> Selector<E> gt(E rhs) {
        return new Gt(rhs, null);
    }

    public static final <E extends Comparable<E>> Selector<E> lt(E rhs) {
        return new Lt(rhs, null);
    }

    public static final <E> Selector<E> not(Selector<E> selector) {
        return new Not(Selectors.list(selector, null));
    }

    public static final <E> Selector<E> or(Iterable<Selector<E>> selectors) {
        return new Or<E>(selectors);
    }

    public static final <E> Selector<E> or(Selector<E> a, Selector<E> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return Selectors.or(Selectors.list(a, b));
    }

    private static <E> List<Selector<E>> list(Selector<E> a, Selector<E> b) {
        ArrayList<Selector<Selector<E>>> items = new ArrayList<Selector<Selector<E>>>();
        if (null != a) {
            items.add(a);
        }
        if (null != b) {
            items.add(b);
        }
        return items;
    }

    private static final class Or<E>
    extends LogicalOperator<E> {
        protected Or(Iterable<Selector<E>> selectors) {
            super("||", selectors);
        }

        @Override
        public Boolean apply(E x) {
            for (Selector selector : this.args) {
                if (!((Boolean)selector.apply(x)).booleanValue()) continue;
                return true;
            }
            return false;
        }
    }

    private static abstract class Operator {
        protected final String op;
        private final Iterable<?> args;

        protected Operator(String op, Iterable<?> args) {
            this.op = op;
            this.args = args;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.op);
            builder.append("(");
            builder.append(Iterables.join(this.args, ","));
            builder.append(")");
            return builder.toString();
        }
    }

    private static final class Not<E>
    extends LogicalOperator<E> {
        private Not(List<Selector<E>> selectors) {
            super("!", selectors);
        }

        @Override
        public Boolean apply(E x) {
            for (Selector selector : this.args) {
                if (!((Boolean)selector.apply(x)).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Lt<E extends Comparable<E>>
    extends ComparisonSelector<E> {
        private Lt(E a) {
            super(a, "<");
        }

        @Override
        public Boolean apply(E l) {
            int c = l.compareTo((Object)this.r);
            return c < 0;
        }

        /* synthetic */ Lt(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    private static abstract class LogicalOperator<E>
    extends Operator
    implements Selector<E> {
        protected final Iterable<Selector<E>> args;

        protected LogicalOperator(String op, Iterable<Selector<E>> selectors) {
            super(op, selectors);
            this.args = selectors;
        }
    }

    private static final class Gt<E extends Comparable<E>>
    extends ComparisonSelector<E> {
        private Gt(E r) {
            super(r, ">");
        }

        @Override
        public Boolean apply(E l) {
            int c = l.compareTo((Object)this.r);
            return c > 0;
        }

        /* synthetic */ Gt(Comparable x0, 1 x1) {
            this(x0);
        }
    }

    private static final class EqualsIgnoreCase
    extends ComparisonSelector<String> {
        private EqualsIgnoreCase(String r) {
            super(r, "equalsIgnoreCase");
        }

        @Override
        public Boolean apply(String l) {
            if (l == null) {
                return this.r == null;
            }
            return l.equalsIgnoreCase((String)this.r);
        }
    }

    private static final class Eq<E>
    extends ComparisonSelector<E> {
        private Eq(E r) {
            super(r, "==");
        }

        @Override
        public Boolean apply(E l) {
            if (l == null) {
                return this.r == null;
            }
            return l.equals(this.r);
        }
    }

    private static class DistinctSelector<E>
    implements Selector<E> {
        private final List<E> existing = new ArrayList();

        private DistinctSelector() {
        }

        @Override
        public Boolean apply(E x) {
            if (this.existing.contains(x)) {
                return false;
            }
            this.existing.add(x);
            return true;
        }
    }

    private static abstract class ComparisonSelector<E>
    extends Operator
    implements Selector<E> {
        protected final E r;

        protected ComparisonSelector(E r, String op) {
            super(op, Arrays.asList(r));
            this.r = r;
        }
    }

    private static final class And<E>
    extends LogicalOperator<E> {
        protected And(Iterable<Selector<E>> selectors) {
            super("&&", selectors);
        }

        @Override
        public Boolean apply(E x) {
            for (Selector selector : this.args) {
                if (((Boolean)selector.apply(x)).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }
}

