/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Timestamps;

public final class PrimitiveTypes {
    private static final List<Class<?>> LITERAL_TYPES = Arrays.asList(Long.TYPE, Double.TYPE, Boolean.TYPE, Integer.TYPE, Byte.TYPE, Short.TYPE, Float.TYPE, Character.TYPE);
    private static final BigDecimal MAX_LONG_WITHOUT_EXPONENT = new BigDecimal(Long.MAX_VALUE);
    private static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final BigInteger MAX_SHORT = BigInteger.valueOf(32767L);
    private static final BigInteger MIN_SHORT = BigInteger.valueOf(-32768L);
    private static final BigInteger MAX_BYTE = BigInteger.valueOf(127L);
    private static final BigInteger MIN_BYTE = BigInteger.valueOf(-32768L);
    private static final String NEGATIVE_INFINITY = Double.toString(Double.NEGATIVE_INFINITY);
    private static final String NOT_A_NUMBER = Double.toString(Double.NaN);
    private static final Pattern NUMERIC = Pattern.compile("^-?[0-9]+(\\.?[0-9]*)?([e|E]?[-|+]?[0-9]*)?$");
    private static final String POSITIVE_INFINITY = Double.toString(Double.POSITIVE_INFINITY);
    private static final List<Class<?>> PRIMITIVE_TYPES = Arrays.asList(String.class, Long.class, Integer.class, Boolean.class, Double.class, Timestamp.class, BigDecimal.class, BigInteger.class, Character.class);

    private PrimitiveTypes() {
    }

    public static Class<?> classOf(String primitiveTypeName) {
        if (primitiveTypeName == null) {
            throw new NullPointerException("primitiveType must not be null");
        }
        Class primitiveType = null;
        if (primitiveTypeName.startsWith("java.lang.")) {
            primitiveTypeName = primitiveTypeName.substring("java.lang.".length());
        } else if (primitiveTypeName.startsWith("java.math.")) {
            primitiveTypeName = primitiveTypeName.substring("java.math.".length());
        } else if (primitiveTypeName.startsWith("java.sql.")) {
            primitiveTypeName = primitiveTypeName.substring("java.sql.".length());
        }
        if ("String".equals(primitiveTypeName)) {
            primitiveType = String.class;
        } else if ("Integer".equals(primitiveTypeName) || "int".equals(primitiveTypeName)) {
            primitiveType = Integer.class;
        } else if ("Long".equals(primitiveTypeName) || "long".equals(primitiveTypeName)) {
            primitiveType = Long.class;
        } else if ("Boolean".equals(primitiveTypeName) || "boolean".equals(primitiveTypeName)) {
            primitiveType = Boolean.class;
        } else if ("Double".equals(primitiveTypeName) || "double".equals(primitiveTypeName)) {
            primitiveType = Double.class;
        } else if ("BigInteger".equals(primitiveTypeName)) {
            primitiveType = BigInteger.class;
        } else if ("BigDecimal".equals(primitiveTypeName)) {
            primitiveType = BigDecimal.class;
        } else if ("Timestamp".equals(primitiveTypeName)) {
            primitiveType = Timestamp.class;
        } else {
            throw new IllegalArgumentException(primitiveTypeName + " is not a supported primitive datatype");
        }
        return primitiveType;
    }

    public static boolean isNumeric(CharSequence text) {
        if (NullOrEmpty.nullOrEmpty(text)) {
            return false;
        }
        boolean isNumeric = NUMERIC.matcher(text).matches();
        if (!isNumeric) {
            String s = text.toString();
            isNumeric = s.equals(POSITIVE_INFINITY) || s.equals(NEGATIVE_INFINITY) || s.equals(NOT_A_NUMBER);
        }
        return isNumeric;
    }

    public static boolean isPrimitive(Object instance) {
        if (instance == null) {
            return false;
        }
        Class<?> type = instance.getClass();
        return PRIMITIVE_TYPES.contains(type);
    }

    public static String string(Boolean value) {
        if (value == null) {
            return null;
        }
        return value != false ? "true" : "false";
    }

    public static String string(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return PrimitiveTypes.string((Boolean)value);
        }
        return value.toString();
    }

    public static <T> T valueOf(CharSequence text, Class<T> primitiveType) {
        PrimitiveTypes.literalValueMustNotBeNull(text, primitiveType);
        Object value = null;
        if (text != null) {
            if (PrimitiveTypes.isAssignable(text, primitiveType)) {
                value = text;
            } else {
                String data = text.toString();
                if (String.class == primitiveType) {
                    value = text;
                } else if (Number.class.isAssignableFrom(primitiveType)) {
                    value = PrimitiveTypes.valueOfNumber(data, primitiveType);
                } else if (Boolean.class == primitiveType || Boolean.TYPE == primitiveType) {
                    value = Boolean.valueOf(data);
                } else if (Timestamp.class == primitiveType) {
                    value = new Timestamp(Timestamps.valueOf(data));
                } else {
                    throw new IllegalArgumentException(primitiveType + " is not a supported primitive datatype");
                }
            }
        }
        return PrimitiveTypes.cast(text, value, primitiveType);
    }

    private static <T> Object valueOfNumber(String data, Class<T> primitiveType) {
        Number value = null;
        if (Double.class == primitiveType || Double.class == primitiveType) {
            value = Double.valueOf(data);
        } else {
            try {
                BigDecimal n = new BigDecimal(data);
                if (BigDecimal.class == primitiveType) {
                    value = n;
                } else if (BigInteger.class == primitiveType) {
                    value = n.toBigIntegerExact();
                } else if (Integer.class == primitiveType || Integer.TYPE == primitiveType) {
                    value = n.intValueExact();
                } else if (Long.class == primitiveType || Long.TYPE == primitiveType) {
                    value = n.longValueExact();
                }
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return value;
    }

    public static <T> T valueOf(Number data, Class<T> primitiveType) {
        PrimitiveTypes.literalValueMustNotBeNull(data, primitiveType);
        Object value = null;
        if (data != null) {
            if (PrimitiveTypes.isAssignable(data, primitiveType)) {
                value = data;
            } else {
                try {
                    value = BigDecimal.class == primitiveType ? PrimitiveTypes.toBigDecimal(data) : (BigInteger.class == primitiveType ? PrimitiveTypes.toBigInteger(data) : (String.class == primitiveType || CharSequence.class == primitiveType ? data.toString() : (data instanceof BigDecimal ? PrimitiveTypes.valueOfBigDecimal((BigDecimal)data, primitiveType) : (data instanceof BigInteger ? PrimitiveTypes.valueOfBigInteger((BigInteger)data, primitiveType) : PrimitiveTypes.valueOfNumber(data, primitiveType)))));
                }
                catch (ArithmeticException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return PrimitiveTypes.cast(data, value, primitiveType);
    }

    private static <T> Object valueOfNumber(Number data, Class<T> primitiveType) {
        Number value = null;
        if (Double.class == primitiveType || Double.TYPE == primitiveType) {
            value = data.doubleValue();
        } else if (Float.class == primitiveType || Float.TYPE == primitiveType) {
            value = Float.valueOf(data.floatValue());
        } else if (Integer.class == primitiveType || Integer.TYPE == primitiveType) {
            value = data.intValue();
        } else if (Long.class == primitiveType || Long.TYPE == primitiveType) {
            value = data.longValue();
        } else if (Short.class == primitiveType || Short.TYPE == primitiveType) {
            value = data.shortValue();
        } else if (Byte.class == primitiveType || Byte.TYPE == primitiveType) {
            value = data.byteValue();
        }
        return value;
    }

    private static <T> Object valueOfBigDecimal(BigDecimal data, Class<T> primitiveType) {
        Number value = null;
        if (Double.class == primitiveType || Double.TYPE == primitiveType) {
            value = data.doubleValue();
        } else if (Float.class == primitiveType || Float.TYPE == primitiveType) {
            value = Float.valueOf(data.floatValue());
        } else if (Integer.class == primitiveType || Integer.TYPE == primitiveType) {
            value = data.intValueExact();
        } else if (Long.class == primitiveType || Long.TYPE == primitiveType) {
            value = data.longValueExact();
        } else if (Short.class == primitiveType || Short.TYPE == primitiveType) {
            value = data.shortValueExact();
        } else if (Byte.class == primitiveType || Byte.TYPE == primitiveType) {
            value = data.byteValueExact();
        }
        return value;
    }

    private static <T> Object valueOfBigInteger(BigInteger data, Class<T> primitiveType) {
        Number value = null;
        if (Double.class == primitiveType || Double.TYPE == primitiveType) {
            value = data.doubleValue();
        } else if (Float.class == primitiveType || Float.TYPE == primitiveType) {
            value = Float.valueOf(data.floatValue());
        } else if (Integer.class == primitiveType || Integer.TYPE == primitiveType) {
            PrimitiveTypes.rangeCheck(data, MIN_INT, MAX_INT);
            value = data.intValue();
        } else if (Long.class == primitiveType || Long.TYPE == primitiveType) {
            PrimitiveTypes.rangeCheck(data, MIN_LONG, MAX_LONG);
            value = data.longValue();
        } else if (Short.class == primitiveType || Short.TYPE == primitiveType) {
            PrimitiveTypes.rangeCheck(data, MIN_SHORT, MAX_SHORT);
            value = data.shortValue();
        } else if (Byte.class == primitiveType || Byte.TYPE == primitiveType) {
            PrimitiveTypes.rangeCheck(data, MIN_BYTE, MAX_BYTE);
            value = data.byteValue();
        }
        return value;
    }

    private static void rangeCheck(BigInteger data, BigInteger min, BigInteger max) {
        if (data.compareTo(max) > 0 || data.compareTo(min) < 0) {
            throw new IllegalArgumentException("Value falls outside range for type");
        }
    }

    public static <T> T valueOf(Object data, Class<T> primitiveType) {
        PrimitiveTypes.literalValueMustNotBeNull(data, primitiveType);
        Object value = null;
        if (data != null) {
            if (PrimitiveTypes.isAssignable(data, primitiveType)) {
                value = data;
            } else if (data instanceof CharSequence) {
                value = PrimitiveTypes.valueOf(data.toString(), primitiveType);
            } else if (data instanceof Number) {
                value = PrimitiveTypes.valueOf((Number)data, primitiveType);
            } else if (data instanceof Date) {
                value = PrimitiveTypes.valueOf((Date)data, primitiveType);
            } else if (data instanceof Boolean) {
                value = PrimitiveTypes.valueOfBoolean(data, primitiveType);
            } else {
                throw new IllegalArgumentException(primitiveType + " is not a supported primitive datatype");
            }
        }
        return PrimitiveTypes.cast(data, value, primitiveType);
    }

    public static <T> T valueOf(Date data, Class<T> primitiveType) {
        PrimitiveTypes.literalValueMustNotBeNull(data, primitiveType);
        Object value = null;
        if (data != null) {
            if (PrimitiveTypes.isAssignable(data, primitiveType)) {
                value = data;
            } else if (Long.class == primitiveType || Long.TYPE == primitiveType) {
                value = data.getTime();
            } else if (String.class == primitiveType || CharSequence.class == primitiveType) {
                value = Timestamps.toString(data.getTime());
            }
        }
        return PrimitiveTypes.cast(data, value, primitiveType);
    }

    private static <T> T cast(Object data, Object value, Class<T> primitiveType) {
        if (data != null && value == null) {
            throw new IllegalArgumentException("Cannot convert from: " + data.getClass() + " to: " + primitiveType);
        }
        Object unchecked = value;
        return (T)unchecked;
    }

    private static <T> boolean isAssignable(Object data, Class<T> primitiveType) {
        return data != null && primitiveType.isAssignableFrom(data.getClass());
    }

    private static void literalValueMustNotBeNull(Object data, Class<?> primitiveType) {
        if (data == null && LITERAL_TYPES.contains(primitiveType)) {
            throw new IllegalArgumentException("Cannot cast a null value to: " + primitiveType);
        }
    }

    private static Object toBigDecimal(Number n) {
        Number value;
        if (n instanceof BigInteger) {
            value = new BigDecimal((BigInteger)n);
        } else if (n instanceof BigDecimal) {
            value = n;
        } else {
            BigDecimal maybeLong = PrimitiveTypes.representableAsLong(n);
            double asDouble = n.doubleValue();
            value = maybeLong == null ? BigDecimal.valueOf(asDouble) : maybeLong;
        }
        return value;
    }

    private static BigDecimal representableAsLong(Number n) {
        if (n instanceof Long || n instanceof Integer || n instanceof Short || n instanceof Byte) {
            return BigDecimal.valueOf(n.longValue());
        }
        return null;
    }

    private static Object toBigInteger(Number n) {
        BigInteger value = n instanceof BigDecimal ? ((BigDecimal)n).toBigIntegerExact() : BigInteger.valueOf(n.longValue());
        return value;
    }

    private static <T> Object valueOfBoolean(Object data, Class<T> primitiveType) {
        Object value = null;
        if (Boolean.class == primitiveType || Boolean.TYPE == primitiveType) {
            value = data;
        } else if (String.class == primitiveType || CharSequence.class == primitiveType) {
            value = Boolean.toString((Boolean)data);
        } else {
            throw new IllegalArgumentException(primitiveType + " is not a supported primitive datatype");
        }
        return value;
    }
}

