/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.PerThreadable;

class PerThread<T>
implements PerThreadable {
    private volatile boolean isSetup = false;
    private final ConcurrentMap<Thread, T> perThread = new ConcurrentHashMap<Thread, T>();

    PerThread() {
    }

    @Override
    public boolean isSetup() {
        return this.isSetup;
    }

    @Override
    public void setup() {
        this.reset();
        this.isSetup = true;
    }

    @Override
    @Deprecated
    public final void setupThread() {
        throw new IllegalStateException();
    }

    @Override
    public void teardown() {
        this.reset();
        this.isSetup = false;
    }

    @Override
    public void teardownThread() {
        Thread thread = Thread.currentThread();
        Object value = this.perThread.get(thread);
        if (value != null) {
            Closeables.close(value);
            this.perThread.remove(thread, value);
        }
    }

    T get() {
        Thread thread = Thread.currentThread();
        Object value = this.perThread.get(thread);
        if (value == null) {
            throw new IllegalStateException("setupThread MUST be called before calling this method");
        }
        return (T)value;
    }

    void setupThread(T value) {
        Thread thread = Thread.currentThread();
        this.perThread.putIfAbsent(thread, value);
    }

    private synchronized void reset() {
        for (Object value : this.perThread.values()) {
            Closeables.close(value);
        }
        this.perThread.clear();
    }
}

