/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.Text;
import oracle.security.misc.Checksum;

public abstract class Passwords {
    private Passwords() {
    }

    public static String comingIn(String value) {
        try {
            byte[] enc = RepConversion.convertHexStringToByte(value);
            byte[] decPwd = Checksum.SHA((byte[])enc, null);
            return Text.toString(decPwd);
        }
        catch (Throwable ex) {
            throw UnrecoverableException.unrecoverable(ex);
        }
    }

    public static String goingOut(String value) {
        try {
            byte[] b = Text.getBytes(value);
            byte[] b2 = Checksum.MD5((byte[])b, null);
            return RepConversion.bArray2String(b2);
        }
        catch (Throwable ex) {
            throw UnrecoverableException.unrecoverable(ex);
        }
    }

    public static String goingOut(char[] text) {
        try {
            ByteBuffer b = Text.defaultCharset().encode(CharBuffer.wrap(text));
            byte[] b2 = Checksum.MD5((byte[])b.array(), null);
            return RepConversion.bArray2String(b2);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static class RepConversion {
        private RepConversion() {
        }

        private static String bArray2String(byte[] array) {
            StringBuffer result = new StringBuffer(array.length * 2);
            for (byte element : array) {
                result.append((char)RepConversion.nibbleToHex((byte)((element & 0xF0) >> 4)));
                result.append((char)RepConversion.nibbleToHex((byte)(element & 0xF)));
            }
            return result.toString();
        }

        private static int convertCharToInt(char charVal) {
            switch (charVal) {
                case '0': {
                    return 0;
                }
                case '1': {
                    return 1;
                }
                case '2': {
                    return 2;
                }
                case '3': {
                    return 3;
                }
                case '4': {
                    return 4;
                }
                case '5': {
                    return 5;
                }
                case '6': {
                    return 6;
                }
                case '7': {
                    return 7;
                }
                case '8': {
                    return 8;
                }
                case '9': {
                    return 9;
                }
                case 'A': 
                case 'a': {
                    return 10;
                }
                case 'B': 
                case 'b': {
                    return 11;
                }
                case 'C': 
                case 'c': {
                    return 12;
                }
                case 'D': 
                case 'd': {
                    return 13;
                }
                case 'E': 
                case 'e': {
                    return 14;
                }
                case 'F': 
                case 'f': {
                    return 15;
                }
            }
            return 48;
        }

        private static byte[] convertHexStringToByte(String refString) {
            byte[] byteArray = new byte[refString.length() / 2];
            for (int i = 0; i < refString.length(); i += 2) {
                int intVal = RepConversion.convertCharToInt(refString.charAt(i));
                Integer newInt = new Integer(0xF0 & intVal << 4);
                byteArray[i / 2] = newInt.byteValue();
                intVal = RepConversion.convertCharToInt(refString.charAt(i + 1));
                newInt = new Integer(0xF & intVal);
                int n = i / 2;
                byteArray[n] = (byte)(byteArray[n] | newInt.byteValue());
            }
            return byteArray;
        }

        private static byte nibbleToHex(byte nibble) {
            return (byte)((nibble = (byte)(nibble & 0xF)) < 10 ? nibble + 48 : nibble - 10 + 65);
        }
    }
}

