/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Comparator;
import oracle.dbtools.common.util.HasOrdering;

public enum Ordering {
    SORTED,
    INSERTION,
    UNSPECIFIED;


    public static boolean equals(HasOrdering<?> a, Ordering bOrdering, Comparator<?> bComparator) {
        return Ordering.equals(a.ordering(), a.comparator(), bOrdering, bComparator);
    }

    public static boolean equals(HasOrdering<?> a, HasOrdering<?> b) {
        Ordering aOrdering = a.ordering();
        Comparator<?> aComparator = a.comparator();
        Ordering bOrdering = b.ordering();
        Comparator<?> bComparator = b.comparator();
        return Ordering.equals(aOrdering, aComparator, bOrdering, bComparator);
    }

    public static boolean equals(Ordering aOrdering, Comparator<?> aComparator, Ordering bOrdering, Comparator<?> bComparator) {
        if (aOrdering == bOrdering) {
            if (SORTED == aOrdering) {
                if (aComparator == null) {
                    return bComparator == null;
                }
                return aComparator.equals(bComparator);
            }
            return true;
        }
        return false;
    }
}

