/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Collections;
import oracle.dbtools.common.util.HasSize;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.common.util.Selectors;
import oracle.dbtools.common.util.Transform;

public class Iterables {
    private Iterables() {
    }

    public static <T> void add(Collection<T> collection, Iterable<? extends T> items) {
        Iterables.add(collection, items, false);
    }

    public static <T> void add(Collection<T> collection, Iterable<? extends T> items, boolean ignoreNulls) {
        Iterators.add(collection, items == null ? null : items.iterator(), ignoreNulls);
    }

    public static <T> List<T> asList(Iterable<? extends T> items) {
        ArrayList list = new ArrayList();
        Iterables.add(list, items);
        return list;
    }

    public static String asString(Iterable<?> items) {
        StringBuilder b = new StringBuilder("[");
        b.append(Iterables.join(items, ", "));
        b.append("]");
        return b.toString();
    }

    public static <T> Iterable<String> asStrings(Iterable<T> items) {
        return Iterables.transform(items, new AsString());
    }

    public static <T> int compare(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        return Iterators.compare(i1.iterator(), i2.iterator());
    }

    public static <T> int compare(Iterable<T> i1, Iterable<T> i2, Comparator<T> comparator) {
        return Iterators.compare(i1.iterator(), i2.iterator(), comparator);
    }

    public static <T> boolean contains(Iterable<? extends T> items, Iterable<? extends T> values) {
        return Iterables.contains(items, new EqualsAnyOf(values));
    }

    public static <T> boolean contains(Iterable<? extends T> items, Selector<? extends T> condition) {
        return null != Iterables.selectFirst(items, condition);
    }

    public static <T> Iterable<T> empty() {
        return java.util.Collections.emptyList();
    }

    public static <T> boolean equals(Iterable<? extends T> i1, Iterable<? extends T> i2) {
        if (null == i1) {
            return null == i2;
        }
        if (i2 == null) {
            return false;
        }
        return Iterators.equals(i1.iterator(), i2.iterator());
    }

    public static final <T> T first(Iterable<T> items) {
        if (items == null) {
            return null;
        }
        return Iterators.nextOrNull(items.iterator());
    }

    public static final <T> Iterable<T> iterable(Iterator<? extends T> items) {
        ArrayList values = new ArrayList();
        Iterators.add(values, items);
        return values;
    }

    public static final <T> Iterable<T> iterable(T ... items) {
        return new ArrayIterable(items);
    }

    public static String join(Iterable<?> items, String separator) {
        return Iterators.join(items.iterator(), separator);
    }

    public static <T> Iterable<T> merge(Iterable<? extends T> existingItems, Iterable<? extends T> items) {
        ArrayList newItems = new ArrayList();
        Iterables.add(newItems, items);
        LinkedHashSet mergedItems = new LinkedHashSet();
        Iterables.add(mergedItems, existingItems);
        for (T existing : existingItems) {
            Iterator n = newItems.iterator();
            while (n.hasNext()) {
                Object newItem = n.next();
                boolean matched = existing == newItem || existing.equals(newItem);
                if (!matched) continue;
                n.remove();
            }
        }
        mergedItems.addAll(newItems);
        return mergedItems;
    }

    public static final <T> Iterable<T> reverse(Deque<T> items) {
        return new ReverseDequeIterable(items);
    }

    public static final <T> Iterable<T> reverse(LinkedList<T> items) {
        return Iterables.reverse(items);
    }

    public static final <T> Iterable<T> reverse(List<T> items) {
        return new ReverseListIterable<T>(items);
    }

    public static final <T> Iterable<T> select(Iterable<? extends T> items, Selector<? extends T> condition) {
        return new SelectedIterator(items, condition);
    }

    public static final <T> T selectFirst(Iterable<? extends T> items, Selector<? extends T> condition) {
        return Iterators.nextOrNull(Iterators.select(items.iterator(), condition));
    }

    public static int size(Iterable<?> items) {
        if (items instanceof Collection) {
            return ((Collection)items).size();
        }
        if (items instanceof HasSize) {
            return ((HasSize)((Object)items)).size();
        }
        int count = 0;
        for (Object item : items) {
            ++count;
        }
        return count;
    }

    public static final <T> Iterable<T> sort(Iterable<T> items, Comparator<T> sortOrder) {
        ArrayList tosort = new ArrayList();
        Iterables.add(tosort, items);
        java.util.Collections.sort(tosort, sortOrder);
        return tosort;
    }

    public static final <T> Iterable<T> subsequent(Iterable<T> items) {
        Iterator<T> iter = items.iterator();
        if (iter.hasNext()) {
            iter.next();
            return new SubsequentIterable(items);
        }
        return Iterables.empty();
    }

    public static final <X, Y> Iterable<Y> transform(Iterable<X> items, Transform<X, Y> transform) {
        return new IterableTransform(items, transform);
    }

    private static final class SubsequentIterable<T>
    implements Iterable<T>,
    HasSize {
        private final Iterable<T> items;

        private SubsequentIterable(Iterable<T> items) {
            this.items = items;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<T> iterator() {
            Iterator<T> iter = this.items.iterator();
            if (iter.hasNext()) {
                iter.next();
                return iter;
            }
            return Iterators.empty();
        }

        @Override
        public int size() {
            int size = Iterables.size(this.items) - 1;
            if (size < 0) {
                size = 0;
            }
            return size;
        }

        public String toString() {
            return Iterables.asString(this);
        }
    }

    private static final class SelectedIterator<T>
    implements Iterable<T> {
        private final Selector<? extends T> condition;
        private final Iterable<? extends T> items;

        private SelectedIterator(Iterable<? extends T> items, Selector<? extends T> condition) {
            this.items = items;
            this.condition = condition;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.select(this.items.iterator(), this.condition);
        }

        public String toString() {
            return "[" + this.items + "," + this.condition + "]";
        }
    }

    private static final class ReverseListIterable<T>
    implements Iterable<T>,
    HasSize,
    Closeable {
        private final List<T> items;

        ReverseListIterable(List<T> items) {
            this.items = items;
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.items);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Iterable) {
                Iterable other = (Iterable)obj;
                return Iterables.equals(this, other);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.items.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.reverseIterator(this.items);
        }

        @Override
        public int size() {
            return this.items.size();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(Iterables.join(this, ", "));
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class ReverseDequeIterable<T>
    implements Iterable<T>,
    HasSize,
    Closeable {
        private final Deque<T> items;

        private ReverseDequeIterable(Deque<T> items) {
            this.items = items;
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.items);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Iterable) {
                Iterable other = (Iterable)obj;
                return Iterables.equals(this, other);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.items.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.items.descendingIterator();
        }

        @Override
        public int size() {
            return this.items.size();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(Iterables.join(this, ", "));
            builder.append("]");
            return builder.toString();
        }
    }

    private static final class IterableTransform<X, Y>
    implements Iterable<Y>,
    HasSize,
    Closeable {
        private final Iterable<X> items;
        private final Transform<X, Y> transform;

        private IterableTransform(Iterable<X> items, Transform<X, Y> transform) {
            this.items = items;
            this.transform = transform;
        }

        @Override
        public void close() throws IOException {
            Closeables.close(this.items);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<Y> iterator() {
            return Iterators.transform(this.items.iterator(), this.transform);
        }

        @Override
        public int size() {
            return Iterables.size(this.items);
        }

        public String toString() {
            return "[" + this.items + "," + this.transform + "]";
        }
    }

    private static final class EqualsAnyOf<T>
    implements Selector<T> {
        private final Iterable<? extends T> values;

        private EqualsAnyOf(Iterable<? extends T> values) {
            this.values = values;
        }

        @Override
        public Boolean apply(T item) {
            return null != Iterables.selectFirst(this.values, Selectors.eq(item));
        }
    }

    private static final class AsString<T>
    implements Transform<T, String> {
        private AsString() {
        }

        @Override
        public String apply(Object x) {
            if (x == null) {
                return null;
            }
            return x.toString();
        }
    }

    private static final class ArrayIterable<T>
    implements Iterable<T>,
    HasSize {
        private final T[] items;

        private ArrayIterable(T[] items) {
            this.items = items;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Iterable) {
                Iterable other = (Iterable)obj;
                return Iterables.equals(this, other);
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return Arrays.hashCode(this.items);
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<T> iterator() {
            return Iterators.iterator(this.items);
        }

        @Override
        public int size() {
            return this.items.length;
        }

        public String toString() {
            return Arrays.toString(this.items);
        }
    }
}

