/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;

public class ChunkedReader<T>
extends Reader {
    private char[] chunk = null;
    private final Iterator<char[]> chunks;
    private int pos = 0;

    public ChunkedReader(Iterator<T> items, Transform<T, char[]> transform) {
        this.chunks = Iterators.transform(items, transform);
        this.chunk = this.nextChunk();
    }

    @Override
    public void close() throws IOException {
        Closeables.close(this.chunks);
    }

    @Override
    public int read(char[] dest, int off, int len) throws IOException {
        int remaining;
        if (this.chunk == null) {
            return -1;
        }
        int count = 0;
        int available = this.chunk.length - this.pos;
        int destPos = off;
        for (remaining = len; available < remaining && this.chunk != null; remaining -= available) {
            System.arraycopy(this.chunk, this.pos, dest, destPos, available);
            count += available;
            destPos += available;
            this.pos = 0;
            this.chunk = this.nextChunk();
            if (this.chunk != null) {
                available = this.chunk.length;
                continue;
            }
            available = 0;
        }
        if (this.chunk != null) {
            System.arraycopy(this.chunk, this.pos, dest, destPos, remaining);
            this.pos += remaining;
            count += remaining;
        }
        return count;
    }

    private char[] nextChunk() {
        char[] chunk = null;
        while (this.chunks.hasNext() && (chunk == null || chunk.length == 0)) {
            chunk = this.chunks.next();
        }
        return chunk;
    }
}

