/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

public abstract class CharSequenceMixin
implements CharSequence {
    private final CharSequence text;

    protected CharSequenceMixin() {
        this.text = null;
    }

    protected CharSequenceMixin(CharSequence text) {
        this.text = text;
    }

    @Override
    public final char charAt(int index) {
        return this.text().charAt(index);
    }

    @Override
    public String toString() {
        if (this.text == null) {
            throw new IllegalStateException(this.getClass() + " must override #toString()");
        }
        return this.text.toString();
    }

    public boolean equals(CharSequence text) {
        return this.text().equals(text.toString());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof CharSequence) {
            return this.equals((CharSequence)obj);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.text().hashCode();
    }

    @Override
    public final int length() {
        return this.text().length();
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        return this.text().subSequence(start, end);
    }

    protected final CharSequence text() {
        CharSequence text = this.text == null ? this.toString() : this.text;
        return text;
    }
}

