/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.tash;

import oracle.dbtools.common.tash.TashTemplate;
import oracle.dbtools.common.tash.TashTemplateImpl;
import oracle.dbtools.common.tash.TashToken;
import oracle.dbtools.common.tash.TokenSequence;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.Lookup;

class TashParser
extends AbstractIterator<TashToken> {
    private final Lookup<TashTemplate> partials;
    private int pos = 0;
    private final String text;
    private static final String CLOSE = "}}";
    private static final String COMMENT_OPEN = "{{!";
    private static final String INVERTED_SECTION_OPEN = "{{^";
    private static final String OPEN = "{{";
    private static final String PARTIAL_OPEN = "{{>";
    private static final String SECTION_CLOSE = "{{/";
    private static final String SECTION_OPEN = "{{#";
    private static final String UNESCAPED_CLOSE = "}}}";
    private static final String UNESCAPED_OPEN = "{{{";

    TashParser(String text, Lookup<TashTemplate> partials) {
        this.text = text;
        if (partials == null) {
            partials = AssociativeArrays.empty();
        }
        this.partials = partials;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.text.replace("\r\n", "\u240d\u2424").replace("\n", "\u2424"));
        builder.append('\n');
        for (int i = 0; i < this.pos; ++i) {
            builder.append(' ');
        }
        builder.append('^');
        builder.append('\n');
        return builder.toString();
    }

    @Override
    protected TashToken advance() {
        TashToken tag = null;
        if (this.pos < this.text.length()) {
            int start = this.pos;
            TashToken.TokenType tagType = this.tagType(start);
            if (tagType == null) {
                tag = this.literal(start);
            } else {
                int end = start;
                TokenSequence name = null;
                TokenSequence section = null;
                TashTemplate template = null;
                switch (tagType) {
                    case COMMENT: {
                        name = this.name(COMMENT_OPEN, CLOSE, start);
                        break;
                    }
                    case VARIABLE: {
                        name = this.name(OPEN, CLOSE, start);
                        break;
                    }
                    case NEW_LINE: {
                        name = this.newline(start);
                        break;
                    }
                    case UNESCAPED_VARIABLE: {
                        name = this.name(UNESCAPED_OPEN, UNESCAPED_CLOSE, start);
                        break;
                    }
                    case PARTIAL: {
                        name = this.name(PARTIAL_OPEN, CLOSE, start);
                        if (name == null) break;
                        template = this.partials.get(name.toString());
                        break;
                    }
                    case SECTION: {
                        name = this.name(SECTION_OPEN, CLOSE, start);
                        if (name == null) break;
                        name = this.scanForSectionWhitespace(name);
                        section = this.section(name, name.end());
                        break;
                    }
                    case INVERTED_SECTION: {
                        name = this.name(INVERTED_SECTION_OPEN, CLOSE, start);
                        if (name == null) break;
                        name = this.scanForSectionWhitespace(name);
                        section = this.section(name, name.end());
                        break;
                    }
                    case LITERAL: {
                        throw new IllegalStateException();
                    }
                }
                if (section == null) {
                    end = name.end();
                } else {
                    template = new TashTemplateImpl(section.toString(), this.partials);
                    end = section.end();
                }
                if (name == null && TashToken.TokenType.NEW_LINE != tagType) {
                    tag = this.literal(start);
                } else {
                    tag = new TashToken(tagType, name, template);
                    this.pos = end;
                }
            }
        }
        return tag;
    }

    private boolean isInvertedSection(int start) {
        return this.isStandaloneTag(INVERTED_SECTION_OPEN, start);
    }

    private boolean isNewline(int start) {
        char c = this.text.charAt(start);
        return c == '\r' && this.text.charAt(start + 1) == '\n' || c == '\n';
    }

    private boolean isSection(int start) {
        return this.isStandaloneTag(SECTION_OPEN, start);
    }

    private boolean isStandaloneTag(String tag, int start) {
        int newline = this.scanForNewLine(start);
        int nextTag = this.scan(tag, start);
        return nextTag != -1 && newline > nextTag && (nextTag == start || this.isWhitespace(start, nextTag));
    }

    private boolean isWhitespace(int start, int end) {
        for (int curr = start; curr < end; ++curr) {
            boolean isWhitespace = Character.isWhitespace(this.text.charAt(curr));
            if (isWhitespace) continue;
            return false;
        }
        return true;
    }

    private TashToken literal(int start) {
        int end = this.scanForNewLineOr(OPEN, start);
        String literal = null;
        literal = this.substring(this.text, start, end);
        this.pos += literal.length();
        TashToken tag = new TashToken(TashToken.TokenType.LITERAL, literal, null);
        return tag;
    }

    private TokenSequence name(String startMarker, String endMarker, int start) {
        int nameStart = this.scan(startMarker, start) + startMarker.length();
        int nameEnd = this.scan(endMarker, nameStart);
        if (nameEnd == -1) {
            return null;
        }
        return new TokenSequence(this.text.subSequence(nameStart, nameEnd), nameEnd + endMarker.length());
    }

    private int nearest(int index1, int index2) {
        if (index1 == -1) {
            return index2;
        }
        if (index2 == -1) {
            return index1;
        }
        return Math.min(index1, index2);
    }

    private TokenSequence newline(int start) {
        int end = start + 1;
        if ('\r' == this.text.charAt(start)) {
            ++end;
        }
        return new TokenSequence(this.text.subSequence(start, end), end);
    }

    private int scan(String token, int offset) {
        return this.text.indexOf(token, offset);
    }

    private int scanForNewLine(int start) {
        int dosNewLine = this.scan("\r\n", start);
        int unixNewLine = this.scan("\n", start);
        return this.nearest(dosNewLine, unixNewLine);
    }

    private int scanForNewLineOr(String token, int start) {
        int newLine = this.scanForNewLine(start);
        int tokenPos = this.scan(token, start);
        return this.nearest(newLine, tokenPos);
    }

    private TokenSequence scanForSectionWhitespace(TokenSequence name) {
        int newLine = this.scanForNewLine(name.end());
        if (newLine != -1 && this.isWhitespace(name.end(), newLine)) {
            if ('\r' == this.text.charAt(newLine)) {
                ++newLine;
            }
            name = new TokenSequence(name.toString(), ++newLine);
        }
        return name;
    }

    private TokenSequence section(CharSequence name, int start) {
        StringBuilder endTag = new StringBuilder();
        endTag.append(SECTION_CLOSE);
        endTag.append(name);
        endTag.append(CLOSE);
        String endMarker = endTag.toString();
        int sectionEnd = this.scan(endMarker, start);
        if (sectionEnd == -1) {
            return null;
        }
        String sectionText = this.text.substring(start, sectionEnd);
        int lastNewLine = sectionText.lastIndexOf(13);
        if (lastNewLine == -1) {
            lastNewLine = sectionText.lastIndexOf(10);
        }
        if (lastNewLine != -1 && sectionText.substring(lastNewLine).trim().isEmpty()) {
            sectionText = sectionText.substring(0, lastNewLine);
        }
        return new TokenSequence(sectionText, sectionEnd + endMarker.length());
    }

    private String substring(String text, int start, int end) {
        if (end == -1 || end > text.length()) {
            end = text.length();
        }
        return text.substring(start, end);
    }

    private TashToken.TokenType tagType(int start) {
        TashToken.TokenType tagType = null;
        String tag = this.substring(this.text, start, start + UNESCAPED_OPEN.length());
        if (tag.startsWith(UNESCAPED_OPEN)) {
            tagType = TashToken.TokenType.UNESCAPED_VARIABLE;
        } else if (this.isSection(start)) {
            tagType = TashToken.TokenType.SECTION;
        } else if (this.isInvertedSection(start)) {
            tagType = TashToken.TokenType.INVERTED_SECTION;
        } else if (tag.startsWith(PARTIAL_OPEN)) {
            tagType = TashToken.TokenType.PARTIAL;
        } else if (tag.startsWith(COMMENT_OPEN)) {
            tagType = TashToken.TokenType.COMMENT;
        } else if (tag.startsWith(OPEN)) {
            tagType = TashToken.TokenType.VARIABLE;
        } else if (this.isNewline(start)) {
            tagType = TashToken.TokenType.NEW_LINE;
        }
        return tagType;
    }
}

