/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.reflect;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.common.reflect.FileResource;
import oracle.dbtools.common.reflect.FileResourceFactory;

public class MemoryResourceFactory
implements FileResourceFactory {
    private final Map<String, MemoryResource> resources = new TreeMap<String, MemoryResource>();

    @Override
    public FileResource get(String path) throws IOException {
        MemoryResource resource = this.resources.get(path);
        if (resource == null) {
            resource = new MemoryResource(path);
            this.resources.put(path, resource);
        }
        return resource;
    }

    private boolean delete(String path) {
        this.resources.remove(path);
        return true;
    }

    private final class MemoryResource
    implements FileResource {
        private long lastModified;
        private byte[] content;
        private final String path;

        @Override
        public long lastModified() {
            return this.lastModified;
        }

        @Override
        public InputStream inputStream() throws IOException {
            if (!this.exists()) {
                throw new FileNotFoundException(this.path);
            }
            return new ByteArrayInputStream(this.content);
        }

        @Override
        public OutputStream outputStream() throws IOException {
            return new ByteArrayOutputStream(){

                @Override
                public void close() throws IOException {
                    MemoryResource.this.lastModified = System.currentTimeMillis();
                    MemoryResource.access$102(MemoryResource.this, this.toByteArray());
                }
            };
        }

        @Override
        public boolean exists() {
            return this.content != null;
        }

        @Override
        public boolean delete() {
            return MemoryResourceFactory.this.delete(this.path);
        }

        public MemoryResource(String path) {
            this.path = path;
        }

        @Override
        public String path() {
            return this.path;
        }

        static /* synthetic */ byte[] access$102(MemoryResource x0, byte[] x1) {
            x0.content = x1;
            return x1;
        }
    }
}

