/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.logging;

import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.inject.Inject;
import oracle.dbtools.common.logging.LogSink;
import oracle.dbtools.common.util.CallStacks;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides(value={Logger.class})
public class JDKLoggerPipe
extends Logger {
    private final Iterable<LogSink> sinks;

    @Inject
    public JDKLoggerPipe(Iterable<LogSink> sinks) {
        super("", null);
        this.sinks = sinks;
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        this.unsupported();
        super.addHandler(handler);
    }

    @Override
    public void config(String msg) {
        this.unsupported();
        super.config(msg);
    }

    @Override
    public Filter getFilter() {
        this.unsupported();
        return super.getFilter();
    }

    @Override
    public Handler[] getHandlers() {
        this.unsupported();
        return super.getHandlers();
    }

    @Override
    public Level getLevel() {
        this.unsupported();
        return super.getLevel();
    }

    @Override
    public String getName() {
        this.unsupported();
        return super.getName();
    }

    @Override
    public Logger getParent() {
        return null;
    }

    @Override
    public ResourceBundle getResourceBundle() {
        return null;
    }

    @Override
    public String getResourceBundleName() {
        return null;
    }

    @Override
    public boolean getUseParentHandlers() {
        this.unsupported();
        return super.getUseParentHandlers();
    }

    @Override
    public boolean isLoggable(Level level) {
        for (LogSink sink : this.sinks()) {
            if (!sink.isLoggable(level)) continue;
            return true;
        }
        return false;
    }

    private void inferCaller(LogRecord lr) {
        StackTraceElement methodCaller = CallStacks.caller(JDKLoggerPipe.class, Logger.class);
        lr.setSourceClassName(methodCaller.getClassName());
        lr.setSourceMethodName(methodCaller.getMethodName());
    }

    @Override
    public void log(LogRecord record) {
        this.inferCaller(record);
        for (LogSink sink : this.sinks()) {
            sink.log(record);
        }
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        this.unsupported();
        super.removeHandler(handler);
    }

    @Override
    public void setFilter(Filter newFilter) throws SecurityException {
        this.unsupported();
        super.setFilter(newFilter);
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        this.unsupported();
        super.setLevel(newLevel);
    }

    @Override
    public void setParent(Logger parent) {
        this.unsupported();
        super.setParent(parent);
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        this.unsupported();
        super.setUseParentHandlers(useParentHandlers);
    }

    private void unsupported() {
        throw new UnsupportedOperationException();
    }

    private Iterable<LogSink> sinks() {
        return this.sinks;
    }
}

