/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.locale;

import java.net.URI;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.locale.LocalePreference;
import oracle.dbtools.common.locale.LocalePreferenceImpl;
import oracle.dbtools.common.locale.LocalePreferences;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.TransformCache;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
public class LocalePreferencesProvider
implements LocalePreferences {
    static final TransformCache<Pair<URI, LocalePreference>, URI> BEST_MATCHES = new TransformCache<Pair<URI, LocalePreference>, URI>(new BestLocaleMatch(), false);
    static final Locale DEFAULT_LOCALE = new Locale("en");
    private static final String ACCEPT_LANGUAGE = "Accept-Language";

    @Inject
    LocalePreferencesProvider() {
    }

    @Override
    public LocalePreference preference(HttpServletRequest request) {
        if (request == null) {
            return LocalePreference.DEFAULT;
        }
        String acceptLanguage = request.getHeader(ACCEPT_LANGUAGE);
        return this.preference(acceptLanguage);
    }

    @Override
    public LocalePreference preference(String acceptLanguage) {
        if (NullOrEmpty.nullOrEmpty(acceptLanguage)) {
            return LocalePreference.DEFAULT;
        }
        String[] segments = acceptLanguage.split(",");
        TreeSet<Weighting> weightings = new TreeSet<Weighting>();
        for (String segment : segments) {
            segment = segment.trim();
            String[] lq = segment.split(";");
            String langRegion = lq[0];
            Double quality = 1.0;
            if (lq.length == 2) {
                int equals = lq[1].indexOf("=");
                try {
                    quality = Double.valueOf(lq[1].substring(equals + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            String[] lr = langRegion.split("-");
            Locale locale = new Locale(lr[0].toLowerCase());
            if (lr.length == 2) {
                locale = new Locale(lr[0].toLowerCase(), lr[1].toUpperCase());
            }
            weightings.add(new Weighting(locale, quality, weightings.size()));
        }
        return new LocalePreferenceImpl(Iterators.transform(weightings.iterator(), new Transform<Weighting, Locale>(){

            @Override
            public Locale apply(Weighting x) {
                return x.locale;
            }
        }));
    }

    public void reset() {
        BEST_MATCHES.clear();
    }

    private static String asPath(Locale locale, Constraint constraint) {
        StringBuilder b = new StringBuilder();
        b.append(locale.getLanguage().toLowerCase());
        String country = locale.getCountry().toUpperCase();
        if (!(constraint != Constraint.COUNTRY && constraint != Constraint.VARIANT || NullOrEmpty.nullOrEmpty(country))) {
            b.append('_');
            b.append(country);
        }
        String variant = locale.getVariant().toUpperCase();
        if (constraint == Constraint.VARIANT && !NullOrEmpty.nullOrEmpty(variant)) {
            b.append('_');
            b.append(variant);
        }
        b.append('/');
        return b.toString();
    }

    private static URI bestMatch(URI root, Locale locale) {
        Constraint constraint;
        URI candidate = null;
        Constraint[] arr$ = Constraint.values();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !URIs.exists(candidate = URIs.resolve(root, LocalePreferencesProvider.asPath(locale, constraint = arr$[i$]))); ++i$) {
            candidate = null;
        }
        return candidate;
    }

    private static final class Weighting
    implements Comparable<Weighting> {
        final Locale locale;
        final int position;
        final Double quality;

        Weighting(Locale locale, Double quality, int position) {
            this.locale = locale;
            this.quality = quality;
            this.position = position;
        }

        @Override
        public int compareTo(Weighting o) {
            if (this.quality < o.quality) {
                return 1;
            }
            if (this.quality > o.quality) {
                return -1;
            }
            return o.position - this.position;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Weighting [locale=");
            builder.append(this.locale);
            builder.append(", position=");
            builder.append(this.position);
            builder.append(", quality=");
            builder.append(this.quality);
            builder.append("]");
            return builder.toString();
        }
    }

    private static enum Constraint {
        COUNTRY,
        LANGUAGE,
        VARIANT;

    }

    private static class BestLocaleMatch
    implements Transform<Pair<URI, LocalePreference>, URI> {
        private BestLocaleMatch() {
        }

        @Override
        public URI apply(Pair<URI, LocalePreference> x) {
            Locale locale;
            URI root = x.first();
            LocalePreference pref = x.second();
            URI candidate = root;
            Iterator i$ = pref.iterator();
            while (i$.hasNext() && (candidate = LocalePreferencesProvider.bestMatch(root, locale = (Locale)i$.next())) == null) {
            }
            if (candidate == null) {
                candidate = LocalePreferencesProvider.bestMatch(root, DEFAULT_LOCALE);
            }
            if (candidate == null) {
                candidate = root;
            }
            return candidate;
        }
    }
}

