/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.Map;
import javax.inject.Inject;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.Maps;
import oracle.dbtools.common.immutables.impl.EntryImpl;
import oracle.dbtools.common.immutables.impl.MapBuilder;
import oracle.dbtools.common.util.KeyedLookup;
import oracle.dbtools.common.util.Ordering;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
class MapsProvider
implements Maps {
    @Inject
    MapsProvider() {
    }

    @Override
    public <K, V> ImmutableMap.Builder<K, V> builder() {
        return MapBuilder.newInstance(0, Ordering.INSERTION, null);
    }

    @Override
    public <K, V> ImmutableMap.Builder<K, V> builder(ImmutableMap<K, V> existing) {
        return this.builder((Map<K, V>)existing);
    }

    @Override
    public <K, V> ImmutableMap.Builder<K, V> builder(KeyedLookup<K, V> existing) {
        return this.builder().add(existing);
    }

    @Override
    public <K, V> ImmutableMap.Builder<K, V> builder(Map<K, V> existing) {
        return this.builder().add(existing);
    }

    @Override
    public <K, V> ImmutableMap<K, V> empty() {
        return this.builder().build();
    }

    @Override
    public <K, V> ImmutableMap.ImmutableEntry<K, V> entry(K key, V value) {
        return EntryImpl.newInstance(key, value);
    }

    @Override
    public ImmutableMap<String, String> map(CharSequence ... keyValuePairs) {
        ImmutableMap.Builder<String, String> map = this.builder();
        if (keyValuePairs.length % 2 == 1) {
            throw new IllegalArgumentException("Even number of key value pairs must be provided");
        }
        for (int i = 0; i < keyValuePairs.length; ++i) {
            CharSequence key = keyValuePairs[i];
            CharSequence value = keyValuePairs[++i];
            String k = null;
            String v = null;
            if (key != null) {
                k = key.toString();
            }
            if (value != null) {
                v = value.toString();
            }
            map.add(k, v);
        }
        return map.build();
    }

    @Override
    public <K, V> ImmutableMap<K, V> map(KeyedLookup<K, V> elements) {
        if (elements instanceof ImmutableMap) {
            return (ImmutableMap)elements;
        }
        return this.builder(elements).build();
    }

    @Override
    public <K, V> ImmutableMap<K, V> map(Map<K, V> elements) {
        if (elements instanceof ImmutableMap) {
            return (ImmutableMap)elements;
        }
        return this.builder(elements).build();
    }
}

