/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import oracle.dbtools.common.immutables.ImmutableCollection;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.ImmutableSet;
import oracle.dbtools.common.immutables.impl.CollectionFactory;
import oracle.dbtools.common.immutables.impl.ListImpl;
import oracle.dbtools.common.immutables.impl.MapBuilder;
import oracle.dbtools.common.immutables.impl.SetImpl;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Ordering;
import oracle.dbtools.common.util.Unsupported;

class MapImpl<K, V>
implements ImmutableMap<K, V>,
Comparable<ImmutableMap<K, V>> {
    private final Comparator<? super K> comparator;
    private final Ordering ordering;
    private final Map<K, V> target;
    static final MapImpl<?, ?> EMPTY = new MapImpl(CollectionFactory.map(0, Ordering.SORTED, null), Ordering.SORTED, null);

    protected MapImpl(Map<K, V> target, Ordering ordering, Comparator<? super K> comparator) {
        this.target = target;
        this.ordering = ordering;
        this.comparator = comparator;
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        Unsupported.unsupported();
    }

    @Override
    public Comparator<? super K> comparator() {
        Unsupported.unsupported();
        return null;
    }

    @Override
    public int compareTo(ImmutableMap<K, V> o) {
        int diff = Iterables.compare(this.entrySet(), o.entrySet());
        return diff;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.target.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.target.containsValue(value);
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        return CollectionFactory.entrySet(this.target.entrySet());
    }

    @Override
    public boolean equals(Object obj) {
        return this.target.equals(obj);
    }

    @Override
    public V get(Object key) {
        return this.target.get(key);
    }

    @Override
    public int hashCode() {
        return this.target.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public ImmutableSet<K> keySet() {
        Set<K> keySet = this.target.keySet();
        return SetImpl.newInstance(keySet, Ordering.INSERTION, null);
    }

    @Override
    public ImmutableMap.Builder<K, V> modify() {
        return MapBuilder.newInstance(this.size(), this.ordering, this.comparator).add(this);
    }

    @Override
    public Ordering ordering() {
        return this.ordering;
    }

    @Override
    public V put(K key, V value) throws UnsupportedOperationException {
        Unsupported.unsupported();
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) throws UnsupportedOperationException {
        Unsupported.unsupported();
    }

    @Override
    public V remove(Object key) throws UnsupportedOperationException {
        Unsupported.unsupported();
        return null;
    }

    @Override
    public int size() {
        return this.target.size();
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    public ImmutableCollection<V> values() {
        Collection<V> values = this.target.values();
        return ListImpl.newInstance(values);
    }

    static <K, V> ImmutableMap<K, V> newInstance(Map<K, V> elements, Ordering ordering, Comparator<? super K> comparator) {
        ImmutableMap immutable;
        if (elements == null) {
            throw new NullPointerException();
        }
        if (NullOrEmpty.nullOrEmpty(elements)) {
            MapImpl<?, ?> empty = EMPTY;
            return empty;
        }
        if (elements instanceof ImmutableMap && Ordering.equals(immutable = (ImmutableMap)elements, ordering, comparator)) {
            return immutable;
        }
        elements = MapImpl.ordered(elements, ordering, comparator);
        return new MapImpl<K, V>(elements, ordering, comparator);
    }

    private static <K, V> Map<K, V> ordered(Map<K, V> elements, Ordering ordering, Comparator<? super K> comparator) {
        switch (ordering) {
            case SORTED: {
                if (elements instanceof SortedMap) break;
                TreeMap<K, V> sorted = new TreeMap<K, V>(comparator);
                sorted.putAll(elements);
                elements = sorted;
                break;
            }
            case UNSPECIFIED: {
                if (!(elements instanceof HashMap)) {
                    elements = new HashMap<K, V>(elements);
                }
            }
            default: {
                if (elements instanceof LinkedHashMap) break;
                elements = new LinkedHashMap<K, V>(elements);
            }
        }
        return elements;
    }
}

